/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.thread;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;

public class ProcessStatusHeartBeatChecker {
    private static final String HEART_BEAT_FLAG = "bcm$heartbeat$";
    private static final long DEAD_TIME = 6000L;

    public static void updateHeartBeat(Object processId) {
        AppCacheServiceHelper.put(ProcessStatusHeartBeatChecker.packKey(processId), ProcessStatusHeartBeatChecker.getCurrentTime(), 600000);
        Long lastTime = AppCacheServiceHelper.get(ProcessStatusHeartBeatChecker.packKey(processId), Long.class);
        System.out.println(lastTime);
    }

    public static void removeHeartBeat(Object processId) {
        AppCacheServiceHelper.remove(ProcessStatusHeartBeatChecker.packKey(processId));
    }

    private static long getHeartBeat(Object processId) {
        Long lastTime = AppCacheServiceHelper.get(ProcessStatusHeartBeatChecker.packKey(processId), Long.class);
        if (lastTime == null) {
            return -1L;
        }
        return lastTime;
    }

    public static List<Long> maybeAbortProcess(List<Long> runningProcessIds) {
        ArrayList<Long> processIds = new ArrayList<Long>(runningProcessIds.size());
        long currentTime = ProcessStatusHeartBeatChecker.getCurrentTime();
        for (Long processId : runningProcessIds) {
            long lastHeartBeatTime = ProcessStatusHeartBeatChecker.getHeartBeat(ProcessStatusHeartBeatChecker.packKey(processId));
            if (lastHeartBeatTime != -1L && currentTime - lastHeartBeatTime < 6000L) continue;
            processIds.add(processId);
        }
        return processIds;
    }

    private static String packKey(Object processId) {
        return HEART_BEAT_FLAG + processId;
    }

    private static long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

