/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.service.thread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.trace.TraceLog;
import kd.fi.bcm.business.adjust.trace.TraceLogUtil;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class ThreadPoolService {
    private static final Log log = LogFactory.getLog(ThreadPoolService.class);
    private static final String pool_name_allInOne = "bcm_allInOne";
    private static final String pool_name_merge = "bcm_allInOne_merge";
    private static final String pool_name_mergechk = "bcm_allInOne_mergechk";
    private static final String pool_name_detail = "bcm_allInOne_detail";
    private static final String pool_name_unit = "bcm_allInOne_unit";
    private static final String pool_name_unitwaiting = "bcm_allInOne_wait";
    private static final String pool_name_Integrate = "bcm_Integrate-detail";
    private static final String pool_name_Integrate_bat = "bcm_Integrate-detail_bat";
    private static final String pool_name_dataCollect = "bcm_dataCollect";
    private static final String pool_name_dataCollect4org = "bcm_dataCollect4org";
    private static final String pool_name_modelOlap = "bcm_modelolap";
    private static final String pool_name_adjustOper = "bcm_adjustOper";
    private static final String pool_name_adjustChildTaskOper = "bcm_adjustChildTaskOper";
    private static final String pool_name_syncthread = "bcm_syncThreadOpr";
    private static final String pool_name_convertthread = "bcm_syncConvertThread";
    private static final String pool_name_syncthreadOther = "bcm_syncThreadOprOther";
    private static final String pool_name_fumularCollect = "bcm_cslreportprocess";
    private static final String pool_name_mergechkCollect = "bcm_merge_chk";
    private static final String pool_name_reportlistchk = "bcm_reportlist_chk";
    private static final String pool_name_schedulechk = "bcm_schedule_chk";
    private static final String pool_name_reportexport = "bcm_reportexport";
    private static final String pool_name_reportexport2 = "bcm_reportexport2";
    private static final String pool_name_syncfumulars = "bcm_sync_formulas";
    private static final String pool_name_permUpgrade = "bcm_perm_upgrade";
    private static final String pool_name_modelUpgrade = "bcm_model_upgrade";
    private static final String pool_name_tplLinkInfo = "bcm_tplLinkInfo";
    private static final String pool_name_glIntegrate = "bcm_glIntegrate";
    private static final String pool_name_calAfterIntegrate = "bcm_calAfterIntegrate";
    private static final String pool_name_extMerge = "bcm_extMerge";
    private static final String pool_name_bizruleExec = "bcm_BizRuleExecuteThreadPool";
    public static final String pool_name_adjustunitwaiting = "pool_name_adjustunitwaiting";
    public static final String pool_name_adjustdetailtask = "pool_name_adjustdetailtask";
    private static final String pool_name_auditlogs = "bcm_auditlogs";
    private static final String pool_completableFuture = "bcm_completableFuture_future";
    private static final int pool_completableFuture_MaxThread = Runtime.getRuntime().availableProcessors();
    public static final int pool_AdjustUnitWaiting_MaxThread = ThreadPoolService.getCurrentMaxThreadPool("pool_name_adjustunitwaiting", 150);
    public static final int pool_AdjustDetailTask_MaxThread = ThreadPoolService.getCurrentMaxThreadPool("pool_name_adjustdetailtask", 50);
    private static final int pool_detail_MaxThread = Integer.getInteger("bcm_allInOne_detail_pool_maxthread", 50);
    private static final int pool_unit_MaxThread = Integer.getInteger("bcm_allInOne_unit_pool_maxthread", 50);
    private static final int pool_wait_MaxThread = Integer.getInteger("bcm_allInOne_wait_pool_maxthread", 100);
    private static final Map<String, ThreadPoolExecutor> ThreadPoolExecutorHolder = new ConcurrentHashMap<String, ThreadPoolExecutor>(16);
    private static final ThreadPool threadPool = BcmThreadPool.access$000("bcm_allInOne", 20, 20);
    private static final ThreadPool threadPoolForMerge = BcmThreadPool.access$000("bcm_allInOne_merge", 50, 50);
    private static final ThreadPool threadPoolForMergeCHK = BcmThreadPool.access$000("bcm_allInOne_mergechk", 20, 20);
    private static final ThreadPool threadPool4Detail = BcmThreadPool.access$000("bcm_allInOne_detail", pool_detail_MaxThread, pool_detail_MaxThread);
    private static final ThreadPool threadPool4Unit = BcmThreadPool.access$000("bcm_allInOne_unit", pool_unit_MaxThread, pool_unit_MaxThread);
    private static final ThreadPool threadPool4UnitWaiting = BcmThreadPool.access$000("bcm_allInOne_wait", pool_wait_MaxThread, pool_wait_MaxThread);
    private static final ThreadPool threadUserPermDetail = BcmThreadPool.access$000("bcm_perm_upgrade", 8, 8);
    private static final ThreadPool threadModelPermUpgrade = BcmThreadPool.access$000("bcm_model_upgrade", 8, 8);
    private static final ThreadPool threadPoolIntegrateDetail = BcmThreadPool.access$000("bcm_Integrate-detail", 10, 10);
    private static final ThreadPool threadPoolIntegrateDetailBat = BcmThreadPool.access$000("bcm_Integrate-detail_bat", 5, 5);
    private static final ThreadPool threadPool4glIntegrate = BcmThreadPool.access$000("bcm_glIntegrate", 5, 5);
    private static final ThreadPool threadPool4CalAfterIntegrate = BcmThreadPool.access$000("bcm_calAfterIntegrate", 10, 10);
    private static final ThreadPool threadPool4DataCollect = BcmThreadPool.access$000("bcm_dataCollect", 5, 5);
    private static ThreadPool threadPool4DataCollect4org = BcmThreadPool.access$000("bcm_dataCollect4org", 5, 5);
    private static final ThreadPool threadPool4ModelOlap = BcmThreadPool.access$000("bcm_modelolap", 10, 10);
    private static final ThreadPool threadPool4AdjustOper = BcmThreadPool.access$000("bcm_adjustOper", 10, 10);
    private static final ThreadPool threadPool4AdjustChildTaskOper = BcmThreadPool.access$000("bcm_adjustChildTaskOper", 15, 15);
    private static final ThreadPool threadPool_AdjustUnitWaiting = BcmThreadPool.access$000("pool_name_adjustunitwaiting", pool_AdjustUnitWaiting_MaxThread, pool_AdjustUnitWaiting_MaxThread);
    private static final ThreadPool threadPool_AdjustDetailTask = BcmThreadPool.access$000("pool_name_adjustdetailtask", pool_AdjustDetailTask_MaxThread, pool_AdjustDetailTask_MaxThread);
    private static final ThreadPool threadPool4Sync = BcmThreadPool.access$000("bcm_syncThreadOpr", 50, 50);
    private static final ThreadPool threadPool4SyncOther = BcmThreadPool.access$000("bcm_syncThreadOprOther", 50, 50);
    private static final ThreadPool threadPool4FumularCollect = BcmThreadPool.access$000("bcm_cslreportprocess", 50, 50);
    private static final ThreadPool threadPool4SyncFumulars = BcmThreadPool.access$000("bcm_sync_formulas", 1, 1);
    private static final ThreadPool threadPool4MergeChkCollect = BcmThreadPool.access$000("bcm_merge_chk", 15, 15);
    private static final ThreadPool threadPool4ReportListChk = BcmThreadPool.access$000("bcm_reportlist_chk", 5, 5);
    private static final ThreadPool threadPool4ScheduleChk = BcmThreadPool.access$000("bcm_schedule_chk", 5, 5);
    private static final ThreadPool threadPool4ReportExport = BcmThreadPool.access$000("bcm_reportexport", 10, 10);
    private static final ThreadPool threadPool4ReportExport2 = BcmThreadPool.access$000("bcm_reportexport2", 1, 1);
    private static final ThreadPool threadPool4UpdateTplLinkInfo = BcmThreadPool.access$000("bcm_tplLinkInfo", 10, 10);
    private static final ThreadPool threadPool4ExtMerge = BcmThreadPool.access$000("bcm_extMerge", 10, 10);
    private static final ThreadPool threadPool4SyncConvert = BcmThreadPool.access$000("bcm_syncConvertThread", 5, 50);
    private static final ThreadPool threadPoolRuleExec = BcmThreadPool.access$000("bcm_BizRuleExecuteThreadPool", 10, 10);
    private static final ThreadPool threadAuditLogs = BcmThreadPool.access$000("bcm_auditlogs", 20, 20);
    private static final ThreadPool threadPool4CompletableFuture = BcmThreadPool.access$000("bcm_completableFuture_future", pool_completableFuture_MaxThread, pool_completableFuture_MaxThread);

    public static int getCurrentMaxThreadPool(String poolName, int defaultSize) {
        return Integer.getInteger(poolName + "_pool_maxthread", defaultSize);
    }

    public static void runInSyncThread(IRunner runner) {
        Object processId = ThreadCache.get((Object)"cache_node_prefix");
        boolean isAllInOne = ThreadCache.exists((Object)"all_in_one_thread");
        ThreadPoolService.doExecute(threadPool4Sync, () -> {
            long start = System.currentTimeMillis();
            if (isAllInOne) {
                ThreadCache.put((Object)"all_in_one_thread", (Object)true);
            }
            ThreadPoolService.hintAllInOneFlag(processId);
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runFormularCollectThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4FumularCollect, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runTemplateFormularsSyncThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4SyncFumulars, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runExtMergeThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ExtMerge, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runMergeChkThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4MergeChkCollect, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--merge--chk--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runReportListChkThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ReportListChk, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--reportlist--chk--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runScheduleChkThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ScheduleChk, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--schedule--chk--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static <R> List<R> runInWaiting4Thread(Callable<R> ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        List result = Collections.synchronizedList(new ArrayList(tasks.length));
        Object processId = ThreadCache.get((Object)"cache_node_prefix");
        boolean isAllInOne = ThreadCache.exists((Object)"all_in_one_thread");
        Object processId2 = processId = processId == null ? "" + GlobalIdUtil.genGlobalLongId() : processId;
        for (Callable task : tasks) {
            threadPool4SyncOther.submit(() -> {
                try {
                    long start = System.currentTimeMillis();
                    if (isAllInOne) {
                        ThreadCache.put((Object)"all_in_one_thread", (Object)true);
                    }
                    ThreadPoolService.hintAllInOneFlag(processId2);
                    Object r = task.call();
                    result.add(r);
                    log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
                    Object v = r;
                    return v;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
            return result;
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void runInWaiting4AdjustChildTaskThread(IRunner ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        Object processId = ThreadCache.get((Object)"cache_node_prefix", GlobalIdUtil::genStringId);
        boolean isAllInOne = ThreadCache.exists((Object)"all_in_one_thread");
        TraceLog tl_Log = TraceLogUtil.getLogInstance("redis");
        for (IRunner task : tasks) {
            threadPool4AdjustChildTaskOper.submit(() -> {
                try {
                    long start = System.currentTimeMillis();
                    if (isAllInOne) {
                        ThreadCache.put((Object)"all_in_one_thread", (Object)true);
                    }
                    TraceLogUtil.set(tl_Log);
                    ThreadPoolService.hintAllInOneFlag(processId);
                    task.doRun();
                    log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
                    String string = "";
                    return string;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void runInWaitingAdjExportTaskThread(IRunner ... tasks) {
        ThreadPoolService.runInWaitingTaskThread(threadPool4AdjustChildTaskOper, tasks);
    }

    public static void runInWaitingTaskThread(ThreadPool threadPool, IRunner ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        for (IRunner task : tasks) {
            threadPool.submit(() -> {
                try {
                    task.doRun();
                    String string = "";
                    return string;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <R> List<R> runInWaiting4MergeStatusTaskThread(Callable<R> ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        List result = Collections.synchronizedList(new LinkedList());
        for (Callable task : tasks) {
            threadPool.submit(() -> {
                try {
                    Object r = task.call();
                    result.add(r);
                    Object v = r;
                    return v;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
            return result;
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void runInModelOlapThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ModelOlap, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInReportExportThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ReportExport, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInReportExportThread2(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4ReportExport2, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static <R> List<R> runInConvertWaiting4Thread(Callable<R> ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        List result = Collections.synchronizedList(new ArrayList(tasks.length));
        Object processId = ThreadCache.get((Object)"cache_node_prefix");
        boolean isAllInOne = ThreadCache.exists((Object)"all_in_one_thread");
        Object processId2 = processId = processId == null ? "" + GlobalIdUtil.genGlobalLongId() : processId;
        for (Callable task : tasks) {
            threadPool4SyncConvert.submit(() -> {
                try {
                    long start = System.currentTimeMillis();
                    if (isAllInOne) {
                        ThreadCache.put((Object)"all_in_one_thread", (Object)true);
                    }
                    ThreadPoolService.hintAllInOneFlag(processId2);
                    Object r = task.call();
                    result.add(r);
                    log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
                    Object v = r;
                    return v;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
            return result;
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void runInAdjustOperThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4AdjustOper, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInAdjustDetailTaskThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool_AdjustDetailTask, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInAdjustUnitWaitingThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool_AdjustUnitWaiting, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInIntegrateThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolIntegrateDetail, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInIntegrateBatThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolIntegrateDetailBat, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInGlIntegrateThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4glIntegrate, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInCalAfterIntegrateThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4CalAfterIntegrate, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--runInCalAfterIntegrateThread--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInUpdateTemplateLinkInfoThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4UpdateTplLinkInfo, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInThreadForMerge(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolForMerge, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--merge--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInThreadForMergeChk(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolForMergeCHK, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--mergechk--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInThread4Detail(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4Detail, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInThread4Unit(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4Unit, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void waitInThread4Unit(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4UnitWaiting, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runDataCollectThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4DataCollect, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runDataCollect4OrgThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4DataCollect4org, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void upgradeServiceThread(IRunner runner) {
        ThreadPoolService.doExecute(threadUserPermDetail, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void upgradeModelThread(IRunner runner) {
        ThreadPoolService.doExecute(threadModelPermUpgrade, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static <R> List<R> runInUpdateTemplateLinkInfoThreadForCallable(Callable<R> ... tasks) {
        CountDownLatch latch = new CountDownLatch(tasks.length);
        CopyOnWriteArrayList result = new CopyOnWriteArrayList();
        TraceLog tl_Log = TraceLogUtil.getLogInstance("redis");
        for (Callable task : tasks) {
            threadPool4UpdateTplLinkInfo.submit(() -> {
                try {
                    TraceLogUtil.set(tl_Log);
                    long start = System.currentTimeMillis();
                    Object r = task.call();
                    result.add(r);
                    log.info(String.format("%s--bcm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
                    Object v = r;
                    return v;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    latch.countDown();
                    tl_Log.close();
                }
            }, ThreadPoolService.createRequestContext());
        }
        try {
            latch.await();
            return result;
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void runRulesAsyncThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolRuleExec, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--batchRules--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runAuditLogsAsyncThread(IRunner runner) {
        ThreadPoolService.doExecute(threadAuditLogs, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--batchRules--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runCompletableFutureThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPool4CompletableFuture, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--bcm--batchRules--spendtime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    private static void doExecute(ThreadPool threadPool, Runnable runner) {
        threadPool.execute(runner, ThreadPoolService.createRequestContext());
    }

    public static RequestContext createRequestContext() {
        RequestContext copy = RequestContextCreator.createForThreadPool();
        copy.setClient(RequestContext.get().getClient());
        copy.setLoginIP(RequestContext.get().getLoginIP());
        return copy;
    }

    private static void hintAllInOneFlag(Object processId) {
        if (processId != null && StringUtils.isNotEmpty((String)processId.toString())) {
            ThreadCache.put((Object)"cache_node_prefix", (Object)("" + processId));
        }
    }

    public static ThreadPool createExportThreadPool(String poolName, int coreThread, int maxThread) {
        return BcmThreadPool.createCachedExecutorService(poolName, coreThread, maxThread);
    }

    public static ThreadPoolExecutor getTreadPoolByName(String name) {
        return ThreadPoolExecutorHolder.get(name);
    }

    static {
        ThreadPoolExecutorHolder.forEach((key, value) -> ConfigurationUtil.observeChange((String)(key + "_pool_maxthread"), (key1, newValue) -> {
            Integer newMaxThread = Integer.getInteger(key + "_pool_maxthread");
            if (newMaxThread != null && newMaxThread > 0) {
                value.setCorePoolSize(newMaxThread);
                log.info(String.format("--bcm-- threadPool [%s] set core pool size [%d] successfull.", key, newMaxThread));
            }
        }));
    }

    static class BcmThreadPool {
        BcmThreadPool() {
        }

        private static ThreadPool createCachedExecutorService(String poolName, int coreThread, int maxThread) {
            return new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)BcmThreadPool.genThreadPoolExecutor(poolName, coreThread, maxThread)));
        }

        private static ThreadPoolExecutor genThreadPoolExecutor(final String poolName, int coreThread, int maxThread) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThread, maxThread, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final AtomicInteger atomicInteger = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
                }
            });
            executor.allowCoreThreadTimeOut(true);
            ThreadPoolExecutorHolder.put(poolName, executor);
            return executor;
        }
    }
}

