/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.allinone.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.common.util.QFBuilder;

public final class AllInOneUtils {
    public static boolean isSubmitted(Long modelId, String orgNumber, Long sceneId, Long yearId, Long periodId) {
        return AllInOneUtils.isSubmittedBatch(modelId, Collections.singleton(orgNumber), sceneId, yearId, periodId).get(orgNumber);
    }

    public static Map<String, Boolean> isSubmittedBatch(Long modelId, Collection<String> orgNumbers, Object sceneId, Object yearId, Object periodId) {
        HashMap<String, Set> orgNumbIdMap = new HashMap<String, Set>(orgNumbers.size());
        QFBuilder qf = new QFBuilder();
        qf.add("model.id", "=", (Object)modelId);
        qf.add("number", "in", orgNumbers);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])qf.toArray()).forEach((k, v) -> {
            Long id = v.getLong("id");
            String number = v.getString("number");
            Set ids = orgNumbIdMap.computeIfAbsent(number, k1 -> new HashSet(4));
            ids.add(id);
        });
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(orgNumbers.size());
        orgNumbers.forEach(e -> result.put((String)e, Boolean.FALSE));
        orgNumbIdMap.forEach((k, v) -> {
            Map<Long, McStatus> mc = McStatus.batchGetMcStatus(modelId, v, sceneId, yearId, periodId);
            for (Map.Entry<Long, McStatus> m : mc.entrySet()) {
                if (!m.getValue().getFlow().isSubmit()) continue;
                result.put((String)k, Boolean.TRUE);
                break;
            }
        });
        return result;
    }
}

