/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;

public class BizRuleAllocateServiceHelper {
    private static final String[] TempNumbers_RPT = new String[]{"BS", "CF", "PL", "BS_FORMULA_EXECUTE", "BS_FORMULA_UNEXECUTE", "CF_FORMULA", "PL_FORMULA_EXECUTE", "PL_FORMULA_UNEXECUTE"};
    private static final String[] BizruleNumbers_RPT = new String[]{"PresetRule01", "PresetRule02", "PresetRule03", "PresetRule04", "PresetRule05", "PresetRule06", "PresetRule07", "PresetRule08"};
    private static final String[] TempNumbers_NOT_RPT = new String[]{"BS", "CF", "PL"};
    private static final String[] BizruleNumbers_NOT_RPT = new String[]{"PresetRule01", "PresetRule02", "PresetRule03"};

    public static void preDefaultRecord(DynamicObject model, ApplicationTypeEnum app) {
        String[] bizruleNumbers;
        String[] tempNumbers;
        if (ConfigServiceHelper.getBoolParam(model.getLong("id"), "CM006")) {
            return;
        }
        long modelId = model.getLong("id");
        if (app == ApplicationTypeEnum.RPT) {
            tempNumbers = TempNumbers_RPT;
            bizruleNumbers = BizruleNumbers_RPT;
        } else {
            tempNumbers = TempNumbers_NOT_RPT;
            bizruleNumbers = BizruleNumbers_NOT_RPT;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter filter1 = new QFilter("number", "in", (Object)tempNumbers);
        QFilter filter2 = new QFilter("number", "in", (Object)bizruleNumbers);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id, number", (QFilter[])new QFilter[]{filter, filter1});
        if (templates == null || templates.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u9884\u7f6e\u6a21\u677f\u3002", (String)"BizRuleAllocateServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection bizrules = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id, number", (QFilter[])new QFilter[]{filter, filter2});
        if (bizrules == null || bizrules.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u9884\u7f6e\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleAllocateServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject[] objs = new DynamicObject[templates.size()];
        for (int i = 0; i < templates.size(); ++i) {
            String tempNumber;
            objs[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brallocateentity");
            objs[i].set("template", (Object)((DynamicObject)templates.get(i)).getLong("id"));
            switch (tempNumber = ((DynamicObject)templates.get(i)).getString("number")) {
                case "BS": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule01", objs[i], bizrules);
                    break;
                }
                case "CF": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule03", objs[i], bizrules);
                    break;
                }
                case "PL": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule02", objs[i], bizrules);
                    break;
                }
                case "BS_FORMULA_EXECUTE": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule04", objs[i], bizrules);
                    break;
                }
                case "BS_FORMULA_UNEXECUTE": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule05", objs[i], bizrules);
                    break;
                }
                case "CF_FORMULA": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule06", objs[i], bizrules);
                    break;
                }
                case "PL_FORMULA_EXECUTE": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule07", objs[i], bizrules);
                    break;
                }
                case "PL_FORMULA_UNEXECUTE": {
                    BizRuleAllocateServiceHelper.setBizRuleId("PresetRule08", objs[i], bizrules);
                    break;
                }
            }
            objs[i].set("model", (Object)model.getLong("id"));
            objs[i].set("execseq", (Object)1);
            objs[i].set("execwhenopen", (Object)0);
            objs[i].set("execwhensave", (Object)1);
            String userId = RequestContext.get().getUserId();
            long currentTime = System.currentTimeMillis();
            objs[i].set("creator", (Object)userId);
            objs[i].set("createdate", (Object)currentTime);
            objs[i].set("modifier", (Object)userId);
            objs[i].set("modifydate", (Object)currentTime);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    private static void setBizRuleId(String number, DynamicObject obj, DynamicObjectCollection bizrules) {
        for (DynamicObject bizrule : bizrules) {
            if (!number.equals(bizrule.getString("number"))) continue;
            obj.set("bizrule", (Object)bizrule.getLong("id"));
        }
    }
}

