/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BizRuleCatalogEnum;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.common.enums.BizRuleScenarioCatalogEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class BizRuleCatalogServiceHelper {
    private static final String root = "root";
    private static final String admin = "admin";
    private static final String[] Numbers_RPT = new String[]{"PresetRule01", "PresetRule02", "PresetRule03", "PresetRule04", "PresetRule05", "PresetRule06", "PresetRule07", "PresetRule08"};
    private static String[] Names_RPT = new String[]{BCMConstant.getBS_BIZRULE_NAME(), BCMConstant.getPL_BIZRULE_NAME(), BCMConstant.getCF_BIZRULE_NAME(), BCMConstant.getBS_FORMULA_EXECUTE_BIZRULE_NAME(), BCMConstant.getBS_FORMULA_UNEXECUTE_BIZRULE_NAME(), BCMConstant.getCF_FORMULA_BIZRULE_NAME(), BCMConstant.getPL_FORMULA_EXECUTE_BIZRULE_NAME(), BCMConstant.getPL_FORMULA_UNEXECUTE_BIZRULE_NAME()};
    private static final String[] Contents_RPT = new String[]{"agg('Account.R1999');\n", "agg('Account.R2999');\n", "agg('Account.R3999');\n", "", "", "", "", ""};
    private static final String[] Numbers_NOT_RPT = new String[]{"PresetRule01", "PresetRule02", "PresetRule03"};
    private static String[] Namess_NOT_RPT = new String[]{BCMConstant.getBS_BIZRULE_NAME(), BCMConstant.getPL_BIZRULE_NAME(), BCMConstant.getCF_BIZRULE_NAME()};
    private static final String[] Contentss_NOT_RPT = new String[]{"agg('Account.R1003');\nagg('Account.R1038');\nagg('AuditTrail.ATTotal');\n", "agg('Account.R2002');\nagg('Account.R2032');\nagg('AuditTrail.ATTotal');\n", "agg('Account.R3003');\nagg('Account.R3044');\nagg('Account.R3066');\nagg('AuditTrail.ATTotal');\n"};

    public static void setDefaultNode(DynamicObject model, ApplicationTypeEnum app) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (app == ApplicationTypeEnum.EB || app == ApplicationTypeEnum.BGMD) {
            BizRuleCatalogServiceHelper.preBizRuleCatalog(model, app, map);
            BizRuleCatalogServiceHelper.preBizRule(model, app, map);
        } else {
            BizRuleCatalogServiceHelper.preBizRuleCatalog(model, app, map);
            BizRuleCatalogServiceHelper.preBizRuleCatalog_new(model, app, map);
            BizRuleCatalogServiceHelper.preBizRule(model, app, map);
        }
    }

    private static void preBizRule(DynamicObject model, ApplicationTypeEnum app, Map<String, Long> map) {
        if (ConfigServiceHelper.getBoolParam(model.getLong("id"), "CM006")) {
            return;
        }
        boolean isTrue = true;
        boolean isFalse = false;
        if (app != ApplicationTypeEnum.EB && app != ApplicationTypeEnum.BGMD) {
            String[] contents;
            String[] names;
            String[] numbers;
            Object[] records;
            Object[] rules;
            long modelId = model.getLong("id");
            if (app == ApplicationTypeEnum.RPT) {
                rules = new Object[8];
                records = new Object[8];
                numbers = Numbers_RPT;
                names = Names_RPT;
                contents = Contents_RPT;
            } else {
                rules = new Object[3];
                records = new Object[3];
                numbers = Numbers_NOT_RPT;
                names = Namess_NOT_RPT;
                contents = Contentss_NOT_RPT;
            }
            DynamicObject rule_x = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleentity");
            DynamicObject record_x = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleversion");
            Long catalog = map.get(BizRuleCatalogEnum.IRpt.getNumber());
            for (int i = 0; i < rules.length; ++i) {
                String executeseq = BizRuleCatalogEnum.IRpt.getName() + String.valueOf(i + 1);
                rule_x = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleentity");
                DimensionServiceHelper.initRuleDyObject(rule_x);
                rule_x.set("number", (Object)numbers[i]);
                rule_x.set("name", (Object)names[i]);
                rule_x.set("catalog", (Object)catalog);
                rule_x.set("status", (Object)1);
                rule_x.set("model", (Object)modelId);
                rule_x.set("content", (Object)contents[i]);
                rule_x.set("debug", (Object)contents[i]);
                rule_x.set("runstatus", (Object)BizRuleRunStatusEnum.COMMITED.getIndex());
                rule_x.set("executeseq", (Object)executeseq);
                rule_x.set("priority", (Object)1);
                rule_x.set("processcatalog", (Object)catalog);
                rule_x.set("issyspreset", (Object)isTrue);
                rule_x.set("deletestatus", (Object)isFalse);
                BizRuleCatalogServiceHelper.setBizRulenultiCatalog(rule_x, map.get("MRpt"));
                rules[i] = rule_x;
                record_x = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleversion");
                DimensionServiceHelper.initCommonDyObject(record_x);
                record_x.set("number", (Object)numbers[i]);
                record_x.set("name", (Object)names[i]);
                record_x.set("catalog", (Object)catalog);
                record_x.set("status", (Object)1);
                record_x.set("model", (Object)modelId);
                record_x.set("content", (Object)contents[i]);
                record_x.set("debug", (Object)contents[i]);
                record_x.set("runstatus", (Object)BizRuleRunStatusEnum.COMMITED.getIndex());
                record_x.set("executeseq", (Object)executeseq);
                record_x.set("processcatalog", (Object)catalog);
                record_x.set("issyspreset", (Object)isTrue);
                record_x.set("deletestatus", (Object)isFalse);
                record_x.set("version", (Object)1);
                records[i] = record_x;
            }
            BusinessDataWriter.save((IDataEntityType)rule_x.getDynamicObjectType(), (Object[])rules);
            BusinessDataWriter.save((IDataEntityType)record_x.getDynamicObjectType(), (Object[])records);
        }
    }

    private static void preBizRuleCatalog(DynamicObject model, ApplicationTypeEnum app, Map<String, Long> map) {
        int maxLevel = app == ApplicationTypeEnum.EB || app == ApplicationTypeEnum.BGMD ? 0 : 4;
        for (int i = 0; i <= maxLevel; ++i) {
            for (BizRuleCatalogEnum bizRuleCatalogEnum : BizRuleCatalogEnum.values()) {
                if (bizRuleCatalogEnum.getLevel() != i) continue;
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulecatalog");
                obj.set("number", (Object)bizRuleCatalogEnum.getNumber());
                Map<Lang, String> transInfo = LanguageUtil.getTranslate(bizRuleCatalogEnum.getName(), "BizRuleCatalog_" + bizRuleCatalogEnum.getNumber(), "fi-bcm-business");
                obj.set("name", LanguageUtil.getName(bizRuleCatalogEnum.getName(), transInfo));
                obj.set("model", model.get("id"));
                obj.set("longnumber", (Object)1);
                obj.set("status", (Object)"C");
                obj.set("enable", (Object)1);
                obj.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
                obj.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
                obj.set("isleaf", (Object)0);
                obj.set("level", (Object)i);
                if (bizRuleCatalogEnum.getParent() != null) {
                    obj.set("parent", (Object)map.get(bizRuleCatalogEnum.getParent()));
                } else {
                    obj.set("parent", (Object)0);
                }
                DynamicObject[] parent = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                map.put(bizRuleCatalogEnum.getNumber(), parent[0].getLong("id"));
            }
        }
    }

    private static void preBizRuleCatalog_new(DynamicObject model, ApplicationTypeEnum app, Map<String, Long> map) {
        ArrayList catalogs = Lists.newArrayList();
        QFBuilder qf = new QFBuilder("model", "=", (Object)model.getLong("id"));
        qf.add("level", "!=", (Object)1);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id,number,name,longnumber", (QFilter[])qf.toArray());
        LocaleString rootLs = ResManager.getLocaleString((String)"\u89c4\u5219\u5206\u7c7b", (String)"BizRuleCatalog_root", (String)"fi-bcm-business");
        DynamicObject obj1 = BizRuleCatalogServiceHelper.getSCatalogDynamicObject(model, map, 0L, root, rootLs, 1, root);
        catalogs.add(obj1);
        map.put(obj1.getString("number"), obj1.getLong("id"));
        LocaleString adminLs = ResManager.getLocaleString((String)"\u7ba1\u7406\u5458\u4e13\u7528", (String)"BizRuleCatalog_admin", (String)"fi-bcm-business");
        DynamicObject obj2 = BizRuleCatalogServiceHelper.getSCatalogDynamicObject(model, map, 0L, admin, adminLs, 1, "root!admin");
        catalogs.add(obj2);
        map.put(obj2.getString("number"), obj2.getLong("id"));
        int seq = 2;
        for (DynamicObject dy : doc) {
            LocaleString localeString = ResManager.getLocaleString((String)dy.getString("name"), (String)("BizRuleCatalog_" + dy.getString("number")), (String)"fi-bcm-business");
            DynamicObject obj = BizRuleCatalogServiceHelper.getSCatalogDynamicObject(model, map, dy.getLong("id"), dy.getString("number"), localeString, seq, dy.getString("longnumber").replace("Scenario", root));
            catalogs.add(obj);
            map.put(obj.getString("number"), obj.getLong("id"));
            ++seq;
        }
        SaveServiceHelper.save((DynamicObject[])catalogs.toArray(new DynamicObject[0]));
    }

    private static void setBizRulenultiCatalog(DynamicObject bizrule, Long scatalog) {
        if (scatalog == null) {
            return;
        }
        DynamicObjectCollection doc = bizrule.getDynamicObjectCollection("scatalog");
        DynamicObject dynamicObject = new DynamicObject(bizrule.getDynamicObjectCollection("scatalog").getDynamicObjectType(), (Object)DB.genGlobalLongId());
        dynamicObject.set("fbasedataid", (Object)scatalog);
        doc.add((Object)dynamicObject);
        bizrule.set("scatalog", (Object)doc);
    }

    private static DynamicObject getSCatalogDynamicObject(DynamicObject model, Map<String, Long> map, long sid, String number, LocaleString name, int seq, String longnumber) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescatalog");
        obj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        obj.set("number", (Object)number);
        obj.set("name", (Object)name);
        obj.set("model", model.get("id"));
        obj.set("longnumber", (Object)longnumber);
        obj.set("isleaf", (Object)(root.equals(longnumber) ? 0 : 1));
        obj.set("level", (Object)(root.equals(longnumber) ? 1 : 2));
        obj.set("scene", (Object)sid);
        obj.set("kseq", (Object)seq);
        if (root.equals(longnumber)) {
            obj.set("parent", (Object)0L);
        } else {
            obj.set("parent", (Object)map.get(root));
        }
        return obj;
    }

    public static DynamicObject getNewBizRuleSCatalog(String number, String name, long modelId, long scenid) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescatalog");
        obj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        obj.set("number", (Object)number);
        obj.set("name", LanguageUtil.getValue(name, "BizRuleCatalog_" + number, "fi-bcm-business"));
        obj.set("model", (Object)modelId);
        obj.set("longnumber", (Object)("root!" + number));
        obj.set("isleaf", (Object)1);
        obj.set("level", (Object)2);
        obj.set("scene", (Object)scenid);
        QFBuilder filter = new QFBuilder("level", "=", (Object)2);
        filter.add("model", "=", (Object)modelId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_bizrulescatalog", (String)"parent,kseq", (QFilter[])filter.toArray(), (String)"kseq desc");
        int seq = 1;
        long parent = 0L;
        if (!doc.isEmpty()) {
            seq = ((DynamicObject)doc.get(0)).getInt("kseq");
            parent = ((DynamicObject)doc.get(0)).getLong("parent");
        }
        obj.set("kseq", (Object)(seq + 1));
        obj.set("parent", (Object)parent);
        return obj;
    }

    public static void upgradeAllModel() {
        QFilter appfilter = new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.getOIndex()).or("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{appfilter});
        for (DynamicObject model : doc) {
            long modelId = model.getLong("id");
            BizRuleCatalogServiceHelper.updateModel(modelId);
        }
    }

    public static void updateModel(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (!QueryServiceHelper.exists((String)"bcm_bizrulescatalog", (QFilter[])new QFilter[]{filter})) {
            DynamicObject[] rules;
            DynamicObject[] sysPre = new DynamicObject[2];
            sysPre[0] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescatalog");
            long rootId = GlobalIdUtil.genGlobalLongId();
            sysPre[0].set("id", (Object)rootId);
            Map<Lang, String> transInfo = LanguageUtil.getTranslate(BizRuleScenarioCatalogEnum.Root.getName(), "BizRuleCatalog_" + BizRuleScenarioCatalogEnum.Root.getNumber(), "fi-bcm-business");
            sysPre[0].set("name", LanguageUtil.getName(BizRuleScenarioCatalogEnum.Root.getName(), transInfo));
            sysPre[0].set("number", (Object)BizRuleScenarioCatalogEnum.Root.getNumber());
            sysPre[0].set("longnumber", (Object)BizRuleScenarioCatalogEnum.Root.getNumber());
            sysPre[0].set("level", (Object)BizRuleScenarioCatalogEnum.Root.getLevel());
            sysPre[0].set("isleaf", (Object)0);
            sysPre[0].set("parent", (Object)0L);
            sysPre[0].set("model", (Object)modelId);
            sysPre[0].set("kseq", (Object)0);
            sysPre[0].set("scene", (Object)0L);
            sysPre[0].set("issystem", (Object)1);
            sysPre[1] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescatalog");
            long adminId = GlobalIdUtil.genGlobalLongId();
            sysPre[1].set("id", (Object)adminId);
            Map<Lang, String> trans = LanguageUtil.getTranslate(BizRuleScenarioCatalogEnum.Admin.getName(), "BizRuleCatalog_" + BizRuleScenarioCatalogEnum.Admin.getNumber(), "fi-bcm-business");
            sysPre[1].set("name", LanguageUtil.getName(BizRuleScenarioCatalogEnum.Admin.getName(), trans));
            sysPre[1].set("number", (Object)BizRuleScenarioCatalogEnum.Admin.getNumber());
            sysPre[1].set("longnumber", (Object)(BizRuleScenarioCatalogEnum.Root.getNumber() + "!" + BizRuleScenarioCatalogEnum.Admin.getNumber()));
            sysPre[1].set("level", (Object)BizRuleScenarioCatalogEnum.Admin.getLevel());
            sysPre[1].set("isleaf", (Object)1);
            sysPre[1].set("parent", (Object)rootId);
            sysPre[1].set("model", (Object)modelId);
            sysPre[1].set("kseq", (Object)0);
            sysPre[1].set("scene", (Object)0L);
            sysPre[1].set("issystem", (Object)1);
            SaveServiceHelper.save((DynamicObject[])sysPre);
            QFilter filter1 = new QFilter("level", "=", (Object)2);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id, name, number, dseq", (QFilter[])new QFilter[]{filter, filter1}, (String)"dseq");
            DynamicObject[] catalogs = new DynamicObject[collection.size()];
            if (!collection.isEmpty()) {
                for (int i = 0; i < collection.size(); ++i) {
                    catalogs[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulescatalog");
                    catalogs[i].set("name", LanguageUtil.getValue(((DynamicObject)collection.get(i)).getString("name"), "BizRuleCatalog_" + ((DynamicObject)collection.get(i)).getString("number"), "fi-bcm-business"));
                    catalogs[i].set("number", (Object)((DynamicObject)collection.get(i)).getString("number"));
                    catalogs[i].set("longnumber", (Object)(BizRuleScenarioCatalogEnum.Root.getNumber() + "!" + ((DynamicObject)collection.get(i)).getString("number")));
                    catalogs[i].set("level", (Object)2);
                    catalogs[i].set("isleaf", (Object)1);
                    catalogs[i].set("parent", (Object)rootId);
                    catalogs[i].set("model", (Object)modelId);
                    catalogs[i].set("kseq", (Object)(((DynamicObject)collection.get(i)).getInt("dseq") + 1));
                    catalogs[i].set("scene", (Object)((DynamicObject)collection.get(i)).getLong("id"));
                    catalogs[i].set("issystem", (Object)1);
                }
                SaveServiceHelper.save((DynamicObject[])catalogs);
            }
            for (DynamicObject rule : rules = BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)"id, name, number, scenarios, scatalog", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection scatalogs;
                DynamicObjectCollection scenCollection = rule.getDynamicObjectCollection("scenarios");
                if (scenCollection != null && !scenCollection.isEmpty()) {
                    scatalogs = rule.getDynamicObjectCollection("scatalog");
                    for (DynamicObject scen : scenCollection) {
                        DynamicObject object = new DynamicObject(scatalogs.getDynamicObjectType());
                        object.set("fbasedataid", (Object)rule.getLong("id"));
                        object.set("fbasedataid_id", (Object)BizRuleCatalogServiceHelper.getScenarioCatalogId(catalogs, scen.getDynamicObject("fbasedataid").getString("number")));
                        scatalogs.add((Object)object);
                    }
                    continue;
                }
                scatalogs = rule.getDynamicObjectCollection("scatalog");
                DynamicObject object = new DynamicObject(scatalogs.getDynamicObjectType());
                object.set("fbasedataid", (Object)rule.getLong("id"));
                object.set("fbasedataid_id", (Object)catalogs[0].getLong("id"));
                scatalogs.add((Object)object);
            }
            SaveServiceHelper.save((DynamicObject[])rules);
        }
    }

    private static long getScenarioCatalogId(DynamicObject[] catalogs, String string) {
        for (DynamicObject catalog : catalogs) {
            if (!catalog.getString("number").equals(string)) continue;
            return catalog.getLong("id");
        }
        return 0L;
    }
}

