/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.DimDataSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BizRuleScriptAnalyzer;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.XDMDimensionFilterItem;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.spread.formula.ICustomerFormat;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.OperationExpr;
import kd.fi.bcm.spread.formula.expr.OperationType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleUtil {
    public static DynamicObject[] createExecRecord(Object[] bizRuleIds, Object modelId) {
        DynamicObject[] execInfos = new DynamicObject[bizRuleIds.length];
        for (int i = 0; i < bizRuleIds.length; ++i) {
            execInfos[i] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brexecuteinfoentity");
            BizRuleUtil.setExecRecord(execInfos[i], modelId, bizRuleIds[i]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])execInfos);
    }

    private static void setExecRecord(DynamicObject execInfo, Object modelId, Object bizRuleId) {
        execInfo.set("bizrule", bizRuleId);
        execInfo.set("model", modelId);
        execInfo.set("starttime", (Object)System.currentTimeMillis());
        execInfo.set("execstatus", (Object)BRExecStatusEnum.EXECUTING.getIndex());
        execInfo.set("executor", (Object)RequestContext.get().getUserId());
    }

    public static long getPeriodDimensionId(Object modelId) {
        QFilter filter = new QFilter("number", "=", (Object)DimTypesEnum.PERIOD.getNumber());
        filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
    }

    public static long getProcessDimensionId(Object modelId) {
        QFilter filter = new QFilter("number", "=", (Object)DimTypesEnum.PROCESS.getNumber());
        filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
        return QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
    }

    public static Map<String, Long> getAllTemplateNumberAndIdMap(long modelId) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("versionnumber", "=", (Object)1));
        filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject template : templates) {
            map.put(template.getString("number"), template.getLong("id"));
        }
        return map;
    }

    public static String validBizRuleNumber(String number) {
        String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BizRuleUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static void updateBizRuleInternalId(WatchLogger log) {
        try (DataSet ds1 = DB.queryDataSet((String)"", (DBRoute)BCMConstant.DBROUTE, (String)"select fid id from t_bcm_bizrule where finternalid = 0");
             DataSet ds2 = DB.queryDataSet((String)"", (DBRoute)BCMConstant.DBROUTE, (String)"select finternalid from t_bcm_bizrule order by finternalid desc");){
            long max = BizRuleUtil.getMaxInternal(ds2);
            HashMap<Long, Long> map = new HashMap<Long, Long>(16);
            for (Row row : ds1) {
                Long id = row.getLong("id");
                map.put(id, max++);
            }
            if (!map.isEmpty()) {
                String updateSql = "update t_bcm_bizrule set finternalid = ? where fid = ?";
                ArrayList paramsList = new ArrayList();
                map.forEach((key, value) -> {
                    Object[] param = new Object[]{value, key};
                    paramsList.add(param);
                });
                int[] ints = DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
                if (log != null) {
                    log.info("update amount: " + ints.length);
                }
            }
        }
    }

    private static long getMaxInternal(DataSet ds2) {
        if (ds2.hasNext()) {
            return ds2.next().getLong("finternalid") + 1L;
        }
        return 1L;
    }

    public static String getTemporaryStr(String getRateformula) {
        String[] strs = getRateformula.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (i <= 1) {
                sb.append(strs[i].replace("\"", ""));
            } else {
                sb.append(strs[i]);
            }
            if (i == strs.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getFunctionNameByScope(int scopeInt) {
        if (scopeInt == RangeEnum.VALUE_20.getValue()) {
            return "children()";
        }
        if (scopeInt == RangeEnum.VALUE_90.getValue()) {
            return "base()";
        }
        if (scopeInt == RangeEnum.VALUE_50.getValue()) {
            return "hierarchy()";
        }
        if (scopeInt == RangeEnum.VALUE_40.getValue()) {
            return "descendant()";
        }
        return "";
    }

    public static String validate(String name, String number, String debug, String id, Long modelId) {
        int msgFlag = 0;
        StringBuilder msg = new StringBuilder();
        String result = BizRuleUtil.checkNumberAndName(name, number);
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            msg.append(result);
        } else {
            QFilter[] qFilters2;
            boolean nameFlag;
            QFilter filter1 = new QFilter("number", "=", (Object)number);
            QFilter filter2 = new QFilter("name", "=", (Object)name);
            QFilter filter3 = new QFilter("model", "=", (Object)modelId);
            QFilter filter4 = new QFilter("id", "!=", (Object)Long.parseLong(id));
            QFilter filter5 = new QFilter("deletestatus", "!=", (Object)true);
            QFilter[] qFilters1 = new QFilter[]{filter1, filter3, filter4, filter5};
            boolean numberFlag = QueryServiceHelper.exists((String)"bcm_bizruleentity", (QFilter[])qFilters1);
            if (numberFlag) {
                msgFlag = 1;
            }
            if (nameFlag = QueryServiceHelper.exists((String)"bcm_bizruleentity", (QFilter[])(qFilters2 = new QFilter[]{filter2, filter3, filter4, filter5}))) {
                msgFlag += 2;
            }
            switch (msgFlag) {
                case 1: {
                    msg.append(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"BizRuleUtil_9", (String)"fi-bcm-business", (Object[])new Object[0]));
                    break;
                }
                case 2: {
                    msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\u3002", (String)"BizRuleUtil_10", (String)"fi-bcm-business", (Object[])new Object[0]));
                    break;
                }
                case 3: {
                    msg.append(ResManager.loadKDString((String)"\u7f16\u7801\u548c\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizRuleUtil_11", (String)"fi-bcm-business", (Object[])new Object[0]));
                    break;
                }
            }
        }
        msg.append(BizRuleUtil.checkScriptGrammar(debug));
        return msg.toString();
    }

    public static String checkScriptGrammar(String script) {
        return new BizRuleScriptAnalyzer(script).checkValidate();
    }

    private static String checkNumberAndName(String name, String number) {
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleUtil_12", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)name)) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleUtil_13", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static boolean checkAllProcessBeforeSave(boolean isCommon, String alloprocess, String alloprocessname) {
        if (isCommon) {
            return false;
        }
        return !kd.bos.util.StringUtils.isNotEmpty((String)alloprocess) || !kd.bos.util.StringUtils.isNotEmpty((String)alloprocessname);
    }

    public static String getLogicForm(String logicType) {
        if (kd.bos.util.StringUtils.isEmpty((String)logicType) || kd.bos.util.StringUtils.isEmpty((String)((String)BizRuleConstant.LOGIC_FORM_MAP.get(logicType)))) {
            return "bcm_bizrulelogicalcal";
        }
        return (String)BizRuleConstant.LOGIC_FORM_MAP.get(logicType);
    }

    public static String getDesc5() {
        return ResManager.loadKDString((String)"  \u6267\u884c\u5b8c\u6210", (String)"BizRuleUtil_8", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String getDesc4() {
        return ResManager.loadKDString((String)"  \u5f00\u59cb\u6267\u884c", (String)"BizRuleUtil_7", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String getDesc3() {
        return ResManager.loadKDString((String)"\u65e5\u5fd7\u8f93\u51fa", (String)"BizRuleUtil_6", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String getDesc2() {
        return ResManager.loadKDString((String)"\u903b\u8f91\u540d\u79f0", (String)"BizRuleUtil_5", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static String getDesc1() {
        return ResManager.loadKDString((String)"\u903b\u8f91\u7f16\u7801", (String)"BizRuleUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    public static boolean hasConditions(BizRuleComponent conditions) {
        return conditions != null && kd.bos.util.StringUtils.isNotEmpty((String)conditions.generateJsScript());
    }

    public static Map<String, Long> getAllInvTemplateNumberAndIdMap(long modelId) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId).and("versionnumber", "=", (Object)1).and("templatecatalog.longnumber", "like", (Object)"root.InvElim%");
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject template : templates) {
            map.put(template.getString("number"), template.getLong("id"));
        }
        return map;
    }

    public static String convert2Js(VFormula vFormula) {
        StringJoiner sj = new StringJoiner(",");
        vFormula.getParamList().forEach(p -> sj.add(p.toString()));
        return String.format("%s('%s')", "v", sj);
    }

    public static String wrapQuote(String str) {
        return "\"" + str + "\"";
    }

    public static String appendQuote(String str) {
        return String.format("\"+%s+\"", str);
    }

    public static String replaceSpecialJs(String str) {
        String wrappedParam = "\"ctx.E.number\"";
        String wrappedParam1 = "\"ctx.E.parent().controlOrg\"";
        String replacedStr = str;
        replacedStr = StringUtils.replace((String)replacedStr, (String)wrappedParam, (String)BizRuleUtil.unWrapQuote(wrappedParam));
        replacedStr = StringUtils.replace((String)replacedStr, (String)wrappedParam1, (String)BizRuleUtil.unWrapQuote(wrappedParam1));
        replacedStr = StringUtils.replace((String)replacedStr, (String)"getLastYearEnd()", (String)BizRuleUtil.appendQuote("getLastYearEnd()"));
        replacedStr = StringUtils.replace((String)replacedStr, (String)"FY@ctx.FY.lastYear()", (String)("FY@" + BizRuleUtil.appendQuote("ctx.FY.lastYear()")));
        replacedStr = StringUtils.replace((String)replacedStr, (String)"getLastPeriod()", (String)BizRuleUtil.appendQuote("getLastPeriod()"));
        return replacedStr;
    }

    public static String unWrapQuote(String str) {
        if (kd.bos.util.StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.replace("\"", "");
    }

    public static String getExpr(ParamItem expression) {
        return BizRuleUtil.getExpr(expression, true);
    }

    public static String getExpr(ParamItem expression, final boolean replaceEqualOperation) {
        StringBuffer sb = new StringBuffer();
        if (expression.getParam() instanceof OperationExpr) {
            OperationExpr operationExpr = (OperationExpr)expression.getParam();
            operationExpr.output(sb, new ICustomerFormat(){

                public void beforeOutput(Expression ex, StringBuffer sb) {
                    BizRuleUtil.formatFunctionExpr(ex);
                }

                public void afterOutput(Expression ex, StringBuffer sb) {
                    BizRuleUtil.restoreFunctionExpr(ex);
                }

                public String formatOP(String op) {
                    if (replaceEqualOperation) {
                        if ("=".equals(op)) {
                            return "==";
                        }
                        if ("<>".equals(op)) {
                            return "!=";
                        }
                    }
                    return op;
                }

                public boolean needBracket(BinaryOperationExpr myself, BinaryOperationExpr expression) {
                    return OperationType.comparePRI((int)myself.getOperationType(), (int)expression.getOperationType()) > 0;
                }
            });
        } else if (expression.getParam() instanceof FunctionExpr) {
            ((FunctionExpr)expression.getParam()).output(sb, new ICustomerFormat(){

                public void beforeOutput(Expression ex, StringBuffer sb) {
                    BizRuleUtil.formatFunctionExpr(ex);
                }

                public void afterOutput(Expression ex, StringBuffer sb) {
                    BizRuleUtil.restoreFunctionExpr(ex);
                }

                public String formatOP(String op) {
                    return op;
                }
            });
        } else {
            sb.append(expression);
        }
        return ChkFormulaServiceHelper.replaceSpace(sb.toString());
    }

    private static void restoreFunctionExpr(Expression ex) {
        if (ex instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)ex;
            functionExpr.setFuncionName(functionExpr.getFuncionName().toUpperCase(Locale.ENGLISH));
        }
    }

    private static void formatFunctionExpr(Expression ex) {
        if (ex instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)ex;
            String functionName = functionExpr.getFuncionName();
            if ("GETRATE".equals(functionName)) {
                functionExpr.setFuncionName("getRate");
                return;
            }
            if ("X".equals(functionName)) {
                return;
            }
            functionExpr.setFuncionName(functionName.toLowerCase(Locale.ENGLISH));
        }
    }

    public static Map<String, String> parseDimStr(String cube, String dimCode) {
        HashMap<String, String> dimMap = new HashMap<String, String>(4);
        if (!dimCode.trim().isEmpty()) {
            String[] dims;
            Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)cube);
            for (String temp : dims = dimCode.split(",")) {
                String key;
                String[] split = temp.split("[@.]", 2);
                if (split.length < 2) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e32%s\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a\u7ef4\u5ea6@\u6210\u5458", (String)"BizRuleUtil_19", (String)"fi-bcm-business", (Object[])new Object[0]), temp));
                }
                String dim = split[0].trim();
                String mem = split[1].trim();
                if (shortNums.containsKey(dim)) {
                    key = (String)shortNums.get(dim);
                } else if (shortNums.containsValue(dim)) {
                    key = dim;
                } else {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_14", (String)"fi-bcm-business", (Object[])new Object[0]), dim));
                }
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)cube, (String)key, (String)mem);
                if (node == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_15", (String)"fi-bcm-business", (Object[])new Object[0]), mem));
                }
                dimMap.put(key, mem);
            }
        }
        return dimMap;
    }

    public static void checkDimMap(List<String> inDims, Map<String, String> dimMap, String message) {
        for (String dim : dimMap.keySet()) {
            if (inDims.contains(dim)) continue;
            throw new BizRuleException(message);
        }
    }

    public static long getNewInternalId() {
        try (TXHandle tx = TX.required();){
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"internal", null, (String)"internal desc", (int)1);
            if (!query.isEmpty()) {
                long l = ((DynamicObject)query.get(0)).getLong("internal") + 1L;
                return l;
            }
        }
        return 1L;
    }

    public static JSONArray getRuleKeys() {
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        try (InputStream resourceAsStream = BizRuleUtil.class.getClassLoader().getResourceAsStream("bcm/keys.json");){
            if (resourceAsStream != null) {
                int charsRead;
                InputStreamReader in = new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8);
                while ((charsRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                    out.append(buffer, 0, charsRead);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return JSONArray.parseArray((String)out.toString());
    }

    public static JSONObject getECMAScript() {
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        try {
            InputStream resourceAsStream = BizRuleUtil.class.getClassLoader().getResourceAsStream("bcm/bcm_ecmascript.json");
            Object object = null;
            try {
                if (resourceAsStream != null) {
                    int charsRead;
                    InputStreamReader in = new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8);
                    while ((charsRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                        out.append(buffer, 0, charsRead);
                    }
                }
            }
            catch (Throwable in) {
                object = in;
                throw in;
            }
            finally {
                if (resourceAsStream != null) {
                    if (object != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable in) {
                            ((Throwable)object).addSuppressed(in);
                        }
                    } else {
                        resourceAsStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)out.toString());
        for (Map.Entry entry : jsonObject.entrySet()) {
            JSONObject next;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JSONObject) || !(next = (JSONObject)value).containsKey((Object)"!parent")) continue;
            String parent = next.get((Object)"!parent").toString();
            JSONObject parentObj = (JSONObject)jsonObject.get((Object)parent);
            BizRuleUtil.mergeObject(next, parentObj);
        }
        return jsonObject;
    }

    private static void mergeObject(JSONObject next, JSONObject parentObj) {
        for (Map.Entry parent : parentObj.entrySet()) {
            String key = (String)parent.getKey();
            Object value = parent.getValue();
            next.putIfAbsent((Object)key, value);
        }
    }

    public static void addOtherDimension(JSONObject jsonObject, long modelId) {
        Map shortNums = MemberReader.getDimDyoByModelId((long)modelId);
        List<String> have = Arrays.asList("E", "S", "FY", "P", "C", "BP", "A");
        JSONObject scriptCell = (JSONObject)jsonObject.get((Object)"ScriptCell");
        for (Map.Entry entry : shortNums.entrySet()) {
            String number = (String)entry.getKey();
            DynamicObject dim = (DynamicObject)entry.getValue();
            String shortNumber = dim.getString("shortnumber");
            if (!have.contains(shortNumber)) {
                JSONObject prop = new JSONObject();
                prop.put("!type", (Object)"fn(value: string) -> ScriptMember");
                prop.put("!doc", (Object)String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u6210\u5458", (String)"BizRuleUtil_16", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getString("name")));
                JSONObject inProp = new JSONObject();
                inProp.put("!type", (Object)"fn(value: ?)-> ScopeInfo");
                inProp.put("!doc", (Object)String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u6210\u5458\u8303\u56f4", (String)"BizRuleUtil_17", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getString("name")));
                prop.put("in", (Object)inProp);
                jsonObject.put(number, (Object)prop);
                jsonObject.put(shortNumber, (Object)prop);
            }
            JSONObject dimObject = new JSONObject();
            dimObject.put("!type", (Object)"number");
            dimObject.put("!doc", (Object)String.format(ResManager.loadKDString((String)"%s\u6210\u5458\u7f16\u7801", (String)"BizRuleUtil_18", (String)"fi-bcm-business", (Object[])new Object[0]), dim.getString("name")));
            scriptCell.put(number, (Object)dimObject);
        }
    }

    public static boolean canEditExtData(IOutline outline, XDMScopeInfo xdmScopeInfo) {
        Map scopeItems = outline.getComputingContext().getScopeItems();
        if (xdmScopeInfo != null && CollectionUtils.isNotEmpty((Collection)xdmScopeInfo.getXdmFilters())) {
            HashMap map = new HashMap(16);
            for (XDMDimensionFilterItem xDMDimensionFilterItem : xdmScopeInfo.getXdmFilters()) {
                if (!scopeItems.containsKey(xDMDimensionFilterItem.getName())) continue;
                Set values = xDMDimensionFilterItem.getValues().stream().map(Object::toString).collect(Collectors.toSet());
                map.put(xDMDimensionFilterItem.getName(), values);
            }
            for (Map.Entry entry : scopeItems.entrySet()) {
                Optional memOp;
                Optional first;
                String newNum;
                String dim = (String)entry.getKey();
                String memNum = (String)((Pair)entry.getValue()).p2;
                if (dim.equals(SysDimensionEnum.Entity.getNumber())) {
                    String tar;
                    String string = newNum = memNum.contains("_") ? memNum.split("_")[1] : memNum;
                    Set entities = (Set)map.get(SysDimensionEnum.Entity.getNumber());
                    if (entities == null || !(first = entities.stream().findFirst()).isPresent() || newNum.equals(tar = ((String)first.get()).contains("_") ? ((String)first.get()).split("_")[1] : (String)first.get())) continue;
                    return false;
                }
                if (dim.equals(SysDimensionEnum.Process.getNumber())) {
                    newNum = BizRuleUtil.switchProcess(memNum);
                    Set process = (Set)map.get(SysDimensionEnum.Process.getNumber());
                    if (process == null || !(first = process.stream().findFirst()).isPresent() || ((String)first.get()).equals(newNum)) continue;
                    return false;
                }
                Set mems = (Set)map.get(dim);
                if (mems == null || !(memOp = mems.stream().findFirst()).isPresent() || ((String)memOp.get()).equals(memNum)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canEditExtData(IOutline outline, Map<String, String[]> dimFilter) {
        if (BizRuleExecuteTypeEnum.INTR_ONLY == outline.getBuiltin().getArgs().get("executeType")) {
            return true;
        }
        Map scopeItems = outline.getComputingContext().getScopeItems();
        for (Map.Entry entry : scopeItems.entrySet()) {
            String newNum;
            String dim = (String)entry.getKey();
            String memNum = (String)((Pair)entry.getValue()).p2;
            if (dim.equals(SysDimensionEnum.Entity.getNumber())) {
                String tar;
                String string = newNum = memNum.contains("_") ? memNum.split("_")[1] : memNum;
                String[] entity = dimFilter.get(SysDimensionEnum.Entity.getNumber());
                if (entity == null || entity.length != 1 || newNum.equals(tar = entity[0].contains("_") ? entity[0].split("_")[1] : entity[0])) continue;
                return false;
            }
            if (dim.equals(SysDimensionEnum.Process.getNumber())) {
                newNum = BizRuleUtil.switchProcess(memNum);
                String[] process = dimFilter.get(SysDimensionEnum.Process.getNumber());
                if (process == null || process.length != 1 || BizRuleUtil.switchProcess(process[0]).equals(newNum)) continue;
                return false;
            }
            String[] mems = dimFilter.get(dim);
            if (mems == null || mems.length != 1 || memNum.equals(mems[0])) continue;
            return false;
        }
        return true;
    }

    public static String switchProcess(String process) {
        String res = process;
        if ("EIRpt".equals(process)) {
            res = "IRpt";
        } else if ("ERAdj".equals(process)) {
            res = "RAdj";
        }
        return res;
    }

    public static boolean isOpenVersion(String modelNum, long scenario, long year, long period) {
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        return ConfigServiceHelper.getBoolParam(modelId, "CM060") && scenario != 0L && year != 0L && period != 0L;
    }

    public static boolean isValidIC(String modelNum, long scenario, long year, long period, String entityNum) {
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        if (BizRuleUtil.isOpenVersion(modelNum, scenario, year, period)) {
            VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
            IDNumberTreeNode icNode = ICVersionServiceHelper.getValidIC(param, entityNum);
            return icNode != IDNumberTreeNode.NotFoundTreeNode && icNode.getParent() != null && "ICEntity".equals(icNode.getParent().getNumber());
        }
        return true;
    }

    public static ScriptMember[] validICByScope(ScriptMember member, long scenario, long year, long period, int range) {
        String modelNum = member.getOutline().getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        IDNumberTreeNode icNode = MemberReader.findMemberById((String)modelNum, (String)"bcm_icmembertree", (Long)member.getId());
        MembBaseItem item = new MembBaseItem("bcm_icmembertree", icNode.getId(), icNode.getLongNumber(), icNode.getNumber(), range, false, (Object)modelId);
        VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
        ArrayList members = new ArrayList(10);
        item.matchItem4Ic(param, ic -> members.add(ScriptMember.create((String)ic.getNumber(), (ScriptDimension)member.getDimension(), (long)((Long)ic.getId()))));
        return members.toArray(new ScriptMember[0]);
    }

    public static ScriptMember validParent(ScriptMember member, long scenario, long year, long period) {
        String modelNum = member.getOutline().getModelNum();
        VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
        IDNumberTreeNode icNode = ICVersionServiceHelper.getValidIC(param, member.getNumber());
        if (icNode != IDNumberTreeNode.NotFoundTreeNode && icNode.getParent() != null) {
            return ScriptMember.create((String)icNode.getParent().getNumber(), (ScriptDimension)member.getDimension(), (long)icNode.getParent().getId());
        }
        return null;
    }

    public static boolean isValidBase(String modelNum, long scenario, long year, long period, String icNum, String parent) {
        VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
        IDNumberTreeNode icNode = ICVersionServiceHelper.getValidIC(param, icNum);
        IDNumberTreeNode parentNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)parent);
        if (icNode != IDNumberTreeNode.NotFoundTreeNode && parentNode != IDNumberTreeNode.NotFoundTreeNode) {
            String[] parents = icNode.getLongNumber().split("!");
            for (int i = 0; i < parents.length - 1; ++i) {
                if (!parents[i].equals(parentNode.getNumber())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isValidDescendant(String modelNum, long scenario, long year, long period, String icNum, String parent) {
        VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
        IDNumberTreeNode icNode = ICVersionServiceHelper.getValidIC(param, icNum);
        IDNumberTreeNode parentNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)parent);
        if (icNode != IDNumberTreeNode.NotFoundTreeNode && parentNode != IDNumberTreeNode.NotFoundTreeNode) {
            return parentNode.getAllChildren(4).stream().anyMatch(c -> c.getId() != null && icNode.getId() != null && Objects.equals(c.getId(), icNode.getId()));
        }
        return false;
    }

    public static boolean isValidHierarchy(String modelNum, long scenario, long year, long period, String icNum, String parent) {
        return BizRuleUtil.isValidDescendant(modelNum, scenario, year, period, icNum, parent) || parent.contains(icNum);
    }

    public static boolean isValidChild(String modelNum, long scenario, long year, long period, String icNum, String parent) {
        VersionParam param = new VersionParam(MemberReader.findModelIdByNum((String)modelNum), scenario, year, period);
        IDNumberTreeNode icNode = ICVersionServiceHelper.getValidIC(param, icNum);
        IDNumberTreeNode parentNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)parent);
        if (icNode != IDNumberTreeNode.NotFoundTreeNode && parentNode != IDNumberTreeNode.NotFoundTreeNode) {
            return parentNode.getChildren().stream().anyMatch(c -> c.getId() != null && icNode.getId() != null && Objects.equals(c.getId(), icNode.getId()));
        }
        return false;
    }

    public static void validCanMergeOrgEditData(IOutline outline, SaveCommand saveCommand) {
        if (ScriptBuiltinExtHelper.isIntrOnlyExectype(outline)) {
            return;
        }
        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((String)outline.getModelNum(), (Long)((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1));
        String process = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM)).p2;
        boolean isLeaf = treeNode.isLeaf();
        if (!isLeaf) {
            for (Object[] values : saveCommand.getAllValues()) {
                BizRuleUtil.checkATIsLeaf(saveCommand.getModelNum(), values[values.length - 1]);
            }
            if (BizRuleUtil.isCSTE(outline)) {
                return;
            }
            DynamicObject dy = saveCommand.getGroupObject();
            if (!dy.getBoolean("isparticipmerge")) {
                return;
            }
            Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
            for (Object[] values : saveCommand.getAllValues()) {
                if (BizRuleUtil.processIsAdjust(process) && BizRuleUtil.isFromAdjustDataSource(modelId, values[values.length - 1] == null ? "" : values[values.length - 1].toString())) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"\u5408\u5e76\u6570\u636e\u6765\u6e90\u4e3a\u201c\u62a5\u8868\u6c47\u603b\u201d\u7684\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u5728\u6570\u636e\u6765\u6e90\u4e3a\u975e\u8c03\u6574\u7684\u5ba1\u8ba1\u7ebf\u7d22\u548c\u975e\u8c03\u6574\u7c7b\u8fc7\u7a0b\u4e0a\u4fee\u6539\u201c\u53c2\u4e0e\u5408\u5e76\u201d\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else {
            for (Object[] values : saveCommand.getAllValues()) {
                BizRuleUtil.checkATIsLeaf(saveCommand.getModelNum(), values[values.length - 1]);
            }
        }
    }

    public static void validCanMergeOrgEditData(IOutline outline, EDResultSet edRs, QueryCommand queryCommand) {
        if (ScriptBuiltinExtHelper.isIntrOnlyExectype(queryCommand.getOutline())) {
            return;
        }
        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((String)outline.getModelNum(), (Long)((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1));
        String process = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM)).p2;
        boolean isLeaf = treeNode.isLeaf();
        if (!isLeaf) {
            for (EDRow row : edRs.getRows()) {
                Object atNum = row.getValue(row.getMetaData().getColIndex("AuditTrail"));
                BizRuleUtil.checkATIsLeaf(queryCommand.getModelNum(), atNum);
            }
            if (!queryCommand.getGroupObject().getBoolean("isparticipmerge") || !BizRuleUtil.isCSTE(outline)) {
                return;
            }
            for (EDRow row : edRs.getRows()) {
                if (BizRuleUtil.processIsAdjust(process) && BizRuleUtil.isFromAdjustDataSource(queryCommand.getModelId(), row.getValue(row.getMetaData().getColIndex("AuditTrail")).toString())) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"\u5408\u5e76\u6570\u636e\u6765\u6e90\u4e3a\u201c\u62a5\u8868\u6c47\u603b\u201d\u7684\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u5728\u6570\u636e\u6765\u6e90\u4e3a\u975e\u8c03\u6574\u7684\u5ba1\u8ba1\u7ebf\u7d22\u548c\u975e\u8c03\u6574\u7c7b\u8fc7\u7a0b\u4e0a\u4fee\u6539\u201c\u53c2\u4e0e\u5408\u5e76\u201d\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else {
            for (EDRow row : edRs.getRows()) {
                Object atNum = row.getValue(row.getMetaData().getColIndex("AuditTrail"));
                BizRuleUtil.checkATIsLeaf(queryCommand.getModelNum(), atNum);
            }
        }
    }

    private static void checkATIsLeaf(String modelNum, Object atNum) {
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)SysDimensionEnum.AuditTrail.getNumber(), (String)(atNum == null ? "" : atNum.toString()));
        if (node == IDNumberTreeNode.NotFoundTreeNode || !node.isLeaf()) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22%s\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u4e0d\u80fd\u65b0\u589e\u548c\u4fee\u6539\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_55", (String)"fi-bcm-business", (Object[])new Object[0]), node.getNumber()));
        }
    }

    private static boolean isCSTE(IOutline outline) {
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        Map scopeItems = outline.getComputingContext().getScopeItems();
        return MergeDataSourceEnum.CSTE == MergeControlHelper.getMergeSource((Object)modelId, ((Pair)scopeItems.get((Object)PresetConstant.SCENE_DIM)).p1, ((Pair)scopeItems.get((Object)PresetConstant.FY_DIM)).p1, ((Pair)scopeItems.get((Object)PresetConstant.PERIOD_DIM)).p1, ((Pair)scopeItems.get((Object)PresetConstant.ENTITY_DIM)).p1);
    }

    public static boolean isXDMScopeMultiDim(XDMScopeInfo scopeInfo) {
        Collection filters;
        if (scopeInfo != null && !(filters = scopeInfo.getXdmFilters()).isEmpty()) {
            for (XDMDimensionFilterItem filter : filters) {
                String name = filter.getName();
                if (!"Entity".equals(name) && !"Scenario".equals(name) && !"Year".equals(name) && !"Period".equals(name) && !"Currency".equals(name) && !"Process".equals(name) && !"AuditTrail".equals(name) || filter.getValues().size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateQueryCommandNeedSum(QueryCommand queryCommand) {
        IDNumberTreeNode entityNode;
        Map<String, String[]> dimFilter = queryCommand.getDimFilter();
        if (dimFilter.get(DimTypesEnum.PROCESS.getNumber()) == null || dimFilter.get(DimTypesEnum.AUDITTRIAL.getNumber()) == null || dimFilter.get(DimTypesEnum.ENTITY.getNumber()) == null || dimFilter.get(DimTypesEnum.SCENARIO.getNumber()) == null || dimFilter.get(DimTypesEnum.YEAR.getNumber()) == null || dimFilter.get(DimTypesEnum.PERIOD.getNumber()) == null) {
            throw new BizRuleException("params error");
        }
        String processValue = dimFilter.get(DimTypesEnum.PROCESS.getNumber())[0];
        String atValue = dimFilter.get(DimTypesEnum.AUDITTRIAL.getNumber())[0];
        String orgValue = dimFilter.get(DimTypesEnum.ENTITY.getNumber())[0];
        String sceneValue = dimFilter.get(DimTypesEnum.SCENARIO.getNumber())[0];
        String yearValue = dimFilter.get(DimTypesEnum.YEAR.getNumber())[0];
        String periodValue = dimFilter.get(DimTypesEnum.PERIOD.getNumber())[0];
        if (queryCommand.getMainOrgId() != 0L) {
            entityNode = MemberReader.findEntityMemberById((Long)queryCommand.getModelId(), (Long)queryCommand.getMainOrgId());
        } else {
            String orgNumber;
            if (queryCommand.getParentOrg() != null) {
                orgNumber = queryCommand.getParentOrg() + "_" + orgValue;
            } else {
                String parentOrgBaseNumber = TreeStructureServiceHelper.getParentOrgBaseNumber(queryCommand.getModelNum(), orgValue);
                orgNumber = parentOrgBaseNumber + "_" + orgValue;
            }
            entityNode = MemberReader.findMemberByNumber((String)queryCommand.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNumber);
        }
        if (ThreadCache.get((Object)(queryCommand.getDatamodel() + "needSum")) != null) {
            if (!MemberReader.findProcessMemberByNum((String)queryCommand.getModelNum(), (String)processValue).isLeaf() || !MemberReader.findMemberByNumber((String)queryCommand.getModelNum(), (String)DimEntityNumEnum.AUDITTRIAL.getNumber(), (String)atValue).isLeaf()) {
                queryCommand.setNeedSum(true);
            } else if (!queryCommand.getGroupObject().getBoolean("isparticipmerge")) {
                queryCommand.setNeedSum(false);
            } else {
                queryCommand.setNeedSum(!entityNode.isLeaf() && MergeDataSourceEnum.CSTE != MergeControlHelper.getMergeSource((Object)queryCommand.getModelId(), (Object)MemberReader.findScenaMemberByNum((String)queryCommand.getModelNum(), (String)sceneValue).getId(), (Object)MemberReader.findScenaMemberByNum((String)queryCommand.getModelNum(), (String)yearValue).getId(), (Object)MemberReader.findScenaMemberByNum((String)queryCommand.getModelNum(), (String)periodValue).getId(), entityNode.getId()) && (!BizRuleUtil.processIsAdjust(processValue) || !BizRuleUtil.isFromAdjustDataSource(queryCommand.getModelId(), atValue)));
            }
        }
        ThreadCache.remove((Object)(queryCommand.getDatamodel() + "needSum"));
    }

    public static boolean isFromAdjustDataSource(long modelId, String auNum) {
        Map sourceMap = (Map)ThreadCache.get((Object)("getAdjustDataSource" + modelId), () -> {
            DynamicObjectCollection cols = QueryServiceHelper.query((String)SysDimensionEnum.AuditTrail.getMemberTreemodel(), (String)"number,datasource", (QFilter[])new QFBuilder("model", "=", (Object)modelId).toArray());
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (DynamicObject col : cols) {
                map.put(col.getString("number"), col.getString("datasource"));
            }
            return map;
        });
        String source = (String)sourceMap.get(auNum);
        return DimDataSourceEnum.Entry.getIndex().equals(source) || DimDataSourceEnum.Style.getIndex().equals(source);
    }

    public static boolean processIsAdjust(String process) {
        return OrgRelaProcessMembPool.isRelaProcess((String)process) || "ERAdj".equals(process) || "RAdj".equals(process);
    }

    public static void setMethodNeed(String datamodelNum) {
        ThreadCache.put((Object)(datamodelNum + "needSum"), (Object)true);
    }
}

