/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.MergeControlStatus;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.helper.InvShareCaseSetHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationScaleHelper;
import kd.fi.bcm.business.invest.invratio.model.InvRelationScaleInfo;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.constant.invest.sharerela.InvDynamicStockRatioConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.ChangeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.ReportTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleReportStatusEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.model.BcmMap;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ScriptBuiltinInvokeHelper {
    public static final String ALL = "All";
    public static final Map<String, String> OWNER_TYPE_MAP = new HashMap<String, String>(8);
    public static final String OWNER_TYPE_D = "D";
    public static final String OWNER_TYPE_A = "A";
    public static final String OWNER_TYPE_M = "M";
    public static final String OWNER_TYPE_SLU = "SLU";
    public static final String OWNER_TYPE_DLU = "DLU";
    public static final String OWNER_TYPE_UD1 = "UD1";
    public static final String OWNER_TYPE_UD2 = "UD2";
    public static final String OWNER_TYPE_UD3 = "UD3";
    public static final String OWNER_TYPE_UD4 = "UD4";
    public static final String OWNER_TYPE_UD5 = "UD5";
    public static final String OWNER_TYPE_UD6 = "UD6";
    public static final String OWNER_TYPE_UD7 = "UD7";
    public static final String OWNER_TYPE_UD8 = "UD8";
    public static final String OWNER_TYPE_UD9 = "UD9";
    public static final String OWNER_TYPE_UD10 = "UD10";
    public static final String OWNER_TYPE_UD11 = "UD11";
    public static final String OWNER_TYPE_UD12 = "UD12";
    public static final String OWNER_TYPE_UD13 = "UD13";
    public static final String OWNER_TYPE_UD14 = "UD14";
    public static final String OWNER_TYPE_UD15 = "UD15";
    public static final String OWNER_TYPE_UD16 = "UD16";
    public static final String OWNER_TYPE_UD17 = "UD17";
    public static final String OWNER_TYPE_UD18 = "UD18";
    public static final String OWNER_TYPE_UD19 = "UD19";
    public static final String OWNER_TYPE_UD20 = "UD20";
    public static final String STATIC_STATE_FIELD = "FinPOWN";
    public static final String DYNAMIC_STATE_FIELD_BOP = "FinBegPOWN";
    public static final String DYNAMIC_STATE_FIELD_ENDING_BALANCE = "FinEndPOWN";
    public static final String DYNAMIC_STATE_FIELD_CHANGE = "FinMovPOWN";
    public static final String GET_CONFLOWSTATUS = "getConFlowStatus";
    public static final List<String> OWNER_SHIP_DIM_LIST = Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.SCENARIO.getNumber());
    public static final List<String> RPT_STAT_DIM_LIST = Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.CURRENCY.getNumber());
    public static final String SPLIT = ",";

    private ScriptBuiltinInvokeHelper() {
    }

    public static JSONArray getOwnership(IOutline outline, Object[] customParams) {
        DynamicObjectCollection invRelations;
        Pair<String, String> investAndInvestedPair;
        Object ownType;
        boolean isDynamic = false;
        if (customParams.length > 3 && customParams[3] != null && StringUtils.isNotEmpty((String)customParams[3].toString())) {
            if (!"false".equals(customParams[3].toString()) && !"true".equals(customParams[3].toString())) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c\u56db\u4e2a\u53c2\u6570\u4e2d\u586b\u5165\u5e03\u5c14\u7c7b\u578b\u3002", (String)"ScriptBuiltinInvokeHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            isDynamic = Boolean.parseBoolean(customParams[3].toString());
        }
        if (!((ownType = customParams[0]) instanceof String) || !isDynamic && !OWNER_TYPE_MAP.containsKey(ownType.toString())) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u80a1\u6743\u6570\u636e\u7c7b\u578b\u53c2\u6570\uff0c\u4e14\u53ea\u80fd\u662f\u201cD\u201d\uff08\u83b7\u53d6\u76f4\u63a5\u6301\u80a1\uff09\u3001\u201cA\u201d\uff08\u7b49\u6548\u6301\u80a1\u52a0\u6cd5\uff09\u3001\u201cM\u201d\uff08\u7b49\u6548\u6301\u80a1\u4e58\u6cd5\uff09\u3001\u201cSLU\u201d\uff08\u672c\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cDLU\u201d\uff08\u8de8\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cUD1~UD20\u201d\uff08\u81ea\u5b9a\u4e49\u80a1\u67431~20\uff09\u3001\u6216\u52a8\u6001\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (customParams.length == 1) {
            investAndInvestedPair = Pair.onePair((Object)"", (Object)"");
            invRelations = ScriptBuiltinInvokeHelper.getInvRelations(ownType.toString(), null, outline, false);
        } else if (customParams.length == 2) {
            investAndInvestedPair = Pair.onePair((Object)"", (Object)"");
            invRelations = ScriptBuiltinInvokeHelper.getInvRelations(ownType.toString(), customParams[1], outline, false);
        } else {
            investAndInvestedPair = ScriptBuiltinInvokeHelper.checkParameter(customParams[2] == null ? "" : customParams[2].toString(), outline, "getOwnership");
            invRelations = ScriptBuiltinInvokeHelper.getInvRelations(ownType.toString(), customParams[1], outline, isDynamic);
        }
        if (customParams.length == 1 || customParams.length == 2 || customParams[2] == null || StringUtils.isEmpty((String)customParams[2].toString())) {
            return ScriptBuiltinInvokeHelper.createJsonArray(ownType.toString(), invRelations, isDynamic);
        }
        String filterInvestOrg = (String)investAndInvestedPair.p1;
        String filterInvestedOrg = (String)investAndInvestedPair.p2;
        DynamicObjectCollection filterInvestAndInvestedOrg = invRelations.stream().filter(invrelation -> {
            String investOrg = invrelation.getString("shareholder.number");
            String investedOrg = invrelation.getString("investeecompany.number");
            return !(!ALL.equals(filterInvestOrg) && !filterInvestOrg.equals(investOrg) || !ALL.equals(filterInvestedOrg) && !filterInvestedOrg.equals(investedOrg));
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
        return ScriptBuiltinInvokeHelper.createJsonArray(ownType.toString(), filterInvestAndInvestedOrg, isDynamic);
    }

    public static void setOwnership(IOutline outline, Object[] params) {
        Object pownCode = STATIC_STATE_FIELD;
        if (params.length == 4) {
            pownCode = params[3];
            if (!Arrays.asList(DYNAMIC_STATE_FIELD_BOP, DYNAMIC_STATE_FIELD_ENDING_BALANCE, DYNAMIC_STATE_FIELD_CHANGE).contains(pownCode)) {
                throw new BizRuleException(ResManager.loadKDString((String)"setOwnership\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u76ee\u6807\u6bd4\u4f8b\u5b57\u6bb5\u3002\u9759\u6001\u80a1\u6bd4\u4e0d\u9700\u8981\u6307\u5b9a\uff0c\u52a8\u6001\u80a1\u6bd4\u7c7b\u578b\u53ef\u6307\u5b9a\uff1aFinBegPOWN-\u786e\u8ba4\u671f\u521d\u6301\u80a1\u6bd4\u4f8b,FinEndPOWN-\u786e\u8ba4\u671f\u672b\u6301\u80a1\u6bd4\u4f8b,FinMovPOWN-\u786e\u8ba4\u53d8\u52a8\u6301\u80a1\u6bd4\u4f8b\u3002", (String)"ScriptBuiltinInvokeHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        boolean isDynamic = !STATIC_STATE_FIELD.equals(pownCode);
        Object value = params[0];
        if (!(value instanceof Number) || !isDynamic && new BigDecimal(value.toString()).compareTo(new BigDecimal(0)) < 0 || isDynamic && new BigDecimal(value.toString()).compareTo(new BigDecimal(-1)) < 0 || new BigDecimal(value.toString()).compareTo(BigDecimal.ONE) > 0) {
            throw new BizRuleException(ResManager.loadKDString((String)"setOwnership\u51fd\u6570\u6307\u5b9a\u7684\u80a1\u6743\u6bd4\u4f8b\u503c\uff0c\u9759\u6001\u80a1\u6bd4\u5e94\u4e3a0\u81f31\u4e4b\u95f4\u7684\u5c0f\u6570\uff0c\u52a8\u6001\u80a1\u6bd4\u5e94\u4e3a-1\u81f31\u4e4b\u95f4\u7684\u5c0f\u6570\u3002", (String)"ScriptBuiltinInvokeHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Object calcTypeWay = outline.getBuiltin().getArgs().get("calcTypeWay");
        if (calcTypeWay != null && (isDynamic && "0".equals(calcTypeWay.toString()) || !isDynamic && "1".equals(calcTypeWay.toString()))) {
            return;
        }
        Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
        Object type = params[1];
        if (!isDynamic && !code2InvRelaTypeEnum.containsKey(type)) {
            throw new BizRuleException(ResManager.loadKDString((String)"setOwnership\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\uff0c\u8bf7\u5230\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u9875\u9762\u67e5\u770b\u3002", (String)"ScriptBuiltinInvokeHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (isDynamic) {
            Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("number", "=", type);
            qFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            if (!QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])new QFilter[]{qFilter})) {
                throw new BizRuleException(ResManager.loadKDString((String)"setOwnership\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\uff0c\u8bf7\u5230\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u9875\u9762\u67e5\u770b\u3002", (String)"ScriptBuiltinInvokeHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        Object invest = params[2];
        ScriptBuiltinInvokeHelper.checkInvestAndInvested(outline, invest, "setOwnership");
        InvRelationScaleInfo invRelationScaleInfo = new InvRelationScaleInfo();
        invRelationScaleInfo.setModel(MemberReader.findModelIdByNum((String)outline.getModelNum()));
        invRelationScaleInfo.setScenario((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1);
        invRelationScaleInfo.setYear((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p1);
        invRelationScaleInfo.setPeriod((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1);
        invRelationScaleInfo.setRelationType(type.toString());
        invRelationScaleInfo.setCategorized(isDynamic ? "1" : "0");
        invRelationScaleInfo.setOrgUnit((String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p2);
        invRelationScaleInfo.setShareholder(invest.toString().split("_")[0]);
        invRelationScaleInfo.setInvestCompany(invest.toString().split("_")[1]);
        HashMap<String, BigDecimal> confirmScaleMap = new HashMap<String, BigDecimal>(16);
        confirmScaleMap.put(pownCode.toString(), new BigDecimal(value.toString()).multiply(new BigDecimal(100)));
        invRelationScaleInfo.setConfirmScaleMap(confirmScaleMap);
        InvRelationScaleHelper.saveScale(invRelationScaleInfo);
    }

    public static void delOwnership(IOutline outline, Object[] params) {
        boolean isDynamic = false;
        if (params.length == 3 && params[2] != null) {
            if (params[2].toString().equalsIgnoreCase("true") || params[2].toString().equalsIgnoreCase("false")) {
                isDynamic = Boolean.parseBoolean(params[2].toString());
            } else {
                throw new BizRuleException(ResManager.loadKDString((String)"\u7b2c3\u4e2a\u53c2\u6570\u8bf7\u586b\u5165\u5e03\u5c14\u7c7b\u578b\u3002", (String)"ScriptBuiltinInvokeHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
        Object type = params[0];
        if (!isDynamic && !code2InvRelaTypeEnum.containsKey(type)) {
            throw new BizRuleException(ResManager.loadKDString((String)"delOwnership\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\uff0c\u8bf7\u524d\u5f80\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u9875\u9762\u67e5\u770b\u3002", (String)"ScriptBuiltinInvokeHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (isDynamic) {
            Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("number", "=", type);
            qFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            if (!QueryServiceHelper.exists((String)"bcm_invrelatype", (QFilter[])new QFilter[]{qFilter})) {
                throw new BizRuleException(ResManager.loadKDString((String)"delOwnership\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\uff0c\u8bf7\u524d\u5f80\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e\u9875\u9762\u67e5\u770b\u3002", (String)"ScriptBuiltinInvokeHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        String invest = params.length == 1 ? "all_all" : params[1];
        ScriptBuiltinInvokeHelper.checkInvestAndInvested(outline, invest, "delOwnership");
        InvRelationScaleInfo invRelationScaleInfo = new InvRelationScaleInfo();
        invRelationScaleInfo.setModel(MemberReader.findModelIdByNum((String)outline.getModelNum()));
        invRelationScaleInfo.setScenario((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1);
        invRelationScaleInfo.setYear((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p1);
        invRelationScaleInfo.setPeriod((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1);
        invRelationScaleInfo.setRelationType(type.toString());
        invRelationScaleInfo.setCategorized(isDynamic ? "1" : "0");
        invRelationScaleInfo.setOrgUnit((String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p2);
        String shareHolder = invest.toString().split("_")[0];
        if (!shareHolder.equalsIgnoreCase("all")) {
            invRelationScaleInfo.setShareholder(shareHolder);
        }
        String investCompany = invest.toString().split("_")[1];
        if (!shareHolder.equalsIgnoreCase("all")) {
            invRelationScaleInfo.setInvestCompany(investCompany);
        }
        InvRelationScaleHelper.deleteScale(invRelationScaleInfo);
    }

    private static void checkInvestAndInvested(IOutline outline, Object invest, String method) {
        IDNumberTreeNode investedOrg;
        IDNumberTreeNode investOrg;
        if (invest == null || !invest.toString().contains("_") || invest.toString().split("_").length != 2) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570\u672a\u6307\u5b9a\u6b63\u786e\u7684\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\uff0c%s\u51fd\u6570\u6307\u5b9a\u7684\u6295\u8d44\u5bf9\u53c2\u6570\u683c\u5f0f\u5fc5\u987b\u662f\u201d\u6295\u8d44\u516c\u53f8\u7f16\u7801_\u88ab\u6295\u8d44\u516c\u53f8\u7f16\u7801\u201d\u3002", (String)"ScriptBuiltinInvokeHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), method));
        }
        String[] splits = invest.toString().split("_");
        if (!(!"delOwnership".equals(method) || "all".equalsIgnoreCase(splits[0]) || (investOrg = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)DimEntityNumEnum.INTERCOMPANY.getNumber(), (String)splits[0])) != IDNumberTreeNode.NotFoundTreeNode && investOrg.isLeaf())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!(!"delOwnership".equals(method) || "all".equalsIgnoreCase(splits[1]) || (investedOrg = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)splits[1])) != IDNumberTreeNode.NotFoundTreeNode && investedOrg.isLeaf())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static Pair<String, String> checkParameter(String investAndInvestedPair, IOutline outline, String methodName) {
        boolean valid;
        if (StringUtils.isEmpty((String)investAndInvestedPair)) {
            return Pair.onePair((Object)"", (Object)"");
        }
        String[] pair = investAndInvestedPair.split("_", 2);
        boolean bl = valid = !investAndInvestedPair.equals("All_All") && pair.length == 2 && ScriptBuiltinInvokeHelper.isValidInternalCompany(outline, pair[0]) && ScriptBuiltinInvokeHelper.isValidOrg(outline, pair[1]);
        if (!valid) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptfunctionParameterError"), new Object[]{methodName, investAndInvestedPair});
        }
        return Pair.onePair((Object)pair[0], (Object)pair[1]);
    }

    private static boolean isValidInternalCompany(IOutline outline, String org) {
        return ALL.equals(org) || MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)DimEntityNumEnum.INTERCOMPANY.getNumber(), (String)org) != IDNumberTreeNode.NotFoundTreeNode;
    }

    private static boolean isValidOrg(IOutline outline, String org) {
        return ALL.equals(org) || MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)org) != IDNumberTreeNode.NotFoundTreeNode;
    }

    private static JSONArray createJsonArray(String ownType, DynamicObjectCollection invrelations, boolean isDynamic) {
        JSONArray array = new JSONArray();
        if (CollectionUtils.isEmpty((Collection)invrelations)) {
            return array;
        }
        BigDecimal divide = new BigDecimal("100");
        if (!isDynamic) {
            invrelations.forEach(e -> {
                JSONObject jsonOb = new JSONObject();
                jsonOb.put("Entity", e.get("orgunit.number"));
                jsonOb.put("Invest", e.get("shareholder.number"));
                jsonOb.put("Invested", e.get("investeecompany.number"));
                jsonOb.put("CalcPOWN", (Object)e.getBigDecimal("equvscale").divide(divide).stripTrailingZeros());
                jsonOb.put(STATIC_STATE_FIELD, (Object)e.getBigDecimal("confirmscale").divide(divide).stripTrailingZeros());
                jsonOb.put("PMIN", (Object)e.getBigDecimal("minconfirmscale").divide(divide).stripTrailingZeros());
                if (OWNER_TYPE_D.equals(ownType)) {
                    jsonOb.put("EQMethod", e.get("isusedinvrule"));
                    jsonOb.put("INVPL", e.get("isconfirmed"));
                }
                array.add((Object)jsonOb);
            });
        } else {
            invrelations.forEach(e -> {
                JSONObject jsonOb = new JSONObject();
                jsonOb.put("Entity", e.get("merge.number"));
                jsonOb.put("Invest", e.get("shareholder.number"));
                jsonOb.put("Invested", e.get("investeecompany.number"));
                jsonOb.put("BegPOWN", (Object)e.getBigDecimal("openscale").divide(divide).stripTrailingZeros());
                jsonOb.put("EndPOWN", (Object)e.getBigDecimal("sharescale").divide(divide).stripTrailingZeros());
                jsonOb.put("MovPOWN", (Object)e.getBigDecimal("changescale").divide(divide).stripTrailingZeros());
                jsonOb.put(DYNAMIC_STATE_FIELD_BOP, (Object)e.getBigDecimal("confirmopenscale").divide(divide).stripTrailingZeros());
                jsonOb.put(DYNAMIC_STATE_FIELD_ENDING_BALANCE, (Object)e.getBigDecimal("confirmsharescale").divide(divide).stripTrailingZeros());
                jsonOb.put(DYNAMIC_STATE_FIELD_CHANGE, (Object)e.getBigDecimal("confirmchangescale").divide(divide).stripTrailingZeros());
                array.add((Object)jsonOb);
            });
        }
        return array;
    }

    private static DynamicObjectCollection getInvRelations(String ownType, Object dimScope, IOutline outline, boolean isDynamic) {
        Long periodId;
        boolean isMatch;
        HashMap dimMaps = new HashMap(4);
        if (dimScope != null && StringUtils.isNotEmpty((String)dimScope.toString())) {
            if (dimScope instanceof String) {
                Map<String, String> dimMap = BizRuleUtil.parseDimStr(outline.getModelNum(), (String)dimScope);
                BizRuleUtil.checkDimMap(OWNER_SHIP_DIM_LIST, dimMap, ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u7ef4\u5ea6\u7ec4\u5408\u53c2\u6570\u53ea\u80fd\u6307\u5b9a\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u548c\u7ec4\u7ec7\u3002", (String)"ScriptBuiltinInvokeHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                for (Map.Entry<String, String> entry : dimMap.entrySet()) {
                    dimMaps.putIfAbsent(entry.getKey(), new ArrayList(10));
                    ((List)dimMaps.get(entry.getKey())).add(entry.getValue());
                }
            } else {
                if (!(dimScope instanceof ScopeInfo) || dimScope instanceof XDMScopeInfo) {
                    throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u7684\u7ef4\u5ea6\u8303\u56f4\u53c2\u6570\u9519\u8bef\u3002", (String)"ScriptBuiltinInvokeHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                ScopeInfo scopeInfo = (ScopeInfo)dimScope;
                Collection filters = scopeInfo.getFilters();
                for (DimensionFilterItem filter : filters) {
                    dimMaps.putIfAbsent(filter.getName(), new ArrayList(10));
                    ((List)dimMaps.get(filter.getName())).addAll(filter.getValues());
                }
            }
        }
        if (isMatch = dimMaps.keySet().stream().anyMatch(dim -> OWNER_SHIP_DIM_LIST.contains(dim) && !DimTypesEnum.ENTITY.getNumber().equals(dim) && ((List)dimMaps.get(dim)).size() > 1)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u6307\u5b9ascope\u8303\u56f4\u4f5c\u4e3agetOwnership\u51fd\u6570\u7684\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u53c2\u6570\u65f6\uff0c\u53ea\u5141\u8bb8\u7ec4\u7ec7\u6307\u5b9a\u5c42\u7ea7\uff0c\u60c5\u666f\u3001\u8d22\u5e74\u548c\u671f\u95f4\u53ea\u80fd\u8bbe\u7f6e\u5355\u4e00\u6210\u5458\u3002", (String)"ScriptBuiltinInvokeHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String modelNum = outline.getModelNum();
        Long l = MemberReader.findModelIdByNum((String)modelNum);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        if (dimMaps.get(DimTypesEnum.ENTITY.getNumber()) == null) {
            Long orgId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1;
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId);
            if (orgNode.isLeaf()) {
                throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u53ea\u80fd\u83b7\u53d6\u5408\u5e76\u7ec4\u7ec7\u7684\u6240\u6709\u6743\u8bbe\u7f6e\u3002", (String)"ScriptBuiltinInvokeHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            orgIds.add(orgId);
        } else {
            ((List)dimMaps.get(DimTypesEnum.ENTITY.getNumber())).forEach(entity -> {
                IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)modelNum, (String)entity);
                if (node != IDNumberTreeNode.NotFoundTreeNode && !node.isLeaf()) {
                    orgIds.add(node.getId());
                }
            });
            if (CollectionUtils.isEmpty(orgIds)) {
                throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u53ea\u80fd\u83b7\u53d6\u5408\u5e76\u7ec4\u7ec7\u7684\u6240\u6709\u6743\u8bbe\u7f6e\u3002", (String)"ScriptBuiltinInvokeHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        Long scenarioId = dimMaps.get(DimTypesEnum.SCENARIO.getNumber()) == null ? (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1 : MemberReader.findScenaMemberByNum((String)modelNum, (String)((String)((List)dimMaps.get(DimTypesEnum.SCENARIO.getNumber())).get(0))).getId();
        Long fyId = dimMaps.get(DimTypesEnum.YEAR.getNumber()) == null ? (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p1 : MemberReader.findFyMemberByNum((String)modelNum, (String)((String)((List)dimMaps.get(DimTypesEnum.YEAR.getNumber())).get(0))).getId();
        Long l2 = periodId = dimMaps.get(DimTypesEnum.PERIOD.getNumber()) == null ? (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1 : MemberReader.findPeriodMemberByNum((String)modelNum, (String)((String)((List)dimMaps.get(DimTypesEnum.PERIOD.getNumber())).get(0))).getId();
        if (scenarioId == -1L || fyId == -1L || periodId == -1L) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u6307\u5b9a\u7684\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u65e0\u6548\u3002", (String)"ScriptBuiltinInvokeHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFilter qf = new QFilter("model", "=", (Object)l).and(new QFilter("scenario", "=", (Object)scenarioId)).and(new QFilter("year", "=", (Object)fyId)).and(new QFilter("period", "=", (Object)periodId));
        if (isDynamic) {
            Map<String, ChangeTypeModel> invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(l);
            if (!invChangetypeModel.containsKey(ownType)) {
                throw new BizRuleException(ResManager.loadKDString((String)"getOwnership\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u80a1\u6743\u6570\u636e\u7c7b\u578b\u53c2\u6570\uff0c\u4e14\u53ea\u80fd\u662f\u201cD\u201d\uff08\u83b7\u53d6\u76f4\u63a5\u6301\u80a1\uff09\u3001\u201cA\u201d\uff08\u7b49\u6548\u6301\u80a1\u52a0\u6cd5\uff09\u3001\u201cM\u201d\uff08\u7b49\u6548\u6301\u80a1\u4e58\u6cd5\uff09\u3001\u201cSLU\u201d\uff08\u672c\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cDLU\u201d\uff08\u8de8\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cUD1~UD20\u201d\uff08\u81ea\u5b9a\u4e49\u80a1\u67431~20\uff09\u3001\u6216\u52a8\u6001\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            qf.and(new QFilter("merge", "in", orgIds)).and(new QFilter("invchangetype.number", "=", (Object)ownType).and("level", "=", (Object)InvDynamicStockRatioConstant.LevelEnum.GROUP_CHANGE_TYPE.getCode()).and(new QFilter("status", "=", (Object)"0")));
            return QueryServiceHelper.query((String)"bcm_dynamicstockratio", (String)"shareholder.number,investeecompany.number,openscale,sharescale,changescale,confirmopenscale,confirmsharescale,confirmchangescale,merge.number", (QFilter[])qf.toArray(), (String)"seqnum desc");
        }
        qf.and(new QFilter("orgunit", "in", orgIds)).and(new QFilter("invrelatype", "=", (Object)OWNER_TYPE_MAP.get(ownType)).and(new QFilter("isdelete", "=", (Object)"0")));
        return QueryServiceHelper.query((String)"bcm_invrelation", (String)"shareholder.number,investeecompany.number,equvscale,confirmscale,invrelatype,minconfirmscale,isusedinvrule,isconfirmed,orgunit.number", (QFilter[])new QFilter[]{qf}, (String)"relaseq desc");
    }

    public static JSONArray getInvestInfo(String solution, IOutline outline, String[] customParams) {
        long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        long invCaseId = ScriptBuiltinInvokeHelper.checkSolution(solution, modelId, "getInvestInfo");
        Pair<String, String> investAndInvestedPair = ScriptBuiltinInvokeHelper.checkParameter(customParams[0], outline, "getInvestInfo");
        Boolean isInternal = ScriptBuiltinInvokeHelper.checkInternal(customParams[1]);
        String filterInvestOrg = (String)investAndInvestedPair.p1;
        String filterInvestedOrg = (String)investAndInvestedPair.p2;
        DynamicObjectCollection invShareRelations = InvestServiceHelper.queryInvShareRelaByModelID(modelId, invCaseId);
        Map<String, ChangeTypeModel> invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(modelId);
        Map<Long, String> invChangeMap = invChangetypeModel.values().stream().collect(Collectors.toMap(typeModel -> typeModel.getId(), dy -> dy.number(), (v1, v2) -> v2));
        JSONArray jsonArray = new JSONArray();
        invShareRelations.stream().filter(invShare -> {
            if (StringUtils.isNotEmpty((String)filterInvestOrg) && !StringUtils.equals((String)ALL, (String)filterInvestOrg) && !StringUtils.equals((String)filterInvestOrg, (String)MemberReader.findMemberById((String)outline.getModelNum(), (String)DimEntityNumEnum.INTERCOMPANY.getEntityNum(), (Long)invShare.getLong("shareholder")).getNumber())) {
                return false;
            }
            if (StringUtils.isNotEmpty((String)filterInvestedOrg) && !StringUtils.equals((String)ALL, (String)filterInvestedOrg) && !StringUtils.equals((String)filterInvestedOrg, (String)MemberReader.findEntityMemberById((String)outline.getModelNum(), (Long)invShare.getLong("investeecompany")).getNumber())) {
                return false;
            }
            return isInternal == null || isInternal.booleanValue() == invShare.getBoolean("isout");
        }).forEach(invShare -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("invest", (Object)MemberReader.findMemberById((String)outline.getModelNum(), (String)DimEntityNumEnum.INTERCOMPANY.getEntityNum(), (Long)invShare.getLong("shareholder")).getNumber());
            jsonObject.put("invested", (Object)MemberReader.findEntityMemberById((String)outline.getModelNum(), (Long)invShare.getLong("investeecompany")).getNumber());
            jsonObject.put("isInternal", (Object)(invShare.getBoolean("isout") ? "Y" : "N"));
            jsonObject.put("changeType", invChangeMap.containsKey(invShare.getLong("invchangetype")) ? invChangeMap.get(invShare.getLong("invchangetype")) : "");
            jsonObject.put("currency", (Object)MemberReader.findCurrencyMemberById((String)outline.getModelNum(), (Long)invShare.getLong("holderec")).getNumber());
            try {
                Date investdate = DateTimeUtils.parseDate((String)invShare.getString("investdate"), (String)"yyyy-MM-dd");
                jsonObject.put("investDate", (Object)DateTimeUtils.format((Date)investdate, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                jsonObject.put("investDate", (Object)"");
            }
            jsonObject.put("changePOWN", StringUtils.isEmpty((String)invShare.getString("changescale")) ? "" : new BigDecimal(invShare.getString("changescale")).divide(new BigDecimal(100)));
            jsonObject.put("endPOWN", StringUtils.isEmpty((String)invShare.getString("sharescale")) ? "" : new BigDecimal(invShare.getString("sharescale")).divide(new BigDecimal(100)));
            jsonObject.put("isControled", (Object)(invShare.getBoolean("iscontrol") ? "Y" : "N"));
            jsonObject.put("amount", (Object)invShare.getString("investamount"));
            jsonObject.put("remark", (Object)invShare.getString("remark"));
            jsonArray.add((Object)jsonObject);
        });
        return jsonArray;
    }

    private static Boolean checkInternal(String internal) {
        Boolean isInternal;
        if ("true".equals(internal) || "false".equals(internal)) {
            isInternal = Boolean.parseBoolean(internal);
        } else {
            isInternal = null;
            if (StringUtils.isNotEmpty((String)internal)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptfunctionInternalError"), new Object[]{"getInvestInfo"});
            }
        }
        return isInternal;
    }

    private static long checkSolution(String solution, long modelId, String methodName) {
        DynamicObject invCase = QueryServiceHelper.queryOne((String)"bcm_invsharecase", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)solution).toArray());
        if (invCase == null) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptfunctionSolutionError"), new Object[]{methodName});
        }
        return invCase.getLong("id");
    }

    private static String formatChangeWay(String changeWay) {
        if (ChangeEnum.NoChange.getIndex().equals(changeWay)) {
            return "N";
        }
        if (ChangeEnum.Increase.getIndex().equals(changeWay)) {
            return OWNER_TYPE_A;
        }
        if (ChangeEnum.Decrease.getIndex().equals(changeWay)) {
            return OWNER_TYPE_D;
        }
        if (ChangeEnum.Disable.getIndex().equals(changeWay)) {
            return "B";
        }
        return "";
    }

    private static QFilter initQFilter(long modelId, long invCaseId, String reportType, Map<String, String> ctxDims) {
        QFilter filter = new QFilter("model", "=", (Object)modelId).and("sharecase", "=", (Object)invCaseId);
        QFilter notzeroFilter = new QFilter("issamemon", "=", (Object)Boolean.TRUE);
        QFilter notzeroFilter1 = new QFilter("issamemon", "=", (Object)Boolean.FALSE).and("sharescale", "!=", (Object)BigDecimal.ZERO);
        QFilter mergeFilter = notzeroFilter.or(notzeroFilter1);
        filter.and(mergeFilter);
        String year = ctxDims.get(DimTypesEnum.YEAR.getShortNumber());
        String period = ctxDims.get(DimTypesEnum.PERIOD.getShortNumber());
        if (ReportTypeEnum.ALL.getValue().equals(reportType)) {
            Date endDate = PeriodUtils.calcStartAndEndDate((long)modelId, (String)year, (String)period)[1];
            filter.and("investdategroup", "<=", (Object)endDate);
        } else if (ReportTypeEnum.YEAR.getValue().equals(reportType)) {
            if (year.startsWith("FY")) {
                int realYear = Integer.parseInt(year.substring(2));
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(1, realYear);
                Date beginDate = calendar.getTime();
                filter.and("investdategroup", ">=", (Object)beginDate);
                Date endDate = PeriodUtils.calcStartAndEndDate((long)modelId, (String)year, (String)period)[1];
                filter.and("investdategroup", "<=", (Object)endDate);
            }
        } else if (ReportTypeEnum.MONTH.getValue().equals(reportType)) {
            Date[] datearr = PeriodUtils.calcStartAndEndDate((long)modelId, (String)year, (String)period);
            Date endDate = datearr[1];
            Date startDate = datearr[0];
            filter.and("investdategroup", ">=", (Object)startDate);
            filter.and("investdategroup", "<=", (Object)endDate);
        }
        return filter;
    }

    private static boolean invalidReportType(String reportType) {
        return !ReportTypeEnum.YEAR.getValue().equals(reportType) && !ReportTypeEnum.MONTH.getValue().equals(reportType) && !ReportTypeEnum.ALL.getValue().equals(reportType);
    }

    public static JSONArray getOwnershipMap(IOutline outline, String key, String parent, String startEntity, String endEntity) {
        Long entityId = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)parent).getId();
        Long caseId = InvShareCaseSetHelper.findShareCaseByOrg(MemberReader.findModelIdByNum((String)outline.getModelNum()), (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Scenario.getNumber())).p1, Collections.singleton(entityId)).get(entityId);
        if (caseId == null) {
            caseId = 0L;
        }
        String newKey = key + "_" + caseId;
        Table holderWalkPaths = (Table)CacheGenFactory.getCommonCache().getOrLoad(newKey, HashBasedTable::create);
        List walkPaths = (List)holderWalkPaths.get((Object)parent, (Object)(startEntity + "->" + endEntity));
        JSONArray pathArray = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)walkPaths)) {
            walkPaths.forEach(walkPath -> {
                if (StringUtils.isNotEmpty((String)walkPath.getPath())) {
                    String[] split = walkPath.getPath().split("->");
                    JSONArray onePath = new JSONArray();
                    Collections.addAll(onePath, split);
                    onePath.add(walkPath.getScale() == null ? "" : new BigDecimal(walkPath.getScale().stripTrailingZeros().toPlainString()));
                    pathArray.add((Object)onePath);
                }
            });
        }
        return pathArray;
    }

    public static boolean isRptStatMatched(Outline outline, Object[] customParams) {
        if (!(customParams[0] instanceof String) || !(customParams[1] instanceof String) || customParams.length == 3 && !(customParams[2] instanceof String)) {
            throw new BizRuleException("params type error");
        }
        String rptCodes = customParams[0].toString();
        String statCode = customParams[1].toString();
        String dimStr = customParams.length == 3 ? customParams[2].toString() : "";
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        DynamicObjectCollection templates = ScriptBuiltinInvokeHelper.getTemplates(modelId);
        HashMap groupToIds = new HashMap();
        HashMap<String, DynamicObject> numToDyn = new HashMap<String, DynamicObject>();
        for (DynamicObject template : templates) {
            long groupId = template.getLong("group");
            long templateId = template.getLong("id");
            groupToIds.putIfAbsent(groupId, new ArrayList());
            ((List)groupToIds.get(groupId)).add(templateId);
            numToDyn.put(template.getString("number"), template);
        }
        HashSet<String> selects = new HashSet<String>(16);
        if (rptCodes.contains(SPLIT)) {
            selects.addAll(Arrays.stream(rptCodes.split(SPLIT)).collect(Collectors.toSet()));
        } else {
            selects.add(rptCodes);
        }
        if (!numToDyn.keySet().containsAll(selects)) {
            throw new BizRuleException(ResManager.loadKDString((String)"isRptStatMatched\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u62a5\u8868\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!BizRuleReportStatusEnum.getAllStatus().contains(statCode)) {
            throw new BizRuleException(ResManager.loadKDString((String)"isRptStatMatched\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u62a5\u8868\u7f16\u5236\u72b6\u6001\u7f16\u7801\u3002\u6709\u6548\u7684\u72b6\u6001\u7f16\u7801\u4e3a\uff1aU\uff08\u672a\u7f16\u5236\uff09\u3001I\uff08\u7f16\u5236\u4e2d\uff09\u3001C\uff08\u7f16\u5236\u5b8c\u6210\uff09\u3001S\uff08\u5df2\u4e0a\u62a5\uff09\u3002", (String)"ScriptBuiltinInvokeHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<String, String> dimMaps = ScriptBuiltinInvokeHelper.checkAndResolveDimStr(outline, dimStr, "isRptStatMatched");
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.ENTITY.getNumber()));
        if (entityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new BizRuleException("entity not found");
        }
        long entityId = entityNode.getId();
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> allVersionTemplateIds = new HashSet<Long>(16);
        for (String string : selects) {
            List groups = (List)groupToIds.get(((DynamicObject)numToDyn.get(string)).getLong("group"));
            if (!CollectionUtils.isNotEmpty((Collection)groups)) continue;
            templateIds.add((Long)groups.get(0));
            allVersionTemplateIds.addAll(groups);
        }
        Map<Long, Set<Long>> tempToEntities = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, templateIds);
        for (Long templateId : templateIds) {
            Set<Long> entities = tempToEntities.get(templateId);
            if (entities != null && entities.contains(entityId)) continue;
            throw new BizRuleException(ResManager.loadKDString((String)"isRptStatMatched\u51fd\u6570\u6307\u5b9a\u7684\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d\u6307\u5b9a\u7684\u6a21\u677f\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFBuilder qFBuilder = ScriptBuiltinInvokeHelper.getReportBuilder(outline, modelId, dimMaps, entityId, allVersionTemplateIds);
        if (BizRuleReportStatusEnum.getReportStatus((String)statCode) != ReportStatusEnum.UNWEAVE) {
            if (BizRuleReportStatusEnum.getReportStatus((String)statCode) == ReportStatusEnum.WEAVING) {
                qFBuilder.add("reportstatus", "in", Arrays.asList(ReportStatusEnum.WEAVING.status(), ReportStatusEnum.BACK.status()));
            } else {
                qFBuilder.add("reportstatus", "=", (Object)BizRuleReportStatusEnum.getReportStatus((String)statCode).status());
            }
        }
        Set completes = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template", (QFilter[])qFBuilder.toArray()).stream().map(dyn -> dyn.getLong("template")).collect(Collectors.toSet());
        if (BizRuleReportStatusEnum.getReportStatus((String)statCode) == ReportStatusEnum.UNWEAVE) {
            return completes.size() == 0;
        }
        if (completes.size() == 0) {
            return false;
        }
        block3: for (String select : selects) {
            List versions = (List)groupToIds.get(((DynamicObject)numToDyn.get(select)).getLong("group"));
            for (Long version : versions) {
                if (!completes.contains(version)) continue;
                continue block3;
            }
            return false;
        }
        return true;
    }

    public static String getRptStats(Outline outline, Object[] customParams) {
        if (!(customParams[0] instanceof String) || customParams.length == 2 && !(customParams[1] instanceof String)) {
            throw new BizRuleException("params type error");
        }
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        String rptCodes = customParams[0].toString();
        String dimStr = customParams.length == 2 ? customParams[1].toString() : "";
        DynamicObjectCollection templates = ScriptBuiltinInvokeHelper.getTemplates(modelId);
        HashMap groupToIds = new HashMap();
        HashMap groupToNums = new HashMap();
        HashMap<String, DynamicObject> numToDyn = new HashMap<String, DynamicObject>();
        HashMap<Long, DynamicObject> idToDyn = new HashMap<Long, DynamicObject>();
        for (DynamicObject template : templates) {
            long groupId = template.getLong("group");
            long templateId = template.getLong("id");
            groupToIds.putIfAbsent(groupId, new ArrayList());
            ((List)groupToIds.get(groupId)).add(templateId);
            groupToNums.putIfAbsent(groupId, new HashSet(16));
            ((Set)groupToNums.get(groupId)).add(template.getString("number"));
            numToDyn.put(template.getString("number"), template);
            idToDyn.put(templateId, template);
        }
        LinkedList<String> selects = new LinkedList<String>();
        if (rptCodes.contains(SPLIT)) {
            selects.addAll(Arrays.stream(rptCodes.split(SPLIT)).collect(Collectors.toList()));
        } else {
            selects.add(rptCodes);
        }
        if (!numToDyn.keySet().containsAll(selects)) {
            throw new BizRuleException(ResManager.loadKDString((String)"getRptStats\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u62a5\u8868\u7f16\u7801\u3002", (String)"ScriptBuiltinInvokeHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<String, String> dimMaps = ScriptBuiltinInvokeHelper.checkAndResolveDimStr(outline, dimStr, "getRptStats");
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.ENTITY.getNumber()));
        if (entityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new BizRuleException("entity not found");
        }
        long entityId = entityNode.getId();
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> allVersionTemplateIds = new HashSet<Long>(16);
        for (String string : selects) {
            List groups = (List)groupToIds.get(((DynamicObject)numToDyn.get(string)).getLong("group"));
            if (!CollectionUtils.isNotEmpty((Collection)groups)) continue;
            templateIds.add((Long)groups.get(0));
            allVersionTemplateIds.addAll(groups);
        }
        Map<Long, Set<Long>> tempToEntities = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(modelId, templateIds);
        for (Long templateId : templateIds) {
            Set<Long> entities = tempToEntities.get(templateId);
            if (entities != null && entities.contains(entityId)) continue;
            throw new BizRuleException(ResManager.loadKDString((String)"getRptStats\u51fd\u6570\u6307\u5b9a\u7684\u7ec4\u7ec7\u6ca1\u6709\u5206\u914d\u6307\u5b9a\u7684\u6a21\u677f\u7f16\u7801", (String)"ScriptBuiltinInvokeHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFBuilder qFBuilder = ScriptBuiltinInvokeHelper.getReportBuilder(outline, modelId, dimMaps, entityId, allVersionTemplateIds);
        HashMap<String, String> res = new HashMap<String, String>();
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,template,reportstatus", (QFilter[])qFBuilder.toArray());
        for (DynamicObject report : reports) {
            String select;
            String status;
            long template = report.getLong("template");
            String reportStatus = report.getString("reportstatus");
            long group = ((DynamicObject)idToDyn.get(template)).getLong("group");
            Optional<String> first = ((Set)groupToNums.get(group)).stream().filter(selects::contains).findFirst();
            if (!first.isPresent() || (status = (String)res.get(select = first.get())) != null && status.compareTo(reportStatus) <= 0) continue;
            res.put(select, BizRuleReportStatusEnum.transReportStatus((ReportStatusEnum)ReportStatusEnum.getStatusEnumBy((String)reportStatus)));
        }
        StringJoiner stringJoiner = new StringJoiner(SPLIT);
        for (String select : selects) {
            String status = (String)res.get(select);
            stringJoiner.add(status == null ? BizRuleReportStatusEnum.U.getStatus() : status);
        }
        return stringJoiner.toString();
    }

    private static QFBuilder getReportBuilder(Outline outline, Long modelId, Map<String, String> dimMaps, long entityId, Set<Long> allVersionTemplateIds) {
        QFBuilder reportBuilder = new QFBuilder("model", "=", (Object)modelId);
        reportBuilder.add("scene", "=", (Object)MemberReader.findScenaMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.SCENARIO.getNumber())).getId());
        reportBuilder.add("fyear", "=", (Object)MemberReader.findFyMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.YEAR.getNumber())).getId());
        reportBuilder.add("period", "=", (Object)MemberReader.findPeriodMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.PERIOD.getNumber())).getId());
        reportBuilder.add("currency", "=", (Object)MemberReader.findCurrencyMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.CURRENCY.getNumber())).getId());
        reportBuilder.add("entity", "=", (Object)entityId);
        reportBuilder.add("template", "in", allVersionTemplateIds);
        return reportBuilder;
    }

    private static Map<String, String> checkAndResolveDimStr(Outline outline, String dimStr, String method) {
        Map<String, String> dimMaps = BizRuleUtil.parseDimStr(outline.getModelNum(), dimStr);
        BizRuleUtil.checkDimMap(RPT_STAT_DIM_LIST, dimMaps, String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\uff0c\u53ea\u5141\u8bb8\u6307\u5b9a\u60c5\u666f\u3001\u7ec4\u7ec7\u3001\u8d22\u5e74\u3001\u671f\u95f4\u548c\u5e01\u79cd\u3002", (String)"ScriptBuiltinInvokeHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), method));
        dimMaps.putIfAbsent(DimTypesEnum.ENTITY.getNumber(), (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.ENTITY.getNumber())).p2);
        dimMaps.putIfAbsent(DimTypesEnum.SCENARIO.getNumber(), (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.SCENARIO.getNumber())).p2);
        dimMaps.putIfAbsent(DimTypesEnum.YEAR.getNumber(), (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.YEAR.getNumber())).p2);
        dimMaps.putIfAbsent(DimTypesEnum.PERIOD.getNumber(), (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PERIOD.getNumber())).p2);
        dimMaps.putIfAbsent(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)dimMaps.get(DimTypesEnum.ENTITY.getNumber())).getCurrency());
        return dimMaps;
    }

    private static DynamicObjectCollection getTemplates(long modelId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        qfBuilder.and("status", "=", (Object)TemplateModel.TplStatus.ENABLE.getStatuValue());
        qfBuilder.and("usage", "=", (Object)TemplateModel.UsageEnum.WEAVE.getStatuValue());
        return QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,group", (QFilter[])qfBuilder.toArray(), (String)"sequence,number,versionnumber");
    }

    public static Set<Long> getPropertyMember(long modelId, String entityNum, long memId, String memNum, int rangeVal) {
        HashSet<Long> ids = new HashSet<Long>(16);
        new MembRangeItem(entityNum, (Long)memId, memNum, rangeVal, true, (Object)modelId).matchItems(simpleItem -> ids.add((Long)simpleItem.getId()));
        return ids;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getConFlowStatus(IOutline outline, Object[] params) {
        HashMap<String, String> ctxMap = new HashMap<String, String>(6);
        int type = 0;
        if (params != null) {
            if (params.length == 1) {
                if (params[0] instanceof BigDecimal) {
                    type = ((BigDecimal)params[0]).intValue();
                } else {
                    if (!(params[0] instanceof String)) throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u53c2\u6570\u4f20\u5165\u6709\u8bef\u3002", (String)"ScriptBuiltinInvokeHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), GET_CONFLOWSTATUS));
                    Map<String, String> map = BizRuleUtil.parseDimStr(outline.getModelNum(), (String)params[0]);
                    ctxMap.putAll(map);
                    ctxMap.putAll(map);
                }
            } else if (params.length == 2) {
                Object dimStr;
                if (params[0] instanceof BigDecimal && params[1] instanceof String) {
                    type = ((BigDecimal)params[0]).intValue();
                    dimStr = (String)params[1];
                } else {
                    if (!(params[0] instanceof String) || !(params[1] instanceof BigDecimal)) throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u53c2\u6570\u4f20\u5165\u6709\u8bef\u3002", (String)"ScriptBuiltinInvokeHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), GET_CONFLOWSTATUS));
                    type = ((BigDecimal)params[1]).intValue();
                    dimStr = (String)params[0];
                }
                Map<String, String> map = BizRuleUtil.parseDimStr(outline.getModelNum(), (String)dimStr);
                ctxMap.putAll(map);
            } else if (params.length != 0) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u53c2\u6570\u4f20\u5165\u6709\u8bef\u3002", (String)"ScriptBuiltinInvokeHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), GET_CONFLOWSTATUS));
            }
        }
        BizRuleUtil.checkDimMap(RPT_STAT_DIM_LIST, ctxMap, String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\uff0c\u53ea\u5141\u8bb8\u6307\u5b9a\u60c5\u666f\u3001\u7ec4\u7ec7\u3001\u8d22\u5e74\u3001\u671f\u95f4\u548c\u5e01\u79cd\u3002", (String)"ScriptBuiltinInvokeHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), GET_CONFLOWSTATUS));
        if (type != 0 && type != 1) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u53c2\u6570\u4f20\u5165\u6709\u8bef\u3002", (String)"ScriptBuiltinInvokeHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), GET_CONFLOWSTATUS));
        }
        for (String dim : RPT_STAT_DIM_LIST) {
            if (DimTypesEnum.ENTITY.getNumber().equals(dim) && !ctxMap.containsKey(dim)) {
                ctxMap.put(DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberById((String)outline.getModelNum(), (Long)((Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)dim)).p1)).getParent_SonNumber());
                continue;
            }
            ctxMap.putIfAbsent(dim, (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)dim)).p2);
        }
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        Long orgId = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)((String)ctxMap.get(DimTypesEnum.ENTITY.getNumber()))).getId();
        Long scenario = MemberReader.findScenaMemberByNum((String)outline.getModelNum(), (String)((String)ctxMap.get(DimTypesEnum.SCENARIO.getNumber()))).getId();
        if (MergeControlHelper.isQuoteScene(modelId, scenario)) {
            scenario = MergeControlHelper.getSrcScene(modelId, scenario);
        }
        Long periodId = MemberReader.findPeriodMemberByNum((String)outline.getModelNum(), (String)((String)ctxMap.get(DimTypesEnum.PERIOD.getNumber()))).getId();
        long year = MemberReader.findFyMemberByNum((String)outline.getModelNum(), (String)((String)ctxMap.get(DimTypesEnum.YEAR.getNumber()))).getId();
        FilterOrgStructParam param = new FilterOrgStructParam((long)modelId, (long)scenario, (String)ctxMap.get(DimTypesEnum.YEAR.getNumber()), (long)periodId);
        Map<Long, String> effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, Collections.singletonList(orgId));
        if (effectiveOrg.isEmpty()) {
            return null;
        }
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String newCurr = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)entityNode, (long)modelId.longValue(), (String)((String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PROCESS.getNumber())).p2), (String)((String)ctxMap.get((Object)DimTypesEnum.CURRENCY.getNumber()))).p2;
        MergeControlStatus mcStatus = MergeStatusHelper.getMergeControlStatus(modelId, orgId, scenario, year, periodId, newCurr);
        if (type == 0) {
            if (mcStatus.isArchive()) {
                return 3;
            }
            if (!mcStatus.isSubmit()) return 1;
            return 2;
        }
        BcmMap bcmMap = new BcmMap();
        mcStatus.queryStageCommitNumber().forEach((key, val) -> bcmMap.put(key, (Object)(val != false ? 2 : 1)));
        return bcmMap;
    }

    static {
        OWNER_TYPE_MAP.put(OWNER_TYPE_D, InvRelaTypeEnum.DirectRelaType.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_A, InvRelaTypeEnum.INDirectRelaType.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_M, InvRelaTypeEnum.MultiRelaType.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_SLU, InvRelaTypeEnum.SameLevelRelaType.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_DLU, InvRelaTypeEnum.MinRelaType.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD1, InvRelaTypeEnum.CustomRelaType1.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD2, InvRelaTypeEnum.CustomRelaType2.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD3, InvRelaTypeEnum.CustomRelaType3.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD4, InvRelaTypeEnum.CustomRelaType4.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD5, InvRelaTypeEnum.CustomRelaType5.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD6, InvRelaTypeEnum.CustomRelaType6.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD7, InvRelaTypeEnum.CustomRelaType7.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD8, InvRelaTypeEnum.CustomRelaType8.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD9, InvRelaTypeEnum.CustomRelaType9.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD10, InvRelaTypeEnum.CustomRelaType10.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD11, InvRelaTypeEnum.CustomRelaType11.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD12, InvRelaTypeEnum.CustomRelaType12.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD13, InvRelaTypeEnum.CustomRelaType13.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD14, InvRelaTypeEnum.CustomRelaType14.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD15, InvRelaTypeEnum.CustomRelaType15.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD16, InvRelaTypeEnum.CustomRelaType16.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD17, InvRelaTypeEnum.CustomRelaType17.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD18, InvRelaTypeEnum.CustomRelaType18.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD19, InvRelaTypeEnum.CustomRelaType19.getType());
        OWNER_TYPE_MAP.put(OWNER_TYPE_UD20, InvRelaTypeEnum.CustomRelaType20.getType());
    }
}

