/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.extendmodel;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.script.ScriptFunction;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendRow;
import kd.fi.bcm.business.bizrule.extendscript.util.ExtendService;
import kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.time.DateUtils;

@KSObject
public class ExtendResultSet
implements ScriptObject,
Iterable<EDRow> {
    private static final Log LOG = LogFactory.getLog(ExtendResultSet.class);
    private String ColSumSetNumber;
    private ExtendsModel extendsModel;
    private QueryCommand queryCommand;
    private EDResultSet edResultSet;
    private Map<Long, Map<String, Object>> updateValues = new HashMap<Long, Map<String, Object>>(16);
    private List<Long> deletePkIds = new ArrayList<Long>();

    public String getColSumSetNumber() {
        return this.ColSumSetNumber;
    }

    public void setColSumSetNumber(String colSumSetNumber) {
        this.ColSumSetNumber = colSumSetNumber;
    }

    public Map<Long, Map<String, Object>> getUpdateValues() {
        return this.updateValues;
    }

    public void setUpdateValues(Map<Long, Map<String, Object>> updateValues) {
        this.updateValues = updateValues;
    }

    public ExtendsModel getExtendsModel() {
        return this.extendsModel;
    }

    public void setExtendsModel(ExtendsModel extendsModel) {
        this.extendsModel = extendsModel;
    }

    public QueryCommand getQueryCommand() {
        return this.queryCommand;
    }

    public void setQueryCommand(QueryCommand queryCommand) {
        this.queryCommand = queryCommand;
    }

    public ExtendResultSet() {
    }

    public ExtendResultSet(QueryCommand queryCommand, ExtendsModel extendsModel, EDResultSet edResultSet) {
        this.queryCommand = queryCommand;
        this.extendsModel = extendsModel;
        this.edResultSet = edResultSet;
    }

    public EDResultSet getEdResultSet() {
        return this.edResultSet;
    }

    @Override
    public Iterator<EDRow> iterator() {
        return Arrays.stream(this.edResultSet.getRows()).iterator();
    }

    @KSMethod
    public void forEach(ScriptFunction func) {
        EDRow row;
        Iterator<EDRow> iter = this.iterator();
        ArrayList<ExtendRow> rows = new ArrayList<ExtendRow>(10);
        while (iter.hasNext()) {
            ExtendRow next = (ExtendRow)iter.next();
            next.setExtendResultSet(this);
            rows.add(next);
        }
        int i = 0;
        Object returnV = null;
        Iterator iterator = rows.iterator();
        while (!(!iterator.hasNext() || (returnV = func.call(new Object[]{row = (EDRow)iterator.next(), i++})) instanceof Boolean && ((Boolean)returnV).booleanValue())) {
        }
    }

    public Object __getUndefinedProperty(String propertyName) {
        String length = "length";
        if (length.equals(propertyName)) {
            return this.edResultSet.getRows().length;
        }
        return super.__getUndefinedProperty(propertyName);
    }

    public Object __getUndefinedElement(Object element) {
        return super.__getUndefinedElement(element);
    }

    public void set(Object ... objects) {
        this.checkParams(objects);
        this.checkModelEnable();
        EDRow row = (EDRow)objects[0];
        String col = objects[1].toString();
        Object value = objects[2];
        FieldEntry entry = this.getFieldEntryByNum(col);
        if (entry.getIsNecessary() && value == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtendResultSet_8", (String)"fi-bcm-business", (Object[])new Object[0]), col));
        }
        if (value != null) {
            value = this.checkAndDealValue(entry, col, value);
        }
        if (ScriptBuiltinExtHelper.checkIsSameContext(this.queryCommand) && (!this.queryCommand.isNeedSum() || ScriptBuiltinExtHelper.isIntrOnlyExectype(this.queryCommand.getOutline()))) {
            if (!this.updateValues.containsKey(row.getPkId())) {
                HashMap<String, Object> fieldToValueMap = new HashMap<String, Object>(1);
                fieldToValueMap.put(col, value);
                this.updateValues.put(row.getPkId(), fieldToValueMap);
            } else {
                this.updateValues.get(row.getPkId()).put(col, value);
            }
        }
    }

    public void add(Object ... objects) {
        if (!this.queryCommand.isNeedSum()) {
            Map<Object, Object> fieldToValueMap;
            this.checkParams(objects);
            this.checkModelEnable();
            EDRow row = (EDRow)objects[0];
            String col = objects[1].toString();
            Object value = objects[2];
            FieldEntry entry = this.getFieldEntryByNum(col);
            if (entry.getIsNecessary() && value == null) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtendResultSet_8", (String)"fi-bcm-business", (Object[])new Object[0]), col));
            }
            if (entry.getFieldType() != FieldTypeEnum.EXT_FIELD.getType() || !entry.getExtField().getMapped().contains("numext") || DataTypeEnum.ENUMTP.getOIndex().equals(entry.getExtField().getDataType())) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u7d2f\u52a0\u8ba1\u7b97\uff0c\u4ec5\u652f\u6301\u6570\u636e\u7c7b\u578b\u7684\u5b57\u6bb5\uff0c\u5305\u62ec\u9ed8\u8ba4\u3001\u8d27\u5e01\u3001\u6570\u503c\u548c\u6bd4\u4f8b", (String)"ExtendResultSet_9", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (value != null) {
                value = this.checkAndDealValue(entry, col, value);
            }
            Object src = row.getValue(row.getMetaData().getColIndex(col.trim()));
            if (!this.updateValues.containsKey(row.getPkId())) {
                fieldToValueMap = new HashMap(1);
                this.updateValues.put(row.getPkId(), fieldToValueMap);
            } else {
                fieldToValueMap = this.updateValues.get(row.getPkId());
                if (fieldToValueMap.containsKey(col)) {
                    src = fieldToValueMap.get(col);
                }
            }
            if (src == null) {
                BigDecimal res = value == null ? null : new BigDecimal(value.toString());
                fieldToValueMap.put(col, res);
                row.getValues().set(row.getMetaData().getColIndex(col.trim()), res);
            } else {
                Object res = value == null ? src : ((BigDecimal)src).add(new BigDecimal(value.toString()));
                fieldToValueMap.put(col, res);
                row.getValues().set(row.getMetaData().getColIndex(col.trim()), res);
            }
        }
    }

    public void delete(Object ... objects) {
        if (objects.length != 1 && !(objects[0] instanceof EDRow)) {
            throw new BizRuleException("params missing");
        }
        this.checkModelEnable();
        EDRow row = (EDRow)objects[0];
        if (ScriptBuiltinExtHelper.checkIsSameContext(this.queryCommand) && !this.queryCommand.isNeedSum()) {
            this.deletePkIds.add(row.getPkId());
        }
    }

    @KSMethod
    public void save() {
        SaveCommand edSaveComInfo = new SaveCommand(this.extendsModel.getModelShowNumber(), this.extendsModel.getExtendsGroupNumber(), this.extendsModel.getNumber());
        String[] extSelects = this.queryCommand.getExtselects();
        String[] dimSelects = this.queryCommand.getDimselects();
        edSaveComInfo.setCols(extSelects);
        edSaveComInfo.setDims(dimSelects);
        edSaveComInfo.setFixDim(this.queryCommand.getFixDims());
        edSaveComInfo.setParentOrg(this.queryCommand.getParentOrg());
        if (ScriptBuiltinExtHelper.isIntrOnlyExectype(this.queryCommand.getOutline())) {
            edSaveComInfo.setKeepEntity(true);
            edSaveComInfo.setBizRule2InTrade(true);
            edSaveComInfo.setPaperTemplateId((Long)this.queryCommand.getOutline().getBuiltin().getArgs().get("paperTemplateId"));
        } else if (!BizRuleUtil.canEditExtData(this.queryCommand.getOutline(), this.queryCommand.getDimFilter()) || this.queryCommand.isNeedSum()) {
            return;
        }
        BizRuleUtil.validCanMergeOrgEditData(this.queryCommand.getOutline(), this.edResultSet, this.queryCommand);
        if (this.updateValues.size() > 0) {
            HashSet<String> uniqueFieldSet = this.getUniqueFieldSet();
            Map<String, Long> uniqueValues = this.getUniqueValue(uniqueFieldSet);
            for (Map.Entry<Long, Map<String, Object>> entry : this.updateValues.entrySet()) {
                Long pkId = entry.getKey();
                Map<String, Object> updateMap = entry.getValue();
                for (EDRow row : this.edResultSet.getRows()) {
                    if (row.getPkId() != pkId.longValue()) continue;
                    List<Object> values = row.getValues();
                    String uniqueStr = this.checkUniqueAndReturnStr(uniqueFieldSet, uniqueValues, updateMap, row);
                    for (Map.Entry<String, Object> updateEntry : updateMap.entrySet()) {
                        String colName = updateEntry.getKey();
                        Object newValue = updateEntry.getValue();
                        int colIndex = this.edResultSet.getMetaData().getColIndex(colName);
                        values.set(colIndex, newValue);
                        if (uniqueFieldSet.isEmpty()) continue;
                        this.updateUniqueValue(pkId, uniqueStr, uniqueValues);
                    }
                    List<Object> dimValues = values.subList(0, dimSelects.length);
                    List<Object> extValues = values.subList(dimSelects.length, values.size());
                    edSaveComInfo.putUpdateValues(pkId, extValues.toArray(), dimValues.toArray(new String[0]));
                }
            }
            ExtDataServiceHelper.saveData(edSaveComInfo);
        }
        if (!this.deletePkIds.isEmpty()) {
            ExtendService.deleteDataBySaveInfo(this.deletePkIds, edSaveComInfo);
        }
        this.deletePkIds.clear();
        this.updateValues.clear();
    }

    private String checkUniqueAndReturnStr(HashSet<String> uniqueFieldSet, Map<String, Long> uniqueValue, Map<String, Object> updateMap, EDRow row) {
        if (uniqueFieldSet.isEmpty()) {
            return "";
        }
        StringJoiner sj = new StringJoiner("|");
        for (EDColumn col : row.getMetaData().getColMetaDatas()) {
            if (!uniqueFieldSet.contains(col.getMdName())) continue;
            if (updateMap.containsKey(col.getMdName())) {
                sj.add(updateMap.get(col.getMdName()).toString());
                continue;
            }
            Object value = row.getValue(col.getColIndex());
            sj.add(value == null ? "" : String.valueOf(value));
        }
        if (uniqueValue.containsKey(sj.toString()) && uniqueValue.get(sj.toString()).longValue() != row.getPkId()) {
            LOG.info("unique check fail, pkId is ", (Object)uniqueValue.get(sj.toString()));
            throw new BizRuleException(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u6570\u636e\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff01", (String)"ExtendResultSet_16", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return sj.toString();
    }

    private HashSet<String> getUniqueFieldSet() {
        HashSet<String> uniqueFieldSet = new HashSet<String>(10);
        List<FieldEntry> fieldEntrys = this.extendsModel.getFieldEntry();
        for (FieldEntry field : fieldEntrys) {
            if (!field.getUniqueCheck()) continue;
            uniqueFieldSet.add(field.getNumber());
        }
        if (!uniqueFieldSet.isEmpty()) {
            uniqueFieldSet.add(DimTypesEnum.ENTITY.getNumber());
            uniqueFieldSet.add(DimTypesEnum.AUDITTRIAL.getNumber());
        }
        return uniqueFieldSet;
    }

    private Map<String, Long> getUniqueValue(Set<String> uniqueFieldSet) {
        if (uniqueFieldSet.isEmpty()) {
            return new HashMap<String, Long>(16);
        }
        QueryCommand queryCommand4All = new QueryCommand(this.extendsModel.getModelShowNumber(), this.extendsModel.getExtendsGroupNumber(), this.extendsModel.getNumber());
        queryCommand4All.setMainOrgId(this.queryCommand.getMainOrgId());
        try {
            BeanUtils.copyProperties((Object)queryCommand4All, (Object)this.queryCommand);
        }
        catch (Exception e) {
            LOG.error("bizRule getUniqueValue fail:", (Throwable)e);
            throw new BizRuleException(ResManager.loadKDString((String)"\u6821\u9a8c\u552f\u4e00\u6027\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"ExtendResultSet_17", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        queryCommand4All.setCustomFilter(new QFilter("1", "=", (Object)1));
        EDResultSet resultSet = ExtDataServiceHelper.queryData(queryCommand4All);
        HashMap<String, Long> uniqueValue = new HashMap<String, Long>(this.edResultSet.getRows().length);
        for (EDRow row : resultSet.getRows()) {
            List<Object> values = row.getValues();
            StringJoiner sj = new StringJoiner("|");
            for (EDColumn col : row.getMetaData().getColMetaDatas()) {
                if (!uniqueFieldSet.contains(col.getMdName())) continue;
                Object value = row.getValue(col.getColIndex());
                sj.add(value == null ? "" : String.valueOf(value));
            }
            uniqueValue.put(sj.toString(), row.getPkId());
        }
        return uniqueValue;
    }

    private void updateUniqueValue(Long pkId, String uniqueStr, Map<String, Long> uniqueValues) {
        uniqueValues.put(uniqueStr, pkId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        EDRow[] rows = this.getEdResultSet().getRows();
        if (rows.length > 0) {
            for (EDRow extendRow : rows) {
                if (StringUtils.isNotEmpty((CharSequence)this.ColSumSetNumber)) {
                    sb.append(((ExtendRow)extendRow).toOnlyColSumSetNumber(this.ColSumSetNumber, MemberReader.findModelNumberById((Object)this.extendsModel.getModelId())));
                } else {
                    sb.append(extendRow.toString());
                }
                if (count >= rows.length - 1) continue;
                sb.append("\n");
            }
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    @KSMethod
    public ExtendResultSet getColSumSet(String colCode, XDMScopeInfo xdmScope) {
        List ids;
        String msg1 = this.checkColCode(colCode);
        if (StringUtils.isNotEmpty((CharSequence)msg1)) {
            throw new BizRuleException(msg1);
        }
        String msg2 = this.checkScope(xdmScope);
        if (StringUtils.isNotEmpty((CharSequence)msg2)) {
            throw new BizRuleException(msg2);
        }
        QFilter qFilter = null;
        if (!this.queryCommand.isNeedSum() && !CollectionUtils.isEmpty(ids = Stream.of(this.getEdResultSet().getRows()).map(EDRow::getPkId).collect(Collectors.toList()))) {
            qFilter = new QFilter("id", "in", ids);
        }
        if (qFilter == null) {
            qFilter = new QFilter("1", "!=", (Object)1);
        }
        return ScriptBuiltinExtHelper.getColSumSetResult(this.queryCommand.getOutline(), colCode, xdmScope, this.getExtendsModel(), qFilter);
    }

    @KSMethod
    public ExtendResultSet getColSumSet(XDMScopeInfo xdmScope) {
        throw new BizRuleException(ResManager.loadKDString((String)"getColSumSet\u7f3a\u5931\u6c42\u548c\u5b57\u6bb5\u53c2\u6570\u3002", (String)"ExtendResultSet_7", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private String checkScope(XDMScopeInfo xdmScope) {
        String msg = "";
        if (xdmScope != null && !this.getExtendsModel().getNumber().equals(xdmScope.getExtendsmodelNumber())) {
            msg = String.format(ResManager.loadKDString((String)"getColSumSet\u4e2d\u8303\u56f4\u6761\u4ef6\u53c2\u6570\u4e0e\u62d3\u5c55\u6570\u636e\u96c6%s\u7684\u6765\u6e90\u6570\u636e\u6a21\u578b\u4e0d\u4e00\u81f4\u3002", (String)"ExtendResultSet_6", (String)"fi-bcm-business", (Object[])new Object[0]), this.getExtendsModel().getNumber());
        }
        return msg;
    }

    private String checkColCode(String colCode) {
        String msg = "";
        if (StringUtils.isEmpty((CharSequence)colCode)) {
            msg = ResManager.loadKDString((String)"getColSumSet\u65b9\u6cd5\u5fc5\u987b\u6307\u5b9a\u7a7a\u5b57\u6bb5\u7f16\u7801", (String)"ExtendResultSet_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        } else {
            List<ExtFieldEntry> extFieldEntry = this.getExtendsModel().getExtFieldEntry();
            Optional<ExtFieldEntry> first = extFieldEntry.stream().filter(fieldEntry -> fieldEntry.getExtField().getNumber().equals(colCode.trim())).findFirst();
            if (!first.isPresent()) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u62d3\u5c55\u6570\u636e\u96c6\u4e0d\u5305\u542b%2$s\u5b57\u6bb5", (String)"ExtendResultSet_4", (String)"fi-bcm-business", (Object[])new Object[0]), this.getExtendsModel().getNumber(), colCode);
            } else {
                Optional<ExtFieldEntry> second = extFieldEntry.stream().filter(fieldEntry -> fieldEntry.getExtField().getNumber().equals(colCode.trim()) && fieldEntry.getExtField().getMapped().contains("numext")).findFirst();
                if (!second.isPresent()) {
                    msg = ResManager.loadKDString((String)"getColSumSet\u6c42\u548c\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u9ed8\u8ba4\u3001\u8d27\u5e01\u3001\u6570\u503c\u6216\u6bd4\u4f8b\u3002", (String)"ExtendResultSet_5", (String)"fi-bcm-business", (Object[])new Object[0]);
                }
            }
        }
        return msg;
    }

    private void checkParams(Object ... objects) {
        if (objects.length < 3) {
            throw new BizRuleException("params missing");
        }
        Object row = objects[0];
        Object col = objects[1];
        if (!(row instanceof EDRow) || !(col instanceof String)) {
            throw new BizRuleException("param error");
        }
    }

    private FieldEntry getFieldEntryByNum(String colNum) {
        if (this.edResultSet.getMetaData().getColIndex(colNum.trim()) == -1) {
            throw new BizRuleException("colName is not existed");
        }
        FieldEntry entry = this.extendsModel.getFieldEntryByNumber(colNum.trim());
        if (entry == null) {
            throw new BizRuleException("colName is not existed");
        }
        return entry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object checkAndDealValue(FieldEntry entry, String col, Object value) {
        if (entry.getFieldType() == FieldTypeEnum.EXT_FIELD.getType()) {
            ExtField extField = entry.getExtField();
            String dataType = extField.getDataType();
            if (DataTypeEnum.ENUMTP.getOIndex().equals(dataType)) {
                if (extField.getEnumItemId() == 0L) return value;
                Object finalValue = value;
                DynamicObject object = (DynamicObject)ThreadCache.get((Object)("enumitemid-" + extField.getEnumItemId()), () -> QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])new QFilter("id", "=", (Object)extField.getEnumItemId()).toArray()));
                QFilter qf = new QFilter("enumitemid", "=", (Object)extField.getEnumItemId());
                qf.and(new QFilter("model", "=", (Object)this.extendsModel.getModelId()));
                DynamicObjectCollection dyos = (DynamicObjectCollection)ThreadCache.get((Object)("enumvalue|" + this.queryCommand.getModelNum() + "|" + extField.getEnumItemId()), () -> QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,datatype,enumvalue", (QFilter[])qf.toArray()));
                List enumValues = dyos.stream().map(str -> str.getString("enumvalue")).collect(Collectors.toList());
                if (object.getString("datatype").equals("1") || object.getString("datatype").equals("5") || object.getString("datatype").equals("2")) {
                    Optional<String> first = enumValues.stream().filter(val -> new BigDecimal((String)val).compareTo(new BigDecimal(finalValue.toString())) == 0 || new BigDecimal(finalValue.toString()).equals(BigDecimal.ZERO)).findFirst();
                    if (first.isPresent()) return new BigDecimal(value.toString());
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ExtendResultSet_1", (String)"fi-bcm-business", (Object[])new Object[0]), value, col));
                }
                if (object.getString("datatype").equals("4")) {
                    try {
                        if (value instanceof Date) {
                            Optional<String> optional = enumValues.stream().filter(val -> {
                                try {
                                    return DateUtils.isSameDay((Date)((Date)finalValue), (Date)DateTimeUtils.parseDate((String)val));
                                }
                                catch (ParseException e) {
                                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]), DateTimeUtils.formatDate((Date)((Date)finalValue)), col));
                                }
                            }).findFirst();
                            if (optional.isPresent()) return value;
                            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ExtendResultSet_1", (String)"fi-bcm-business", (Object[])new Object[0]), DateTimeUtils.formatDate((Date)((Date)finalValue)), col));
                        }
                        if (!(value instanceof String)) throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                        Date tempDate = ScriptBuiltinExtHelper.getDateByDateStr((String)value, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ExtendResultSet_1", (String)"fi-bcm-business", (Object[])new Object[0]), finalValue, col));
                        Optional<String> optional = enumValues.stream().filter(val -> {
                            try {
                                return DateUtils.isSameDay((Date)tempDate, (Date)DateTimeUtils.parseDate((String)val));
                            }
                            catch (ParseException e) {
                                throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                            }
                        }).findFirst();
                        if (optional.isPresent()) return tempDate;
                        throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ExtendResultSet_1", (String)"fi-bcm-business", (Object[])new Object[0]), DateTimeUtils.formatDate((Date)tempDate), col));
                    }
                    catch (ParseException e) {
                        throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
                if (enumValues.contains(value.toString())) return value;
                if (value.toString().trim().length() <= 0) return value;
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ExtendResultSet_1", (String)"fi-bcm-business", (Object[])new Object[0]), value, col));
            }
            if (DataTypeEnum.TXT.getOIndex().equals(dataType)) {
                if (value instanceof String) return value;
                throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (DataTypeEnum.DATETP.getOIndex().equals(dataType)) {
                if (value instanceof String) {
                    try {
                        Date tempDate = ScriptBuiltinExtHelper.getDateByDateStr((String)value, ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                        return tempDate;
                    }
                    catch (ParseException e) {
                        throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
                if (value instanceof Date) return value;
                throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (value instanceof Number) return value;
            if (NumberUtil.isNumberable((Object)value)) return value;
            throw new BizRuleException(ResManager.loadKDString((String)"set(row, colNum, colValue)\u5b57\u6bb5\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u503c\u7684\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ExtendResultSet_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!(value instanceof String)) throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u7f16\u7801\u3002", (String)"ExtendResultSet_15", (String)"fi-bcm-business", (Object[])new Object[0]));
        Dimension dimension = entry.getDimension();
        IDNumberTreeNode treeNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.extendsModel.getModelId()), (String)dimension.getNumber(), (String)value.toString());
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) return value;
        throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6210\u5458\u7f16\u7801\u3002", (String)"ExtendResultSet_15", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    @KSMethod
    public Object get(Object[] args) {
        Object[] filterColValues;
        if (args.length > 2) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"get", 2});
        }
        if (!(args[0] instanceof String) || args.length == 2 && !(args[1] instanceof String)) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
        }
        FieldEntry entry = this.extendsModel.getFieldEntryByNumber(args[0].toString().trim());
        if (entry == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\uff0c\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u53d6\u503c\u5b57\u6bb5\u7f16\u7801%3$s", (String)"ExtendResultSet_11", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), "get", args[0].toString().trim()));
        }
        Map<String, String> filterMap = new HashMap<String, String>();
        if (args.length == 2) {
            filterMap = this.getFilterMap(args[1].toString().trim(), "get");
        }
        if ((filterColValues = this.getFilterColValues(args[0].toString().trim(), filterMap, false)).length > 1) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\u83b7\u53d6\u7684\u503c\u4e0d\u552f\u4e00", (String)"ExtendResultSet_14", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), "get"));
        }
        return filterColValues.length == 0 ? null : filterColValues[0];
    }

    public Object get() {
        throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\u7f3a\u5931\u76ee\u6807\u5b57\u6bb5\u53c2\u6570", (String)"ExtendResultSet_10", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), "get"));
    }

    private Map<String, String> getFilterMap(String colStr, String method) {
        String[] splits;
        HashMap<String, String> map = new HashMap<String, String>();
        Map shortNumMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.extendsModel.getModelId()));
        for (String split : splits = colStr.split(",")) {
            String newFieldNum;
            String col = split.trim();
            String[] vals = col.split("[.@]");
            if (vals.length == 2) {
                newFieldNum = shortNumMap.getOrDefault(vals[0].trim(), vals[0].trim());
                FieldEntry entry = this.extendsModel.getFieldEntryByNumber(newFieldNum);
                if (entry == null) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\uff0c\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801%3$s", (String)"ExtendResultSet_12", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), method, newFieldNum));
                }
            } else {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\uff0c\u6761\u4ef6\u5b57\u6bb5\u7ec4\u5408\u65e0\u6548\uff0c\u8981\u6c42\u5b57\u6bb5\u7f16\u7801\u4e0e\u5185\u5bb9\u76f4\u63a5\u7528\"@\"\u7b26\u53f7\u94fe\u63a5\uff0c\u4e14\u5b57\u6bb5\u4e0e\u5b57\u6bb5\u4e4b\u95f4\u7528\u82f1\u6587\u9017\u53f7\",\"\u5206\u9694", (String)"ExtendResultSet_13", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), method));
            }
            map.put(newFieldNum, vals[1].trim());
        }
        return map;
    }

    private Object[] getFilterColValues(String fieldNumber, Map<String, String> filterMap, boolean deduplicated) {
        EDResultSetMetaData metaData = this.getEdResultSet().getMetaData();
        ArrayList<Object> res = new ArrayList<Object>();
        block2: for (EDRow row : this.getEdResultSet().getRows()) {
            Object value = row.getValue(metaData.getColIndex(fieldNumber));
            for (Map.Entry<String, String> entry : filterMap.entrySet()) {
                int colIndex = metaData.getColIndex(entry.getKey());
                Object colValue = row.getValue(colIndex);
                if (colValue instanceof String) {
                    if (colValue.toString().equals(entry.getValue())) continue;
                    continue block2;
                }
                if (colValue instanceof Date) {
                    try {
                        Date tempDate = ScriptBuiltinExtHelper.getDateByDateStr(entry.getValue(), ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                        if (DateUtils.isSameDay((Date)tempDate, (Date)((Date)colValue))) continue;
                        continue block2;
                    }
                    catch (ParseException e) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
                if (!(colValue instanceof BigDecimal ? new BigDecimal(entry.getValue()).compareTo((BigDecimal)colValue) != 0 : Objects.equals(colValue, entry.getValue()))) continue;
                continue block2;
            }
            if (deduplicated && res.size() > 0) {
                Optional<Object> optional;
                if (value instanceof BigDecimal) {
                    optional = res.stream().filter(re -> ((BigDecimal)value).compareTo((BigDecimal)re) == 0).findFirst();
                    if (optional.isPresent()) continue;
                    res.add(value);
                    continue;
                }
                if (value instanceof Date) {
                    optional = res.stream().filter(re -> DateUtils.isSameDay((Date)((Date)value), (Date)((Date)re))).findFirst();
                    if (optional.isPresent()) continue;
                    res.add(value);
                    continue;
                }
                if (res.contains(value)) continue;
                res.add(value);
                continue;
            }
            res.add(value);
        }
        return res.toArray();
    }

    @KSMethod
    public Object[] gets(Object[] args) {
        FieldEntry entry;
        Map<String, String> filterMap = new HashMap<String, String>();
        boolean deduplicated = false;
        if (args.length == 1) {
            if (!(args[0] instanceof String)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
        } else if (args.length == 2) {
            if (!(args[0] instanceof String)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            if (args[1] instanceof Boolean || args[1] instanceof String && ("false".equals(args[1].toString()) || "true".equals(args[1].toString()))) {
                deduplicated = Boolean.parseBoolean(args[1].toString());
            } else {
                filterMap = this.getFilterMap(args[1].toString().trim(), "gets");
            }
        } else if (args.length == 3) {
            if (!(args[0] instanceof String && args[1] instanceof String && (args[2] instanceof Boolean || args[2] instanceof String || "false".equals(args[2].toString()) || "true".equals(args[2].toString())))) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            filterMap = this.getFilterMap(args[1].toString().trim(), "gets");
            deduplicated = Boolean.parseBoolean(args[2].toString());
        } else {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"get", 3});
        }
        if ((entry = this.extendsModel.getFieldEntryByNumber(args[0].toString().trim())) == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\uff0c\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u53d6\u503c\u5b57\u6bb5\u7f16\u7801%3$s", (String)"ExtendResultSet_11", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), "gets", args[0].toString().trim()));
        }
        return this.getFilterColValues(args[0].toString().trim(), filterMap, deduplicated);
    }

    @KSMethod
    public Object[] gets() {
        throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u96c6%1$s\u7684%2$s\u65b9\u6cd5\u7f3a\u5931\u76ee\u6807\u5b57\u6bb5\u53c2\u6570", (String)"ExtendResultSet_10", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber(), "gets"));
    }

    private void checkModelEnable() {
        if (!this.extendsModel.getEnable().equals("1")) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u5199\u5165\u6570\u636e\u3002", (String)"ExtendResultSet_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.extendsModel.getNumber()));
        }
    }

    private boolean isSameEntity(EDRow row) {
        String ctxEntity = (String)((Pair)this.queryCommand.getOutline().getComputingContext().getScopeItems().get((Object)SysDimensionEnum.Entity.getNumber())).p2;
        if (ctxEntity.contains("_")) {
            ctxEntity = ctxEntity.split("_")[1];
        }
        return ctxEntity.equals(row.getOriginalValue(PresetConstant.ENTITY_DIM));
    }
}

