/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.extendmodel;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendResultSet;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.exception.BizRuleException;
import org.apache.commons.lang.ArrayUtils;

@KSObject
public class ExtendRow
extends EDRow
implements ScriptObject {
    private List<Long> pkIds;
    private List<String> moneys;
    private ExtendResultSet extendResultSet;

    public ExtendRow(EDResultSetMetaData metaData) {
        super(metaData);
    }

    public ExtendResultSet getExtendResultSet() {
        return this.extendResultSet;
    }

    public void setExtendResultSet(ExtendResultSet extendResultSet) {
        this.extendResultSet = extendResultSet;
    }

    public Object __getUndefinedProperty(String propertyName) {
        int index;
        Map shortNumMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.extendResultSet.getQueryCommand().getModelNum());
        if (shortNumMap.containsKey(propertyName)) {
            propertyName = (String)shortNumMap.get(propertyName);
        }
        if ((index = this.metaData.getColIndex(propertyName)) == -1) {
            throw new BizRuleException(String.format("%s not supported property [%s] operate", "ExtendRow", propertyName));
        }
        Object value = this.values.get(index);
        if (value instanceof BigDecimal) {
            return new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString());
        }
        if (value instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            value = dateFormat.format(value);
        }
        return value;
    }

    public Object __getUndefinedElement(Object element) {
        if (element instanceof String) {
            return this.__getUndefinedProperty((String)element);
        }
        if (element != null && element.getClass().getName().contains("String")) {
            return this.__getUndefinedProperty(element.toString());
        }
        throw new BizRuleException(String.format("row not supported property [%s] operate", element));
    }

    @KSMethod
    public void set(Object ... objects) {
        this.getExtendResultSet().set(ArrayUtils.add((Object[])objects, (int)0, (Object)this));
    }

    public void add(Object ... objects) {
        this.getExtendResultSet().add(ArrayUtils.add((Object[])objects, (int)0, (Object)this));
    }

    @KSMethod
    public void delete() {
        this.getExtendResultSet().delete(this);
    }

    @Override
    public long getPkId() {
        return this.pkId;
    }

    @Override
    public void setPkId(long pkId) {
        this.pkId = pkId;
    }

    public List<Long> getPkIds() {
        return this.pkIds;
    }

    public void setPkIds(List<Long> pkIds) {
        this.pkIds = pkIds;
    }

    public List<String> getMoneys() {
        return this.moneys;
    }

    public void setMoneys(List<String> moneys) {
        this.moneys = moneys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int count = 0;
        List<EDColumn> columns = this.getMetaData().getColMetaDatas();
        for (EDColumn column : columns) {
            String colName = column.getMdName();
            int colIndex = column.getColIndex();
            Object value = this.values.get(colIndex);
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                ++count;
                continue;
            }
            if (value instanceof BigDecimal) {
                value = new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString());
            } else if (value instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                value = dateFormat.format(value);
            }
            sb.append(colName).append(":").append(value);
            if (count < this.metaData.getColumCount() - 1) {
                sb.append(",");
            }
            ++count;
        }
        sb.append("}");
        return sb.toString();
    }

    public String toOnlyColSumSetNumber(String colSumSetNumber, String modelNum) {
        HashSet dims = new HashSet(MemberReader.getDimensionShortNumber2NumberMap((String)modelNum).values());
        StringBuilder sb = new StringBuilder("{");
        int count = 0;
        List<EDColumn> columns = this.getMetaData().getColMetaDatas();
        for (EDColumn column : columns) {
            String colName = column.getMdName();
            int colIndex = column.getColIndex();
            Object value = this.values.get(colIndex);
            if (value == null || value instanceof String && ((String)value).length() == 0 && !dims.contains(colName) || !dims.contains(colName) && !colSumSetNumber.equals(colName)) {
                ++count;
                continue;
            }
            if (value instanceof BigDecimal) {
                value = new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString());
            }
            sb.append(colName).append(":").append(value).append(",");
            ++count;
        }
        if (sb.toString().endsWith(",")) {
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
        }
        sb.append("}");
        return sb.toString();
    }
}

