/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptObject;
import kd.bos.script.jsengine.KRuntimeException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendResultSet;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendRow;
import kd.fi.bcm.business.bizrule.extendscript.service.IBizRuleExtFuncService;
import kd.fi.bcm.business.bizrule.extendscript.util.ExtendService;
import kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EDSortInfo;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.ParamConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ChineseUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MethodParamsValidator;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.XDMDimensionFilterItem;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.member.ScriptAllMemberExtDimensionNode;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.computing.model.NormalFilterItem;
import kd.fi.bcm.computing.model.SpecialFilterItem;
import kd.fi.bcm.computing.model.WhenFilterItem;
import kd.fi.bcm.computing.util.ExpCommonValidateUtil;
import kd.fi.bcm.computing.util.RuleExecuteServiceHelper;
import kd.fi.bcm.computing.util.ScriptBuiltinHelper;
import kd.fi.bcm.fel.FelEngine;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.view.builder.extend.SortInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AbstractBizRuleExtFuncService
implements IBizRuleExtFuncService {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(AbstractBizRuleExtFuncService.class);
    private static final String IN = "in";
    private static final String NOTIN = "not in";
    private static final String NOTLIKE = "not like";
    private static final String LIKE = "like";
    private static final int scale = 15;
    private static final String OPERATORSTR = "[+\\-*/=]";
    private static final Pattern WHEN_EQUAL_PATTERN = Pattern.compile("s\\.[^.=]*=");
    private static final Pattern WHEN_IN_PATTERN = Pattern.compile("s\\.[^.=]*\\.in\\(.*\\)");
    private static final Pattern WHEN_SPECIAL_PATTERN = Pattern.compile("[ts]\\.[^.=]*=\\s*[ts]\\.[^.=]*");
    private static final Set<String> compareConditions = Sets.newHashSet((Object[])new String[]{"<=", "<", ">", ">="});
    private static final int ALLOW_IN_MAX_AMOUNT = 500000;
    private static final Set<String> MODEL_DEFAULT_DIMS = new HashSet<String>(Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Process.getNumber(), SysDimensionEnum.AuditTrail.getNumber()));

    @Override
    public ScriptObject getXDMSet(Object[] args, int argsNum, IOutline outline) {
        int type = MethodParamsValidator.checkAndReturnParamType((String)"getXDMSet", (Object[])args);
        ExtendsModel extendsModel = null;
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        XDMScopeInfo xdmScopeInfo = null;
        QFilter qf = null;
        String orderBy = "";
        String orderType = "";
        String dimStr = "";
        boolean needSum = true;
        switch (type) {
            case 0: 
            case 8: {
                extendsModel = ExtendService.existExtendModel((String)args[0], outline.getModelNum());
                dimStr = (String)args[1];
                if (type != 8) break;
                needSum = (Boolean)args[2];
                break;
            }
            case 1: 
            case 9: {
                extendsModel = ExtendService.existExtendModel((String)args[0], outline.getModelNum());
                xdmScopeInfo = (XDMScopeInfo)args[1];
                if (type != 9) break;
                needSum = (Boolean)args[2];
                break;
            }
            case 2: 
            case 10: {
                extendsModel = ExtendService.existExtendModel((String)args[0], outline.getModelNum());
                xdmScopeInfo = (XDMScopeInfo)args[1];
                orderBy = (String)args[2];
                orderType = "D";
                if (type != 10) break;
                needSum = (Boolean)args[3];
                break;
            }
            case 3: 
            case 11: {
                extendsModel = ExtendService.existExtendModel((String)args[0], outline.getModelNum());
                xdmScopeInfo = (XDMScopeInfo)args[1];
                orderBy = (String)args[2];
                orderType = (String)args[3];
                if (!"A".equals(orderType) && !"D".equals(orderType)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"getXDMSet\u51fd\u6570\u53c2\u6570\u5b9a\u4e49\u9519\u8bef\u3002", (String)"ScriptBuiltinExtHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (type != 11) break;
                needSum = (Boolean)args[4];
                break;
            }
            case 4: 
            case 12: {
                xdmScopeInfo = (XDMScopeInfo)args[0];
                extendsModel = ExtendService.existExtendModel(xdmScopeInfo.getExtendsmodelNumber(), outline.getModelNum());
                orderBy = (String)args[1];
                orderType = "D";
                if (type != 12) break;
                needSum = (Boolean)args[2];
                break;
            }
            case 5: 
            case 13: {
                xdmScopeInfo = (XDMScopeInfo)args[0];
                extendsModel = ExtendService.existExtendModel(xdmScopeInfo.getExtendsmodelNumber(), outline.getModelNum());
                orderBy = (String)args[1];
                orderType = (String)args[2];
                if (!"A".equals(orderType) && !"D".equals(orderType)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"getXDMSet\u51fd\u6570\u53c2\u6570\u5b9a\u4e49\u9519\u8bef\u3002", (String)"ScriptBuiltinExtHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (type != 13) break;
                needSum = (Boolean)args[3];
                break;
            }
            case 6: 
            case 14: {
                extendsModel = ExtendService.existExtendModel((String)args[0], outline.getModelNum());
                if (type != 14) break;
                needSum = (Boolean)args[1];
                break;
            }
            case 7: 
            case 15: {
                xdmScopeInfo = (XDMScopeInfo)args[0];
                extendsModel = ExtendService.existExtendModel(xdmScopeInfo.getExtendsmodelNumber(), outline.getModelNum());
                if (type != 15) break;
                needSum = (Boolean)args[1];
                break;
            }
        }
        if (ScriptBuiltinExtHelper.isIntrOnlyExectype(outline)) {
            needSum = false;
        }
        if (extendsModel == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"getXDMSet\u51fd\u6570\u53c2\u6570\u4e2d\u6307\u5b9a\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u65e0\u6548\u3002", (String)"ScriptBuiltinExtHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (ExtendDimGroupType.getEnumByIndex((String)extendsModel.getExtendsGroupType()) == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u975e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b", (String)"ScriptBuiltinExtHelper_52", (String)"fi-bcm-business", (Object[])new Object[0]), "getXDMSet"));
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (type == 0 || type == 6) {
            Map<String, String> dimMap = BizRuleUtil.parseDimStr(outline.getModelNum(), dimStr);
            for (Map.Entry<String, String> entry : dimMap.entrySet()) {
                dimNumMap.put(entry.getKey(), new String[]{entry.getValue()});
                dimQcpMap.put(entry.getKey(), IN);
            }
        } else {
            AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
            if (xdmScopeInfo != null) {
                qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
            }
        }
        if (needSum) {
            BizRuleUtil.setMethodNeed(extendsModel.getNumber());
        }
        QueryCommand queryCommand = this.getQueryCommand(outline, extendsModel, qf, orderBy, orderType, dimNumMap, dimQcpMap);
        EDResultSet edResultSet = ExtDataServiceHelper.queryData(queryCommand);
        return new ExtendResultSet(queryCommand, extendsModel, edResultSet);
    }

    private QueryCommand getQueryCommand(IOutline outline, ExtendsModel extendsModel, QFilter qf, String orderBy, String orderType, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap) {
        String dim = ExtendService.checkDim(extendsModel, dimNumMap.keySet());
        if (StringUtils.isNotEmpty((String)dim)) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s \u62d3\u5c55\u6570\u636e\u6a21\u578b\u4e0d\u5305\u542b%2$s\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), extendsModel.getNumber(), dim));
        }
        this.getQueryParams(outline, dimNumMap, dimQcpMap, "ATTotal");
        QueryCommand queryCommand = ExtendService.getQueryCommand(extendsModel, dimNumMap, dimQcpMap, outline, qf);
        if (StringUtils.isNotEmpty((String)orderBy)) {
            List<ExtFieldEntry> extFieldEntry = extendsModel.getExtFieldEntry();
            Optional<ExtFieldEntry> first = extFieldEntry.stream().filter(fieldEntry -> fieldEntry.getExtField().getNumber().equals(orderBy.trim()) && fieldEntry.getExtField().getMapped().contains("numext")).findFirst();
            if (!first.isPresent()) {
                throw new BizRuleException(ResManager.loadKDString((String)"getXDMSet\u53ea\u80fd\u6307\u5b9a\u6570\u636e\u7c7b\u578b\u662f\u9ed8\u8ba4\u3001\u8d27\u5e01\u3001\u6570\u503c\u6216\u6bd4\u4f8b\u4f5c\u4e3a\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_41", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            EDSortInfo esi = new EDSortInfo();
            SortInfo sortInfo = new SortInfo(orderBy, orderType.equals("A") ? SortInfo.SortType.ASC : SortInfo.SortType.DESC);
            esi.setSortInfos(Collections.singletonList(sortInfo));
            queryCommand.setSortInfo(esi);
            queryCommand.setSortInfo(esi);
        }
        return queryCommand;
    }

    private Map<String, List<String>> getExtendModelDimNums(List<ExtendResultSet> extendResultSetList, Collection<String> dimNumbers) {
        HashMap<String, List<String>> extendModelDimNumMap = new HashMap<String, List<String>>(16);
        for (ExtendResultSet extendResultSet : extendResultSetList) {
            String extendModel = extendResultSet.getExtendsModel().getNumber();
            if (extendModelDimNumMap.containsKey(extendModel)) continue;
            ArrayList<String> extendModelDimNums = new ArrayList<String>(10);
            List<EDColumn> colMetaData = extendResultSet.getEdResultSet().getMetaData().getColMetaDatas();
            for (EDColumn edColumn : colMetaData) {
                if (!dimNumbers.contains(edColumn.getMdName()) || DimTypesEnum.ENTITY.getNumber().equals(edColumn.getMdName())) continue;
                extendModelDimNums.add(edColumn.getMdName());
            }
            extendModelDimNumMap.put(extendModel, extendModelDimNums);
        }
        return extendModelDimNumMap;
    }

    private List<DynamicObject> addExpressions(List<ExtendResultSet> extendResultSetList, Collection<String> dimNumbers, Map<String, List<String>> extendModelDimMap, List<Map<String, String>> dimNumMapList, List<String> expressions, IOutline outline, Map<String, Object> args, List<String> deleteDimStrList) {
        Map scopeItems = outline.getComputingContext().getScopeItems();
        Object ruleId = args.get("ruleid");
        LinkedList<DynamicObject> logs = new LinkedList<DynamicObject>();
        if (extendResultSetList.stream().anyMatch(re -> re.getQueryCommand().isNeedSum())) {
            return logs;
        }
        IntStream.range(0, extendResultSetList.size()).forEach(ind -> {
            int count = 0;
            ExtendResultSet extendResultSet = (ExtendResultSet)extendResultSetList.get(ind);
            Map dimNumMap = (Map)dimNumMapList.get(ind);
            String extendModelNum = extendResultSet.getExtendsModel().getNumber();
            HashMap<Long, DynamicObject> entityMap = new HashMap<Long, DynamicObject>(16);
            ArrayList<Long> ids = new ArrayList<Long>(10);
            for (EDRow row : extendResultSet.getEdResultSet().getRows()) {
                ids.addAll(((ExtendRow)row).getPkIds());
            }
            String extendEntity = ExtendDimGroupType.COMMON.getIndex().equals(extendResultSet.getExtendsModel().getExtendsGroupType()) ? "bcm_extenddata" : "bcm_extenddata_bus";
            String dimFields = "process,scenario,year,period,entity,currency,audittrail";
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)extendEntity, (String)("id,org," + dimFields), (QFilter[])new QFilter("id", IN, ids).toArray());
            for (DynamicObject dyn : dyns) {
                entityMap.put(dyn.getLong("id"), dyn);
            }
            for (EDRow row : extendResultSet.getEdResultSet().getRows()) {
                Object dim2;
                List<Long> pkIds = ((ExtendRow)row).getPkIds();
                List filterPkIds = pkIds.stream().filter(entityMap::containsKey).collect(Collectors.toList());
                if (filterPkIds.size() != pkIds.size()) continue;
                HashMap<String, String> templateMap = new HashMap<String, String>(dimNumMap);
                StringBuilder sb = new StringBuilder();
                List<Object> values = row.getValues();
                for (Object dim2 : (List)extendModelDimMap.get(extendModelNum)) {
                    int colIndex;
                    String colValue;
                    if (templateMap.containsKey(dim2) || !StringUtils.isNotEmpty((String)(colValue = (String)values.get(colIndex = row.getMetaData().getColIndex((String)dim2))))) continue;
                    templateMap.put((String)dim2, colValue);
                }
                if (dimNumbers.size() - 6 != templateMap.size() && count == 0) {
                    Set targetNames = templateMap.keySet();
                    dimNumbers.forEach(dimNumber -> {
                        if (!scopeItems.containsKey(dimNumber) && !targetNames.contains(dimNumber)) {
                            throw new BizRuleException(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u7f3a\u5931\u7ef4\u5ea6\u3002", (String)"ScriptBuiltinExtHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                    });
                }
                int i = 0;
                dim2 = templateMap.entrySet().iterator();
                while (dim2.hasNext()) {
                    Map.Entry entry = (Map.Entry)dim2.next();
                    sb.append((String)entry.getKey()).append("@").append((String)entry.getValue());
                    if (i < templateMap.size() - 1) {
                        sb.append(",");
                    }
                    ++i;
                }
                if (StringUtils.isEmpty((String)extendResultSet.getColSumSetNumber())) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u7f3a\u5c11\u5408\u8ba1\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                int colIndex = row.getMetaData().getColIndex(extendResultSet.getColSumSetNumber());
                if (colIndex > -1) {
                    sb.append("=").append(values.get(colIndex));
                }
                expressions.add(sb.toString());
                ++count;
                this.addSynLog(templateMap, extendResultSet, (ExtendRow)row, ruleId, scopeItems, deleteDimStrList, logs, entityMap);
            }
        });
        return logs;
    }

    private void addSynLog(Map<String, String> targetDimMap, ExtendResultSet extendResultSet, ExtendRow row, Object ruleId, Map<String, Pair<Long, String>> scopeItems, List<String> deleteDimStrList, List<DynamicObject> logs, Map<Long, DynamicObject> entityMap) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsynlog");
        ExtendsModel extendsModel = extendResultSet.getExtendsModel();
        long modelId = extendsModel.getModelId();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Long bizRuleId = LongUtil.toLong((Object)ruleId);
        long extendModelId = extendsModel.getId();
        String targetDimsStr = this.getTotalDimStr(targetDimMap, modelId, scopeItems);
        Optional<ExtFieldEntry> optional = extendsModel.getExtFieldEntry().stream().filter(ext -> ext.getExtField().getNumber().equals(extendResultSet.getColSumSetNumber())).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        long extendFieldId = optional.get().getExtField().getId();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        String dimFields = "process,scenario,year,period,entity,currency,audittrail";
        String[] dims = dimFields.split(",");
        List<Long> pkIds = row.getPkIds();
        List<String> moneys = row.getMoneys();
        int index = 0;
        for (Long pkId : pkIds) {
            DynamicObject object = new DynamicObject(entryEntity.getDynamicObjectType());
            DynamicObject entity = entityMap.get(pkId);
            for (String dim : dims) {
                IDNumberTreeNode mem;
                if ("process".equals(dim)) {
                    mem = MemberReader.findMemberByNumber((String)modelNum, (String)SysDimensionEnum.Process.getNumber(), (String)entity.getString(dim));
                    if (ScriptBuiltinHelper.PARENT_JOURNAL_BPS.contains(mem.getNumber()) || mem.getParent() != IDNumberTreeNode.NotFoundTreeNode && "EJE".equals(mem.getParent().getNumber())) {
                        object.set("org", (Object)MemberReader.findMemberByNumber((String)modelNum, (String)SysDimensionEnum.Entity.getNumber(), (String)entity.getString("org").split("_")[0]).getId());
                    } else {
                        object.set("org", (Object)MemberReader.findMemberByNumber((String)modelNum, (String)SysDimensionEnum.Entity.getNumber(), (String)entity.getString("org")).getId());
                    }
                } else {
                    mem = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.getNumberByLowercaseNumber((String)dim), (String)entity.getString(dim));
                }
                object.set(dim, (Object)mem.getId());
            }
            object.set("money", (Object)moneys.get(index));
            object.set("seq", (Object)index);
            if (ExtendDimGroupType.COMMON.getIndex().equals(extendResultSet.getExtendsModel().getExtendsGroupType())) {
                object.set("data", (Object)pkId);
            } else {
                object.set("databus", (Object)pkId);
            }
            entryEntity.add((Object)object);
            ++index;
        }
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("bizrule", (Object)bizRuleId);
        dynamicObject.set("extendsmodel", (Object)extendModelId);
        dynamicObject.set("dimstr", (Object)targetDimsStr);
        dynamicObject.set("creater", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set("extendmember", (Object)extendFieldId);
        deleteDimStrList.add(targetDimsStr);
        logs.add(dynamicObject);
    }

    private String getTotalDimStr(Map<String, String> targetDimMap, Long modelId, Map<String, Pair<Long, String>> scopeItems) {
        StringBuilder sb = new StringBuilder();
        Set dims = MemberReader.getDimNumberMapNameById((long)modelId).keySet();
        int i = 0;
        for (String dim : dims) {
            String memberNum;
            if (scopeItems.get(dim) != null) {
                memberNum = (String)scopeItems.get((Object)dim).p2;
                if (DimTypesEnum.PROCESS.getNumber().equals(dim) && "EIRpt".equals(memberNum)) {
                    memberNum = "IRpt";
                } else if (DimTypesEnum.PROCESS.getNumber().equals(dim) && "ERAdj".equals(memberNum)) {
                    memberNum = "RAdj";
                }
            } else {
                memberNum = targetDimMap.get(dim);
            }
            sb.append(dim).append(".").append(memberNum);
            if (i != dims.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String[] xSyn(IOutline outline, Map<String, Object> args, Object[] params) {
        if (params.length == 0 || params.length % 2 != 0) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u53c2\u6570\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\uff0c\u6bcf\u4e2a\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u540e\u9762\u9700\u8ddf\u968f\u4e00\u4e2a\u62d3\u5c55\u6570\u636egetColSumSet\u8fd4\u56de\u7684\u5bf9\u8c61\u3002", (String)"ScriptBuiltinExtHelper_42", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        List<Object> dimStrList = new LinkedList();
        LinkedList<ExtendResultSet> resultSetList = new LinkedList<ExtendResultSet>();
        for (Object param : params) {
            if ((dimStrList.size() + resultSetList.size()) % 2 == 0 && !(param instanceof String) || (dimStrList.size() + resultSetList.size()) % 2 != 0 && !(param instanceof ExtendResultSet)) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u53c2\u6570\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\uff0c\u6bcf\u4e2a\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u540e\u9762\u9700\u8ddf\u968f\u4e00\u4e2a\u62d3\u5c55\u6570\u636egetColSumSet\u8fd4\u56de\u7684\u5bf9\u8c61\u3002", (String)"ScriptBuiltinExtHelper_42", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if ((dimStrList.size() + resultSetList.size()) % 2 == 0) {
                dimStrList.add((String)param);
                continue;
            }
            resultSetList.add((ExtendResultSet)param);
        }
        Collection<String> dimNumbers = MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum()).values();
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        Map<String, List<String>> extendModelDimNumMap = this.getExtendModelDimNums(resultSetList, dimNumbers);
        dimStrList = dimStrList.stream().map(dimStr -> dimStr.contains("v(") ? dimStr.substring(3, dimStr.length() - 2) : dimStr).collect(Collectors.toList());
        ArrayList<Map<String, String>> dimNumMap = new ArrayList<Map<String, String>>(10);
        for (String string : dimStrList) {
            dimNumMap.add(BizRuleUtil.parseDimStr(outline.getModelNum(), string));
        }
        ArrayList<String> expressions = new ArrayList<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        List<DynamicObject> logs = this.addExpressions(resultSetList, dimNumbers, extendModelDimNumMap, dimNumMap, expressions, outline, args, linkedList);
        if (!logs.isEmpty()) {
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.and("dimstr", IN, linkedList);
            DeleteServiceHelper.delete((String)"bcm_extendsynlog", (QFilter[])qf.toArray());
            SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
        }
        return expressions.toArray(new String[0]);
    }

    public static List<DynamicObject> getExtNodeListById(DynamicObject extmodel) {
        Map extMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield", (QFilter[])new QFilter("extmodelid", "=", (Object)extmodel.getLong("id")).toArray(), (String)"sequence,extfield.number");
        return new ArrayList<DynamicObject>(extMap.values());
    }

    private QFilter addXdmScopeFilter(ExtendsModel extendsModel, XDMScopeInfo xdmScopeInfo, IOutline outline, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
        QFilter qf = new QFilter("1", "=", (Object)1);
        Map<String, String> memberToFieldMap = DimensionServiceHelper.getDimensionNumMapped(extendsModel.getModelId());
        HashMap<String, QFilter> compareFilterMap = new HashMap<String, QFilter>(16);
        Set contextDims = outline.getComputingContext().getScopeItems().keySet();
        for (XDMDimensionFilterItem xDMDimensionFilterItem : xdmScopeInfo.getXdmFilters()) {
            List<Object> values = xDMDimensionFilterItem.getValues();
            String number = xDMDimensionFilterItem.getName();
            Optional<ExtFieldEntry> optional = extendsModel.getExtFieldEntry().stream().filter(ext -> ext.getExtField().getNumber().equals(number)).findFirst();
            if (optional.isPresent()) {
                values = AbstractBizRuleExtFuncService.changeValues(values, optional.get(), xDMDimensionFilterItem.getCondition());
            }
            if ("is null".equals(xDMDimensionFilterItem.getCondition()) || "is not null".equals(xDMDimensionFilterItem.getCondition())) {
                String mapKey;
                Object value = null;
                FieldEntry fieldEntry = extendsModel.getFieldEntryByNumber(xDMDimensionFilterItem.getName());
                if (fieldEntry == null) continue;
                if (FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType()) {
                    mapKey = fieldEntry.getExtField().getMapped();
                    String dataType = fieldEntry.getExtField().getDataType();
                    if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                        value = " ";
                    } else if (dataType.equals(DataTypeEnum.ENUMTP.getOIndex())) {
                        long enumItemId = fieldEntry.getExtField().getEnumItemId();
                        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)enumItemId, (String)"bcm_enumitem");
                        String enumDataType = object.getString("datatype");
                        if (enumDataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || enumDataType.equals(DataTypeEnum.PROPORTION.getOIndex())) {
                            value = 0;
                        } else if (enumDataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || enumDataType.equals(DataTypeEnum.TXT.getOIndex())) {
                            value = " ";
                        }
                    } else if (!dataType.equals(DataTypeEnum.DATETP.getOIndex())) {
                        value = 0;
                    }
                } else {
                    mapKey = fieldEntry.getDimension().getNumber().toLowerCase();
                    value = " ";
                }
                if (value == null) {
                    qf.and(mapKey, xDMDimensionFilterItem.getCondition(), null);
                    continue;
                }
                qf.and(mapKey, xDMDimensionFilterItem.getCondition().equals("is null") ? "=" : "!=", value);
                continue;
            }
            if (values == null) continue;
            if (contextDims.contains(number) || DimTypesEnum.AUDITTRIAL.getNumber().equals(number)) {
                dimNumMap.put(xDMDimensionFilterItem.getName(), values.toArray(new String[0]));
                dimQcpMap.put(number, xDMDimensionFilterItem.getCondition());
                continue;
            }
            QFilter tempQf = this.getQfilterByXdmFilterAndValues(extendsModel, xDMDimensionFilterItem, values, memberToFieldMap);
            if (compareConditions.contains(xDMDimensionFilterItem.getCondition())) {
                if (!optional.isPresent()) continue;
                if (compareFilterMap.containsKey(number)) {
                    compareFilterMap.put(number, ((QFilter)compareFilterMap.get(number)).and(tempQf));
                    continue;
                }
                compareFilterMap.put(number, tempQf);
                continue;
            }
            if (filterMap.containsKey(number)) {
                filterMap.put(number, ((QFilter)filterMap.get(number)).or(tempQf));
                continue;
            }
            filterMap.put(number, tempQf);
        }
        for (Map.Entry entry : filterMap.entrySet()) {
            if (compareFilterMap.containsKey(entry.getKey())) {
                qf.and(((QFilter)entry.getValue()).or((QFilter)compareFilterMap.get(entry.getKey())));
                compareFilterMap.remove(entry.getKey());
                continue;
            }
            qf.and((QFilter)entry.getValue());
        }
        for (Map.Entry entry : compareFilterMap.entrySet()) {
            qf.and((QFilter)entry.getValue());
        }
        return qf;
    }

    private Map<String, Set<String>> getBigMembersInData(XDMScopeInfo xdmScopeInfo) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        for (XDMDimensionFilterItem item : xdmScopeInfo.getXdmFilters()) {
            List values = item.getValues();
            String name = item.getName();
            if (!IN.equals(item.getCondition()) || values == null || values.size() < 500000) continue;
            res.put(name, values.stream().map(Object::toString).collect(Collectors.toSet()));
        }
        return res;
    }

    private QFilter getQfilterByXdmFilterAndValues(ExtendsModel extendsModel, XDMDimensionFilterItem item, List<Object> values, Map<String, String> memberToFieldMap) {
        String field;
        FieldEntry fieldEntry = extendsModel.getFieldEntryByNumber(item.getName());
        if (fieldEntry == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6\u6216\u5b57\u6bb5%s\u3002", (String)"ScriptBuiltinExtHelper_35", (String)"fi-bcm-business", (Object[])new Object[0]), item.getName()));
        }
        if (FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType()) {
            field = fieldEntry.getExtField().getMapped();
        } else {
            if (!memberToFieldMap.containsKey(item.getName())) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6\u6216\u5b57\u6bb5%s\u3002", (String)"ScriptBuiltinExtHelper_35", (String)"fi-bcm-business", (Object[])new Object[0]), item.getName()));
            }
            field = memberToFieldMap.get(item.getName());
        }
        if (IN.equals(item.getCondition()) || NOTIN.equals(item.getCondition())) {
            return new QFilter(field, item.getCondition(), values);
        }
        QFilter likeQf = null;
        for (Object obj : values) {
            if (likeQf == null) {
                likeQf = new QFilter(field, item.getCondition(), obj);
                continue;
            }
            likeQf.or(new QFilter(field, item.getCondition(), obj));
        }
        return likeQf;
    }

    private static List<Object> changeValues(List<Object> values, ExtFieldEntry extend, String condition) {
        String fieldmapped = extend.getExtField().getMapped();
        if ((NOTLIKE.equals(condition) || LIKE.equals(condition)) && !fieldmapped.contains("textext")) {
            return null;
        }
        if (("<=".equals(condition) || ">".equals(condition)) && !fieldmapped.contains("numext") && !fieldmapped.contains("dateext")) {
            return null;
        }
        if (values == null) {
            return null;
        }
        if (fieldmapped.contains("dateext")) {
            return values.stream().map(DateTimeUtils::trans2DateFilter4BizRule).collect(Collectors.toList());
        }
        if (fieldmapped.contains("textext")) {
            return values.stream().map(Object::toString).collect(Collectors.toList());
        }
        if (fieldmapped.contains("numext")) {
            try {
                return values.stream().map(obj -> new BigDecimal(obj.toString()).setScale(15, 4)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getShowNumberByModelNum(String modelNum) {
        DynamicObject doj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"shownumber", (QFilter[])new QFilter("number", "=", (Object)modelNum).toArray());
        if (doj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"ScriptBuiltinExtHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return doj.getString("shownumber");
    }

    private String checkExpression(String[] expressions, Map<String, String> numToFieldMap) {
        String message = "";
        for (String expression : expressions) {
            if (!expression.contains("=")) {
                return ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5b9a\u4e49\u9519\u8bef\u3002", (String)"ScriptBuiltinExtHelper_13", (String)"fi-bcm-computing", (Object[])new Object[0]);
            }
            String targetNum = expression.substring(0, expression.indexOf("=")).trim();
            if (StringUtils.isEmpty((String)targetNum) || targetNum.split(OPERATORSTR).length >= 2) {
                message = ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5b9a\u4e49\u9519\u8bef\u3002", (String)"ScriptBuiltin_44", (String)"fi-bcm-computing", (Object[])new Object[0]);
                break;
            }
            String field = numToFieldMap.get(targetNum);
            if (StringUtils.isEmpty((String)field)) {
                message = String.format(ResManager.loadKDString((String)"xRuns\u51fd\u6570%s\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptBuiltinExtHelper_15", (String)"fi-bcm-computing", (Object[])new Object[0]), targetNum);
                break;
            }
            if (field.contains("numext")) continue;
            message = String.format(ResManager.loadKDString((String)"xRuns\u51fd\u6570\u4e2d\u6307\u5b9a\u7684\u5b57\u6bb5\u201c%s\u201d\u7684\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u76f8\u5173\u8ba1\u7b97\u3002", (String)"ScriptBuiltinExtHelper_16", (String)"fi-bcm-computing", (Object[])new Object[0]), targetNum);
            break;
        }
        return message;
    }

    private void getNumToValueMap(FelEngine felEngine, List<EDColumn> edColumns, List<Object> values) {
        for (EDColumn edColumn : edColumns) {
            felEngine.getContext().set(edColumn.getMdName(), values.get(edColumn.getColIndex()));
        }
    }

    private ExtendResultSet getExtendModel(String dataModelNum, IOutline outline, XDMScopeInfo xdmScopeInfo, String defaultAudit) {
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        if (extendsModel == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"AbstractBizRuleExtFuncService_1", (String)"fi-bcm-business", (Object[])new Object[0]), dataModelNum));
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
        QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
        return this.getExtendDataModel(extendsModel, outline, qf, dimNumMap, dimQcpMap, defaultAudit);
    }

    private ExtendResultSet getExtendDataModel(ExtendsModel extendsModel, IOutline outline, QFilter xRunsQfilter, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, String defaultAudit) {
        this.getQueryParams(outline, dimNumMap, dimQcpMap, defaultAudit);
        return ExtendService.queryData(extendsModel, dimNumMap, dimQcpMap, outline, xRunsQfilter);
    }

    private DataSet getExtendDataSet(ExtendsModel extendsModel, IOutline outline, QFilter xRunsQfilter, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap) {
        this.getQueryParams(outline, dimNumMap, dimQcpMap, "ATTotal");
        return ExtendService.queryDataSet(extendsModel, dimNumMap, dimQcpMap, outline, xRunsQfilter);
    }

    private void getQueryParams(IOutline outline, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, String defaultAudit) {
        outline.getComputingContext().getScopeItems().forEach((key, value) -> {
            if (!dimNumMap.containsKey(key) || ((String[])dimNumMap.get(key)).length == 0) {
                dimNumMap.put((String)key, new String[]{(String)value.p2});
            }
            if (!dimQcpMap.containsKey(key)) {
                dimQcpMap.put((String)key, IN);
            }
        });
        if (!dimNumMap.containsKey(DimTypesEnum.AUDITTRIAL.getNumber())) {
            dimNumMap.putIfAbsent(DimTypesEnum.AUDITTRIAL.getNumber(), new String[]{defaultAudit});
            dimQcpMap.putIfAbsent(DimTypesEnum.AUDITTRIAL.getNumber(), IN);
        }
    }

    private String getGroupKeyByDims(EDRow row, List<String> dimSets) {
        StringBuilder sb = new StringBuilder();
        for (String dim : dimSets) {
            List<Object> values = row.getValues();
            sb.append(values.get(row.getMetaData().getColIndex(dim)));
        }
        return sb.toString();
    }

    @Override
    public void xRuns(IOutline outline, ScriptAllMemberExtDimensionNode node, XDMScopeInfo xdmScopeInfo, String[] expressions) {
        if (StringUtils.isNotEmpty((String)xdmScopeInfo.getExtendsmodelNumber()) && !node.getDatamodelNum().equals(xdmScopeInfo.getExtendsmodelNumber())) {
            throw new BizRuleException(ResManager.loadKDString((String)"xRuns\u51fd\u6570\u62d3\u5c55\u6570\u636e\u6a21\u578b\u4e0e\u6a21\u578b\u5b57\u6bb5\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_36", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (!BizRuleUtil.canEditExtData(outline, xdmScopeInfo)) {
            return;
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ExtendsModel extendsModel = new ExtendsModel(node.getDatamodelId());
        AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
        HashMap<String, String> numToFieldMap = new HashMap<String, String>(16);
        HashMap<String, String> fieldToNumMap = new HashMap<String, String>(16);
        for (ExtFieldEntry extFieldEntry : extendsModel.getExtFieldEntry()) {
            String col = extFieldEntry.getExtField().getNumber();
            String mapped = extFieldEntry.getExtField().getMapped();
            numToFieldMap.put(col, mapped);
            fieldToNumMap.put(mapped, col);
        }
        List fields = numToFieldMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        if (!"1".equals(extendsModel.getEnable())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u7981\u7528\u72b6\u6001\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String message = this.checkExpression(expressions, numToFieldMap);
        boolean isLock = this.checkDataLocked(outline, extendsModel.getId());
        if (isLock) {
            return;
        }
        if (StringUtils.isEmpty((String)message)) {
            HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
            HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
            QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
            try (DataSet extendDataSet = this.getExtendDataSet(extendsModel, outline, qf, dimNumMap, dimQcpMap);){
                LinkedHashMap<String, String> expMap = new LinkedHashMap<String, String>(10);
                for (int i = 0; i < expressions.length; ++i) {
                    for (String key : fields) {
                        expressions[i] = expressions[i].replace(key, (CharSequence)numToFieldMap.get(key));
                    }
                    int index = expressions[i].indexOf("=");
                    expMap.remove(expressions[i].substring(0, index).trim());
                    expMap.put(expressions[i].substring(0, index).trim(), expressions[i].substring(index + 1).trim());
                }
                if (extendDataSet == null || extendDataSet.isEmpty()) {
                    return;
                }
                String[] keys = new String[expMap.size()];
                String[] exps = new String[expMap.size()];
                int index = 0;
                for (Map.Entry entry : expMap.entrySet()) {
                    keys[index] = (String)entry.getKey();
                    exps[index] = (String)entry.getValue();
                    ++index;
                }
                DataSet resultDataSet = extendDataSet.updateFields(keys, exps);
                HashMap<Long, Map> valueMap = new HashMap<Long, Map>(16);
                resultDataSet.forEachRemaining(row -> {
                    HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
                    for (String key : keys) {
                        try {
                            BigDecimal value = row.getBigDecimal(key);
                            map.put(key, value);
                        }
                        catch (Exception e) {
                            logger.error("xRuns:" + Arrays.toString(expressions) + "  ERROR :" + e.getMessage());
                            map.put(key, BigDecimal.ZERO);
                        }
                    }
                    if (!map.isEmpty()) {
                        valueMap.put(row.getLong("id"), map);
                    }
                });
                if (valueMap.size() == 0) {
                    return;
                }
                for (Map values2 : valueMap.values()) {
                    for (Map.Entry entry : values2.entrySet()) {
                        String key = (String)fieldToNumMap.get(entry.getKey());
                        String[] value = (String[])entry.getValue();
                        FieldEntry fieldEntry = extendsModel.getFieldEntryByNumber(key);
                        if (fieldEntry == null || FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
                        ExtField extField = fieldEntry.getExtField();
                        if (!DataTypeEnum.ENUMTP.getOIndex().equals(extField.getDataType())) continue;
                        DynamicObject object = (DynamicObject)ThreadCache.get((Object)("enumitemid-" + extField.getEnumItemId()), () -> QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])new QFilter("id", "=", (Object)extField.getEnumItemId()).toArray()));
                        QFilter idQf = new QFilter("enumitemid", "=", (Object)extField.getEnumItemId());
                        idQf.and(new QFilter("model", "=", (Object)extendsModel.getModelId()));
                        DynamicObjectCollection dyos = (DynamicObjectCollection)ThreadCache.get((Object)("enumvalue|" + MemberReader.findModelNumberById((Object)extendsModel.getModelId()) + "|" + extField.getEnumItemId()), () -> QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,datatype,enumvalue", (QFilter[])idQf.toArray()));
                        List enumValues = dyos.stream().map(str -> str.getString("enumvalue")).collect(Collectors.toList());
                        Optional<String> first = enumValues.stream().filter(arg_0 -> AbstractBizRuleExtFuncService.lambda$xRuns$13((BigDecimal)value, arg_0)).findFirst();
                        if (first.isPresent()) continue;
                        throw new BizRuleException(String.format(ResManager.loadKDString((String)"xRuns\u8ba1\u7b97\u540e\u679a\u4e3e\u5b57\u6bb5%s\u7684\u503c\u4e0d\u5728\u679a\u4e3e\u503c\u8303\u56f4\u4e2d\u3002", (String)"ScriptBuiltinExtHelper_39", (String)"fi-bcm-business", (Object[])new Object[0]), key));
                    }
                }
                String groupType = extendsModel.getExtendsGroupType();
                String extendEntity = ExtendDimGroupType.COMMON.getIndex().equals(groupType) ? "bcm_extenddata" : "bcm_extenddata_bus";
                String prefix = "UPDATE t_" + extendEntity + " SET ";
                StringBuilder sql = new StringBuilder(prefix);
                StringJoiner stringJoiner = new StringJoiner(",");
                for (String key : keys) {
                    stringJoiner.add("f" + key + " = ?");
                }
                sql.append(stringJoiner);
                sql.append("where fid = ?");
                LinkedList paramsList = new LinkedList();
                valueMap.forEach((id, values) -> {
                    Object[] params = new Object[keys.length + 1];
                    for (int i = 0; i < keys.length; ++i) {
                        String key = keys[i];
                        params[i] = values.get(key);
                    }
                    params[keys.length] = id;
                    paramsList.add(params);
                });
                int[] countArray = DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)sql.toString(), paramsList);
                int sum = Arrays.stream(countArray).sum();
                logger.info("xRuns(" + Arrays.toString(expressions) + ") update " + sum + " data");
            }
        } else {
            throw new BizRuleException(message);
        }
    }

    private boolean checkDataLocked(IOutline outline, long extModelId) {
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        String processNum = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PROCESS.getNumber())).p2;
        Long entityId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.ENTITY.getNumber())).p1;
        if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
            entityId = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId).getParent().getId();
        }
        Long scenarioId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.SCENARIO.getNumber())).p1;
        Long yearId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.YEAR.getNumber())).p1;
        Long periodId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.PERIOD.getNumber())).p1;
        Long currencyId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.CURRENCY.getNumber())).p1;
        return ExtDataLockServiceHelper.isLocked((long)modelId, extModelId, entityId, scenarioId, yearId, periodId, currencyId);
    }

    @Override
    public ExtendResultSet getColSumSet(IOutline outline, String number, String dataModelNum, XDMScopeInfo xdmScopeInfo) {
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
        if (extendsModel == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"getColSumSet\u51fd\u6570\u53c2\u6570\u4e2d\u6307\u5b9a\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u65e0\u6548\u3002", (String)"AbstractBizRuleExtFuncService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        FieldEntry fieldEntryByNumber = extendsModel.getFieldEntryByNumber(number);
        if (fieldEntryByNumber.getExtField().getMapped().contains("textext") || fieldEntryByNumber.getExtField().getMapped().contains("dateext")) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u975e\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        return this.getColSumSetResult(outline, number, xdmScopeInfo, extendsModel, null);
    }

    @Override
    public ExtendResultSet getColSumSetResult(IOutline outline, String number, XDMScopeInfo xdmScopeInfo, ExtendsModel extendsModel, QFilter specialFilter) {
        Long modelId;
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
        if (specialFilter != null) {
            qf.and(specialFilter);
        }
        if (ConfigServiceHelper.getBoolParam(modelId = MemberReader.findModelIdByNum((String)outline.getModelNum()), "CM060")) {
            long scenarioId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1;
            long yearId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p1;
            long periodId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1;
            Set<String> invalidNumbers = ICVersionServiceHelper.getInvalidNumbers(new VersionParam(modelId, scenarioId, yearId, periodId));
            if (CollectionUtils.isNotEmpty(invalidNumbers)) {
                qf.and(SysDimensionEnum.InternalCompany.getSign(), NOTIN, invalidNumbers);
            }
        }
        ExtendResultSet extendResultSet = this.getExtendDataModel(extendsModel, outline, qf, dimNumMap, dimQcpMap, "ATTotal");
        List<String> dimSets = this.getDimSetsByXdmId(extendsModel);
        Map<String, List<EDRow>> aftergroupMap = Arrays.stream(extendResultSet.getEdResultSet().getRows()).collect(Collectors.groupingBy(row -> this.getGroupKeyByDims((EDRow)row, dimSets)));
        EDResultSetMetaData extendResultSetMeta = extendResultSet.getEdResultSet().getMetaData();
        EDRow[] rows = new ExtendRow[aftergroupMap.size()];
        int count = 0;
        for (Map.Entry<String, List<EDRow>> entry : aftergroupMap.entrySet()) {
            BigDecimal sum = BigDecimal.ZERO;
            ArrayList<Long> pkIds = new ArrayList<Long>(10);
            ArrayList<String> moneys = new ArrayList<String>(10);
            for (EDRow extendRow : entry.getValue()) {
                List<Object> values = extendRow.getValues();
                BigDecimal value = (BigDecimal)values.get(extendRow.getMetaData().getColIndex(number));
                sum = sum.add(value);
                pkIds.add(extendRow.getPkId());
                moneys.add(value.stripTrailingZeros().toPlainString());
            }
            ExtendRow newExtendRow = new ExtendRow(extendResultSetMeta);
            newExtendRow.setPkIds(pkIds);
            newExtendRow.setMoneys(moneys);
            this.fillNewExtendRow(newExtendRow, sum, entry.getValue(), number, dimSets);
            rows[count] = newExtendRow;
            ++count;
        }
        extendResultSet.getEdResultSet().setRows(rows);
        extendResultSet.setColSumSetNumber(number);
        return extendResultSet;
    }

    private List<String> getDimSetsByXdmId(ExtendsModel extendsModel) {
        ArrayList<String> list = new ArrayList<String>(10);
        List<DimFieldEntry> dimFieldEntry = extendsModel.getDimFieldEntry();
        for (DimFieldEntry fieldEntry : dimFieldEntry) {
            list.add(fieldEntry.getDimension().getNumber());
        }
        list.add(DimTypesEnum.AUDITTRIAL.getNumber());
        list.add(DimTypesEnum.ENTITY.getNumber());
        return list;
    }

    private void fillNewExtendRow(ExtendRow newExtendRow, BigDecimal sum, List<EDRow> extendRowList, String number, List<String> dimSets) {
        if (!extendRowList.isEmpty()) {
            EDRow edRow = extendRowList.get(0);
            List<EDColumn> colMetaDatas = edRow.getMetaData().getColMetaDatas();
            for (EDColumn colMetaData : colMetaDatas) {
                int colIndex = colMetaData.getColIndex();
                String col = colMetaData.getMdName();
                Object value = edRow.getValue(colIndex);
                if (!StringUtils.isNotEmpty((String)col)) continue;
                if (number.equals(col)) {
                    newExtendRow.addValue(sum);
                    continue;
                }
                if (dimSets.contains(col)) {
                    newExtendRow.addValue(value);
                    continue;
                }
                if (value instanceof BigDecimal) {
                    newExtendRow.addValue(BigDecimal.ZERO);
                    continue;
                }
                if (value instanceof Date) {
                    newExtendRow.addValue(null);
                    continue;
                }
                newExtendRow.addValue("");
            }
        }
    }

    @Override
    public void setColValue(IOutline outline, Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap, String datamodelNum, Object value, String colNumber, XDMScopeInfo xdmScopeInfo) {
        EDRow[] rows;
        ScriptMemberExtDimensionNode node = extDimensionNodeMap.get(colNumber);
        if (node == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5b57\u6bb5\u6210\u5458\u3002", (String)"ScriptBuiltinExtHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), colNumber));
        }
        if (!BizRuleUtil.canEditExtData(outline, xdmScopeInfo)) {
            return;
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ExtendResultSet extendResultSet = this.getExtendModel(datamodelNum, outline, xdmScopeInfo, "EntityInput");
        this.checkEnable(extendResultSet);
        if (extendResultSet.getQueryCommand().isNeedSum()) {
            return;
        }
        BizRuleUtil.validCanMergeOrgEditData(outline, extendResultSet.getEdResultSet(), extendResultSet.getQueryCommand());
        List<ExtFieldEntry> extFieldEntry = extendResultSet.getExtendsModel().getExtFieldEntry();
        for (ExtFieldEntry fieldEntry : extFieldEntry) {
            ExtField extField = fieldEntry.getExtField();
            if (extField.getId() != node.getId()) continue;
            if (value == null) break;
            String dataType = extField.getDataType();
            if (DataTypeEnum.ENUMTP.getOIndex().equals(dataType)) {
                if (extField.getEnumItemId() == 0L) continue;
                Object finalValue = value;
                DynamicObject object = (DynamicObject)ThreadCache.get((Object)("enumitemid-" + extField.getEnumItemId()), () -> QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])new QFilter("id", "=", (Object)extField.getEnumItemId()).toArray()));
                QFilter qf = new QFilter("enumitemid", "=", (Object)extField.getEnumItemId());
                qf.and(new QFilter("model", "=", (Object)extendResultSet.getExtendsModel().getModelId()));
                DynamicObjectCollection dyos = (DynamicObjectCollection)ThreadCache.get((Object)("enumvalue|" + outline.getModelNum() + "|" + extField.getEnumItemId()), () -> QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,datatype,enumvalue", (QFilter[])qf.toArray()));
                List enumValues = dyos.stream().map(str -> str.getString("enumvalue")).collect(Collectors.toList());
                if (object.getString("datatype").equals("1") || object.getString("datatype").equals("5") || object.getString("datatype").equals("2")) {
                    Optional<String> first = enumValues.stream().filter(val -> new BigDecimal((String)val).compareTo(new BigDecimal(finalValue.toString())) == 0).findFirst();
                    if (!first.isPresent()) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    value = new BigDecimal(value.toString());
                    continue;
                }
                if (object.getString("datatype").equals("4")) {
                    try {
                        if (value instanceof Date) {
                            Optional<String> optional = enumValues.stream().filter(val -> {
                                try {
                                    return DateUtils.isSameDay((Date)((Date)finalValue), (Date)DateTimeUtils.parseDate((String)val));
                                }
                                catch (ParseException e) {
                                    throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                                }
                            }).findFirst();
                            if (optional.isPresent()) continue;
                            throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                        }
                        if (value instanceof String) {
                            Date tempDate = this.getDateByDateStr((String)value, ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                            Optional<String> optional = enumValues.stream().filter(val -> {
                                try {
                                    return DateUtils.isSameDay((Date)tempDate, (Date)DateTimeUtils.parseDate((String)val));
                                }
                                catch (ParseException e) {
                                    throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                                }
                            }).findFirst();
                            if (!optional.isPresent()) {
                                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                            }
                            value = tempDate;
                            continue;
                        }
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    catch (ParseException e) {
                        throw new KRuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ScriptBuiltinExtHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), value, colNumber));
                    }
                }
                if (enumValues.contains(value.toString()) || value.toString().trim().length() <= 0) continue;
                throw new KRuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ScriptBuiltinExtHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), value, colNumber));
            }
            if (DataTypeEnum.TXT.getOIndex().equals(dataType)) {
                if (value instanceof String) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (DataTypeEnum.DATETP.getOIndex().equals(dataType)) {
                if (value instanceof String) {
                    try {
                        value = this.getDateByDateStr((String)value, ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
                if (value instanceof Date) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (DataTypeEnum.PROPORTION.getOIndex().equals(dataType) && value instanceof String) {
                if (!((String)value).matches("\\d+(\\.\\d+)?%")) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                value = new BigDecimal(((String)value).replace("%", "")).divide(new BigDecimal("100"), 4);
                continue;
            }
            if (!(value instanceof Number)) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            value = new BigDecimal(value.toString());
        }
        this.checkMustInputAndSame(extendResultSet, value, node.getId(), colNumber);
        HashMap<Long, Map<String, Object>> updateValues = new HashMap<Long, Map<String, Object>>(16);
        for (EDRow row : rows = extendResultSet.getEdResultSet().getRows()) {
            int index = row.getMetaData().getColIndex(colNumber);
            if (!updateValues.containsKey(row.getPkId())) {
                HashMap<String, Object> fieldToValueMap = new HashMap<String, Object>(1);
                fieldToValueMap.put(colNumber, value);
                updateValues.put(row.getPkId(), fieldToValueMap);
                continue;
            }
            ((Map)updateValues.get(row.getPkId())).put(colNumber, value);
        }
        extendResultSet.setUpdateValues(updateValues);
        extendResultSet.save();
    }

    private void checkMustInputAndSame(ExtendResultSet extendResultSet, Object newValue, long colId, String colNum) {
        if (newValue == null) {
            ExtendsModel extendsModel = extendResultSet.getExtendsModel();
            List<ExtFieldEntry> fieldEntry = extendsModel.getExtFieldEntry();
            for (ExtFieldEntry extField : fieldEntry) {
                if (extField.getExtField().getId() != colId || !extField.getIsNecessary()) continue;
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptBuiltinExtHelper_51", (String)"fi-bcm-business", (Object[])new Object[0]), colNum));
            }
        }
    }

    protected void checkEnable(ExtendResultSet extendResultSet) {
        ExtendsModel extendsModel = extendResultSet.getExtendsModel();
        if (!"1".equals(extendsModel.getEnable())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u7981\u7528\u72b6\u6001\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    protected void checkEnable(ExtendsModel extendsModel) {
        if (!"1".equals(extendsModel.getEnable())) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u7981\u7528\u72b6\u6001\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u6570\u636e\u3002", (String)"ScriptBuiltinExtHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object checkInsertRowDataType(String extModelNum, long modelId, ExtField extField, Object value) {
        Object newObj = value;
        String dataType = extField.getDataType();
        String fieldNumber = extField.getNumber();
        if (DataTypeEnum.ENUMTP.getOIndex().equals(dataType)) {
            if (extField.getEnumItemId() == 0L) return newObj;
            Object finalValue = value;
            DynamicObject object = (DynamicObject)ThreadCache.get((Object)("enumitemid-" + extField.getEnumItemId()), () -> QueryServiceHelper.queryOne((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])new QFilter("id", "=", (Object)extField.getEnumItemId()).toArray()));
            QFilter qf = new QFilter("enumitemid", "=", (Object)extField.getEnumItemId());
            qf.and(new QFilter("model", "=", (Object)modelId));
            DynamicObjectCollection dyos = (DynamicObjectCollection)ThreadCache.get((Object)("enumvalue|" + MemberReader.findModelNumberById((Object)modelId) + "|" + extField.getEnumItemId()), () -> QueryServiceHelper.query((String)"bcm_enumvalue", (String)"id,datatype,enumvalue", (QFilter[])qf.toArray()));
            List enumValues = dyos.stream().map(str -> str.getString("enumvalue")).collect(Collectors.toList());
            if (object.getString("datatype").equals("1") || object.getString("datatype").equals("5") || object.getString("datatype").equals("2")) {
                Optional<String> first = enumValues.stream().filter(val -> new BigDecimal((String)val).compareTo(new BigDecimal(finalValue.toString())) == 0 || new BigDecimal(finalValue.toString()).equals(BigDecimal.ZERO)).findFirst();
                if (first.isPresent()) return new BigDecimal(value.toString());
                throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
            }
            if (object.getString("datatype").equals("4")) {
                try {
                    if (value instanceof Date) {
                        Optional<String> optional = enumValues.stream().filter(val -> {
                            try {
                                return DateUtils.isSameDay((Date)((Date)finalValue), (Date)DateTimeUtils.parseDate((String)val));
                            }
                            catch (ParseException e) {
                                throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                            }
                        }).findFirst();
                        if (optional.isPresent()) return newObj;
                        throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                    }
                    if (!(value instanceof String)) throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                    Date tempDate = this.getDateByDateStr((String)value, AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                    Optional<String> optional = enumValues.stream().filter(val -> {
                        try {
                            return DateUtils.isSameDay((Date)tempDate, (Date)DateTimeUtils.parseDate((String)val));
                        }
                        catch (ParseException e) {
                            throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                        }
                    }).findFirst();
                    if (optional.isPresent()) return tempDate;
                    throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                }
                catch (ParseException e) {
                    throw new KRuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ScriptBuiltinExtHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), value, extField.getNumber()));
                }
            }
            if (enumValues.contains(value.toString())) return newObj;
            if (value.toString().trim().length() <= 0) return newObj;
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5728%2$s\u7684\u679a\u4e3e\u503c\u5217\u8868\u4e2d\u3002", (String)"ScriptBuiltinExtHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), value, extField.getNumber()));
        }
        if (DataTypeEnum.TXT.getOIndex().equals(dataType)) {
            if (value instanceof String) return newObj;
            throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
        }
        if (DataTypeEnum.DATETP.getOIndex().equals(dataType)) {
            if (value instanceof String) {
                try {
                    return this.getDateByDateStr((String)value, AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                }
                catch (ParseException e) {
                    throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
                }
            }
            if (value instanceof Date) return newObj;
            throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
        }
        if (value instanceof Integer) return newObj;
        if (value instanceof Double) return newObj;
        if (value instanceof BigDecimal) return newObj;
        throw new BizRuleException(AbstractBizRuleExtFuncService.getFieldTypeNotMatchExpStr(extModelNum, value, fieldNumber));
    }

    private static String getFieldTypeNotMatchExpStr(String extModelNum, Object fielValue, String extField) {
        return String.format(ResManager.loadKDString((String)"%1$s\u6a21\u578b\u7684save\u65b9\u6cd5\uff0c\u4fdd\u5b58\u6570\u636e[%2$s]\uff0c\u4e0e\u5b57\u6bb5[%3$s]\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]), extModelNum, fielValue, extField);
    }

    public Date getDateByDateStr(String value, String description) throws ParseException {
        Date tempDate;
        if (ChineseUtil.hasChinese((String)value)) {
            String[] split = value.split("[\u4e00-\u9fa5]");
            if (split.length != 3) {
                throw new BizRuleException(description);
            }
            int year = Integer.parseInt(split[0]);
            int month = Integer.parseInt(split[1]) - 1;
            int day = Integer.parseInt(split[2]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, 0, 0, 0);
            tempDate = calendar.getTime();
        } else if (value.contains("/")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            tempDate = simpleDateFormat.parse(value);
        } else {
            if (value.contains("T")) {
                value = DateTimeUtils.parseUTC((String)value);
            }
            tempDate = DateTimeUtils.parseDate((String)value);
        }
        return tempDate;
    }

    private List<Object> getNewValues(Map<String, Object> valueMap, ExtendResultSet extendResultSet) {
        EDResultSetMetaData metaData = extendResultSet.getEdResultSet().getMetaData();
        LinkedList<Object> values = new LinkedList<Object>();
        List<EDColumn> colMetaDatas = metaData.getColMetaDatas();
        for (EDColumn colMetaData : colMetaDatas) {
            Object value = valueMap.get(colMetaData.getMdName());
            if (value instanceof Number) {
                values.add(new BigDecimal(value.toString()));
                continue;
            }
            values.add(value);
        }
        return values;
    }

    private boolean buildSaveCommand(Map<String, Boolean> uniqueMap, ExtendResultSet extendResultSet, List<Object> values, SaveCommand saveCommand) {
        EDResultSetMetaData metaData = extendResultSet.getEdResultSet().getMetaData();
        QueryCommand queryCommand = extendResultSet.getQueryCommand();
        String[] extSelects = queryCommand.getExtselects();
        String[] dimselects = queryCommand.getDimselects();
        saveCommand.setCols(extSelects);
        saveCommand.setDims(dimselects);
        saveCommand.setFixDim(queryCommand.getFixDims());
        saveCommand.setParentOrg(queryCommand.getParentOrg());
        List<EDColumn> colMetaDatas = metaData.getColMetaDatas();
        StringBuilder tarRow = new StringBuilder();
        for (EDColumn colMetaData : colMetaDatas) {
            Boolean isUnique = uniqueMap.get(colMetaData.getMdName());
            int colIndex = colMetaData.getColIndex();
            Object tarValue = values.get(colIndex);
            if (!isUnique.booleanValue()) continue;
            if (tarValue == null) {
                tarRow.append("null").append("|");
                continue;
            }
            if (tarValue instanceof Number) {
                tarRow.append(((BigDecimal)tarValue).stripTrailingZeros().toPlainString()).append("|");
                continue;
            }
            tarRow.append(StringUtils.isEmpty((String)tarValue.toString()) ? "null" : tarValue.toString()).append("|");
        }
        boolean isUpdate = false;
        if (StringUtils.isEmpty((String)tarRow.toString())) {
            List<String> dimValues = values.subList(0, dimselects.length).stream().map(dim -> dim == null ? null : dim.toString()).collect(Collectors.toList());
            List<Object> extValues = values.subList(dimselects.length, values.size());
            saveCommand.addValue(extValues.toArray(), dimValues.toArray(new String[0]));
        } else {
            EDRow[] rows = extendResultSet.getEdResultSet().getRows();
            HashMap<StringBuilder, EDRow> srcRows = new HashMap<StringBuilder, EDRow>(16);
            for (EDRow row2 : rows) {
                StringBuilder temp = new StringBuilder();
                List<Object> rowValues = row2.getValues();
                for (EDColumn colMetaData : colMetaDatas) {
                    Boolean isUnique = uniqueMap.get(colMetaData.getMdName());
                    int colIndex = colMetaData.getColIndex();
                    Object tarValue = rowValues.get(colIndex);
                    if (!isUnique.booleanValue()) continue;
                    if (tarValue == null) {
                        temp.append("null").append("|");
                        continue;
                    }
                    if (tarValue instanceof Number) {
                        temp.append(((BigDecimal)tarValue).stripTrailingZeros().toPlainString()).append("|");
                        continue;
                    }
                    temp.append(StringUtils.isEmpty((String)tarValue.toString()) ? "null" : tarValue.toString()).append("|");
                }
                srcRows.put(temp, row2);
            }
            Optional<StringBuilder> first = srcRows.keySet().stream().filter(row -> row.toString().contentEquals(tarRow)).findFirst();
            isUpdate = first.isPresent();
            if (isUpdate) {
                EDRow edRow = (EDRow)srcRows.get(first.get());
                LinkedList<Object> finalValues = new LinkedList<Object>();
                List<Object> oldValues = edRow.getValues();
                List<EDColumn> cols = edRow.getMetaData().getColMetaDatas();
                for (EDColumn col : cols) {
                    int colIndex = col.getColIndex();
                    Object oldValue = oldValues.get(colIndex);
                    Object newValue = values.get(colIndex);
                    if (newValue == null) {
                        finalValues.add(oldValue);
                        continue;
                    }
                    finalValues.add(newValue);
                }
                List<String> dimValues = finalValues.subList(0, dimselects.length).stream().map(dim -> dim == null ? null : dim.toString()).collect(Collectors.toList());
                List extValues = finalValues.subList(dimselects.length, finalValues.size());
                saveCommand.putUpdateValues(edRow.getPkId(), extValues.toArray(), dimValues.toArray(new String[0]));
            } else {
                List<String> dimValues = values.subList(0, dimselects.length).stream().map(dim -> dim == null ? null : dim.toString()).collect(Collectors.toList());
                List<Object> extValues = values.subList(dimselects.length, values.size());
                saveCommand.addValue(extValues.toArray(), dimValues.toArray(new String[0]));
            }
        }
        return isUpdate;
    }

    @Override
    public SaveCommand insertRow(IOutline outline, String datamodelNum, SaveCommand oldSaveCommand, String colNumbers, Object[] values) {
        ExtendResultSet extendResultSet = (ExtendResultSet)ThreadCache.get((Object)(outline.getModelNum() + "|" + datamodelNum + "|insertRow"), () -> this.beforeInsertRow(outline, datamodelNum, colNumbers));
        if (values instanceof Object[][]) {
            SaveCommand saveCommand = this.getSaveCommand(outline, colNumbers, (Object[])values[0], extendResultSet, false, oldSaveCommand);
            if (oldSaveCommand == null) {
                oldSaveCommand = saveCommand;
            }
            for (int i = 1; i < values.length; ++i) {
                SaveCommand saveCommand1 = this.getSaveCommand(outline, colNumbers, (Object[])values[i], extendResultSet, false, oldSaveCommand);
                oldSaveCommand.getUpdateValues().putAll(saveCommand1.getUpdateValues());
                oldSaveCommand.getValue().addAll(saveCommand1.getValue());
            }
        } else if (values != null) {
            SaveCommand saveCommand = this.getSaveCommand(outline, colNumbers, values, extendResultSet, false, oldSaveCommand);
            if (oldSaveCommand == null) {
                return saveCommand;
            }
            oldSaveCommand.getUpdateValues().putAll(saveCommand.getUpdateValues());
            oldSaveCommand.getValue().addAll(saveCommand.getValue());
        }
        return oldSaveCommand;
    }

    @Override
    public void copy(IOutline outline, String dataModelNum, String tarATCode, String ctxDimStr, SaveCommand oldSaveCommand) {
        String tarATMembrNumber;
        if (!tarATCode.contains("@")) {
            if (MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)"AuditTrail", (String)tarATCode) == IDNumberTreeNode.NotFoundTreeNode) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684copy\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u6709\u6548\u7684\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u3002", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            tarATMembrNumber = tarATCode;
        } else {
            String[] split = tarATCode.split("@", 2);
            IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)"AuditTrail", (String)split[1]);
            if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684copy\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u6709\u6548\u7684\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u3002", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            tarATMembrNumber = split[1];
        }
        Map<String, String> srcDimMap = BizRuleUtil.parseDimStr(outline.getModelNum(), ctxDimStr);
        HashMap<String, String> ctxDimMap = new HashMap<String, String>(16);
        outline.getComputingContext().getScopeItems().forEach((k, v) -> {
            String cfr_ignored_0 = (String)ctxDimMap.put((String)k, (String)v.p2);
        });
        ctxDimMap.put("AuditTrail", tarATMembrNumber);
        srcDimMap.putIfAbsent("AuditTrail", tarATMembrNumber);
        if (this.isSameDimensions(srcDimMap, ctxDimMap)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684copy\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u6765\u6e90\u6570\u636e\u7684\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u6216\u5ba1\u8ba1\u7ebf\u7d22\uff0c\u4e14\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u6210\u5458\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e00\u81f4\u3002", (String)"ScriptBuiltinExtHelper_48", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList xdmFilters = new ArrayList(10);
        srcDimMap.forEach((k, v) -> {
            ArrayList<String> values = new ArrayList<String>(1);
            values.add((String)v);
            XDMDimensionFilterItem filter = new XDMDimensionFilterItem(k, IN, values);
            xdmFilters.add(filter);
        });
        XDMScopeInfo xdmScopeInfo = new XDMScopeInfo(xdmFilters);
        xdmScopeInfo.setExtendsmodelNumber(dataModelNum);
        ArrayList<XDMDimensionFilterItem> xdmDelFilters = new ArrayList<XDMDimensionFilterItem>(1);
        xdmDelFilters.add(new XDMDimensionFilterItem("AuditTrail", IN, Lists.newArrayList((Object[])new Object[]{tarATMembrNumber})));
        XDMScopeInfo delXdmScopeInfo = new XDMScopeInfo(xdmDelFilters);
        delXdmScopeInfo.setExtendsmodelNumber(dataModelNum);
        ExtendResultSet xdmSet = (ExtendResultSet)this.getXDMSet(new Object[]{xdmScopeInfo}, 1, outline);
        if (xdmSet.getEdResultSet().getRows().length < 1) {
            this.delRows(outline, dataModelNum, delXdmScopeInfo, true);
            return;
        }
        String colNumbers = this.buildColNumbersStr(xdmSet, outline.getComputingContext().getScopeItems().keySet());
        Object[][] params = this.buildInsertRowParam(xdmSet, outline.getComputingContext().getScopeItems().keySet(), tarATMembrNumber);
        Pair<List<Long>, SaveCommand> delParms = this.delRows(outline, dataModelNum, delXdmScopeInfo, false);
        if (delParms != null) {
            SaveCommand saveCommand = this.insertRow(outline, dataModelNum, oldSaveCommand, colNumbers, (Object[])params);
            if (saveCommand == null) {
                return;
            }
            this.overwrite(outline, delParms, saveCommand);
        }
    }

    private String buildColNumbersStr(ExtendResultSet xdmSet, Set<String> dimKeys) {
        EDRow[] rows = xdmSet.getEdResultSet().getRows();
        if (rows == null || rows.length < 1) {
            return "";
        }
        return rows[0].getMetaData().getColMetaDatas().stream().map(EDColumn::getMdName).filter(mdName -> !dimKeys.contains(mdName)).collect(Collectors.joining(","));
    }

    private Object[][] buildInsertRowParam(ExtendResultSet xdmSet, Set<String> dimKeys, String tarAT) {
        EDRow[] rows = xdmSet.getEdResultSet().getRows();
        ArrayList<Object[]> params = new ArrayList<Object[]>(rows.length);
        HashSet<Integer> indexSet = new HashSet<Integer>(10);
        int ATIndex = -1;
        int index = 0;
        for (EDColumn c : rows[0].getMetaData().getColMetaDatas()) {
            if (dimKeys.contains(c.getMdName())) {
                indexSet.add(index);
            }
            if (c.getMdName().equals("AuditTrail")) {
                ATIndex = index;
            }
            ++index;
        }
        for (EDRow row : rows) {
            List<Object> values = row.getValues();
            ArrayList<Object> filterValues = new ArrayList<Object>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                if (indexSet.contains(i)) continue;
                if (i == ATIndex) {
                    filterValues.add(tarAT);
                    continue;
                }
                filterValues.add(values.get(i));
            }
            params.add(filterValues.toArray());
        }
        return (Object[][])params.toArray((T[])new Object[0][]);
    }

    private boolean isSameDimensions(Map<String, String> srcDimMap, Map<String, String> ctxDimMap) {
        for (Map.Entry<String, String> entry : srcDimMap.entrySet()) {
            if (ctxDimMap.containsKey(entry.getKey()) && ctxDimMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private void overwrite(IOutline outline, Pair<List<Long>, SaveCommand> delParms, SaveCommand saveCommand) {
        ExtDataServiceHelper.overwrite(outline, delParms, saveCommand);
    }

    @Override
    public void save(IOutline outline, SaveCommand saveCommand) {
        BizRuleUtil.validCanMergeOrgEditData(outline, saveCommand);
        ExtDataServiceHelper.saveData(saveCommand);
    }

    @Override
    public void save(IOutline outline, List<InvEDSaveComInfo> saveCommand) {
    }

    @Override
    public void batchInsertRows(IOutline outline, String datamodelNum, long datamodelId, long extGroupId, String colNumbers, Object[] values, int count) {
        ExtendResultSet extendResultSet = this.beforeInsertRow(outline, datamodelNum, colNumbers);
        SaveCommand saveCommand = this.getSaveCommand(outline, colNumbers, values, extendResultSet, true);
        List<Object[]> value = saveCommand.getValue();
        if (!value.isEmpty()) {
            Object[] one = value.get(0);
            for (int i = 0; i < count; ++i) {
                value.add(one);
            }
        }
        ExtDataServiceHelper.saveData(saveCommand);
    }

    private SaveCommand getSaveCommand(IOutline outline, String colNumbers, Object[] values, ExtendResultSet extendResultSet, boolean isBatch, SaveCommand oldSaveCommand) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
        ExtendsModel extendsModel = extendResultSet.getExtendsModel();
        String[] split = colNumbers.split(",");
        if (split.length != values.length) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u6a21\u578b\u7684insertRow\u65b9\u6cd5\u4e2d\u5b9a\u4e49\u7684\u6570\u636e\u4e2a\u6570\u4e0e\u5b57\u6bb5\u4e2a\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ScriptBuiltinExtHelper_25", (String)"fi-bcm-business", (Object[])new Object[0]), extendResultSet.getExtendsModel().getNumber()));
        }
        Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum());
        for (int i = 0; i < split.length; ++i) {
            Object dimNumber = split[i].trim();
            Object dimValue = values[i];
            if (shortNums.containsKey(dimNumber)) {
                dimNumber = (String)shortNums.get(dimNumber);
            }
            if (shortNums.containsValue(dimNumber)) {
                valueMap.put((String)dimNumber, dimValue);
                if (dimValue == null) continue;
                if (!(dimValue instanceof String)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u683c\u5f0f\u9519\u8bef\u3002", (String)"ScriptBuiltinExtHelper_26", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                IDNumberTreeNode member = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)dimNumber, (String)dimValue.toString());
                if (member == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"ScriptBuiltinExtHelper_27", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                if (!member.getDimNumber().equals(SysDimensionEnum.AuditTrail.getNumber()) || member.getStorageType() != StorageTypeEnum.LABEL && member.getStorageType() != StorageTypeEnum.DYNAMIC) continue;
                return new SaveCommand(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
            }
            valueMap.put((String)dimNumber, dimValue);
        }
        Set contextDims = outline.getComputingContext().getScopeItems().keySet();
        for (String dimKey : valueMap.keySet()) {
            if (!contextDims.contains(dimKey) || this.isEntityDimAndIntrOnly(dimKey)) continue;
            throw new BizRuleException(ResManager.loadKDString((String)"insertRow(colCodes,valueArr)\u4e0d\u80fd\u6307\u5b9a\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_28", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        HashMap<String, Boolean> uniqueMap = new HashMap<String, Boolean>(16);
        List<FieldEntry> fieldEntry = extendsModel.getFieldEntry();
        valueMap.forEach((field, value) -> {
            Optional<FieldEntry> optional = fieldEntry.stream().filter(entry -> entry.getNumber().equals(field)).findFirst();
            if (!(optional.isPresent() || field.equals(DimTypesEnum.AUDITTRIAL.getNumber()) || this.isEntityDimAndIntrOnly((String)field))) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u6216\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_37", (String)"fi-bcm-computing", (Object[])new Object[0]), field));
            }
        });
        for (FieldEntry entry : fieldEntry) {
            if (entry.getIsNecessary() && valueMap.get(entry.getNumber()) == null) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u6a21\u578b\u7684insertRow\u65b9\u6cd5\u4e2d\u6307\u5b9a\u7684\u5b57\u6bb5\u7f3a\u5931\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_29", (String)"fi-bcm-business", (Object[])new Object[0]), extendResultSet.getExtendsModel().getNumber()));
            }
            if (valueMap.containsKey(entry.getNumber())) {
                Object value2 = valueMap.get(entry.getNumber());
                if (entry.getFieldType() == FieldTypeEnum.EXT_FIELD.getType() && value2 != null) {
                    Object newValue = this.checkInsertRowDataType(extendsModel.getNumber(), extendsModel.getModelId(), entry.getExtField(), value2);
                    valueMap.put(entry.getNumber(), newValue);
                }
            }
            uniqueMap.put(entry.getNumber(), entry.getUniqueCheck());
        }
        boolean think = uniqueMap.containsValue(Boolean.TRUE);
        uniqueMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), think);
        uniqueMap.put(DimTypesEnum.ENTITY.getNumber(), think);
        valueMap.putIfAbsent(DimTypesEnum.AUDITTRIAL.getNumber(), "EntityInput");
        String entity = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)DimTypesEnum.ENTITY.getNumber())).p2;
        valueMap.putIfAbsent(DimTypesEnum.ENTITY.getNumber(), entity.contains("_") ? entity.split("_")[1] : entity);
        if (isBatch) {
            for (Boolean isUnique : uniqueMap.values()) {
                if (!isUnique.booleanValue()) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"batchInsertRows(count ,colCodes,valueArr)\u4e0d\u80fd\u6709\u552f\u4e00\u6027\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_30", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
        }
        SaveCommand saveCommand = new SaveCommand(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        if (this.isIntrOnlyExectype()) {
            saveCommand.setBizRule2InTrade(true);
            saveCommand.setKeepEntity(true);
            saveCommand.setPaperTemplateId((Long)outline.getBuiltin().getArgs().get("paperTemplateId"));
        }
        List<Object> newRowValues = this.getNewValues(valueMap, extendResultSet);
        boolean isUpdate = this.buildSaveCommand(uniqueMap, extendResultSet, newRowValues, saveCommand);
        if (oldSaveCommand != null && !isUpdate) {
            this.doubleCheckUnique(oldSaveCommand, uniqueMap, saveCommand);
        }
        return saveCommand;
    }

    private void doubleCheckUnique(SaveCommand oldSaveCommand, Map<String, Boolean> uniqueMap, SaveCommand saveCommand) {
        int i;
        String[] commandCols = oldSaveCommand.getCols();
        String[] commandDims = oldSaveCommand.getDims();
        ArrayList<Integer> uniqueIndex = new ArrayList<Integer>();
        for (i = 0; i < commandCols.length; ++i) {
            String commandCol = commandCols[i];
            if (!Boolean.TRUE.equals(uniqueMap.get(commandCol))) continue;
            uniqueIndex.add(i);
        }
        for (i = 0; i < commandDims.length; ++i) {
            String commandDim = commandDims[i];
            if (!Boolean.TRUE.equals(uniqueMap.get(commandDim))) continue;
            uniqueIndex.add(i + commandCols.length);
        }
        if (CollectionUtils.isEmpty(uniqueIndex)) {
            return;
        }
        HashSet uniqueRowValue = new HashSet();
        saveCommand.getValue().forEach(row -> {
            if (((Object[])row).length >= commandCols.length + commandDims.length) {
                StringJoiner stringJoiner = new StringJoiner("|");
                uniqueIndex.forEach(index -> stringJoiner.add(String.valueOf(row[index])));
                uniqueRowValue.add(stringJoiner.toString());
            }
        });
        Iterator<Object[]> iterator = oldSaveCommand.getValue().iterator();
        while (iterator.hasNext()) {
            Object[] cols = iterator.next();
            if (cols.length < commandCols.length + commandDims.length) continue;
            StringJoiner stringJoiner = new StringJoiner("|");
            uniqueIndex.forEach(index -> stringJoiner.add(String.valueOf(cols[index])));
            if (!uniqueRowValue.contains(stringJoiner.toString())) continue;
            iterator.remove();
        }
    }

    private SaveCommand getSaveCommand(IOutline outline, String colNumbers, Object[] values, ExtendResultSet extendResultSet, boolean isBatch) {
        return this.getSaveCommand(outline, colNumbers, values, extendResultSet, isBatch, null);
    }

    private ExtendResultSet beforeInsertRow(IOutline outline, String dataModelNum, String colNumbers) {
        if (StringUtils.isEmpty((String)colNumbers)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptBuiltinExtHelper_31", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (ExpCommonValidateUtil.isContainChinese((String)colNumbers)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d\u5305\u542b\u4e2d\u6587\u5b57\u7b26\u3002", (String)"ScriptBuiltinExtHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ExtendResultSet extendResultSet = this.getExtendModel(dataModelNum, outline, new XDMScopeInfo(), "ATTotal");
        this.checkEnable(extendResultSet);
        return extendResultSet;
    }

    @Override
    public void delRows(IOutline outline, String datamodelNum, XDMScopeInfo xdmScopeInfo) {
        if (xdmScopeInfo != null && BizRuleUtil.canEditExtData(outline, xdmScopeInfo)) {
            this.delRows(outline, datamodelNum, xdmScopeInfo, true);
        }
    }

    private Pair<List<Long>, SaveCommand> delRows(IOutline outline, String datamodelNum, XDMScopeInfo xdmScopeInfo, boolean isRealTime) {
        if (xdmScopeInfo == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6a21\u578b\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptBuiltinExtHelper_32", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (BizRuleUtil.canEditExtData(outline, xdmScopeInfo)) {
            Set outLineDims = outline.getComputingContext().getScopeItems().keySet();
            for (XDMDimensionFilterItem xdmFilter : xdmScopeInfo.getXdmFilters()) {
                if (!outLineDims.contains(xdmFilter.getName())) continue;
                throw new BizRuleException(ResManager.loadKDString((String)"\u4e0d\u80fddelRows\u51fd\u6570\u4e2d\u6307\u5b9a\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7684\u6210\u5458\u8303\u56f4\u3002", (String)"ScriptBuiltinExtHelper_33", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ExtendResultSet extendResultSet = this.getExtendModel(datamodelNum, outline, xdmScopeInfo, "ATTotal");
            this.checkEnable(extendResultSet);
            if (extendResultSet.getQueryCommand().isNeedSum()) {
                return null;
            }
            String entity = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p2;
            String ctxEntity = entity.contains("_") ? entity.split("_", 2)[1] : entity;
            List<Long> deleteIds = this.isIntrOnlyExectype() ? Arrays.stream(extendResultSet.getEdResultSet().getRows()).map(EDRow::getPkId).collect(Collectors.toList()) : Arrays.stream(extendResultSet.getEdResultSet().getRows()).filter(row -> ctxEntity.equals(row.getOriginalValue(PresetConstant.ENTITY_DIM))).map(EDRow::getPkId).collect(Collectors.toList());
            QueryCommand queryCommand = extendResultSet.getQueryCommand();
            SaveCommand clearCommand = null;
            if (CollectionUtils.isNotEmpty(deleteIds)) {
                clearCommand = new SaveCommand(queryCommand.getShowNumber(), queryCommand.getExtGroup(), queryCommand.getDatamodel());
                clearCommand.setFixDim(queryCommand.getFixDims());
                clearCommand.setParentOrg(queryCommand.getParentOrg());
                clearCommand.setDims(queryCommand.getDimselects());
                clearCommand.setCols(queryCommand.getExtselects());
            }
            if (isRealTime && clearCommand != null) {
                ExtendService.deleteDataBySaveInfo(deleteIds, clearCommand);
            }
            return Pair.onePair(deleteIds, clearCommand);
        }
        return null;
    }

    @Override
    public BigDecimal getColSum(IOutline outline, String number, String dataModelNum, XDMScopeInfo xdmScopeInfo) {
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        if (extendsModel == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"getColSum\u51fd\u6570\u53c2\u6570\u4e2d\u6307\u5b9a\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u65e0\u6548\u3002", (String)"AbstractBizRuleExtFuncService_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
        ExtField extField = extendsModel.getFieldEntryByNumber(number).getExtField();
        if (!extField.getMapped().contains("numext")) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u975e\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u83b7\u53d6\u5408\u8ba1\u6570\u3002", (String)"ScriptBuiltinExtHelper_34", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        Map<String, Set<String>> bigMembersInData = this.getBigMembersInData(xdmScopeInfo);
        if (!bigMembersInData.isEmpty()) {
            xdmScopeInfo.getXdmFilters().removeIf(filter -> bigMembersInData.containsKey(filter.getName()));
        }
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
        ExtendResultSet extendResultSet = this.getExtendDataModel(extendsModel, outline, qf, dimNumMap, dimQcpMap, "ATTotal");
        return this.getSumResult(outline, number, bigMembersInData, extendResultSet);
    }

    private BigDecimal getSumResult(IOutline outline, String number, Map<String, Set<String>> bigMembersInData, ExtendResultSet extendResultSet) {
        BigDecimal sum = BigDecimal.ZERO;
        EDResultSetMetaData metaData = extendResultSet.getEdResultSet().getMetaData();
        block0: for (EDRow row : extendResultSet.getEdResultSet().getRows()) {
            List<Object> values = row.getValues();
            for (Map.Entry<String, Set<String>> entry : bigMembersInData.entrySet()) {
                String key = entry.getKey();
                Set<String> valueSet = entry.getValue();
                int colIndex = metaData.getColIndex(key);
                if (colIndex < 0 || valueSet.contains(values.get(colIndex).toString())) continue;
                continue block0;
            }
            sum = sum.add((BigDecimal)values.get(metaData.getColIndex(number)));
        }
        return sum;
    }

    public BigDecimal getColSum(String cube, String dataModel, String fieldNumber, Map<String, Pair<Long, String>> params, Map<String, String> dimScope, List<String> extScope) {
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModel, cube);
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((String)cube, (Long)((Long)params.get((Object)SysDimensionEnum.Entity.getNumber()).p1));
        String cacheKey = new StringJoiner("|").add(cube).add(dataModel).add(entityNode.getParent().getNumber()).add(entityNode.getNumber()).add((CharSequence)params.get((Object)SysDimensionEnum.Scenario.getNumber()).p2).add((CharSequence)params.get((Object)SysDimensionEnum.Year.getNumber()).p2).add((CharSequence)params.get((Object)SysDimensionEnum.Period.getNumber()).p2).add((CharSequence)params.get((Object)SysDimensionEnum.Currency.getNumber()).p2).add((CharSequence)params.get((Object)SysDimensionEnum.Process.getNumber()).p2).toString();
        Map cacheMap = (Map)ThreadCache.get((Object)cacheKey, HashMap::new);
        ExtendResultSet extendResultSet = this.getSameExtScopeResult(cacheMap, extScope);
        Map<String, Set<String>> dimValuesMap = this.getDimValuesMap(cube, MemberReader.findModelIdByNum((String)cube), dimScope);
        IOutline outline = this.transferToOutline(cube, params);
        if (extendResultSet == null || CollectionUtils.isNotEmpty(extScope)) {
            XDMScopeInfo xdmScopeInfo;
            Set extendsNumbers = extendsModel.getExtFieldEntry().stream().map(ext -> ext.getExtField().getNumber()).collect(Collectors.toSet());
            ArrayList<XDMScopeInfo> inScopeInfos = new ArrayList<XDMScopeInfo>();
            ArrayList<XDMScopeInfo> notInScopeInfos = new ArrayList<XDMScopeInfo>();
            for (String scopeStr : extScope) {
                String[] split = scopeStr.split("@@");
                if (split.length == 3) {
                    this.getCondition(split[0], split[1], split[2], inScopeInfos, notInScopeInfos, extendsModel);
                    continue;
                }
                this.getCondition(split[0], split[1], null, inScopeInfos, notInScopeInfos, extendsModel);
            }
            if (params.get(SysDimensionEnum.AuditTrail.getNumber()) != null) {
                this.getCondition(SysDimensionEnum.AuditTrail.getNumber(), "1", (String)params.get((Object)SysDimensionEnum.AuditTrail.getNumber()).p2, inScopeInfos, notInScopeInfos, extendsModel);
            }
            XDMScopeInfo finalXdmScopeInfo = xdmScopeInfo = new XDMScopeInfo();
            inScopeInfos.forEach(in -> finalXdmScopeInfo.XDMScope(extendsModel.getNumber(), extendsNumbers, new Object[]{in}));
            for (XDMScopeInfo no : notInScopeInfos) {
                xdmScopeInfo = (XDMScopeInfo)xdmScopeInfo.except(new Object[]{no});
            }
            AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
            HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
            HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
            QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
            extendResultSet = this.getExtendDataModel(extendsModel, outline, qf, dimNumMap, dimQcpMap, "ATTotal");
            cacheMap.put(extScope, extendResultSet);
        }
        return this.getSumResult(outline, fieldNumber, dimValuesMap, extendResultSet);
    }

    private Map<String, Set<String>> getDimValuesMap(String cube, Long modelId, Map<String, String> dimScope) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : dimScope.entrySet()) {
            Set<Object> numbers = new HashSet();
            List scopes = (List)SerializationUtils.fromJsonString((String)entry.getValue(), List.class);
            for (Map scope : scopes) {
                String id = (String)scope.get("id");
                String number = (String)scope.get("number");
                String value = (String)scope.get("scope");
                String entityNumber = MemberReader.getEntityNumberByDim((String)cube, (String)entry.getKey());
                IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)cube, (String)entry.getKey(), (String)number);
                if (SysDimensionEnum.InternalCompany.getNumber().equals(entry.getKey())) {
                    numbers = new MembRangeItem(entityNumber, memberNode.getId(), number, Integer.parseInt(value), false, (Object)modelId).matchItem4UnmodifiableSet();
                    continue;
                }
                HashSet temp = new HashSet();
                new MembRangeItem(entityNumber, memberNode.getId(), number, Integer.parseInt(value), false, (Object)modelId).matchItems(item -> temp.add(item.getNumber()));
                numbers = temp;
            }
            if (numbers.isEmpty()) continue;
            res.put(entry.getKey(), numbers);
        }
        return res;
    }

    private IOutline transferToOutline(String cube, Map<String, Pair<Long, String>> params) {
        OlapConnection olapConnection = RuleExecuteServiceHelper.getOlapConnection((String)cube);
        Outline outline = new Outline(olapConnection);
        BizRuleExecParam bizRuleExecParam = new BizRuleExecParam(cube);
        params.forEach((k, v) -> bizRuleExecParam.addCommonParamPair(k, v));
        outline.setComputingContext(new ComputingContext(olapConnection, (IOutline)outline, bizRuleExecParam.getCommonParam()));
        return outline;
    }

    private void getCondition(String item, String code, String value, List<XDMScopeInfo> inScopeInfos, List<XDMScopeInfo> notInScopeInfos, ExtendsModel extendsModel) {
        XDMDimensionFilterItem filterItem = new XDMDimensionFilterItem();
        filterItem.setName(item);
        switch (code) {
            case "1": {
                filterItem.setCondition(IN);
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "2": {
                filterItem.setCondition(IN);
                notInScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "3": {
                filterItem.setCondition(LIKE);
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "4": {
                filterItem.setCondition(LIKE);
                notInScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "5": {
                filterItem.setCondition(">");
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "6": {
                filterItem.setCondition("<");
                notInScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "7": {
                filterItem.setCondition("<");
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "8": {
                filterItem.setCondition(">");
                notInScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "9": {
                filterItem.setCondition("is null");
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
            case "10": {
                filterItem.setCondition("is not null");
                inScopeInfos.add(new XDMScopeInfo(Collections.singletonList(filterItem)));
                break;
            }
        }
        if (extendsModel.getFieldEntryByNumber(item) != null && extendsModel.getFieldEntryByNumber(item).getFieldType() == FieldTypeEnum.EXT_FIELD.getType()) {
            ExtField extField = extendsModel.getFieldEntryByNumber(item).getExtField();
            Object valueByType = this.getValueByType(extendsModel, item, value, code);
            if (valueByType instanceof List) {
                filterItem.setValues((List)valueByType);
            } else if (valueByType != null) {
                filterItem.setValues(Collections.singletonList(valueByType));
            }
        } else if (value != null) {
            filterItem.setValues(Collections.singletonList(value));
        }
    }

    private Object getValueByType(ExtendsModel extendsModel, String field, String value, String code) {
        Object res;
        block13: {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            boolean multiValue = value.contains(",");
            if (extendsModel.getFieldEntryByNumber(field).getExtField().getMapped().contains("dateext")) {
                try {
                    if (multiValue) {
                        String[] splits = value.split(",");
                        res = Arrays.stream(splits).map(s -> {
                            try {
                                return DateTimeUtils.parseDate((String)s);
                            }
                            catch (ParseException e) {
                                return null;
                            }
                        }).collect(Collectors.toList());
                        break block13;
                    }
                    res = DateTimeUtils.parseDate((String)value);
                }
                catch (ParseException e) {
                    res = value;
                }
            } else if (extendsModel.getFieldEntryByNumber(field).getExtField().getMapped().contains("numext")) {
                if (multiValue) {
                    String[] splits = value.split(",");
                    res = Arrays.stream(splits).map(BigDecimal::new).collect(Collectors.toList());
                } else {
                    res = new BigDecimal(value);
                }
            } else if (multiValue) {
                String[] splits = value.split(",");
                res = Arrays.asList(splits);
            } else {
                if ((ParamConstant.MethodEnum.LIKE.getCode().equals(code) || ParamConstant.MethodEnum.NOT_LIKE.getCode().equals(code)) && !value.contains("%")) {
                    value = "%" + value + "%";
                }
                res = value;
            }
        }
        return res;
    }

    private ExtendResultSet getSameExtScopeResult(Map<List<String>, ExtendResultSet> resultSetMap, List<String> extScope) {
        for (Map.Entry<List<String>, ExtendResultSet> entry : resultSetMap.entrySet()) {
            List<String> src = entry.getKey();
            if (!this.isSameExtScope(src, extScope)) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean isSameExtScope(List<String> src, List<String> extScope) {
        if (src.size() == extScope.size()) {
            for (String conditionStr : src) {
                Optional<String> first = extScope.stream().filter(scope -> scope.equals(conditionStr)).findFirst();
                if (first.isPresent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Object[] getColValue(IOutline outline, long id, String number, String datamodelNum, XDMScopeInfo xdmScopeInfo) {
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        ExtendsModel extendsModel = ExtendService.existExtendModel(datamodelNum, outline.getModelNum());
        if (extendsModel == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"getColValue\u51fd\u6570\u53c2\u6570\u4e2d\u6307\u5b9a\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801\u65e0\u6548\u3002", (String)"AbstractBizRuleExtFuncService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        AbstractBizRuleExtFuncService.checkValidXDMScopeInfo(extendsModel, xdmScopeInfo);
        if (BizRuleUtil.isXDMScopeMultiDim(xdmScopeInfo)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u89c4\u5219\u80cc\u666f\u7ef4\u5ea6\u4e0d\u80fd\u6709\u591a\u4e2a\u3002", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFilter qf = this.addXdmScopeFilter(extendsModel, xdmScopeInfo, outline, dimNumMap, dimQcpMap);
        ExtendResultSet extendResultSet = this.getExtendDataModel(extendsModel, outline, qf, dimNumMap, dimQcpMap, "ATTotal");
        Object[] results = new Object[extendResultSet.getEdResultSet().getRows().length];
        int count = 0;
        EDResultSetMetaData metaData = extendResultSet.getEdResultSet().getMetaData();
        for (EDRow row : extendResultSet.getEdResultSet().getRows()) {
            List<Object> values = row.getValues();
            results[count] = values.get(metaData.getColIndex(number));
            if (values.get(metaData.getColIndex(number)) instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                results[count] = dateFormat.format((Date)results[count]);
            }
            ++count;
        }
        return results;
    }

    @Override
    public WhenFilterItem when(IOutline outline, Object[] args) {
        WhenFilterItem whenFilterItem = new WhenFilterItem();
        Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum());
        for (Object arg : args) {
            String[] splits;
            if (arg == null || arg.toString().isEmpty()) continue;
            String str = arg.toString();
            if (str.contains(",")) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u6216\u5b57\u6bb5\u7f16\u7801", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-computing", (Object[])new Object[0])));
            }
            if (WHEN_SPECIAL_PATTERN.matcher(str).find()) {
                splits = str.split("=");
                String left = splits[0];
                String right = splits[1];
                String[] lefts = left.split("\\.");
                String[] rights = right.split("\\.");
                SpecialFilterItem specialFilterItem = "s".equals(lefts[0]) ? new SpecialFilterItem(shortNums.getOrDefault(lefts[1].trim(), lefts[1]).trim(), shortNums.getOrDefault(rights[1].trim(), rights[1].trim())) : new SpecialFilterItem(shortNums.getOrDefault(rights[1].trim(), rights[1]).trim(), shortNums.getOrDefault(lefts[1].trim(), lefts[1].trim()));
                whenFilterItem.addSpecial(specialFilterItem);
                continue;
            }
            if (WHEN_EQUAL_PATTERN.matcher(str).find()) {
                splits = str.split("=");
                String col = splits[0].split("\\.")[1].trim();
                NormalFilterItem normalFilterItem = new NormalFilterItem(shortNums.getOrDefault(col, col), "=");
                String value = splits[1].trim();
                if (value.contains("'")) {
                    value = value.replaceAll("'", "");
                }
                normalFilterItem.setValue(value);
                whenFilterItem.addNormal(normalFilterItem);
                continue;
            }
            if (WHEN_IN_PATTERN.matcher(str).find()) {
                splits = str.split("\\.");
                NormalFilterItem normalFilterItem = new NormalFilterItem(shortNums.getOrDefault(splits[1].trim(), splits[1].trim()), IN);
                String valueStr = splits[2].substring(splits[2].indexOf("(") + 1, splits[2].indexOf(")"));
                for (String val : valueStr.split(",")) {
                    String value = val.trim();
                    if (value.contains("'")) {
                        value = value.replaceAll("'", "");
                    }
                    normalFilterItem.addValue(val.trim());
                }
                whenFilterItem.addNormal(normalFilterItem);
                continue;
            }
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u6216\u5b57\u6bb5\u7f16\u7801", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        return whenFilterItem;
    }

    @Override
    public void xCopy(IOutline outline, Object[] args) {
        String srcColStr;
        ExtendsModel srcExtendModel;
        String srcCode;
        IDNumberTreeNode node;
        String atCode;
        if (args.length < 5) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"xCopy", 5});
        }
        String string = atCode = args[0] == null ? "" : args[0].toString();
        if (atCode.contains("@")) {
            atCode = atCode.split("@", 2)[1];
        }
        if ((node = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)atCode)) == IDNumberTreeNode.NotFoundTreeNode || node.getStorageType() != StorageTypeEnum.STORAGE) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22", (String)"ScriptBuiltinExtHelper_48", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        String tarCode = args[1] == null ? "" : args[1].toString();
        ExtendsModel tarExtendModel = ExtendService.existExtendModel(tarCode, outline.getModelNum());
        if (tarExtendModel == null || !"1".equals(tarExtendModel.getEnable())) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ScriptBuiltinExtHelper_49", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        if (ExtendDimGroupType.getEnumByIndex((String)tarExtendModel.getExtendsGroupType()) == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u975e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b", (String)"ScriptMemberExtDimensionNode_26", (String)"fi-bcm-computing", (Object[])new Object[0]), "getXDMSet"));
        }
        String tarColStr = args[2] == null ? "" : args[2].toString();
        ArrayList<String> tarCols = new ArrayList<String>(Arrays.asList(tarColStr.split(",")));
        tarCols.stream().filter(col -> tarExtendModel.getFieldEntryByNumber((String)col) == null).findFirst().ifPresent(col -> {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u76ee\u6807\u62d3\u5c55\u5b57\u6bb5\uff0c\u6216\u672a\u5305\u542b\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u552f\u4e00\u6027\u5b57\u6bb5", (String)"ScriptBuiltinExtHelper_50", (String)"fi-bcm-computing", (Object[])new Object[0])));
        });
        List tarUniqueCols = tarExtendModel.getFieldEntry().stream().filter(FieldEntry::getUniqueCheck).map(DynaEntityObject::getNumber).collect(Collectors.toList());
        tarUniqueCols.removeAll(tarCols);
        if (tarUniqueCols.size() > 0) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u76ee\u6807\u62d3\u5c55\u5b57\u6bb5\uff0c\u6216\u672a\u5305\u542b\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u6240\u6709\u552f\u4e00\u6027\u5b57\u6bb5", (String)"ScriptBuiltinExtHelper_50", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        String string2 = srcCode = args[3] == null ? "" : args[3].toString();
        if (srcCode.trim().length() == 0) {
            srcCode = tarCode;
        }
        if ((srcExtendModel = ExtendService.existExtendModel(srcCode, outline.getModelNum())) == null || !"1".equals(srcExtendModel.getEnable())) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"ScriptBuiltinExtHelper_51", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        if (ExtendDimGroupType.getEnumByIndex((String)srcExtendModel.getExtendsGroupType()) == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u975e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b", (String)"ScriptMemberExtDimensionNode_26", (String)"fi-bcm-computing", (Object[])new Object[0]), "xCopy"));
        }
        String string3 = srcColStr = args[4] == null ? "" : args[4].toString();
        if (srcColStr.trim().length() == 0) {
            srcColStr = tarColStr;
        }
        ArrayList<String> srcCols = new ArrayList<String>(Arrays.asList(srcColStr.split(",")));
        srcCols.stream().filter(col -> srcExtendModel.getFieldEntryByNumber((String)col) == null).findFirst().ifPresent(col -> {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6765\u6e90\u62d3\u5c55\u5b57\u6bb5", (String)"ScriptBuiltinExtHelper_52", (String)"fi-bcm-computing", (Object[])new Object[0])));
        });
        if (srcCols.size() != tarCols.size()) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u62d3\u5c55\u5b57\u6bb5\u6570\u91cf\u4e0d\u4e00\u81f4", (String)"ScriptBuiltinExtHelper_56", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        IntStream.range(0, srcCols.size()).forEach(ind -> {
            FieldEntry srcFieldEntry = srcExtendModel.getFieldEntryByNumber((String)srcCols.get(ind));
            FieldEntry tarFieldEntry = tarExtendModel.getFieldEntryByNumber((String)tarCols.get(ind));
            if (FieldTypeEnum.EXT_FIELD.getType() == srcFieldEntry.getFieldType() && FieldTypeEnum.EXT_FIELD.getType() == tarFieldEntry.getFieldType()) {
                String srcMapped = srcFieldEntry.getExtField().getMapped();
                String tarMapped = tarFieldEntry.getExtField().getMapped();
                if (srcMapped.contains("dateext") && !tarMapped.contains("dateext") || srcMapped.contains("numext") && !tarMapped.contains("numext") || srcMapped.contains("textext") && !tarMapped.contains("textext")) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u62d3\u5c55\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)"ScriptBuiltinExtHelper_57", (String)"fi-bcm-computing", (Object[])new Object[0])));
                }
            }
        });
        ArrayList<WhenFilterItem> filterItems = new ArrayList<WhenFilterItem>(10);
        if (args.length == 5) {
            WhenFilterItem whenFilterItem = new WhenFilterItem();
            NormalFilterItem filterItem = new NormalFilterItem(SysDimensionEnum.AuditTrail.getNumber(), "=");
            filterItem.setValue(atCode);
            whenFilterItem.addNormal(filterItem);
            filterItems.add(whenFilterItem);
        }
        for (int i = 5; i < args.length; ++i) {
            if (!(args[i] instanceof WhenFilterItem)) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u6216\u5b57\u6bb5\u7f16\u7801", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-computing", (Object[])new Object[0])));
            }
            WhenFilterItem whenFilterItem = (WhenFilterItem)args[i];
            Optional<NormalFilterItem> first = whenFilterItem.getNormals().stream().filter(normal -> SysDimensionEnum.AuditTrail.getNumber().equals(normal.getCol()) || SysDimensionEnum.AuditTrail.getShortnumber().equals(normal.getCol())).findFirst();
            if (!first.isPresent()) {
                whenFilterItem.addATNormal(atCode);
            }
            filterItems.add(whenFilterItem);
        }
        Map<String, Set<String>> ctxDimMap = this.checkDimFilter(outline, filterItems, srcExtendModel, tarExtendModel);
        HashMap<String, String[]> dimNumMap = new HashMap<String, String[]>(16);
        HashMap<String, String> dimQcpMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Set<String>> entry : ctxDimMap.entrySet()) {
            dimNumMap.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            dimQcpMap.put(entry.getKey(), IN);
        }
        QFilter qf = null;
        boolean existSpecial = false;
        for (WhenFilterItem filterItem : filterItems) {
            QFilter otherFilter;
            if (filterItem.getNormals().size() > 0 && (otherFilter = this.getQFilterByWhenFilterItem(filterItem, srcExtendModel)) != null) {
                if (qf == null) {
                    qf = otherFilter;
                } else {
                    qf.or(otherFilter);
                }
            }
            if (existSpecial) continue;
            existSpecial = filterItem.getSpecials().size() > 0;
        }
        BizRuleUtil.setMethodNeed(srcExtendModel.getNumber());
        QueryCommand srcQueryCommand = this.getQueryCommand(outline, srcExtendModel, qf, "", "", dimNumMap, dimQcpMap);
        EDResultSet srcResultSet = ExtDataServiceHelper.queryData(srcQueryCommand);
        ExtendResultSet tarResultSet = this.getExtendModel(tarCode, outline, new XDMScopeInfo(), atCode);
        if (tarResultSet.getQueryCommand().isNeedSum()) {
            return;
        }
        ArrayList ins = new ArrayList();
        if (existSpecial) {
            ArrayList pairList = new ArrayList();
            for (WhenFilterItem filterItem : filterItems) {
                if (filterItem.getSpecials().size() <= 0) continue;
                ArrayList<Pair> itemlist = new ArrayList<Pair>(10);
                for (SpecialFilterItem special : filterItem.getSpecials()) {
                    String srcCol = special.getSrcCol();
                    String tarCol = special.getTarCol();
                    itemlist.add(Pair.onePair((Object)srcCol, (Object)tarCol));
                }
                pairList.add(itemlist);
            }
            HashMap<Long, Map<String, Object>> updateRows = new HashMap<Long, Map<String, Object>>();
            HashSet<Long> srcIds = new HashSet<Long>();
            boolean tarSize = false;
            for (EDRow src : srcResultSet.getRows()) {
                for (EDRow tar : tarResultSet) {
                    ArrayList<Boolean> exists = new ArrayList<Boolean>(10);
                    for (List list : pairList) {
                        boolean exist = true;
                        for (Pair pair : list) {
                            if (!exist) continue;
                            String srcCol = (String)pair.p1;
                            String tarCol = (String)pair.p2;
                            Object srcValue = src.getOriginalValue(srcCol);
                            Object tarValue = tar.getOriginalValue(tarCol);
                            if (srcValue instanceof BigDecimal) {
                                exist = ((BigDecimal)srcValue).compareTo((BigDecimal)tarValue) == 0;
                                continue;
                            }
                            if (srcValue instanceof Date) {
                                exist = ((Date)srcValue).compareTo((Date)tarValue) == 0;
                                continue;
                            }
                            if (srcValue instanceof String) {
                                exist = srcValue.toString().trim().equals(tarValue.toString().trim());
                                continue;
                            }
                            exist = srcValue == null && tarValue == null;
                        }
                        exists.add(exist);
                    }
                    if (!exists.contains(Boolean.TRUE)) continue;
                    srcIds.add(src.getPkId());
                    if (updateRows.containsKey(tar.getPkId())) continue;
                    HashMap valueMap = new HashMap(8);
                    IntStream.range(0, tarCols.size()).forEach(index -> valueMap.put(tarCols.get(index), src.getOriginalValue((String)srcCols.get(index))));
                    updateRows.put(tar.getPkId(), valueMap);
                }
            }
            if (srcIds.size() != tarResultSet.getEdResultSet().getRows().length) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6\u4e0b\u6e90\u548c\u76ee\u6807\u6570\u91cf\u4e0d\u4e00\u81f4\u65e0\u6cd5\u590d\u5236", (String)"ScriptBuiltinExtHelper_58", (String)"fi-bcm-computing", (Object[])new Object[0])));
            }
            tarResultSet.setUpdateValues(updateRows);
            tarResultSet.save();
        } else {
            String finalAtCode = atCode;
            srcResultSet.iteratorRows(row -> {
                List<EDColumn> cols = tarResultSet.getEdResultSet().getMetaData().getColMetaDatas();
                ArrayList<Object> values = new ArrayList<Object>(tarCols.size());
                for (String col : srcCols) {
                    int ind = row.getMetaData().getColIndex(col);
                    if (ind < 0) continue;
                    values.add(row.getOriginalValue(col));
                }
                values.add(finalAtCode);
                ins.add(values);
            });
            SaveCommand old = null;
            int ind2 = 0;
            String newTarColStr = tarColStr + "," + SysDimensionEnum.AuditTrail.getNumber();
            for (List in : ins) {
                SaveCommand saveCommand = this.getSaveCommand(outline, newTarColStr, in.toArray(), tarResultSet, false, old);
                if (ind2 == 0) {
                    old = saveCommand;
                } else {
                    SaveCommand saveCommand1 = this.getSaveCommand(outline, newTarColStr, in.toArray(), tarResultSet, false, old);
                    if (old != null) {
                        old.getUpdateValues().putAll(saveCommand1.getUpdateValues());
                        old.getValue().addAll(saveCommand1.getValue());
                    }
                }
                ++ind2;
            }
            if (ins.size() > 0) {
                this.save(outline, old);
            }
        }
    }

    @Override
    public void setColValue(IOutline outline, Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap, String dataModelNum, Object value, String colNumber, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
    }

    @Override
    public void insertRow(IOutline outline, String dataModelNum, List<InvEDSaveComInfo> saveCommands, String investOrg, String investedOrg, String ownType, String columns, Object[] values, boolean isCustomed, String mergeOrg) {
    }

    @Override
    public void delRows(IOutline outline, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
    }

    @Override
    public Object getColValue(IOutline outline, long id, String number, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, Map<String, String> dimMap, String mergeOrg) {
        return null;
    }

    private Map<String, Set<String>> checkDimFilter(IOutline outline, List<WhenFilterItem> filterItems, ExtendsModel srcExtendModel, ExtendsModel tarExtendModel) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet ctxDims = new HashSet(outline.getComputingContext().getScopeItems().keySet());
        ctxDims.add(DimTypesEnum.AUDITTRIAL.getNumber());
        for (WhenFilterItem whenFilterItem : filterItems) {
            List normals = whenFilterItem.getNormals();
            for (NormalFilterItem normal : normals) {
                if (!ctxDims.contains(normal.getCol())) continue;
                result.putIfAbsent(normal.getCol(), new HashSet());
                result.put(normal.getCol(), "=".equals(normal.getCondition()) ? Collections.singleton(normal.getValue()) : new HashSet(normal.getValues()));
            }
            for (SpecialFilterItem special : whenFilterItem.getSpecials()) {
                if (ctxDims.contains(special.getSrcCol()) || ctxDims.contains(special.getTarCol())) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e0a\u4e0b\u6587\u53ca\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u5ea6\u4f5c\u4e3a\u6e90\u548c\u76ee\u6807\u540c\u65f6\u7b5b\u9009\u7684\u6761\u4ef6", (String)"ScriptBuiltinExtHelper_55", (String)"fi-bcm-computing", (Object[])new Object[0])));
                }
                if (ctxDims.contains(special.getSrcCol()) || srcExtendModel.getFieldEntryByNumber(special.getSrcCol()) != null && null != tarExtendModel.getFieldEntryByNumber(special.getTarCol())) continue;
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u6216\u5b57\u6bb5\u7f16\u7801", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-computing", (Object[])new Object[0])));
            }
        }
        for (Map.Entry entry : outline.getComputingContext().getScopeItems().entrySet()) {
            if (!result.containsKey(entry.getKey())) {
                result.put((String)entry.getKey(), (Set<String>)Collections.singleton(((Pair)entry.getValue()).p2));
                continue;
            }
            if (((Set)result.get(entry.getKey())).size() <= 1) continue;
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6307\u5b9a\u591a\u4e2a\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u503c", (String)"ScriptBuiltinExtHelper_54", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        return result;
    }

    private QFilter getQFilterByWhenFilterItem(WhenFilterItem whenFilterItem, ExtendsModel extendsModel) {
        QFilter finalFilter = null;
        for (NormalFilterItem normal : whenFilterItem.getNormals()) {
            FieldEntry fieldEntry = extendsModel.getFieldEntryByNumber(normal.getCol());
            if (fieldEntry != null) {
                String col = FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType() ? fieldEntry.getExtField().getMapped() : fieldEntry.getDimension().getNumber().toLowerCase();
                List<Object> value = "=".equals(normal.getCondition()) ? this.transferValue(fieldEntry, normal.getValue()) : this.transferValues(normal.getValues(), fieldEntry);
                if (finalFilter == null) {
                    finalFilter = new QFilter(col, normal.getCondition(), value);
                    continue;
                }
                finalFilter.and(col, normal.getCondition(), value);
                continue;
            }
            if (MODEL_DEFAULT_DIMS.contains(normal.getCol())) continue;
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u51fd\u6570xCopy(\u76ee\u6807\u5ba1\u8ba1\u7ebf\u7d22\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u76ee\u6807\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7f16\u7801,\u6765\u6e90\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684\u5b57\u6bb5,[\u4ece\u6e90\u6a21\u578b\u53d6\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f])\uff0c %s", (String)"ScriptBuiltinExtHelper_47", (String)"fi-bcm-computing", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6761\u4ef6\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u6216\u5b57\u6bb5\u7f16\u7801", (String)"ScriptBuiltinExtHelper_53", (String)"fi-bcm-computing", (Object[])new Object[0])));
        }
        return finalFilter;
    }

    private List<Object> transferValues(List<String> values, FieldEntry fieldEntry) {
        return values.stream().map(val -> this.transferValue(fieldEntry, (String)val)).collect(Collectors.toList());
    }

    private Object transferValue(FieldEntry fieldEntry, String val) {
        if (FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType()) {
            String mapped = fieldEntry.getExtField().getMapped();
            if (mapped.contains("dateext")) {
                try {
                    return DateTimeUtils.parseStrDate((String)val);
                }
                catch (ParseException e) {
                    try {
                        SimpleDateFormat sp = new SimpleDateFormat("yyyy/MM/dd");
                        return sp.parse(val);
                    }
                    catch (ParseException ex) {
                        return null;
                    }
                }
            }
            if (mapped.contains("numext")) {
                try {
                    return new BigDecimal(val).setScale(15, 4);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return val;
        }
        return val;
    }

    public boolean isEntityDimAndIntrOnly(String dimNum) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNum) && this.isIntrOnlyExectype();
    }

    protected boolean isIntrOnlyExectype() {
        return false;
    }

    public static void checkValidXDMScopeInfo(ExtendsModel extendsModel, XDMScopeInfo xdmScopeInfo) {
        Optional<XDMDimensionFilterItem> first;
        if (xdmScopeInfo != null && StringUtils.isEmpty((String)xdmScopeInfo.getExtendsmodelNumber()) && (first = xdmScopeInfo.getXdmFilters().stream().filter(item -> extendsModel.getFieldEntryByNumber(item.getName()) == null && Arrays.stream(ParamConstant.CONTEXT_DIMENSIONS_ENUM).noneMatch(p -> p.getNumber().equals(item.getName()))).findFirst()).isPresent()) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5b57\u6bb5\u6210\u5458\u3002", (String)"ScriptBuiltinExtHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), first.get().getName()));
        }
    }

    private static /* synthetic */ boolean lambda$xRuns$13(BigDecimal value, String val) {
        return new BigDecimal(val).compareTo(new BigDecimal(value.toString())) == 0;
    }
}

