/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper;
import kd.fi.bcm.business.bizrule.extendscript.service.AbstractBizRuleExtFuncService;
import kd.fi.bcm.business.bizrule.extendscript.util.ExtendService;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.extdim.InvExtDataSaveService;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultSet;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.invest.sheet.log.IInvLimSheetLogServer;
import kd.fi.bcm.business.invest.sheet.log.InvLimSheetLogServer;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invsheet.InvLimSheetLogConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.fel.common.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EquityBizRuleExtFuncService
extends AbstractBizRuleExtFuncService {
    @Override
    public void insertRow(IOutline outline, String dataModelNum, List<InvEDSaveComInfo> saveCommands, String investOrg, String investedOrg, String ownType, String columns, Object[] values, boolean isCustomed, String mergeOrg) {
        this.investMethodParamValidate("insertRow", outline, investOrg, investedOrg, ownType, mergeOrg);
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        this.checkEnable(extendsModel);
        List<ExtFieldEntry> extFieldEntry = extendsModel.getExtFieldEntry();
        if (columns == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u5b57\u6bb5\u5fc5\u987b\u6307\u5b9a", (String)"ScriptBuiltinExtHelper_45", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String[] colNums = columns.split(",");
        Object[] objectArray = values = values == null ? new Object[colNums.length] : values;
        if (colNums.length != values.length) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u6a21\u578b\u7684insertRow\u65b9\u6cd5\u4e2d\u5b9a\u4e49\u7684\u6570\u636e\u4e2a\u6570\u4e0e\u5b57\u6bb5\u4e2a\u6570\u4e0d\u4e00\u81f4\u3002", (String)"ScriptBuiltinExtHelper_25", (String)"fi-bcm-business", (Object[])new Object[0]), extendsModel.getNumber()));
        }
        HashMap<String, String> colTypeMap = new HashMap<String, String>(16);
        for (ExtFieldEntry extFieldEntry2 : extFieldEntry) {
            ExtField extField = extFieldEntry2.getExtField();
            colTypeMap.put(extField.getNumber(), extField.getDataType());
            if (!extField.getDataType().equals("6")) continue;
            if (extField.getMapped().contains("dateext")) {
                colTypeMap.put(extField.getNumber(), "4");
                continue;
            }
            if (extField.getMapped().contains("numext")) {
                colTypeMap.put(extField.getNumber(), "2");
                continue;
            }
            colTypeMap.put(extField.getNumber(), "3");
        }
        int index = 0;
        for (String colNum : colNums) {
            String type = (String)colTypeMap.get(colNum);
            if (type == null) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u6216\u5b57\u6bb5\u3002", (String)"ScriptBuiltinExtHelper_37", (String)"fi-bcm-computing", (Object[])new Object[0]), colNum));
            }
            values[index] = values[index] == null ? null : this.getNewColValue(values[index], InvExtDataSaveService.getValueField(type));
            ++index;
        }
        Object[] objectArray2 = values;
        InvEDSaveComInfo saveCommand = null;
        if (saveCommands.size() == 0) {
            saveCommand = ExtendService.getInvestSaveCommand(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, mergeOrg);
        } else {
            for (InvEDSaveComInfo command : saveCommands) {
                if (!command.getDatamodel().equals(extendsModel.getNumber()) || !command.getInvestOrg().equals(investedOrg) || !command.getSharehold().equals(investOrg) || !command.getRelationType().equals(ownType) || !command.getMerge().equals(mergeOrg) || (!isCustomed || !command.getCategorized().equals(InvRelationTypeConstant.CatalogEnum.change_type.getCode())) && (isCustomed || !command.getCategorized().equals(InvRelationTypeConstant.CatalogEnum.relation.getCode()))) continue;
                saveCommand = command;
                break;
            }
            if (saveCommand == null) {
                saveCommand = ExtendService.getInvestSaveCommand(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, mergeOrg);
            }
        }
        InvEDResultSet invEDResultSet = (InvEDResultSet)ThreadCache.get((Object)("queryInvestData|" + extendsModel.getNumber() + "|" + investedOrg + "|" + investedOrg + "|" + ownType + "|" + isCustomed), () -> ExtendService.queryInvestData(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, Collections.emptyMap(), mergeOrg));
        HashMap<String, Long> oldDataMap = new HashMap<String, Long>(16);
        while (invEDResultSet.next()) {
            oldDataMap.put(invEDResultSet.getExtendMember(), invEDResultSet.getRow().getLong("id"));
        }
        HashMap<String, EDColumn> olds = new HashMap<String, EDColumn>(16);
        if (!ArrayUtils.isEmpty((Object[])saveCommand.getCols())) {
            for (EDColumn col : saveCommand.getCols()) {
                olds.put(col.getMdName(), col);
            }
        }
        IntStream.range(0, colNums.length).forEach(in -> {
            EDColumn edColumn = new EDColumn(colNums[in], (String)colTypeMap.get(colNums[in]), finalValues[in]);
            if (oldDataMap.containsKey(colNums[in])) {
                edColumn.setId((Long)oldDataMap.get(colNums[in]));
            }
            olds.put(edColumn.getMdName(), edColumn);
        });
        saveCommand.setCols(olds.values().toArray(new EDColumn[0]));
        if (!saveCommands.contains(saveCommand)) {
            saveCommands.add(saveCommand);
        }
    }

    @Override
    public void setColValue(IOutline outline, Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap, String dataModelNum, Object value, String colNumber, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
        ScriptMemberExtDimensionNode node = extDimensionNodeMap.get(colNumber);
        if (node == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5b57\u6bb5\u6210\u5458\u3002", (String)"ScriptBuiltinExtHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), colNumber));
        }
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        this.checkEnable(extendsModel);
        InvEDResultSet invEDResultSet = ExtendService.queryInvestData(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, Collections.emptyMap(), mergeOrg);
        DynamicObject accDy = null;
        while (invEDResultSet.next()) {
            if (!colNumber.equals(invEDResultSet.getExtendMember())) continue;
            accDy = invEDResultSet.getRow();
            break;
        }
        InvEDSaveComInfo edSaveComInfo = ExtendService.getInvestSaveCommand(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, mergeOrg);
        IInvLimSheetLogServer logServer = this.buildInvLimSheetLogServer(outline);
        if (accDy != null) {
            String accDataType = accDy.getString("datatype");
            String valueField = InvExtDataSaveService.getValueField(accDataType);
            value = this.getNewColValue(value, valueField);
            EDColumn edColumn = new EDColumn(colNumber, accDataType, value);
            edColumn.setId(accDy.getLong("id"));
            edSaveComInfo.setCols(new EDColumn[]{edColumn});
            InvExtDataServiceHelper.saveData(Collections.singletonList(edSaveComInfo));
            logServer.logSheetDataSave(edSaveComInfo, edColumn, null);
        } else {
            FieldEntry entry = extendsModel.getFieldEntryByNumber(colNumber);
            if (entry != null) {
                String type = entry.getExtField().getDataType();
                if (type.equals("6")) {
                    type = entry.getExtField().getMapped().contains("dateext") ? "4" : (entry.getExtField().getMapped().contains("numext") ? "2" : "3");
                }
                String valueField = InvExtDataSaveService.getValueField(type);
                value = this.getNewColValue(value, valueField);
                EDColumn edColumn = new EDColumn(colNumber, type, value);
                edSaveComInfo.setCols(new EDColumn[]{edColumn});
                InvExtDataServiceHelper.saveData(Collections.singletonList(edSaveComInfo));
                logServer.logSheetDataSave(edSaveComInfo, edColumn, null);
            }
        }
        logServer.successLogAsync();
    }

    @Override
    public void delRows(IOutline outline, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
        this.investMethodParamValidate("insertRow", outline, investOrg, investedOrg, ownType, mergeOrg);
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        this.checkEnable(extendsModel);
        InvEDResultSet invEDResultSet = ExtendService.queryInvestData(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, Collections.emptyMap(), mergeOrg);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        while (invEDResultSet.next()) {
            ids.add(invEDResultSet.getId());
        }
        if (!ids.isEmpty()) {
            InvExtDataServiceHelper.deleteDataBySaveInfo(ids);
        }
    }

    @Override
    public Object getColValue(IOutline outline, long id, String number, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, Map<String, String> dimMap, String mergeOrg) {
        Map<String, ChangeTypeModel> invChangetypeModel;
        this.investMethodParamValidate("getColValue", outline, investOrg, investedOrg, ownType, mergeOrg);
        if (ownType == null || !isCustomed && !ScriptBuiltinInvokeHelper.OWNER_TYPE_MAP.containsKey(ownType)) {
            throw new BizRuleException(ResManager.loadKDString((String)"getColValue\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u80a1\u6743\u6570\u636e\u7c7b\u578b\u53c2\u6570\uff0c\u4e14\u53ea\u80fd\u662f\u201cD\u201d\uff08\u83b7\u53d6\u76f4\u63a5\u6301\u80a1\uff09\u3001\u201cA\u201d\uff08\u7b49\u6548\u6301\u80a1\u52a0\u6cd5\uff09\u3001\u201cM\u201d\uff08\u7b49\u6548\u6301\u80a1\u4e58\u6cd5\uff09\u3001\u201cSLU\u201d\uff08\u672c\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cDLU\u201d\uff08\u8de8\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cUD1~UD20\u201d\uff08\u81ea\u5b9a\u4e49\u80a1\u67431~20\uff09\u3001\u53ca\u52a8\u6001\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\u3002", (String)"ScriptBuiltinExtHelper_50", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (isCustomed && !(invChangetypeModel = InvestServiceHelper.getInvChangetypeModel(MemberReader.findModelIdByNum((String)outline.getModelNum()))).containsKey(ownType)) {
            throw new BizRuleException(ResManager.loadKDString((String)"getColValue\u51fd\u6570\u5fc5\u987b\u6307\u5b9a\u80a1\u6743\u6570\u636e\u7c7b\u578b\u53c2\u6570\uff0c\u4e14\u53ea\u80fd\u662f\u201cD\u201d\uff08\u83b7\u53d6\u76f4\u63a5\u6301\u80a1\uff09\u3001\u201cA\u201d\uff08\u7b49\u6548\u6301\u80a1\u52a0\u6cd5\uff09\u3001\u201cM\u201d\uff08\u7b49\u6548\u6301\u80a1\u4e58\u6cd5\uff09\u3001\u201cSLU\u201d\uff08\u672c\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cDLU\u201d\uff08\u8de8\u7ea7\u8054\u5408\u6301\u80a1\uff09\u3001\u201cUD1~UD20\u201d\uff08\u81ea\u5b9a\u4e49\u80a1\u67431~20\uff09\u3001\u53ca\u52a8\u6001\u80a1\u6bd4\u7c7b\u578b\u7f16\u7801\u3002", (String)"ScriptBuiltinExtHelper_50", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ExtendsModel extendsModel = ExtendService.existExtendModel(dataModelNum, outline.getModelNum());
        InvEDResultSet invEDResultSet = ExtendService.queryInvestData(extendsModel, outline, investOrg, investedOrg, ownType, isCustomed, dimMap, mergeOrg);
        Object res = null;
        invEDResultSet.beforeFirst();
        while (invEDResultSet.next()) {
            if (!invEDResultSet.getExtendMember().equals(number)) continue;
            res = invEDResultSet.getValue();
            DataTypeEnum typeEnum = DataTypeEnum.valueOfBy((String)invEDResultSet.getRow().getString("datatype"));
            if (res != null || typeEnum == DataTypeEnum.TXT || typeEnum == DataTypeEnum.DATETP || typeEnum == DataTypeEnum.ENUMTP) break;
            res = BigDecimal.ZERO;
            break;
        }
        return res;
    }

    private void investMethodParamValidate(String methodName, IOutline outline, String investOrg, String investedOrg, String ownType, String mergeOrg) {
        String cube = outline.getModelNum();
        IDNumberTreeNode invest = MemberReader.findEntityMemberByNum((String)cube, (String)investOrg);
        if (invest == IDNumberTreeNode.NotFoundTreeNode || !invest.isLeaf()) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u4e2d\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801", (String)"ScriptBuiltinExtHelper_43", (String)"fi-bcm-business", (Object[])new Object[0]), methodName));
        }
        IDNumberTreeNode invested = MemberReader.findEntityMemberByNum((String)cube, (String)investedOrg);
        if (invested == IDNumberTreeNode.NotFoundTreeNode || !invested.isLeaf()) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u4e2d\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u6295\u8d44\u5355\u4f4d\u7f16\u7801\u6216\u88ab\u6295\u8d44\u5355\u4f4d\u7f16\u7801", (String)"ScriptBuiltinExtHelper_43", (String)"fi-bcm-business", (Object[])new Object[0]), methodName));
        }
        String orgNum = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)"Entity")).p2;
        String process = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)"Process")).p2;
        String string = orgNum = orgNum.contains("_") ? orgNum.split("_")[1] : orgNum;
        if (StringUtils.isNotEmpty((CharSequence)mergeOrg)) {
            if (OrgRelaProcessMembPool.isRelaProcess((String)process) && StringUtils.equals((CharSequence)orgNum, (CharSequence)mergeOrg)) {
                return;
            }
            IDNumberTreeNode org = MemberReader.findEntityMemberByNum((String)cube, (String)orgNum);
            if (!StringUtils.equals((CharSequence)org.getParent().getNumber(), (CharSequence)mergeOrg) && org.getShareNodes().stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getParent().getNumber(), (CharSequence)mergeOrg))) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u5408\u5e76\u7ec4\u7ec7\u4e0d\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u7236\u7ea7\u8282\u70b9\u3002", (String)"ScriptBuiltinExtHelper_56", (String)"fi-bcm-business", (Object[])new Object[0]), methodName));
            }
        }
    }

    private Object getNewColValue(Object value, String valueField) {
        if (valueField.equals("numext")) {
            if (!(value instanceof Number)) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            value = new BigDecimal(value.toString());
        } else if (valueField.equals("dateext")) {
            if (value instanceof String) {
                try {
                    value = this.getDateByDateStr((String)value, ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                catch (ParseException e) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
            } else if (!(value instanceof Date)) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        } else if (!(value instanceof String)) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6210\u5458colCode\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u503c\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltinExtHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return value;
    }

    protected IInvLimSheetLogServer buildInvLimSheetLogServer(IOutline outline) {
        Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
        long scenarioId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p1;
        long yearId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p1;
        long periodId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p1;
        long orgId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1;
        return InvLimSheetLogServer.buildInvLimSheetLogServer(modelId, scenarioId, yearId, periodId, orgId, InvLimSheetLogConstant.Operation.RULE);
    }

    @Override
    public void save(IOutline outline, List<InvEDSaveComInfo> saveCommand) {
        IInvLimSheetLogServer logServer = this.buildInvLimSheetLogServer(outline);
        InvExtDataServiceHelper.saveData(saveCommand);
        saveCommand.forEach(cmd -> {
            for (EDColumn col : cmd.getCols()) {
                logServer.logSheetDataSave((InvEDSaveComInfo)cmd, col, null);
            }
        });
        logServer.successLogAsync();
    }
}

