/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendResultSet;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.invest.extdim.InvExtDataServiceHelper;
import kd.fi.bcm.business.invest.extdim.model.InvEDResultSet;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.invlimsheet.InvExtDataConstant;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.datasource.IOutline;

public class ExtendService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExtendService.class);
    public static final List<String> processByAdj = Lists.newArrayList((Object[])new String[]{"ADJ", "CADJ", "CCADJ", "EJE"});
    public static final Set<String> processByRpt = Sets.newHashSet((Object[])new String[]{"ERpt", "EIRpt", "ERAdj"});

    public static ExtendsModel existExtendModel(String dmCode, String modelNum) {
        return (ExtendsModel)ThreadCache.get((Object)(modelNum + dmCode), () -> {
            String selectFields = "id,number,extendsgroup.number,extendsgroup.id,enable";
            QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)dmCode).add("model.number", "=", (Object)modelNum);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)selectFields, (QFilter[])qfBuilder.toArray());
            return query.isEmpty() ? null : new ExtendsModel(((DynamicObject)query.get(0)).getLong("id"));
        });
    }

    public static String checkDim(ExtendsModel extendsModel, Set<String> dims) {
        String dim = "";
        List<DimFieldEntry> dimFieldEntries = extendsModel.getDimFieldEntry();
        if (!CollectionUtils.isEmpty(dimFieldEntries)) {
            HashSet<String> inDims = new HashSet<String>(dimFieldEntries.size());
            for (DimFieldEntry modelDim : dimFieldEntries) {
                inDims.add(modelDim.getDimension().getNumber());
            }
            for (String di : dims) {
                ArrayList defaultDims = Lists.newArrayList((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
                if (defaultDims.contains(di) || inDims.contains(di)) continue;
                dim = di;
                break;
            }
        }
        return dim;
    }

    public static ExtendResultSet queryData(ExtendsModel extendsModel, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, IOutline outline, QFilter xRunsQfilter) {
        QueryCommand queryCommand = ExtendService.getQueryCommand(extendsModel, dimNumMap, dimQcpMap, outline, xRunsQfilter);
        EDResultSet edResultSet = ExtDataServiceHelper.queryData(queryCommand);
        return new ExtendResultSet(queryCommand, extendsModel, edResultSet);
    }

    public static DataSet queryDataSet(ExtendsModel extendsModel, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, IOutline outline, QFilter xRunsQfilter) {
        QueryCommand queryCommand = ExtendService.getQueryCommand(extendsModel, dimNumMap, dimQcpMap, outline, xRunsQfilter);
        ExtDataQueryService extDataQueryService = new ExtDataQueryService();
        if (queryCommand.isNeedSum()) {
            return null;
        }
        return extDataQueryService.queryDataset(queryCommand);
    }

    public static QueryCommand getQueryCommand(ExtendsModel extendsModel, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, IOutline outline, QFilter xRunsQfilter) {
        QueryCommand queryCommand = new QueryCommand(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        dimNumMap.forEach((dim, val) -> {
            if (DimTypesEnum.ENTITY.getNumber().equals(dim)) {
                List<String> collect = Stream.of(val).map(v -> v.contains("_") ? v.split("_")[1] : v).collect(Collectors.toList());
                queryCommand.addDimFilter((String)dim, collect.toArray(new String[0]));
            } else {
                queryCommand.addDimFilter((String)dim, (String)val);
            }
        });
        HashMap<String, String> fixDims = new HashMap<String, String>(8);
        outline.getComputingContext().getScopeItems().forEach((k, v) -> {
            if (DimTypesEnum.ENTITY.getNumber().equals(k)) {
                fixDims.put((String)k, ((String)v.p2).contains("_") ? ((String)v.p2).split("_")[1] : (String)v.p2);
            } else {
                fixDims.put((String)k, (String)v.p2);
            }
        });
        queryCommand.setFixDims(fixDims);
        queryCommand.setDimQcpMap(dimQcpMap);
        queryCommand.setOutline(outline);
        if (xRunsQfilter != null) {
            queryCommand.setCustomFilter(xRunsQfilter);
        }
        if (dimNumMap.get(DimTypesEnum.ENTITY.getNumber()) != null) {
            String entityNum = dimNumMap.get(DimTypesEnum.ENTITY.getNumber())[0];
            IDNumberTreeNode treeNode = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)entityNum);
            if (entityNum.contains("_")) {
                queryCommand.setParentOrg(entityNum.split("_")[0]);
                queryCommand.setMainOrgId(treeNode.getId());
            } else {
                queryCommand.setParentOrg(treeNode.getParent().getNumber());
                queryCommand.setMainOrgId(treeNode.getId());
            }
        }
        BizRuleUtil.updateQueryCommandNeedSum(queryCommand);
        List<ExtFieldEntry> extFieldEntry = extendsModel.getExtFieldEntry();
        List<DimFieldEntry> dimFieldEntry = extendsModel.getDimFieldEntry();
        List<String> extSelects = extFieldEntry.stream().map(extField -> extField.getExtField().getNumber()).collect(Collectors.toList());
        queryCommand.setExtselects(extSelects.toArray(new String[0]));
        List<String> dimSelects = dimFieldEntry.stream().map(dimEntry -> dimEntry.getDimension().getNumber()).collect(Collectors.toList());
        dimSelects.add(DimTypesEnum.ENTITY.getNumber());
        if (!queryCommand.isNeedSum()) {
            dimSelects.add(DimTypesEnum.AUDITTRIAL.getNumber());
        }
        queryCommand.setDimselects(dimSelects.toArray(new String[0]));
        return queryCommand;
    }

    public static int deleteDataBySaveInfo(Collection<Long> pkIds, SaveCommand saveComInfo) {
        return ExtDataServiceHelper.deleteDataBySaveInfo(pkIds, saveComInfo);
    }

    public static boolean checkMergeOrgSave(String extGroupNumber, long mainOrgId, long modelId) {
        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)mainOrgId);
        boolean isLeaf = treeNode.isLeaf();
        if (!isLeaf) {
            QFilter modelQF = new QFilter("model", "=", (Object)modelId);
            QFilter numQF = new QFilter("number", "=", (Object)extGroupNumber);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"isparticipmerge", (QFilter[])new QFilter[]{modelQF, numQF});
            if (!dy.getBoolean("isparticipmerge")) {
                return false;
            }
        }
        return true;
    }

    public static InvEDResultSet queryInvestData(ExtendsModel extendsModel, IOutline outline, String investOrg, String investedOrg, String ownType, boolean isCustomed, Map<String, String> dimMap, String mergeOrg) {
        QueryCommand edQueryComInfo = new QueryCommand(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        edQueryComInfo.setExtselects(InvExtDataConstant.getSelectField());
        String scenario = dimMap.containsKey(PresetConstant.SCENE_DIM) ? dimMap.get(PresetConstant.SCENE_DIM) : (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p2;
        String year = dimMap.containsKey(PresetConstant.FY_DIM) ? dimMap.get(PresetConstant.FY_DIM) : (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p2;
        String period = dimMap.containsKey(PresetConstant.PERIOD_DIM) ? dimMap.get(PresetConstant.PERIOD_DIM) : (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p2;
        String org = dimMap.containsKey(PresetConstant.ENTITY_DIM) ? dimMap.get(PresetConstant.ENTITY_DIM) : (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p2;
        Long orgId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1;
        String process = dimMap.containsKey(PresetConstant.PROCESS_DIM) ? dimMap.get(PresetConstant.PROCESS_DIM) : (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM)).p2;
        edQueryComInfo.addDimFilter("Scenario", scenario);
        edQueryComInfo.addDimFilter("Year", year);
        edQueryComInfo.addDimFilter("Period", period);
        QFilter customFilter = new QFilter("internalcompany", "=", (Object)investOrg);
        String belongOrg = org.split("_").length > 1 ? org.split("_")[1] : org;
        customFilter.and(new QFilter("org", "=", (Object)belongOrg));
        if (StringUtils.isEmpty((Object)mergeOrg)) {
            mergeOrg = OrgRelaProcessMembPool.isRelaProcess((String)process) ? belongOrg : MemberReader.findEntityMemberById((Long)MemberReader.findModelIdByNum((String)outline.getModelNum()), (Long)orgId).getParent().getNumber();
        }
        customFilter.and(new QFilter("merge", "=", (Object)mergeOrg));
        customFilter.and("entity", "=", (Object)investedOrg);
        if (isCustomed) {
            customFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.change_type.getCode());
            customFilter.and("relationtype", "=", (Object)ownType);
        } else {
            customFilter.and("categorized", "=", (Object)InvRelationTypeConstant.CatalogEnum.relation.getCode());
            InvRelaTypeEnum invRelaTypeEnum = (InvRelaTypeEnum)InvRelationTypeConstant.getCode2InvRelaTypeEnum().get(ownType);
            if (invRelaTypeEnum != null) {
                customFilter.and("relationtype", "=", (Object)invRelaTypeEnum.getType());
            }
        }
        edQueryComInfo.setCustomFilter(customFilter);
        String key = new StringJoiner("|").add(outline.getModelNum()).add(scenario).add(year).add(period).add(org).add(mergeOrg).add(investOrg).add(investedOrg).add(ownType).toString();
        return (InvEDResultSet)ThreadCache.get((Object)key, () -> InvExtDataServiceHelper.queryData(edQueryComInfo));
    }

    public static InvEDSaveComInfo getInvestSaveCommand(ExtendsModel extendsModel, IOutline outline, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
        InvEDSaveComInfo edSaveComInfo = new InvEDSaveComInfo(extendsModel.getModelShowNumber(), extendsModel.getExtendsGroupNumber(), extendsModel.getNumber());
        String scenario = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM)).p2;
        String org = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p2;
        Long orgId = (Long)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM)).p1;
        String year = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM)).p2;
        String period = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM)).p2;
        String process = (String)((Pair)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM)).p2;
        edSaveComInfo.addfixedDimension("Scenario", scenario);
        edSaveComInfo.addfixedDimension("Year", year);
        edSaveComInfo.addfixedDimension("Period", period);
        edSaveComInfo.setRelationType(ownType);
        String belongOrg = org.split("_").length > 1 ? org.split("_")[1] : org;
        edSaveComInfo.setBelongOrg(belongOrg);
        if (StringUtils.isEmpty((Object)mergeOrg)) {
            mergeOrg = OrgRelaProcessMembPool.isRelaProcess((String)process) ? belongOrg : MemberReader.findEntityMemberById((Long)MemberReader.findModelIdByNum((String)outline.getModelNum()), (Long)orgId).getParent().getNumber();
        }
        edSaveComInfo.setMerge(mergeOrg);
        edSaveComInfo.setSharehold(investOrg);
        edSaveComInfo.setInvestOrg(investedOrg);
        Object paperTemplate = outline.getBuiltin().getArgs().get("paperTemplateNumber");
        edSaveComInfo.setTemplateNumber(paperTemplate == null ? "" : paperTemplate.toString());
        if (isCustomed) {
            edSaveComInfo.setCategorized(InvRelationTypeConstant.CatalogEnum.change_type.getCode());
        } else {
            Map code2InvRelaTypeEnum = InvRelationTypeConstant.getCode2InvRelaTypeEnum();
            if (code2InvRelaTypeEnum.containsKey(ownType)) {
                edSaveComInfo.setCategorized(InvRelationTypeConstant.CatalogEnum.relation.getCode());
            } else {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5305\u542b%s\u80a1\u6bd4\u7c7b\u578b!", (String)"InvExtDataServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), ownType));
            }
        }
        return edSaveComInfo;
    }
}

