/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.extendscript.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendResultSet;
import kd.fi.bcm.business.bizrule.extendscript.service.AbstractBizRuleExtFuncService;
import kd.fi.bcm.business.bizrule.extendscript.service.BizRuleExtServiceStrategyFactory;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.invest.extdim.model.InvEDSaveComInfo;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.util.ChineseUtil;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.member.ScriptAllMemberExtDimensionNode;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.computing.model.WhenFilterItem;
import kd.fi.bcm.computing.util.RuleExecuteServiceHelper;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class ScriptBuiltinExtHelper {
    public static ScriptObject getXDMSet(Object[] args, int argsNum, IOutline outline) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getXDMSet(args, argsNum, outline);
    }

    private static void createConditionMap(String dimStr, Map<String, String[]> dimNumMap, Map<String, String> dimQcpMap, String modelNum) {
    }

    public static String[] xSyn(IOutline outline, Map<String, Object> args, Object[] params) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).xSyn(outline, args, params);
    }

    public static void xRuns(IOutline outline, ScriptAllMemberExtDimensionNode node, XDMScopeInfo xdmScopeInfo, String[] expressions) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).xRuns(outline, node, xdmScopeInfo, expressions);
    }

    public static ExtendResultSet getColSumSet(IOutline outline, String number, String dataModelNum, XDMScopeInfo xdmScopeInfo) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getColSumSet(outline, number, dataModelNum, xdmScopeInfo);
    }

    public static ExtendResultSet getColSumSetResult(IOutline outline, String number, XDMScopeInfo xdmScopeInfo, ExtendsModel extendsModel, QFilter specialFilter) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getColSumSetResult(outline, number, xdmScopeInfo, extendsModel, specialFilter);
    }

    public static void setColValue(IOutline outline, Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap, String datamodelNum, Object value, String colNumber, XDMScopeInfo xdmScopeInfo) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).setColValue(outline, extDimensionNodeMap, datamodelNum, value, colNumber, xdmScopeInfo);
    }

    public static void setColValue(IOutline outline, Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap, String dataModelNum, Object value, String colNumber, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).setColValue(outline, extDimensionNodeMap, dataModelNum, value, colNumber, investOrg, investedOrg, ownType, isCustomed, mergeOrg);
    }

    public static Date getDateByDateStr(String value, String description) throws ParseException {
        Date tempDate;
        if (ChineseUtil.hasChinese((String)value)) {
            String[] split = value.split("[\u4e00-\u9fa5]");
            if (split.length != 3) {
                throw new BizRuleException(description);
            }
            int year = Integer.parseInt(split[0]);
            int month = Integer.parseInt(split[1]) - 1;
            int day = Integer.parseInt(split[2]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, 0, 0, 0);
            tempDate = calendar.getTime();
        } else if (value.contains("/")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            tempDate = simpleDateFormat.parse(value);
        } else {
            if (value.contains("T")) {
                value = DateTimeUtils.parseUTC((String)value);
            }
            tempDate = DateTimeUtils.parseDate((String)value);
        }
        return tempDate;
    }

    public static SaveCommand insertRow(IOutline outline, String datamodelNum, SaveCommand oldSaveCommand, String colNumbers, Object[] values) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).insertRow(outline, datamodelNum, oldSaveCommand, colNumbers, values);
    }

    public static void copy(IOutline outline, String dataModelNum, String tarATCode, String ctxDimStr, SaveCommand oldSaveCommand) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).copy(outline, dataModelNum, tarATCode, ctxDimStr, oldSaveCommand);
    }

    public static void insertRow(IOutline outline, String dataModelNum, List<InvEDSaveComInfo> saveCommands, String investOrg, String investedOrg, String ownType, String columns, Object[] values, boolean isCustomed, String mergeOrg) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).insertRow(outline, dataModelNum, saveCommands, investOrg, investedOrg, ownType, columns, values, isCustomed, mergeOrg);
    }

    public static void save(IOutline outline, SaveCommand saveCommand) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).save(outline, saveCommand);
    }

    public static void save(IOutline outline, List<InvEDSaveComInfo> saveCommand) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).save(outline, saveCommand);
    }

    public static void batchInsertRows(IOutline outline, String datamodelNum, long datamodelId, long extGroupId, String colNumbers, Object[] values, int count) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).batchInsertRows(outline, datamodelNum, datamodelId, extGroupId, colNumbers, values, count);
    }

    public static void delRows(IOutline outline, String datamodelNum, XDMScopeInfo xdmScopeInfo) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).delRows(outline, datamodelNum, xdmScopeInfo);
    }

    public static void delRows(IOutline outline, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, String mergeOrg) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).delRows(outline, dataModelNum, investOrg, investedOrg, ownType, isCustomed, mergeOrg);
    }

    public static BigDecimal getColSum(IOutline outline, String number, String dataModelNum, XDMScopeInfo xdmScopeInfo) {
        BizRuleUtil.setMethodNeed(dataModelNum);
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getColSum(outline, number, dataModelNum, xdmScopeInfo);
    }

    public static BigDecimal getColSum(String cube, String dataModel, String fieldNumber, Map<String, Pair<Long, String>> params, Map<String, String> dimScope, List<String> extScope) {
        return new AbstractBizRuleExtFuncService().getColSum(cube, dataModel, fieldNumber, params, dimScope, extScope);
    }

    public static WhenFilterItem when(IOutline outline, Object[] args) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).when(outline, args);
    }

    private static IOutline transferToOutline(String cube, Map<String, Pair<Long, String>> params) {
        OlapConnection olapConnection = RuleExecuteServiceHelper.getOlapConnection((String)cube);
        Outline outline = new Outline(olapConnection);
        BizRuleExecParam bizRuleExecParam = new BizRuleExecParam(cube);
        params.forEach((k, v) -> bizRuleExecParam.addCommonParamPair(k, v));
        outline.setComputingContext(new ComputingContext(olapConnection, (IOutline)outline, bizRuleExecParam.getCommonParam()));
        return outline;
    }

    public static Object[] getColValue(IOutline outline, long id, String number, String datamodelNum, XDMScopeInfo xdmScopeInfo) {
        BizRuleUtil.setMethodNeed(datamodelNum);
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getColValue(outline, id, number, datamodelNum, xdmScopeInfo);
    }

    public static Object getColValue(IOutline outline, long id, String number, String dataModelNum, String investOrg, String investedOrg, String ownType, boolean isCustomed, Map<String, String> dimMap, String mergeOrg) {
        return BizRuleExtServiceStrategyFactory.getFuncService(outline).getColValue(outline, id, number, dataModelNum, investOrg, investedOrg, ownType, isCustomed, dimMap, mergeOrg);
    }

    public static void xCopy(IOutline outline, Object[] args) {
        BizRuleExtServiceStrategyFactory.getFuncService(outline).xCopy(outline, args);
    }

    public static boolean isEntityDimAndIntrOnly(String dimNum, IOutline outline) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNum) && ScriptBuiltinExtHelper.isIntrOnlyExectype(outline);
    }

    public static boolean isIntrOnlyExectype(IOutline outline) {
        return BizRuleExecuteTypeEnum.INTR_ONLY == outline.getBuiltin().getArgs().get("executeType");
    }

    public static boolean checkIsSameContext(QueryCommand queryCommand) {
        ComputingContext context = queryCommand.getOutline().getComputingContext();
        Map scopeItems = context.getScopeItems();
        Map<String, String[]> fixDims = queryCommand.getDimFilter();
        if (fixDims != null) {
            for (Map.Entry entry : scopeItems.entrySet()) {
                String[] curs;
                String dim = (String)entry.getKey();
                String val = (String)((Pair)entry.getValue()).p2;
                if (SysDimensionEnum.Entity.getNumber().equals(dim) && val.contains("_")) {
                    val = val.split("_")[1];
                }
                if ((curs = fixDims.get(dim)).length != 1 || val.equals(curs[0])) continue;
                return false;
            }
        }
        return true;
    }

    public static List<DynamicObject> getExtNodeListById(DynamicObject extmodel) {
        DynamicObject[] extmodelfield = BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,synsetting,sequence", (QFilter[])new QFilter("extmodelid", "=", (Object)extmodel.getLong("id")).toArray(), (String)"sequence,extfield.number");
        return Arrays.stream(extmodelfield).collect(Collectors.toList());
    }

    public static List<String> getExtModelAllFieldNums(long extModelId) {
        return (List)ThreadCache.get((Object)("getExtModelAllFieldNums" + extModelId), () -> new ExtendsModel(extModelId).getFieldEntry().stream().map(f -> f.get("number").toString()).collect(Collectors.toList()));
    }

    public static String getExtModelAllFieldNumStr(long extModelId) {
        return String.join((CharSequence)",", ScriptBuiltinExtHelper.getExtModelAllFieldNums(extModelId));
    }
}

