/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleIfCondition;

public class BizRuleComponentIfCondition
implements BizRuleComponent {
    private List<BizRuleIfCondition> conditions;

    public BizRuleComponentIfCondition(List<BizRuleIfCondition> conditions) {
        this.conditions = conditions;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.conditions.forEach(condition -> stringBuilder.append(condition.toString()));
        return stringBuilder.toString();
    }

    @Override
    public String generateJsScript() {
        return this.generateConditionScript(this.conditions);
    }

    private String generateConditionScript(List<BizRuleIfCondition> bizRuleIfConditions) {
        Map<Integer, List<BizRuleIfCondition>> map = bizRuleIfConditions.stream().collect(Collectors.groupingBy(BizRuleIfCondition::getPriority));
        StringBuilder conditionJsScript = new StringBuilder();
        int j = 1;
        for (int i = 1; i <= 4; ++i) {
            if (!map.containsKey(i)) continue;
            StringBuilder addCondition = new StringBuilder();
            List<BizRuleIfCondition> conditions = map.get(i);
            int linkSymbolLength = 0;
            int size = conditions.size();
            for (int k = 0; k < size; ++k) {
                BizRuleIfCondition bizRuleIfCondition = conditions.get(k);
                if (k == 0 && bizRuleIfCondition.getLinkSymbol() != null) {
                    linkSymbolLength = bizRuleIfCondition.getLinkSymbol().getJsScript().length();
                }
                addCondition.append(bizRuleIfCondition.generateJsScript());
            }
            if (j == 1) {
                conditionJsScript.append((CharSequence)addCondition);
            } else {
                String oldJsScript = conditionJsScript.toString();
                conditionJsScript.setLength(0);
                conditionJsScript.append("(").append(oldJsScript).append(")");
                conditionJsScript.append(addCondition.substring(0, linkSymbolLength));
                conditionJsScript.append("(");
                conditionJsScript.append(addCondition.substring(linkSymbolLength));
                conditionJsScript.append(")");
            }
            ++j;
        }
        return conditionJsScript.toString();
    }
}

