/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleScope;
import kd.fi.bcm.common.cache.MemberReader;
import org.apache.commons.lang.StringUtils;

public class BizRuleComponentScope
implements BizRuleComponent {
    private List<BizRuleScope> scopes;
    private Long modelId;
    private List<String> errorMsg = new ArrayList<String>();

    public BizRuleComponentScope(List<BizRuleScope> scopes, long modelId) {
        this.scopes = scopes;
        this.modelId = modelId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.scopes.forEach(scope -> stringBuilder.append(scope.toString()));
        return stringBuilder.toString();
    }

    @Override
    public String generateJsScript() {
        if (!this.valid()) {
            throw new KDBizException(this.errorMsg.toString());
        }
        StringBuilder scopeInScripe = new StringBuilder();
        StringBuilder scopeExceptScripe = new StringBuilder();
        int includeCount = 0;
        int excludeCount = 0;
        for (BizRuleScope scope : this.scopes) {
            if (StringUtils.isNotEmpty((String)this.generateJsScript(scope, scope.getIncludeNumber()))) {
                if (includeCount != 0) {
                    scopeInScripe.append(",");
                }
                scopeInScripe.append(this.generateJsScript(scope, scope.getIncludeNumber()));
                ++includeCount;
            }
            if (!StringUtils.isNotEmpty((String)this.generateJsScript(scope, scope.getExcludeNumber()))) continue;
            if (excludeCount != 0) {
                scopeExceptScripe.append(",");
            }
            scopeExceptScripe.append(this.generateJsScript(scope, scope.getExcludeNumber()));
            ++excludeCount;
        }
        if (scopeInScripe.length() == 0 && scopeExceptScripe.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("scope(");
        stringBuilder.append((CharSequence)scopeInScripe).append(")");
        if (scopeExceptScripe.length() != 0) {
            stringBuilder.append(".except(").append((CharSequence)scopeExceptScripe).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean valid() {
        for (BizRuleScope scope : this.scopes) {
            if (!StringUtils.isNotEmpty((String)scope.getDimension()) || !StringUtils.isNotEmpty((String)scope.getExcludeNumber()) || !StringUtils.isNotEmpty((String)scope.getIncludeNumber()) || !scope.getExcludeNumber().equals(scope.getIncludeNumber())) continue;
            this.errorMsg.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u7684\u5305\u542b\u6210\u5458\u548c\u6392\u9664\u6210\u5458\u76f8\u540c\u3002", (String)"BizRuleFunctionScope_0", (String)"fi-bcm-business", (Object[])new Object[0]), scope.getDimension()));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String generateJsScript(BizRuleScope bizRuleScope, String scopeStr) {
        String[] scopeNums;
        StringBuilder stringBuilder = new StringBuilder();
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        Map dimensionMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        ArrayList<String> scopeNumsOnlyMyself = new ArrayList<String>(10);
        ArrayList<String> scopeNumsOther = new ArrayList<String>(10);
        HashMap propertyMap = new HashMap(16);
        for (String str : scopeNums = scopeStr.split(",")) {
            if (!StringUtils.isNotEmpty((String)str)) continue;
            if (str.contains("@")) {
                scopeNumsOther.add(str);
                continue;
            }
            if (str.contains(":")) {
                String[] splits = str.split(":");
                propertyMap.putIfAbsent(splits[0], new ArrayList());
                ((List)propertyMap.get(splits[0])).add(splits[1]);
                continue;
            }
            scopeNumsOnlyMyself.add(str);
        }
        String shortNumber = this.getShortnumberFromMap(dimensionMap, bizRuleScope.getDimension());
        if (StringUtils.isNotEmpty((String)shortNumber)) {
            if (!scopeNumsOnlyMyself.isEmpty()) {
                int count = 0;
                stringBuilder.append(shortNumber).append(".in(");
                for (String strMyself : scopeNumsOnlyMyself) {
                    if (count == scopeNumsOnlyMyself.size() - 1) {
                        stringBuilder.append("\"").append(strMyself).append("\"");
                    } else {
                        stringBuilder.append("\"").append(strMyself).append("\",");
                    }
                    ++count;
                }
                stringBuilder.append(")");
            }
            if (!scopeNumsOther.isEmpty()) {
                if (!scopeNumsOnlyMyself.isEmpty()) {
                    stringBuilder.append(",");
                }
                int count1 = 0;
                for (String strOther : scopeNumsOther) {
                    stringBuilder.append(shortNumber).append("[\"");
                    String memberStr = strOther.substring(0, strOther.indexOf("@"));
                    String scopeInt = strOther.substring(strOther.indexOf("@") + 1);
                    stringBuilder.append(memberStr).append("\"].").append(BizRuleUtil.getFunctionNameByScope(Integer.parseInt(scopeInt)));
                    if (count1 != scopeNumsOther.size() - 1) {
                        stringBuilder.append(",");
                    }
                    ++count1;
                }
            }
            if (propertyMap.size() > 0) {
                int index = 0;
                for (Map.Entry entry : propertyMap.entrySet()) {
                    stringBuilder.append(shortNumber);
                    stringBuilder.append(".within(").append("\"").append((String)entry.getKey()).append("\"").append(",[");
                    StringJoiner sj = new StringJoiner(",");
                    for (String pro : (List)entry.getValue()) {
                        sj.add("\"" + pro + "\"");
                    }
                    stringBuilder.append(sj).append("])");
                    if (index != propertyMap.size() - 1) {
                        stringBuilder.append(",");
                    }
                    ++index;
                }
            }
        } else {
            this.errorMsg.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u7b80\u7801\u3002", (String)"BizRuleFunctionScope_1", (String)"fi-bcm-business", (Object[])new Object[0]), bizRuleScope.getDimension()));
        }
        return stringBuilder.toString();
    }

    private String getShortnumberFromMap(Map<String, String> dimensionMap, String dimension) {
        for (Map.Entry<String, String> entry : dimensionMap.entrySet()) {
            if (!entry.getValue().equals(dimension)) continue;
            return entry.getKey();
        }
        return null;
    }
}

