/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.bizrule.logicconfig.expression.JsExpression;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.CheckMethodEnum;
import kd.fi.bcm.common.enums.rule.LinkSymbolEnum;
import kd.fi.bcm.common.enums.rule.YesOrNoEnum;
import kd.fi.bcm.computing.util.TreeStructureServiceHelper;
import org.apache.commons.lang.StringUtils;

public class BizRuleIfCondition
implements JsExpression {
    private LinkSymbolEnum linkSymbol;
    private SysDimensionEnum dimension;
    private String conditionNumber;
    private String conditionName;
    private CheckMethodEnum method;
    private String conditionContentNumber;
    private String multiConditionContentNumber;
    private String conditionContentName;
    private String multiConditionContentName;
    private int priority;
    private long modelId;
    private List<String> errorMsg = new ArrayList<String>();

    public String getMultiConditionContentNumber() {
        return this.multiConditionContentNumber;
    }

    public void setMultiConditionContentNumber(String multiConditionContentNumber) {
        this.multiConditionContentNumber = multiConditionContentNumber;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }

    public String getConditionContentName() {
        return this.conditionContentName;
    }

    public void setConditionContentName(String conditionContentName) {
        this.conditionContentName = conditionContentName;
    }

    public LinkSymbolEnum getLinkSymbol() {
        return this.linkSymbol;
    }

    public void setLinkSymbol(LinkSymbolEnum linkSymbol) {
        this.linkSymbol = linkSymbol;
    }

    public String getConditionNumber() {
        return this.conditionNumber;
    }

    public void setConditionNumber(String conditionNumber) {
        this.conditionNumber = conditionNumber;
    }

    public String getConditionContentNumber() {
        return this.conditionContentNumber;
    }

    public void setConditionContentNumber(String conditionContentNumber) {
        this.conditionContentNumber = conditionContentNumber;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public SysDimensionEnum getDimension() {
        return this.dimension;
    }

    public void setDimension(SysDimensionEnum dimension) {
        this.dimension = dimension;
    }

    public CheckMethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(CheckMethodEnum method) {
        this.method = method;
    }

    @Override
    public String generateJsScript() {
        if (!this.valid()) {
            throw new KDBizException(this.errorMsg.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.linkSymbol != null) {
            stringBuilder.append(this.linkSymbol.getJsScript());
        }
        if (this.method == CheckMethodEnum.INCLUDE || this.method == CheckMethodEnum.NOT_INCLUDE) {
            stringBuilder.append("[").append(this.appendQuotation(this.multiConditionContentNumber)).append("]").append(".").append(this.method.getExpress()).append("(").append("ctx").append(".").append(this.dimension.getShortnumber()).append(".").append(this.conditionNumber).append(")");
            if (this.method == CheckMethodEnum.NOT_INCLUDE) {
                stringBuilder.append(CheckMethodEnum.EQUAL.getExpress()).append(this.method.getDefaultCondition());
            }
        } else if (BizRuleConstant.COMMON_METHOD.contains(this.method)) {
            stringBuilder.append("ctx").append(".").append(this.dimension.getShortnumber()).append(".");
            if ("properties".equals(this.conditionNumber)) {
                String longNumber = TreeStructureServiceHelper.getLongNumber((String)"bcm_definedpropertyvalue", (String)this.dimension.getNumber(), (String)this.conditionContentNumber, (Object)this.modelId);
                stringBuilder.append(longNumber.split("!")[0]).append(this.method.getExpress()).append(this.appendQuotation(this.conditionContentNumber));
            } else {
                stringBuilder.append(this.conditionNumber).append(this.method.getExpress()).append(this.appendQuotation(this.conditionContentNumber));
            }
        } else if (BizRuleConstant.VALID_METHOD.contains(this.method)) {
            stringBuilder.append(this.dimension.getShortnumber()).append(".").append(String.format(this.method.getExpress(), this.appendQuotation(this.conditionContentNumber))).append(CheckMethodEnum.EQUAL.getExpress()).append(this.method.getDefaultCondition());
        } else {
            stringBuilder.append("ctx").append(".").append(this.dimension.getShortnumber()).append(".").append(String.format(this.method.getExpress(), this.appendQuotation(this.conditionContentNumber))).append(CheckMethodEnum.EQUAL.getExpress()).append(this.method.getDefaultCondition());
        }
        return stringBuilder.toString();
    }

    private String appendQuotation(String content) {
        if (StringUtils.isEmpty((String)content.trim())) {
            return "";
        }
        String[] split = content.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : split) {
            if ("isIC".equals(this.conditionNumber) || "isDependent".equals(this.conditionNumber)) {
                stringBuilder.append(YesOrNoEnum.getEnumByValue((String)this.conditionContentNumber).getJsScript());
            } else if (s.contains(":")) {
                String[] property = s.split(":");
                String propertKey = property[0];
                String propertVal = property[1];
                Long dimensionId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)this.getDimension().getNumber());
                Set propList = DimPropList.getDimPropList((long)dimensionId).getPropList();
                Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)this.modelId);
                IDNumberTreeNode exist = null;
                for (IDNumberTreeNode node : allNodeFromCache.values()) {
                    if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(propertVal)) continue;
                    exist = node;
                }
                if (exist != null && exist != IDNumberTreeNode.NotFoundTreeNode) {
                    StringJoiner sj = new StringJoiner(",");
                    HashSet numbers = new HashSet();
                    new MembRangeItem(this.dimension.getMemberTreefrom(), exist.getId(), exist.getNumber(), 10, true, (Object)this.modelId).matchItems(simpleItem -> numbers.add(simpleItem.getNumber()));
                    if (numbers.size() == 0) continue;
                    for (String number : numbers) {
                        sj.add("\"" + number + "\"");
                    }
                    stringBuilder.append(sj);
                }
            } else {
                stringBuilder.append("\"");
                stringBuilder.append(s.trim());
                stringBuilder.append("\"");
            }
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public boolean valid() {
        if (BizRuleConstant.SUPPORT_EQUAL_METHOD.contains(this.conditionNumber) && !BizRuleConstant.EQUAL_METHOD.contains(this.method)) {
            this.errorMsg.add(this.getMsg(BizRuleConstant.EQUAL_METHOD));
            return false;
        }
        if (BizRuleConstant.SUPPORT_EQUAL_AND_INCLUDE_METHOD.contains(this.conditionNumber) && !BizRuleConstant.EQUAL_AND_INCLUDE_METHOD.contains(this.method)) {
            this.errorMsg.add(this.getMsg(BizRuleConstant.EQUAL_AND_INCLUDE_METHOD));
            return false;
        }
        switch (this.method) {
            case DETAIL: 
            case NOT_DETAIL: {
                break;
            }
            case INCLUDE: 
            case NOT_INCLUDE: {
                if (!StringUtils.isBlank((String)this.multiConditionContentNumber)) break;
                this.errorMsg.add(ResManager.loadKDString((String)"\u6761\u4ef6\u503c\u591a\u9009\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleIfCondition_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                break;
            }
            case VALID_LEAF: 
            case NOT_VALID_LEAF: 
            case VALID_CHILD: 
            case NOT_VALID_CHILD: 
            case VALID_SUBORDINATE: 
            case NOT_VALID_SUBORDINATE: {
                if (this.dimension != SysDimensionEnum.Entity) {
                    this.errorMsg.add(ResManager.loadKDString((String)"\u5224\u65ad\u6709\u6548\u660e\u7ec6\u6210\u5458/\u6709\u6548\u76f4\u63a5\u4e0b\u7ea7\u6210\u5458/\u6709\u6548\u4e0b\u7ea7\u6210\u5458\u4ec5\u9002\u7528\u4e8e\u7ec4\u7ec7\u7ef4\u5ea6\u3002", (String)"BizRuleIfCondition_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    return false;
                }
            }
            default: {
                if (!StringUtils.isBlank((String)this.conditionContentNumber)) break;
                this.errorMsg.add(ResManager.loadKDString((String)"\u6761\u4ef6\u503c\u5355\u9009\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleIfCondition_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private String getMsg(List<CheckMethodEnum> methodEnums) {
        return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5224\u65ad\u6761\u4ef6\u201c%1$s\u201d\u4ec5\u652f\u6301\u201c%2$s\u201d\u5224\u65ad\u65b9\u6cd5\u3002", (String)"BizRuleIfCondition_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.conditionName, methodEnums);
    }

    public static BizRuleIfCondition transferFromDynamicObject(DynamicObject dynamicObject) {
        BizRuleIfCondition bizRuleIfCondition = new BizRuleIfCondition();
        bizRuleIfCondition.setLinkSymbol(LinkSymbolEnum.getEnumByValue((String)dynamicObject.getString("link")));
        bizRuleIfCondition.setDimension(SysDimensionEnum.getEnumByMemberTreemodel((String)dynamicObject.getString("main_dimension")));
        bizRuleIfCondition.setConditionName(dynamicObject.getString("check_condition"));
        bizRuleIfCondition.setConditionNumber(dynamicObject.getString("check_condition_number"));
        bizRuleIfCondition.setConditionContentName(dynamicObject.getString("condition_value1"));
        bizRuleIfCondition.setConditionContentNumber(dynamicObject.getString("condition_value1_number"));
        bizRuleIfCondition.setMultiConditionContentName(dynamicObject.getString("condition_value2"));
        bizRuleIfCondition.setMultiConditionContentNumber(dynamicObject.getString("condition_value2_number"));
        bizRuleIfCondition.setMethod(CheckMethodEnum.getEnumByValue((String)dynamicObject.getString("check_method")));
        bizRuleIfCondition.setPriority(dynamicObject.getInt("priority"));
        return bizRuleIfCondition;
    }

    public static List<BizRuleIfCondition> parseCondition(String conditionNum, String conditionName, long modelId) {
        ArrayList<BizRuleIfCondition> conditions = new ArrayList<BizRuleIfCondition>();
        if (StringUtils.isEmpty((String)conditionNum)) {
            return conditions;
        }
        String[] nums = conditionNum.split(";");
        String[] names = conditionName.split(";");
        for (int i = 0; i < nums.length; ++i) {
            String num = nums[i];
            String name = names[i];
            String[] numColumns = num.split("\\|");
            String[] nameColumns = name.split("\\|");
            if (i == 0) {
                int j = 0;
                BizRuleIfCondition bizRuleIfCondition = new BizRuleIfCondition();
                bizRuleIfCondition.setLinkSymbol(LinkSymbolEnum.EMPTY);
                bizRuleIfCondition.setDimension(SysDimensionEnum.getEnumByMemberTreemodel((String)numColumns[j++]));
                bizRuleIfCondition.setConditionNumber(numColumns[j]);
                bizRuleIfCondition.setConditionName(nameColumns[j]);
                String methodVal = numColumns[++j];
                bizRuleIfCondition.setMethod(CheckMethodEnum.getEnumByValue((String)methodVal));
                ++j;
                if (methodVal.equals(CheckMethodEnum.INCLUDE.getValue()) || methodVal.equals(CheckMethodEnum.NOT_INCLUDE.getValue())) {
                    bizRuleIfCondition.setMultiConditionContentNumber(numColumns[j]);
                    bizRuleIfCondition.setMultiConditionContentName(nameColumns[j]);
                } else {
                    bizRuleIfCondition.setConditionContentNumber(numColumns[j]);
                    bizRuleIfCondition.setConditionContentName(nameColumns[j]);
                }
                int n = ++j;
                ++j;
                bizRuleIfCondition.setPriority(Integer.parseInt(numColumns[n]));
                bizRuleIfCondition.setModelId(modelId);
                conditions.add(bizRuleIfCondition);
                continue;
            }
            BizRuleIfCondition bizRuleIfCondition = new BizRuleIfCondition();
            bizRuleIfCondition.setLinkSymbol(LinkSymbolEnum.getEnumByValue((String)numColumns[0]));
            bizRuleIfCondition.setDimension(SysDimensionEnum.getEnumByMemberTreemodel((String)numColumns[1]));
            bizRuleIfCondition.setConditionNumber(numColumns[2]);
            bizRuleIfCondition.setConditionName(nameColumns[2]);
            String methodVal = numColumns[3];
            bizRuleIfCondition.setMethod(CheckMethodEnum.getEnumByValue((String)methodVal));
            if (methodVal.equals(CheckMethodEnum.INCLUDE.getValue()) || methodVal.equals(CheckMethodEnum.NOT_INCLUDE.getValue())) {
                bizRuleIfCondition.setMultiConditionContentNumber(numColumns[4]);
                bizRuleIfCondition.setMultiConditionContentName(nameColumns[4]);
            } else {
                bizRuleIfCondition.setConditionContentNumber(numColumns[4]);
                bizRuleIfCondition.setConditionContentName(nameColumns[4]);
            }
            bizRuleIfCondition.setPriority(Integer.parseInt(numColumns[5]));
            bizRuleIfCondition.setModelId(modelId);
            conditions.add(bizRuleIfCondition);
        }
        return conditions;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("|");
        if (this.linkSymbol != LinkSymbolEnum.EMPTY) {
            joiner.add(this.linkSymbol.getValue());
        }
        joiner.add(this.dimension.getMemberTreemodel()).add(this.conditionNumber).add(this.method.getValue()).add(StringUtils.isEmpty((String)this.conditionContentNumber) ? this.multiConditionContentNumber : this.conditionContentNumber).add(String.valueOf(this.priority));
        return joiner + ";";
    }

    public void setMultiConditionContentName(String multiConditionContentName) {
        this.multiConditionContentName = multiConditionContentName;
    }

    public String getMultiConditionContentName() {
        return this.multiConditionContentName;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }
}

