/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.bizrule.logicconfig.expression.JsExpression;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.RangeEnum;
import org.apache.commons.lang.StringUtils;

public class BizRuleScope
implements JsExpression {
    private String dimension;
    private String includeName;
    private String includeNumber;
    private String excludeNumber;
    private String excludeName;

    public static BizRuleScope transferFromDynamicObject(DynamicObject dynamicObject, Long modelId) {
        BizRuleScope bizRuleScope = new BizRuleScope();
        bizRuleScope.setDimension(dynamicObject.getString("dimension"));
        bizRuleScope.setIncludeName(dynamicObject.getString("include"));
        bizRuleScope.setExcludeName(dynamicObject.getString("exclude"));
        bizRuleScope.setIncludeNumber(dynamicObject.getString("include_number"));
        bizRuleScope.setExcludeNumber(dynamicObject.getString("exclude_number"));
        return bizRuleScope;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getIncludeName() {
        return this.includeName;
    }

    public void setIncludeName(String includeName) {
        this.includeName = includeName;
    }

    public String getExcludeName() {
        return this.excludeName;
    }

    public void setExcludeName(String excludeName) {
        this.excludeName = excludeName;
    }

    public String getIncludeNumber() {
        return this.includeNumber;
    }

    public void setIncludeNumber(String includeNumber) {
        this.includeNumber = includeNumber;
    }

    public String getExcludeNumber() {
        return this.excludeNumber;
    }

    public void setExcludeNumber(String excludeNumber) {
        this.excludeNumber = excludeNumber;
    }

    public static List<BizRuleScope> parseScope(String scopeNums, long modelId) {
        ArrayList<BizRuleScope> scopes = new ArrayList<BizRuleScope>(10);
        if (StringUtils.isEmpty((String)scopeNums)) {
            return scopes;
        }
        String[] rowsName = scopeNums.split(";");
        for (int i = 0; i < rowsName.length; ++i) {
            String rowColumnNum = rowsName[i];
            String[] columnsNum = rowColumnNum.split("\\|");
            BizRuleScope bizRuleScope = new BizRuleScope();
            String dimStr = columnsNum[0];
            if (StringUtils.isNotEmpty((String)dimStr)) {
                String[] nums;
                bizRuleScope.setDimension(dimStr);
                if (StringUtils.isNotEmpty((String)columnsNum[1]) && !" ".equals(columnsNum[1])) {
                    bizRuleScope.setIncludeNumber(columnsNum[1]);
                    StringBuilder includeName = new StringBuilder();
                    for (String num : nums = columnsNum[1].split(",")) {
                        includeName.append(BizRuleScope.getFullName(modelId, dimStr, num));
                        includeName.append(",");
                    }
                    bizRuleScope.setIncludeName(includeName.substring(0, includeName.length() - 1));
                }
                if (StringUtils.isNotEmpty((String)columnsNum[2]) && !" ".equals(columnsNum[2])) {
                    bizRuleScope.setExcludeNumber(columnsNum[2]);
                    StringBuilder excludeName = new StringBuilder();
                    for (String num : nums = columnsNum[2].split(",")) {
                        excludeName.append(BizRuleScope.getFullName(modelId, dimStr, num));
                        excludeName.append(",");
                    }
                    bizRuleScope.setExcludeName(excludeName.substring(0, excludeName.length() - 1));
                }
            }
            scopes.add(bizRuleScope);
        }
        return scopes;
    }

    private static String getFullName(long modelId, String dimension, String num) {
        StringBuilder sb = new StringBuilder();
        int index = num.indexOf("@");
        IDNumberTreeNode member = index < 0 ? MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimension, (String)num) : MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimension, (String)num.substring(0, index));
        String memNumber = member.getNumber();
        String memName = member.getName();
        if (member == IDNumberTreeNode.NotFoundTreeNode && num.contains(":")) {
            String[] splits = num.split(":");
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimension);
            memNumber = splits[0] + ":" + DimPropList.getDimPropList((long)dimensionId).getFieldName(splits[0]);
            Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId);
            for (IDNumberTreeNode node : allNodeFromCache.values()) {
                if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(splits[1])) continue;
                memName = splits[1] + ":" + node.getName();
            }
        }
        sb.append(memNumber);
        sb.append("-");
        sb.append(memName);
        if (index >= 0) {
            String sc = num.substring(index + 1);
            sb.append(ResManager.loadKDString((String)"\u7684", (String)"BizRuleScope_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            sb.append(RangeEnum.getRangeByVal((int)Integer.parseInt(sc)).getName());
        }
        return sb.toString();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("|");
        joiner.add(this.dimension);
        if (StringUtils.isNotEmpty((String)this.includeNumber)) {
            joiner.add(this.includeNumber);
        } else {
            joiner.add(" ");
        }
        if (StringUtils.isNotEmpty((String)this.excludeNumber)) {
            joiner.add(this.excludeNumber);
        } else {
            joiner.add(" ");
        }
        return joiner + ";";
    }
}

