/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.function;

import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunction;
import kd.fi.bcm.common.enums.rule.OutputLogEnum;

public abstract class AbstractBizRuleFunction
implements BizRuleComponent,
BizRuleFunction {
    protected String outputLog;
    protected String logicName;
    protected String logicNumber;

    public AbstractBizRuleFunction(String outputLog, String logicName, String logicNumber) {
        this.outputLog = outputLog;
        this.logicName = logicName;
        this.logicNumber = logicNumber;
    }

    @Override
    public String generateJsScript() {
        OutputLogEnum outputLogEnum = OutputLogEnum.getEnumByType((String)this.outputLog);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("/**\n * " + BizRuleUtil.getDesc1() + " %s\n * " + BizRuleUtil.getDesc2() + " %s\n * " + BizRuleUtil.getDesc3() + " %s\n */\n", this.logicNumber, this.logicName, outputLogEnum.getDesc()));
        switch (outputLogEnum) {
            case DEBUG_LOG: {
                stringBuilder.append("debug(\"").append(this.logicName).append(BizRuleUtil.getDesc4()).append("\");").append(System.lineSeparator()).append(this.generateFunctionScript()).append(System.lineSeparator()).append("debug(\"").append(this.logicName).append(BizRuleUtil.getDesc5()).append("\");");
                break;
            }
            case ALWAYS_LOG: {
                stringBuilder.append("log(\"").append(this.logicName).append(BizRuleUtil.getDesc4()).append("\");").append(System.lineSeparator()).append(this.generateFunctionScript()).append(System.lineSeparator()).append("log(\"").append(this.logicName).append(BizRuleUtil.getDesc5()).append("\");");
                break;
            }
            default: {
                stringBuilder.append(this.generateFunctionScript());
            }
        }
        return stringBuilder.toString();
    }
}

