/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizrule.logicconfig.function;

import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.function.AbstractBizRuleFunction;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunction;
import org.apache.commons.lang.StringUtils;

public class BizRuleFunctionRuns
extends AbstractBizRuleFunction {
    private BizRuleComponent conditions;
    private BizRuleComponent scope;
    private BizRuleFunction vFormula;

    public BizRuleFunctionRuns(String outputLog, String logicName, String logicNumber, BizRuleComponent conditions, BizRuleComponent scope, BizRuleFunction vFormula) {
        super(outputLog, logicName, logicNumber);
        this.conditions = conditions;
        this.scope = scope;
        this.vFormula = vFormula;
    }

    @Override
    public String generateFunctionScript() {
        String scopeJsScript = this.scope.generateJsScript();
        if (StringUtils.isNotBlank((String)scopeJsScript)) {
            scopeJsScript = scopeJsScript + ",";
        }
        if (BizRuleUtil.hasConditions(this.conditions)) {
            if (this.hasNoneFormula()) {
                return String.format(this.getFunctionTemplate(), this.conditions.generateJsScript());
            }
            return String.format(this.getFunctionTemplate(), this.conditions.generateJsScript(), scopeJsScript, this.vFormula.generateFunctionScript());
        }
        if (this.hasNoneFormula()) {
            return "";
        }
        return String.format(this.getFunctionTemplate(), scopeJsScript, this.vFormula.generateFunctionScript());
    }

    private boolean hasNoneFormula() {
        return StringUtils.isEmpty((String)this.scope.generateJsScript()) && StringUtils.isEmpty((String)this.vFormula.toString());
    }

    @Override
    public String getFunctionTemplate() {
        if (BizRuleUtil.hasConditions(this.conditions)) {
            if (this.hasNoneFormula()) {
                return "if(%s){\n}";
            }
            return "if(%s){\n  runs(%s\n  %s);\n}";
        }
        return "runs(%s\n  %s);";
    }
}

