/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.access.DataFlowControlStatusAccess;
import kd.fi.bcm.business.bizstatus.access.IBizStatusAccess;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.bizstatus.utils.BizStatusUtil;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class BizStatusServer {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, BizStatusServer.class);
    public static final List<Integer> hasRedirectMember = new ArrayList<Integer>(16);

    public static Map<String, StatusResult> queryStatus(BizStatusContext ct) {
        HashMap<String, StatusResult> results = new HashMap<String, StatusResult>(16);
        if (ct.getQueryCommandInfo() == null) {
            return results;
        }
        QueryStatusCommandInfo commandInfo = ct.getQueryCommandInfo();
        if (!commandInfo.getCrossDimensions().isEmpty() && !commandInfo.isExitFixMemCross()) {
            return results;
        }
        Map<Integer, String> statusAndColorInfo = BizStatusUtil.getStatusAndColorInfo();
        List<IBizStatusAccess> acclist = BizStatusAccessFactory.getAccessService(ct);
        acclist.forEach(e -> {
            log.startWatch();
            e.addOtherAccess(acclist);
            if (!BizStatusServer.checkStatus(ct, e)) {
                e.perPareData();
            }
            log.info(String.format("status perPareData -->%s", e.getClass().getName()));
        });
        log.startWatch();
        ct.getQueryCommandInfo().iterateCrossDims(comb -> {
            IBizStatusAccess access;
            Iterator iterator = acclist.iterator();
            while (iterator.hasNext() && !BizStatusServer.checkStatus(ct, access = (IBizStatusAccess)iterator.next())) {
                access.beforeCheckSingle((Map<String, String>)comb);
            }
        });
        log.info("access status beforeCheckSingle -->spantime");
        log.startWatch();
        HashMap keyMap = new HashMap(16);
        String modelNumber = ct.getQueryCommandInfo().getModelNumber();
        long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        Pair isOpen2ExtOrgs = (Pair)ThreadCache.get((Object)"isOpen2ExtOrgs", () -> ConfigServiceHelper.getCfgWithExpOrg(modelId, "CM043"));
        Recorder isextorg = new Recorder((Object)false);
        if (ConfigServiceHelper.resolverConfigParam(isOpen2ExtOrgs.p1) && commandInfo.getCommonDims() != null && commandInfo.getCommonDims().containsKey(DimTypesEnum.ENTITY.getNumber())) {
            String par_sonNum = (String)commandInfo.getCommonDims().get(DimTypesEnum.ENTITY.getNumber())[1];
            String orgRealNum = (String)ThreadCache.get((Object)("on" + par_sonNum), () -> MemberReader.findMemberByNumber((String)modelNumber, (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
            if (((Set)isOpen2ExtOrgs.p2).contains(orgRealNum)) {
                isextorg.setRecord((Object)true);
            }
        }
        ct.getQueryCommandInfo().iterateCrossDims(comb -> {
            String key1 = ct.getQueryCommandInfo().getKeyPacker().apply((Map<String, String>)comb);
            BizStatusServer.convertEcOrDc(comb, modelNumber);
            String key2 = ct.getQueryCommandInfo().getKeyPacker().apply((Map<String, String>)comb);
            if (!key1.equals(key2)) {
                keyMap.put(key2, key1);
            }
            for (IBizStatusAccess access : acclist) {
                boolean isNoCheckRedictAccess;
                boolean bl = isNoCheckRedictAccess = BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode() != access.getStatusCode();
                if (!isNoCheckRedictAccess && ((Boolean)isextorg.getRecord()).booleanValue() || !access.checkSingle((Map<String, String>)comb) || !isNoCheckRedictAccess) continue;
                break;
            }
        });
        log.info("access status checkSingle -->spantime");
        log.startWatch();
        HashMap redirectResults = new HashMap(16);
        acclist.forEach(access -> access.getMatchKey().forEach(key -> {
            StatusResult sr = new StatusResult((String)key, access.getStatusCode());
            String color = BizStatusUtil.getColorByStatusCode(statusAndColorInfo, access.getStatusCode());
            if (access.getSpecialColor().containsKey(key)) {
                sr.setColor(access.getSpecialColor().get(key));
            } else if (StringUtils.isNotEmpty((CharSequence)color)) {
                sr.setColor(color);
            }
            if (BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode() == access.getStatusCode()) {
                if (!((AbstractBizStatusAccess)access).getTwiceMatchKey().contains(key)) {
                    redirectResults.put(key, sr);
                }
            } else {
                results.put((String)key, sr);
                if (keyMap.get(key) != null) {
                    results.put((String)keyMap.get(key), sr);
                }
            }
        }));
        for (String key : redirectResults.keySet()) {
            if (results.get(key) == null || !hasRedirectMember.contains(((StatusResult)results.get(key)).getStatusCode())) continue;
            results.remove(key);
        }
        log.info("access status StatusResult -->spantime");
        return results;
    }

    public static Map<String, StatusResult> queryExtStatus(BizStatusContext ct) {
        HashMap<String, StatusResult> results = new HashMap<String, StatusResult>(16);
        if (ct.getQueryCommandInfo() == null) {
            return results;
        }
        List<IBizStatusAccess> acclist = BizStatusAccessFactory.getAccessService(ct);
        acclist.forEach(e -> {
            log.startWatch();
            if (!BizStatusServer.checkStatus(ct, e)) {
                e.perPareData();
            }
            log.info(String.format("status perPareData -->%s", e.getClass().getName()));
        });
        log.startWatch();
        ct.getQueryCommandInfo().iterateCrossDims(comb -> {
            IBizStatusAccess access;
            Iterator iterator = acclist.iterator();
            while (iterator.hasNext() && !BizStatusServer.checkStatus(ct, access = (IBizStatusAccess)iterator.next())) {
                access.beforeCheckSingle((Map<String, String>)comb);
            }
        });
        log.info("access status beforeCheckSingle -->spantime");
        log.startWatch();
        HashMap keyMap = new HashMap(16);
        ct.getQueryCommandInfo().iterateCrossDims(comb -> {
            IBizStatusAccess access;
            String key1 = ct.getQueryCommandInfo().getKeyPacker().apply((Map<String, String>)comb);
            BizStatusServer.convertEcOrDc(comb, ct.getQueryCommandInfo().getModelNumber());
            String key2 = ct.getQueryCommandInfo().getKeyPacker().apply((Map<String, String>)comb);
            if (!key1.equals(key2)) {
                keyMap.put(key2, key1);
            }
            Iterator iterator = acclist.iterator();
            while (iterator.hasNext() && (!(access = (IBizStatusAccess)iterator.next()).checkSingle((Map<String, String>)comb) || BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode() == access.getStatusCode())) {
            }
        });
        log.info("access status checkSingle -->spantime");
        log.startWatch();
        HashMap redirectResults = new HashMap(16);
        acclist.forEach(access -> access.getMatchKey().forEach(key -> {
            StatusResult sr = new StatusResult((String)key, access.getStatusCode());
            if (BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode() == access.getStatusCode()) {
                redirectResults.put(key, sr);
            } else {
                results.put((String)key, sr);
                if (keyMap.get(key) != null) {
                    results.put((String)keyMap.get(key), sr);
                }
            }
        }));
        for (String key : redirectResults.keySet()) {
            if (results.get(key) == null || !hasRedirectMember.contains(((StatusResult)results.get(key)).getStatusCode())) continue;
            results.remove(key);
        }
        log.info("access status StatusResult -->spantime");
        return results;
    }

    private static boolean checkStatus(BizStatusContext ct, IBizStatusAccess access) {
        return ct.isStopPreData() && ct.getQueryCommandInfo().getBizStatusQueryTypes().indexOf(access.getStatusCode()) > ct.getQueryCommandInfo().getBizStatusQueryTypes().indexOf(ct.getStopBizCode());
    }

    private static void convertEcOrDc(Map<String, String> dimAndmem, String modelNumber) {
        if (dimAndmem.containsKey(PresetConstant.ENTITY_DIM) && PresetConstant.ENTITY_DIM.equals(dimAndmem.get(PresetConstant.ENTITY_DIM))) {
            return;
        }
        long modelId = MemberReader.findModelIdByNum((String)modelNumber);
        for (Map.Entry<String, String> m : dimAndmem.entrySet()) {
            String currency = null;
            if ("DC".equals(m.getValue())) {
                Long orgId = MemberReader.findMemberByNumber((String)modelNumber, (String)"Entity", (String)dimAndmem.get("Entity")).getId();
                Long yearId = MemberReader.findMemberByNumber((String)modelNumber, (String)"Year", (String)dimAndmem.get("Year")).getId();
                Long periodId = MemberReader.findMemberByNumber((String)modelNumber, (String)"Period", (String)dimAndmem.get("Period")).getId();
                currency = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)orgId.longValue(), (String)dimAndmem.get((Object)"Process"), (String)dimAndmem.get((Object)"Currency"), (long)yearId.longValue(), (long)periodId.longValue()).p2;
            }
            if (currency == null) continue;
            m.setValue(currency);
        }
    }

    public static String getLockMsg(BizStatusContext _ctx, int code) {
        String lockMsg = "";
        try {
            String modelNumber = _ctx.getQueryCommandInfo().getModelNumber();
            long modelId = MemberReader.findModelIdByNum((String)modelNumber);
            Map dimNum2Names = MemberReader.getDimNumberMapNameById((long)modelId);
            BizStatusAccessFactory.StatusCodeEnum bizcode = BizStatusAccessFactory.StatusCodeEnum.of(code);
            block1 : switch (bizcode) {
                case RootEntity: {
                    lockMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6839\u8282\u70b9\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"BizStatusServer_1", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case ValidEntityControl: 
                case ValidCrossControl: {
                    lockMsg = ResManager.loadKDString((String)"\u6709\u6548\u7ec4\u5408\u5df2\u9501\u5b9a\u3002", (String)"BizStatusServer_2", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case NoPermControl: {
                    lockMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\u3002", (String)"BizStatusServer_3", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case MemberSelfControl: {
                    String orgNumber = _ctx.getQueryCommandInfo().getCompCrossMembs(0).get(DimTypesEnum.ENTITY.getNumber());
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and(new QFilter("number", "=", (Object)orgNumber));
                    DynamicObject org = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"isexchangerate", (QFilter[])new QFilter[]{qFilter});
                    if (org != null && org.getBoolean("isexchangerate")) {
                        lockMsg = ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u65e0\u6cd5\u4fee\u6539\u6570\u636e\u3002", (String)"BizStatusServer_4", (String)"fi-bcm-business", (Object[])new Object[0]);
                        break;
                    }
                    HashBasedTable assoMembs = HashBasedTable.create();
                    if (_ctx.isCommonDimsIncludeDim(DimTypesEnum.ENTITY.getNumber())) {
                        String par_sonNum = (String)_ctx.getQueryCommandInfo().getCommonDims().get(DimTypesEnum.ENTITY.getNumber())[1];
                        String string = (String)ThreadCache.get((Object)("on" + (String)par_sonNum), () -> MemberReader.findMemberByNumber((String)_ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
                        boolean isCWP = "CWP".equals(_ctx.getQueryCommandInfo().getFixDimension().get(DimTypesEnum.AUDITTRIAL.getNumber())) && "ERAdj".equals(_ctx.getQueryCommandInfo().getFixDimension().get(DimTypesEnum.PROCESS.getNumber()));
                        assoMembs = isCWP ? (Table)ThreadCache.get((Object)("assoMembInModel" + modelId), () -> AssoStorageMemUtil.getAllAssoMembers(_ctx.getQueryCommandInfo().getModelNumber())) : (Table)ThreadCache.get((Object)("assoMembInModel" + modelId), () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg(_ctx.getQueryCommandInfo().getModelNumber(), orgRealNum));
                    }
                    lockMsg = ResManager.loadKDString((String)"%1$s %2$s\u975e\u660e\u7ec6\u6216\u6807\u7b7e\u7c7b\u7b49\u672c\u8eab\u5c5e\u6027\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_5", (String)"fi-bcm-business", (Object[])new Object[0]);
                    for (Map.Entry entry : _ctx.getQueryCommandInfo().getCompCrossMembs(0).entrySet()) {
                        IDNumberTreeNode member;
                        String memNum;
                        String dim = (String)entry.getKey();
                        if (assoMembs.contains((Object)dim, (Object)(memNum = (String)entry.getValue()))) {
                            memNum = (String)assoMembs.get(entry.getKey(), entry.getValue());
                        }
                        if ((member = MemberReader.findMemberByNumber((String)_ctx.getQueryCommandInfo().getModelNumber(), (String)dim, (String)memNum)).isLeaf() && StorageTypeEnum.LABEL != member.getStorageType()) continue;
                        lockMsg = String.format(lockMsg, dimNum2Names.get(dim), memNum);
                        break block1;
                    }
                    break;
                }
                case ValidCalAccControl: {
                    lockMsg = ResManager.loadKDString((String)"\u79d1\u76ee\u8ba1\u7b97\u5c5e\u6027\u9501\u5b9a", (String)"BizStatusServer_6", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case InnerLogicGenerate: {
                    lockMsg = ResManager.loadKDString((String)"\u5012\u6324\u903b\u8f91\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_7", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case PCControl: {
                    Map<String, String> dimMenNumMap = _ctx.getQueryCommandInfo().getCrossDimensions().isEmpty() ? _ctx.getQueryCommandInfo().getFixDimension() : _ctx.getQueryCommandInfo().getCompCrossMembs(0);
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.ENTITY.getNumber()));
                    IDNumberTreeNode iDNumberTreeNode = MemberReader.findScenaMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.SCENARIO.getNumber()));
                    IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.YEAR.getNumber()));
                    IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.PERIOD.getNumber()));
                    lockMsg = ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u9501\u5b9a\u3002", (String)"BizStatusServer_8", (String)"fi-bcm-business", (Object[])new Object[0]);
                    BaseData baseData = new BaseData((Long)modelId, iDNumberTreeNode, yearNode, periodNode);
                    if (ExchangeQueryHelper.getAutoConvertByOrg(baseData, SimpleVo.newOne(orgNode)).booleanValue()) break;
                    lockMsg = ResManager.loadKDString((String)"\u8be5\u5355\u5143\u683c\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u53ef\u5f55\u5165\u9501\u5b9a\u3002", (String)"BizStatusServer_9", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case BLFYControl: {
                    lockMsg = ResManager.loadKDString((String)"\u5e74\u521d\u6570\u7ed3\u8f6c\u4e0d\u53ef\u4fee\u6539\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_10", (String)"fi-bcm-business", (Object[])new Object[0]);
                    if (!ConfigServiceHelper.getBoolParam(modelId, "CM001")) break;
                    lockMsg = ResManager.loadKDString((String)"\u8be5\u5355\u5143\u683c\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u53ef\u5f55\u5165\u9501\u5b9a\u3002", (String)"BizStatusServer_9", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case InitPeriodControl: {
                    lockMsg = ResManager.loadKDString((String)"\u671f\u95f4\u521d\u59cb\u5316\u671f\u521d\u6570\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_11", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case PeriodManageControl: {
                    lockMsg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u5f00\u542f\u6216\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u4fee\u6539\u6570\u636e\u3002", (String)"BizStatusServer_12", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case AdjustPeriodControl: {
                    Map<String, String> dimMemNumMap = _ctx.getQueryCommandInfo().getCompCrossMembs(0);
                    lockMsg = String.format(ResManager.loadKDString((String)"\u8c03\u6574\u671f%1$s\u5728\u8d22\u5e74%2$s\u672a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u6216\u4fdd\u5b58\u6570\u636e\u3002", (String)"BizStatusServer_19", (String)"fi-bcm-business", (Object[])new Object[0]), dimMemNumMap.get(DimTypesEnum.YEAR.getNumber()), dimMemNumMap.get(DimTypesEnum.PERIOD.getNumber()));
                    break;
                }
                case DataFlowControl: {
                    ContextFilterData filterData = ContextFilterData.getContextFilterData(_ctx);
                    McStatus mcStatus = DataFlowControlStatusAccess.getMcStatus(filterData.model.id, filterData.org.id, filterData.scene.id, filterData.year.id, filterData.period.id);
                    if (mcStatus.getArchive().isArchive()) {
                        lockMsg = String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u5f52\u6863\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_25", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    if (mcStatus.getFlow().isSubmit() && BizStatusServer.isDC(_ctx)) {
                        lockMsg = String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u9501\u5b9a\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_14", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    if (!mcStatus.getPcFlow().isSubmit()) break;
                    lockMsg = String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u6298\u7b97\u5e01\u6d41\u7a0b\u5df2\u9501\u5b9a\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_24", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]);
                    break;
                }
                case DataStageArchiveAccess: {
                    lockMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4\u5df2\u5f52\u6863\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_21", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]);
                    break;
                }
                case DataStageStatusAccess: {
                    if (BizStatusServer.isDC(_ctx)) {
                        Pair<Boolean, List<Pair<String, String>>> lock = BizStatusServer.getDataStageStatus(_ctx, modelId);
                        lockMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b%s\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_22", (String)"fi-bcm-business", (Object[])new Object[0]), ((Pair)((List)lock.p2).get((int)0)).p1);
                        break;
                    }
                    Pair<Boolean, List<Pair<String, String>>> lock = BizStatusServer.getDataStageStatus(_ctx, modelId);
                    lockMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u667a\u80fd\u5408\u5e76\u6298\u7b97\u5e01\u6d41\u7a0b%s\u9636\u6bb5\u5df2\u9501\u5b9a\uff0c\u6570\u636e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"BizStatusServer_23", (String)"fi-bcm-business", (Object[])new Object[0]), ((Pair)((List)lock.p2).get((int)0)).p1);
                    break;
                }
                case ReportStatusControl: {
                    lockMsg = ResManager.loadKDString((String)"\u62a5\u8868\u72b6\u6001\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_16", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case InputMemberControl: {
                    lockMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u8ba1\u7ebf\u7d22\u6216\u8005\u8fc7\u7a0b\u4e0d\u80fd\u76f4\u63a5\u5f55\u6570\u3002", (String)"BizStatusServer_13", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case OnlyReadTemplate: {
                    lockMsg = ResManager.loadKDString((String)"\u53ea\u8bfb\u72b6\u6001\u9501\u5b9a\u3002", (String)"BizStatusServer_15", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case LockInTemplateStyle: {
                    lockMsg = ResManager.loadKDString((String)"\u6a21\u677f\u5185\u8bbe\u7f6e\u9501\u5b9a\u3002", (String)"BizStatusServer_17", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case PermissionControl: {
                    lockMsg = ResManager.loadKDString((String)"\u6210\u5458\u6743\u9650\u53ea\u8bfb\u63a7\u5236\u9501\u5b9a\u3002", (String)"BizStatusServer_18", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
                case ICVersionControlAccess: {
                    lockMsg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u8be5\u6210\u5458\u5728\u6b64\u5f80\u6765\u7ec4\u7ec7\u6d6e\u52a8\u8303\u56f4\u5185\u4e0d\u751f\u6548\u3002", (String)"BizStatusServer_20", (String)"fi-bcm-business", (Object[])new Object[0]);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return lockMsg;
    }

    private static Pair<Boolean, List<Pair<String, String>>> getDataStageStatus(BizStatusContext _ctx, long modelId) {
        Map<String, String> comb = _ctx.getQueryCommandInfo().getCrossDimensions().isEmpty() ? _ctx.getQueryCommandInfo().getFixDimension() : _ctx.getQueryCommandInfo().getCompCrossMembs(0);
        String sceneNum = comb.get(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = comb.get(DimTypesEnum.YEAR.getNumber());
        String periodNum = comb.get(DimTypesEnum.PERIOD.getNumber());
        String orgNum = comb.get(DimTypesEnum.ENTITY.getNumber());
        IDNumberTreeNode orgTreeNode = BcmThreadCache.findMemberByNum((String)_ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNum);
        String cyNum = comb.get(DimTypesEnum.CURRENCY.getNumber());
        String bpNum = comb.get(DimTypesEnum.PROCESS.getNumber());
        cyNum = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)orgTreeNode.getId().longValue(), (String)bpNum, (String)cyNum, (long)0L, (long)0L).p2;
        String dimNum = LockScopeServiceHelper.getLockDimNumber_HasEmpty(modelId);
        String lockDimMemb = comb.get(dimNum);
        HashSet years = Sets.newHashSet((Object[])new String[]{yearNum});
        HashSet periods = Sets.newHashSet((Object[])new String[]{periodNum});
        HashSet cys = Sets.newHashSet((Object[])new String[]{cyNum});
        LockScope lockScope = LockScopeServiceHelper.queryLockScope(modelId, sceneNum, years, periods, cys);
        Pair<Boolean, List<Pair<String, String>>> lock = lockScope.isLock(yearNum, periodNum, cyNum, orgTreeNode.getNumber(), lockDimMemb);
        return lock;
    }

    public static boolean isDC(BizStatusContext _ctx) {
        Map<String, String> comb = _ctx.getQueryCommandInfo().getCrossDimensions().isEmpty() ? _ctx.getQueryCommandInfo().getFixDimension() : _ctx.getQueryCommandInfo().getCompCrossMembs(0);
        String orgNum = comb.get(DimTypesEnum.ENTITY.getNumber());
        IDNumberTreeNode orgTreeNode = BcmThreadCache.findMemberByNum((String)_ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNum);
        String currencyNum = comb.get(DimTypesEnum.CURRENCY.getNumber());
        String orgCurrencyNum = null;
        if (!IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(orgTreeNode.getNumber())) {
            orgCurrencyNum = orgTreeNode.getCurrency();
        }
        return "DC".equals(currencyNum) || "EC".equals(currencyNum) || currencyNum.equals(orgCurrencyNum);
    }

    static {
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.ValidCrossControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.MemberSelfControl.getCode());
        hasRedirectMember.add(BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode());
    }

    public static class ContextFilterData {
        public SimpleVo model;
        public SimpleVo org;
        public SimpleVo scene;
        public SimpleVo year;
        public SimpleVo period;

        public ContextFilterData(SimpleVo org, SimpleVo scene, SimpleVo year, SimpleVo period) {
            this.org = org;
            this.scene = scene;
            this.year = year;
            this.period = period;
        }

        public static ContextFilterData getContextFilterData(BizStatusContext _ctx) {
            String modelNumber = _ctx.getQueryCommandInfo().getModelNumber();
            long modelId = MemberReader.findModelIdByNum((String)modelNumber);
            Map<String, String> dimMenNumMap = _ctx.getQueryCommandInfo().getCrossDimensions().isEmpty() ? _ctx.getQueryCommandInfo().getFixDimension() : _ctx.getQueryCommandInfo().getCompCrossMembs(0);
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.ENTITY.getNumber()));
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.SCENARIO.getNumber()));
            IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.YEAR.getNumber()));
            IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)dimMenNumMap.get(DimTypesEnum.PERIOD.getNumber()));
            ContextFilterData filterData = new ContextFilterData(SimpleVo.newOne(orgNode), SimpleVo.newOne(sceneNode), SimpleVo.newOne(yearNode), SimpleVo.newOne(periodNode));
            filterData.model = SimpleVo.newOne(modelNumber, modelId);
            return filterData;
        }
    }
}

