/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.fi.bcm.business.bizstatus.access.IBizStatusAccess;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public abstract class AbstractBizStatusAccess
implements IBizStatusAccess {
    protected BizStatusContext _ctx;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private List<String> matchKey;
    private List<String> twiceMatchKey;
    private Map<String, String> specialColor;

    public AbstractBizStatusAccess(BizStatusContext ctx) {
        this._ctx = ctx;
    }

    public void mark(Map<String, String> membs, String color) {
        String key = this._ctx.getQueryCommandInfo().getKeyPacker().apply(membs);
        this.getMatchKey().add(key);
        if (color != null) {
            this.getSpecialColor().put(key, color);
        }
    }

    public void twiceMark(Map<String, String> membs) {
        String key = this._ctx.getQueryCommandInfo().getKeyPacker().apply(membs);
        this.getTwiceMatchKey().add(key);
    }

    public void mark(Map<String, String> membs) {
        this.mark(membs, null);
    }

    public void setColor(Map<String, String> membs, String color) {
        String key = this._ctx.getQueryCommandInfo().getKeyPacker().apply(membs);
        this.getSpecialColor().put(key, color);
    }

    @Override
    public List<String> getMatchKey() {
        if (this.matchKey == null) {
            this.matchKey = new ArrayList<String>(10);
        }
        return this.matchKey;
    }

    public List<String> getTwiceMatchKey() {
        if (this.twiceMatchKey == null) {
            this.twiceMatchKey = new ArrayList<String>(10);
        }
        return this.twiceMatchKey;
    }

    @Override
    public Map<String, String> getSpecialColor() {
        if (this.specialColor == null) {
            this.specialColor = new HashMap<String, String>(16);
        }
        return this.specialColor;
    }

    @Override
    public void perPareData() {
        this.doPrePareData();
    }

    protected void doPrePareData() {
    }

    @Override
    public boolean checkSingle(Map<String, String> comb) {
        boolean mark = this.doCheckSingle(comb);
        if (mark) {
            this.mark(comb);
        }
        return mark;
    }

    protected boolean doCheckSingle(Map<String, String> comb) {
        return false;
    }

    @Override
    public void beforeCheckSingle(Map<String, String> comb) {
    }

    public Map<String, String> getFixDimension() {
        return this._ctx.getQueryCommandInfo().getFixDimension();
    }

    protected String getMemberNumber(String dimNumber) {
        if (this.getFixDimension().containsKey(dimNumber)) {
            return this.getFixDimension().get(dimNumber);
        }
        return null;
    }

    protected long getMemberId(String dimNumber) {
        if (this.getFixDimension().containsKey(dimNumber)) {
            return this.getMemberId(dimNumber, this.getFixDimension().get(dimNumber));
        }
        return 0L;
    }

    protected long getMemberId(String dimNumber, String memNum) {
        return this.getMember(dimNumber, memNum).getId();
    }

    protected IDNumberTreeNode findNodeById(String dimnum, long id) {
        return BcmThreadCache.findNodeById((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)dimnum, (long)id);
    }

    protected IDNumberTreeNode getMemberFromFixDim(String dimNumber) {
        if (this.getFixDimension().containsKey(dimNumber)) {
            return this.getMember(dimNumber, this.getFixDimension().get(dimNumber));
        }
        return null;
    }

    protected IDNumberTreeNode getMember(String dimNumber, String memNum) {
        return BcmThreadCache.findMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)dimNumber, (String)memNum);
    }

    protected long getModelId() {
        return MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber());
    }

    public String getOrgRealNum(String par_sonNum) {
        return (String)ThreadCache.get((Object)("on" + par_sonNum), () -> MemberReader.findMemberByNumber((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
    }

    public void stopPreData() {
        this._ctx.setStopPreData(true);
        this._ctx.setStopBizCode(this.getStatusCode());
    }
}

