/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.permission.cache.MemPermClassCacheManager;
import kd.fi.bcm.business.permission.cache.MembPermCacheManager;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.PermEnum;

public abstract class AbstractPermissionStatusAccess
extends AbstractBizStatusAccess {
    protected MembPermCacheManager permMng;
    protected MemPermClassCacheManager permClass;
    protected PermTypePack pack;
    protected boolean unControl;
    protected Map<String, PermEnum> cache;

    public AbstractPermissionStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        if (MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(this.getModelId()))) {
            this.unControl = true;
            return;
        }
        this.permMng = (MembPermCacheManager)ThreadCache.get((Object)"getPermMng", () -> new MembPermCacheManager(this.getModelId()));
        this.permClass = (MemPermClassCacheManager)ThreadCache.get((Object)"getPermClass", () -> new MemPermClassCacheManager(this.getModelId()));
        this.cache = (Map)ThreadCache.get((Object)"getCache", () -> new HashMap(16));
        this.pack = new PermTypePack();
        this.pack.permType = PermEnum.READWRITE;
    }

    protected void cycleComparedPermType(Map<String, String> dimAndmem, PermTypePack remainPack) {
        for (Map.Entry<String, String> m : dimAndmem.entrySet()) {
            if (PermEnum.NOPERM == remainPack.permType) break;
            PermTypePack memTempPack = this.pack.copyPack();
            memTempPack.permType = this.cache.computeIfAbsent(m.getKey() + "|" + m.getValue(), k -> {
                String[] split;
                String mValue = (String)m.getValue();
                if (PresetConstant.ENTITY_DIM.equals(m.getKey()) && (split = mValue.split("_")).length > 1) {
                    mValue = split[1];
                }
                PermEnum memPerm = this.getMemPermControlTypeAllowNull((String)m.getKey(), mValue);
                PermEnum tempPerm = null;
                if (PermEnum.NOPERM == memPerm) {
                    tempPerm = PermEnum.NOPERM;
                } else {
                    PermEnum classPerm = this.permClass.getMemPermClassType((String)m.getKey(), mValue);
                    tempPerm = memPerm == null && classPerm == null ? this.comparedPerm(memTempPack.permType, this.getMemDefaultPermType((String)m.getKey(), mValue)) : (classPerm == null ? this.comparedPerm(memTempPack.permType, memPerm) : (memPerm == null ? this.comparedPerm(memTempPack.permType, classPerm) : this.comparedPerm(memTempPack.permType, this.comparedPerm(memPerm, classPerm))));
                }
                return tempPerm;
            });
            remainPack.permType = this.comparedPerm(memTempPack.permType, remainPack.permType);
        }
    }

    protected PermEnum comparedPerm(PermEnum srcPermType, PermEnum targPermType) {
        return srcPermType.getValue() - targPermType.getValue() > 0 ? srcPermType : targPermType;
    }

    protected PermEnum getMemPermControlTypeAllowNull(String dimNum, String mNum) {
        return this.permMng.getMemPermControlTypeAllowNull(dimNum, mNum);
    }

    protected PermEnum getMemDefaultPermType(String dimNum, String mNum) {
        return this.permMng.getMemDefaultPermType(dimNum, mNum);
    }

    protected static class PermTypePack {
        protected PermEnum permType;

        protected PermTypePack() {
        }

        public void setPermType(PermEnum permType) {
            this.permType = permType;
        }

        public PermEnum getPermType() {
            return this.permType;
        }

        public PermTypePack copyPack() {
            PermTypePack copy = new PermTypePack();
            copy.permType = this.permType;
            return copy;
        }
    }
}

