/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class AdjustPeriodAccess
extends AbstractBizStatusAccess {
    Map<String, String> adjPeriodNum2UseFYs = new HashMap<String, String>(16);

    public AdjustPeriodAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        super.doPrePareData();
        long modelId = MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber());
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("isadjust", "=", (Object)true);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number,useyear,isadjust", (QFilter[])filter.toArray());
        doc.forEach(d -> {
            if (d.getBoolean("isadjust")) {
                this.adjPeriodNum2UseFYs.put(d.getString("number"), d.getString("useyear"));
            }
        });
    }

    @Override
    public void beforeCheckSingle(Map<String, String> comb) {
        super.beforeCheckSingle(comb);
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.adjPeriodNum2UseFYs.containsKey(comb.get(DimTypesEnum.PERIOD.getNumber()))) {
            String yearNum = comb.get(DimTypesEnum.YEAR.getNumber());
            String useYear = this.adjPeriodNum2UseFYs.get(comb.get(DimTypesEnum.PERIOD.getNumber()));
            return !useYear.contains(yearNum);
        }
        return super.doCheckSingle(comb);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.AdjustPeriodControl.getCode();
    }
}

