/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.Map;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class BFLYStatusAccess
extends AbstractBizStatusAccess {
    private boolean canEdit;

    public BFLYStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.BLFYControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        this.canEdit = ConfigServiceHelper.getBoolParam(this.getModelId(), "CM001");
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        String changeType = comb.get(DimTypesEnum.CHANGETYPE.getNumber());
        String process = comb.get(DimTypesEnum.PROCESS.getNumber());
        String currency = comb.get(DimTypesEnum.CURRENCY.getNumber());
        IDNumberTreeNode orgNode = this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
        Pair<String, String> pair = TransMemberUtil.getTransOrgAndCurbyOrgId(orgNode, orgNode.getModelId(), process, currency);
        currency = (String)pair.p2;
        if ("BFLY".equals(changeType) && "IRpt".equals(process) && currency.equals(orgNode.getCurrency())) {
            return true;
        }
        if ("BFLY".equals(changeType)) {
            if (!this.canEdit) {
                return true;
            }
            if (this.canEdit) {
                if (!"IRpt".equals(process)) {
                    return false;
                }
                return "IRpt".equals(process) && currency.equals(orgNode.getCurrency());
            }
        }
        return false;
    }
}

