/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.bizstatus.access.AdjustPeriodAccess;
import kd.fi.bcm.business.bizstatus.access.BFLYStatusAccess;
import kd.fi.bcm.business.bizstatus.access.ConversionPCControlBizAccess;
import kd.fi.bcm.business.bizstatus.access.DataFlowControlStatusAccess;
import kd.fi.bcm.business.bizstatus.access.DataStageArchiveAccess;
import kd.fi.bcm.business.bizstatus.access.DataStageStatusAccess;
import kd.fi.bcm.business.bizstatus.access.ExtBizAccess;
import kd.fi.bcm.business.bizstatus.access.IBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.ICVersionControlAccess;
import kd.fi.bcm.business.bizstatus.access.InitPeriodStatusAccess;
import kd.fi.bcm.business.bizstatus.access.InnerLogicGenerateStatusAccess;
import kd.fi.bcm.business.bizstatus.access.InputMemberAccess;
import kd.fi.bcm.business.bizstatus.access.LockInTempStyleStatusAccess;
import kd.fi.bcm.business.bizstatus.access.NoPermAccess;
import kd.fi.bcm.business.bizstatus.access.NotDetailedLabelBizAccess;
import kd.fi.bcm.business.bizstatus.access.OnlyReadTempStatusAccess;
import kd.fi.bcm.business.bizstatus.access.PeriodManageStatusAccess;
import kd.fi.bcm.business.bizstatus.access.PermissionBizAccess;
import kd.fi.bcm.business.bizstatus.access.RedirectMemberAccess;
import kd.fi.bcm.business.bizstatus.access.ReportStatusControlStatusAccess;
import kd.fi.bcm.business.bizstatus.access.RootEntityAccess;
import kd.fi.bcm.business.bizstatus.access.ValidCalAccountAccess;
import kd.fi.bcm.business.bizstatus.access.ValidCrossStatusAccess;
import kd.fi.bcm.business.bizstatus.access.ValidEntityAcess;
import kd.fi.bcm.business.bizstatus.access.adjust.AdjustNotDetailedLabelBizAccess;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class BizStatusAccessFactory {
    private static Map<StatusCodeEnum, Class<? extends IBizStatusAccess>> register = new ConcurrentHashMap<StatusCodeEnum, Class<? extends IBizStatusAccess>>();
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(BizStatusAccessFactory.class);

    public static List<IBizStatusAccess> getAccessService(BizStatusContext ctx) {
        ArrayList<IBizStatusAccess> list = new ArrayList<IBizStatusAccess>(10);
        List<Integer> statusCodes = ctx.getQueryCommandInfo().getBizStatusQueryTypes();
        BizStatusAccessFactory.getBizStatusAccess(ctx, list, statusCodes);
        return list;
    }

    public static void getBizStatusAccess(BizStatusContext ctx, List<IBizStatusAccess> list, List<Integer> statusCodes) {
        if (statusCodes != null) {
            for (int code : statusCodes) {
                StatusCodeEnum statusCode = StatusCodeEnum.of(code);
                if (statusCode == null) continue;
                Class<? extends IBizStatusAccess> clazz = register.get((Object)statusCode);
                if (clazz == null) {
                    throw new KDBizException(String.format("status code %d relation class is not register.", code));
                }
                try {
                    Constructor<? extends IBizStatusAccess> cons = clazz.getConstructor(BizStatusContext.class);
                    list.add(cons.newInstance(ctx));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    static {
        register.put(StatusCodeEnum.RootEntity, RootEntityAccess.class);
        register.put(StatusCodeEnum.ValidCrossControl, ValidCrossStatusAccess.class);
        register.put(StatusCodeEnum.NoPermControl, NoPermAccess.class);
        register.put(StatusCodeEnum.MemberSelfControl, NotDetailedLabelBizAccess.class);
        register.put(StatusCodeEnum.ValidCalAccControl, ValidCalAccountAccess.class);
        register.put(StatusCodeEnum.InnerLogicGenerate, InnerLogicGenerateStatusAccess.class);
        register.put(StatusCodeEnum.PCControl, ConversionPCControlBizAccess.class);
        register.put(StatusCodeEnum.BLFYControl, BFLYStatusAccess.class);
        register.put(StatusCodeEnum.InitPeriodControl, InitPeriodStatusAccess.class);
        register.put(StatusCodeEnum.PeriodManageControl, PeriodManageStatusAccess.class);
        register.put(StatusCodeEnum.AdjustPeriodControl, AdjustPeriodAccess.class);
        register.put(StatusCodeEnum.InputMemberControl, InputMemberAccess.class);
        register.put(StatusCodeEnum.DataFlowControl, DataFlowControlStatusAccess.class);
        register.put(StatusCodeEnum.OnlyReadTemplate, OnlyReadTempStatusAccess.class);
        register.put(StatusCodeEnum.LockInTemplateStyle, LockInTempStyleStatusAccess.class);
        register.put(StatusCodeEnum.ReportStatusControl, ReportStatusControlStatusAccess.class);
        register.put(StatusCodeEnum.PermissionControl, PermissionBizAccess.class);
        register.put(StatusCodeEnum.ExtBizControl, ExtBizAccess.class);
        register.put(StatusCodeEnum.ValidEntityControl, ValidEntityAcess.class);
        register.put(StatusCodeEnum.RedirectMemberAccess, RedirectMemberAccess.class);
        register.put(StatusCodeEnum.ICVersionControlAccess, ICVersionControlAccess.class);
        register.put(StatusCodeEnum.DataStageArchiveAccess, DataStageArchiveAccess.class);
        register.put(StatusCodeEnum.DataStageStatusAccess, DataStageStatusAccess.class);
        register.put(StatusCodeEnum.AdjustMemberSelfControl, AdjustNotDetailedLabelBizAccess.class);
    }

    public static enum StatusCodeEnum {
        RootEntity(-100),
        NoPermControl(0),
        OnlyReadTemplate(1),
        LockInTemplateStyle(2),
        ReportStatusControl(3),
        DataFlowControl(4),
        MemberSelfControl(6),
        PeriodManageControl(7),
        ValidCrossControl(8),
        ValidCalAccControl(9),
        PermissionControl(10),
        PCControl(11),
        InnerLogicGenerate(12),
        BLFYControl(13),
        InitPeriodControl(14),
        InputMemberControl(15),
        ExtBizControl(16),
        ValidEntityControl(17),
        AdjustMemberSelfControl(18),
        RedirectMemberAccess(5),
        AdjustPeriodControl(19),
        ICVersionControlAccess(20),
        DataStageArchiveAccess(21),
        DataStageStatusAccess(22);

        private int code;

        private StatusCodeEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static StatusCodeEnum of(int code) {
            for (StatusCodeEnum s : StatusCodeEnum.values()) {
                if (s.getCode() != code) continue;
                return s;
            }
            return null;
        }
    }
}

