/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import org.apache.commons.math3.util.Pair;

public class ConversionPCControlBizAccess
extends AbstractBizStatusAccess {
    private Boolean isCache = false;
    private Boolean isLock = false;

    public ConversionPCControlBizAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        if (this.getFixDimension().containsKey(DimTypesEnum.ENTITY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.CURRENCY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.CHANGETYPE.getNumber())) {
            IDNumberTreeNode org = this.getMember(DimTypesEnum.ENTITY.getNumber(), this.getFixDimension().get(DimTypesEnum.ENTITY.getNumber()));
            IDNumberTreeNode scene = this.getMember(DimTypesEnum.SCENARIO.getNumber(), this.getFixDimension().get(DimTypesEnum.SCENARIO.getNumber()));
            IDNumberTreeNode year = this.getMember(DimTypesEnum.YEAR.getNumber(), this.getFixDimension().get(DimTypesEnum.YEAR.getNumber()));
            IDNumberTreeNode period = this.getMember(DimTypesEnum.PERIOD.getNumber(), this.getFixDimension().get(DimTypesEnum.PERIOD.getNumber()));
            String currencyNum = this.getFixDimension().get(DimTypesEnum.CURRENCY.getNumber());
            Map<String, String> comb = this.getFixDimension();
            this.isCache = true;
            BaseData baseData = new BaseData((Long)this.getModelId(), scene, year, period);
            boolean isAutoConvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData, SimpleVo.newOne(org));
            this.isLock = this.getLockStatus(isAutoConvert, org.getId(), currencyNum, comb);
            if (this.isLock.booleanValue()) {
                this.stopPreData();
            }
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.isCache.booleanValue() && this.isLock.booleanValue()) {
            return this.isLock;
        }
        IDNumberTreeNode org = this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
        IDNumberTreeNode scene = this.getMember(DimTypesEnum.SCENARIO.getNumber(), comb.get(DimTypesEnum.SCENARIO.getNumber()));
        IDNumberTreeNode year = this.getMember(DimTypesEnum.YEAR.getNumber(), comb.get(DimTypesEnum.YEAR.getNumber()));
        IDNumberTreeNode period = this.getMember(DimTypesEnum.PERIOD.getNumber(), comb.get(DimTypesEnum.PERIOD.getNumber()));
        String currencyNum = comb.get(DimTypesEnum.CURRENCY.getNumber());
        BaseData baseData = new BaseData((Long)this.getModelId(), scene, year, period);
        boolean isAutoConvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData, SimpleVo.newOne(org));
        return this.getLockStatus(isAutoConvert, org.getId(), currencyNum, comb);
    }

    private Boolean getLockStatus(Boolean isAutoConvert, Long orgId, String currencyNum, Map<String, String> comb) {
        if (isAutoConvert.booleanValue()) {
            if (StringUtils.isEmpty((String)currencyNum)) {
                return false;
            }
            Pair<String, String> queryResult = this.getCurrencyNumberDynaByOrgId(orgId);
            String parentC = (String)queryResult.getSecond();
            String selfC = (String)queryResult.getFirst();
            String changeType = null;
            String process = null;
            String currency = null;
            String audittrial = "";
            if (comb != null) {
                changeType = comb.get(DimTypesEnum.CHANGETYPE.getNumber());
                process = comb.get(DimTypesEnum.PROCESS.getNumber());
                currency = comb.get(DimTypesEnum.CURRENCY.getNumber());
                audittrial = comb.get(DimTypesEnum.AUDITTRIAL.getNumber());
            }
            if (process == null || currency == null || changeType == null || audittrial == null) {
                return false;
            }
            if (StringUtils.isNotEmpty((String)selfC) && selfC.equals(currency) && this.checkEcLock(process, audittrial)) {
                return true;
            }
            Set<String> atCWPNums = this._ctx.getEffCombChecker().getAtCWPNums();
            List<String> processList = Arrays.asList("EIRpt", "IRpt");
            if ("BBOY01".equals(changeType) && (processList.contains(process) && "EntityInput".equals(audittrial) || atCWPNums.contains(audittrial) && "ERAdj".equals(process))) {
                return false;
            }
            Set<String> specialCTNumbers = this._ctx.getEffCombChecker().getSpecialCTNumbers();
            IDNumberTreeNode org = this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
            IDNumberTreeNode scene = this.getMember(DimTypesEnum.SCENARIO.getNumber(), comb.get(DimTypesEnum.SCENARIO.getNumber()));
            IDNumberTreeNode year = this.getMember(DimTypesEnum.YEAR.getNumber(), comb.get(DimTypesEnum.YEAR.getNumber()));
            IDNumberTreeNode period = this.getMember(DimTypesEnum.PERIOD.getNumber(), comb.get(DimTypesEnum.PERIOD.getNumber()));
            Set<String> cys = ConvertServiceHelper.getAllConvertTargetCurNumSet(this.getModelId(), scene.getId(), year.getId(), period.getId(), org.getId());
            if ("PC".equals(currencyNum) || currencyNum.equals(parentC) && !selfC.equals(parentC) || cys.contains(currencyNum)) {
                if ("RAdj".equals(process) && atCWPNums.contains(audittrial)) {
                    return false;
                }
                boolean isBfly = "BFLY".equals(changeType);
                if (specialCTNumbers.contains(changeType) || isBfly) {
                    if (atCWPNums.contains(audittrial) && "ERAdj".equals(process)) {
                        return false;
                    }
                    if (isBfly && processList.contains(process) && "EntityInput".equals(audittrial)) {
                        return false;
                    }
                    if (processList.contains(process) && "EntityInput".equals(audittrial) && !parentC.equals(currencyNum)) {
                        return false;
                    }
                }
                return true;
            }
            if (specialCTNumbers.contains(changeType) && processList.contains(process) && "EntityInput".equals(audittrial) && currency.equals(parentC) && !currency.equals(selfC)) {
                return true;
            }
        } else if (comb != null) {
            String process = comb.get(DimTypesEnum.PROCESS.getNumber());
            String currency = comb.get(DimTypesEnum.CURRENCY.getNumber());
            String atNumber = comb.get(DimTypesEnum.AUDITTRIAL.getNumber());
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)comb.get(DimTypesEnum.ENTITY.getNumber()));
            kd.fi.bcm.common.Pair<String, String> pair = TransMemberUtil.transOrgAndCurbyOrgId(this.getModelId(), (long)orgNode.getId(), process, currency, 0L, 0L);
            currency = (String)pair.p2;
            if (currency.equals(orgNode.getCurrency()) && this.checkEcLock(process, atNumber)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkEcLock(String process, String atNumber) {
        return "IRpt".equals(process) && "EntityInput".equals(atNumber) || "RAdj".equals(process) && this._ctx.getEffCombChecker().getAtCWPNums().contains(atNumber);
    }

    private Pair<String, String> getCurrencyNumberDynaByOrgId(long orgId) {
        IDNumberTreeNode org = this.findNodeById(DimTypesEnum.ENTITY.getNumber(), orgId);
        return new Pair((Object)org.getCurrency(), (Object)org.getParent().getCurrency());
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.PCControl.getCode();
    }
}

