/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class DataFlowControlStatusAccess
extends AbstractBizStatusAccess {
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private boolean lockAll = false;
    private boolean isstop = false;
    private String modelNum;
    private Long modelId;
    private String color;
    private Map<String, McStatus> mcStatusMap = new HashMap<String, McStatus>(16);

    public DataFlowControlStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        this.modelNum = this._ctx.getQueryCommandInfo().getModelNumber();
        this.modelId = MemberReader.findModelIdByNum((String)this.modelNum);
        this.initMcStatus();
        boolean[] bool = this.checkPageViewCurrencyStatus();
        boolean issubmit0 = bool[0];
        this.isstop = bool[1];
        boolean isArchive = bool[2];
        if (issubmit0) {
            this.color = isArchive ? "#808080" : "#C5D9F1";
            this.lockAll = true;
            if (this.lockAll) {
                this.stopPreData();
            }
        }
    }

    private void initMcStatus() {
        HashSet<Long> scenarioIds = new HashSet<Long>(16);
        HashSet<Long> yearIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        QueryStatusCommandInfo queryCommandInfo = this._ctx.getQueryCommandInfo();
        ArrayList dims = Lists.newArrayList((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.ENTITY.getNumber()});
        dims.retainAll(queryCommandInfo.getFixDimension().keySet());
        if (dims.size() == 4) {
            scenarioIds.add(this.getMemberId(DimTypesEnum.SCENARIO.getNumber()));
            yearIds.add(this.getMemberId(DimTypesEnum.YEAR.getNumber()));
            periodIds.add(this.getMemberId(DimTypesEnum.PERIOD.getNumber()));
            orgIds.add(this.getMemberId(DimTypesEnum.ENTITY.getNumber()));
        } else {
            queryCommandInfo.iterateCrossDims(comb -> comb.forEach((k, v) -> {
                if (DimTypesEnum.SCENARIO.getNumber().equals(k)) {
                    this.addDimMems(scenarioIds, (String)k, (String)v);
                }
                if (DimTypesEnum.YEAR.getNumber().equals(k)) {
                    this.addDimMems(yearIds, (String)k, (String)v);
                }
                if (DimTypesEnum.PERIOD.getNumber().equals(k)) {
                    this.addDimMems(periodIds, (String)k, (String)v);
                }
                if (DimTypesEnum.ENTITY.getNumber().equals(k)) {
                    this.addDimMems(orgIds, (String)k, (String)v);
                }
            }));
        }
        this.mcStatusMap = MergeStatusHelper.batchGetMcStatus4Periods(this.modelId, scenarioIds, yearIds, periodIds, orgIds);
    }

    private void addDimMems(Set<Long> ids, String dimNum, String memNum) {
        IDNumberTreeNode treeNode = this.getMember(dimNum, memNum);
        if (treeNode != null && treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            ids.add(treeNode.getId());
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.lockAll) {
            this.setColor(comb, this.color);
            return true;
        }
        if (!this.isstop) {
            return this.checkRowColCurrencyStatus(comb);
        }
        return false;
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.DataFlowControl.getCode();
    }

    private boolean[] checkPageViewCurrencyStatus() {
        String modelNum = this._ctx.getQueryCommandInfo().getModelNumber();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        boolean issubmit0 = false;
        boolean isstop = false;
        boolean isArchive = false;
        if (!(this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.ENTITY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.CURRENCY.getNumber()))) {
            return new boolean[]{issubmit0, isstop, isArchive};
        }
        IDNumberTreeNode orgTreeNode = this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber());
        long orgId = orgTreeNode == null || orgTreeNode == IDNumberTreeNode.NotFoundTreeNode ? 0L : orgTreeNode.getId();
        long scenarioId = this.getMemberId(DimTypesEnum.SCENARIO.getNumber());
        long yearId = this.getMemberId(DimTypesEnum.YEAR.getNumber());
        long periodId = this.getMemberId(DimTypesEnum.PERIOD.getNumber());
        String currencyNum = this.getMemberNumber(DimTypesEnum.CURRENCY.getNumber());
        if (StringUtils.isEmpty((String)currencyNum)) {
            return new boolean[]{issubmit0, isstop, isArchive};
        }
        String orgCurrencyNum = null;
        if (orgId != 0L) {
            orgCurrencyNum = orgTreeNode.getCurrency();
        }
        McStatus mcStatus = this.getMcStatus(orgId, scenarioId, yearId, periodId);
        isArchive = mcStatus.getArchive().isArchive();
        if ("DC".equals(currencyNum) || "EC".equals(currencyNum) || currencyNum.equals(orgCurrencyNum)) {
            if (modelId != 0L && orgId != 0L && scenarioId != 0L && yearId != 0L && periodId != 0L) {
                isstop = true;
                issubmit0 = mcStatus.getFlow().isSubmit();
            } else {
                isstop = false;
                issubmit0 = false;
            }
        } else if (this.getParentCurrencyNum(orgId) != null) {
            isstop = true;
            issubmit0 = this.getMcStatus(orgId, scenarioId, yearId, periodId).getPcFlow().isSubmit();
        } else {
            isstop = true;
            issubmit0 = false;
        }
        return new boolean[]{issubmit0, isstop, isArchive};
    }

    private boolean checkRowColCurrencyStatus(Map<String, String> cell) {
        boolean issubmit = false;
        boolean isArchive = false;
        IDNumberTreeNode orgTreeNode = this.getMember(PresetConstant.ENTITY_DIM, cell.get(PresetConstant.ENTITY_DIM));
        long orgId0 = orgTreeNode == null || orgTreeNode == IDNumberTreeNode.NotFoundTreeNode ? 0L : orgTreeNode.getId();
        long scenarioId0 = this.getMemberId(PresetConstant.SCENE_DIM, cell.get(PresetConstant.SCENE_DIM));
        long yearId0 = this.getMemberId(PresetConstant.FY_DIM, cell.get(PresetConstant.FY_DIM));
        long periodId0 = this.getMemberId(PresetConstant.PERIOD_DIM, cell.get(PresetConstant.PERIOD_DIM));
        String currencyNum0 = cell.get(PresetConstant.CURRENCY_DIM);
        String orgCurrencyNum = null;
        String orgParentCurrencyNum = this.getParentCurrencyNum(orgId0);
        if (orgId0 != 0L) {
            orgCurrencyNum = orgTreeNode.getCurrency();
        }
        McStatus mcStatus = this.getMcStatus(orgId0, scenarioId0, yearId0, periodId0);
        isArchive = mcStatus.getArchive().isArchive();
        if (StringUtils.isNotEmpty((String)currencyNum0) && ("EC".equals(currencyNum0) || currencyNum0.equals(orgCurrencyNum))) {
            issubmit = mcStatus.getFlow().isSubmit();
        } else if (StringUtils.isNotEmpty((String)currencyNum0) && ("PC".equals(currencyNum0) || currencyNum0.equals(orgParentCurrencyNum))) {
            issubmit = mcStatus.getPcFlow().isSubmit();
        }
        if (isArchive || issubmit) {
            String color = isArchive ? "#808080" : "#C5D9F1";
            this.setColor(cell, color);
            return true;
        }
        return false;
    }

    private McStatus getMcStatus(long orgId, Object scenarioId, Object yearId, Object periodId) {
        IDNumberTreeNode treeNode = this.findNodeById(DimTypesEnum.ENTITY.getNumber(), orgId);
        String key = String.join((CharSequence)"_", String.valueOf(scenarioId), String.valueOf(yearId), String.valueOf(periodId), treeNode.getNumber());
        McStatus mcStatus = this.mcStatusMap.get(key);
        if (mcStatus == null) {
            mcStatus = McStatus.getMcStatus(this.modelId, orgId, scenarioId, yearId, periodId);
            this.mcStatusMap.put(key, mcStatus);
        }
        return mcStatus;
    }

    public static McStatus getMcStatus(Object modelId, Object orgId, Object scenarioId, Object yearId, Object periodId) {
        return (McStatus)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)("getMc" + modelId), orgId, new Object[]{scenarioId, yearId, periodId}), () -> McStatus.getMcStatus(modelId, orgId, scenarioId, yearId, periodId));
    }

    private String getParentCurrencyNum(Long orgId) {
        IDNumberTreeNode numberTreeNode = this.findNodeById(DimTypesEnum.ENTITY.getNumber(), orgId);
        if (numberTreeNode != null && numberTreeNode.getId() != -1L && numberTreeNode.getParent() != null) {
            return numberTreeNode.getParent().getCurrency();
        }
        return null;
    }
}

