/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.Map;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class DataStageArchiveAccess
extends AbstractBizStatusAccess {
    private boolean isStageArchive = false;
    private boolean isSYPInPV = false;

    public DataStageArchiveAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        super.doPrePareData();
        this.isStageArchive = this.isStageArchive_PV();
        this.isSYPInPV = this.checkSYPInPV();
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.isStageArchive) {
            return true;
        }
        if (!this.isSYPInPV) {
            try {
                String sceneNum = comb.get(DimTypesEnum.SCENARIO.getNumber());
                String yearNum = comb.get(DimTypesEnum.YEAR.getNumber());
                String periodNum = comb.get(DimTypesEnum.PERIOD.getNumber());
                return this.isStageArchive(sceneNum, yearNum, periodNum);
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.DataStageArchiveAccess.getCode();
    }

    private boolean isStageArchive_PV() {
        if (!this.checkSYPInPV()) {
            return false;
        }
        long scenarioId = this.getMemberId(DimTypesEnum.SCENARIO.getNumber());
        long yearId = this.getMemberId(DimTypesEnum.YEAR.getNumber());
        long periodId = this.getMemberId(DimTypesEnum.PERIOD.getNumber());
        String sceneNum = MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)scenarioId).getNumber();
        String yearNum = MemberReader.findFyMemberById((Long)this.getModelId(), (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)periodId).getNumber();
        boolean existArchiving = this.isStageArchive(sceneNum, yearNum, periodNum);
        return existArchiving;
    }

    private boolean isStageArchive(String sceneNum, String yearNum, String periodNum) {
        boolean existArchiving = LockScopeServiceHelper.isExistArchiving(this.getModelId(), sceneNum, yearNum, periodNum);
        return existArchiving;
    }

    private boolean checkSYPInPV() {
        return this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber());
    }
}

