/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.dimension.datalock.LockScope;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class DataStageStatusAccess
extends AbstractBizStatusAccess {
    private boolean isHasLockDim = false;
    private String dimNum = "";

    public DataStageStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        super.doPrePareData();
        this.dimNum = LockScopeServiceHelper.getLockDimNumber_HasEmpty(this.getModelId());
        this.isHasLockDim = !this.dimNum.isEmpty() && !IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(this.dimNum);
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (!this.isHasLockDim) {
            return false;
        }
        try {
            String sceneNum = comb.get(DimTypesEnum.SCENARIO.getNumber());
            String yearNum = comb.get(DimTypesEnum.YEAR.getNumber());
            String periodNum = comb.get(DimTypesEnum.PERIOD.getNumber());
            String orgNum = comb.get(DimTypesEnum.ENTITY.getNumber());
            IDNumberTreeNode orgTreeNode = this.getMember(DimTypesEnum.ENTITY.getNumber(), orgNum);
            String cyNum = comb.get(DimTypesEnum.CURRENCY.getNumber());
            String lockDimMemb = comb.get(this.dimNum);
            return this.hasLock(orgTreeNode.getNumber(), sceneNum, yearNum, periodNum, cyNum, lockDimMemb);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return false;
        }
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.DataStageStatusAccess.getCode();
    }

    public boolean hasLock(String entityNum, String sceneNum, String yearNum, String periodNum, String cyNum, String lockDimMemb) {
        HashSet years = Sets.newHashSet((Object[])new String[]{yearNum});
        HashSet periods = Sets.newHashSet((Object[])new String[]{periodNum});
        HashSet cys = Sets.newHashSet((Object[])new String[]{cyNum});
        LockScope lockScope = LockScopeServiceHelper.queryLockScope(this.getModelId(), sceneNum, years, periods, cys);
        Pair<Boolean, List<Pair<String, String>>> lock = lockScope.isLock(yearNum, periodNum, cyNum, entityNum, lockDimMemb);
        return (Boolean)lock.p1 != false && lock.p2 != null && !((List)lock.p2).isEmpty();
    }
}

