/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class ExtBizAccess
extends AbstractBizStatusAccess {
    private boolean isNotDetailedLabelOrg = false;
    private static Set<String> inputATs = Sets.newHashSet((Object[])new String[]{"EntityInput", "DataCollection"});
    private Set<String> cwpAt;

    public ExtBizAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        QueryStatusCommandInfo queryCommandInfo = this._ctx.getQueryCommandInfo();
        Map<String, String> fixDimension = queryCommandInfo.getFixDimension();
        DynamicObjectCollection atDoc = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number,datasource", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId())});
        this.cwpAt = atDoc.stream().filter(d -> d.getString("datasource").equals(DataSourceEnum.TABLEADJUSTMENT.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet());
        if (this.isLeafOrLabel(DimTypesEnum.ENTITY.getNumber(), fixDimension.get(DimTypesEnum.ENTITY.getNumber()))) {
            this.isNotDetailedLabelOrg = true;
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        IDNumberTreeNode org = this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
        IDNumberTreeNode scene = this.getMember(DimTypesEnum.SCENARIO.getNumber(), comb.get(DimTypesEnum.SCENARIO.getNumber()));
        IDNumberTreeNode year = this.getMember(DimTypesEnum.YEAR.getNumber(), comb.get(DimTypesEnum.YEAR.getNumber()));
        IDNumberTreeNode period = this.getMember(DimTypesEnum.PERIOD.getNumber(), comb.get(DimTypesEnum.PERIOD.getNumber()));
        String currencyNum = this.getFixDimension().get(DimTypesEnum.CURRENCY.getNumber());
        if (currencyNum.equals("DC") || currencyNum.equals("EC")) {
            currencyNum = comb.get(DimTypesEnum.CURRENCY.getNumber());
        }
        BaseData baseData = new BaseData((Long)this.getModelId(), scene, year, period);
        boolean isAutoConvert = ExchangeQueryHelper.getAutoConvertByOrg(baseData, SimpleVo.newOne(org));
        String processNumber = comb.get(DimTypesEnum.PROCESS.getNumber());
        String at = comb.get(DimTypesEnum.AUDITTRIAL.getNumber());
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)comb.get(DimTypesEnum.ENTITY.getNumber()));
        boolean isEC = currencyNum.equals(orgNode.getCurrency());
        Pair<String, String> pair = TransMemberUtil.transOrgAndCurbyOrgId(this.getModelId(), (long)orgNode.getId(), processNumber, currencyNum, 0L, 0L);
        boolean isPOrg = this.isNotDetailedLabelOrg;
        boolean isInMerge = this._ctx.getQueryCommandInfo().isBizGroupInMerge();
        if (!isPOrg && "EIRpt".equals(processNumber) && isEC && inputATs.contains(at)) {
            return false;
        }
        if (isPOrg && "EIRpt".equals(processNumber) && isEC && inputATs.contains(at) && !isInMerge) {
            return false;
        }
        if (!isPOrg && "IRpt".equals(processNumber) && !isEC && inputATs.contains(at) && !isAutoConvert) {
            return false;
        }
        if (isPOrg && "IRpt".equals(processNumber) && !isEC && inputATs.contains(at) && !isAutoConvert && !isInMerge) {
            return false;
        }
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(this.getModelId(), scene.getId(), year.getId(), period.getId());
        String mdSource = mdsMap.get(orgNode.getId());
        if (isPOrg && MergeDataSourceEnum.CSTE.getIndex().equals(mdSource) && isInMerge && "EIRpt".equals(processNumber) && "EntityInput".equals(at) && isEC) {
            return false;
        }
        if ("ERAdj".equals(processNumber) && this.cwpAt.contains(at)) {
            return false;
        }
        return !"RAdj".equals(processNumber) || !this.cwpAt.contains(at);
    }

    public boolean isLeafOrLabel(String dimNumber, String memNum) {
        return (Boolean)ThreadCache.get((Object)("lf" + dimNumber + memNum), () -> {
            IDNumberTreeNode member = this.getMember(dimNumber, memNum);
            return !member.isLeaf() || StorageTypeEnum.LABEL == member.getStorageType();
        });
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ExtBizControl.getCode();
    }
}

