/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;

public class ICVersionControlAccess
extends AbstractBizStatusAccess {
    boolean isCheckICVer = false;
    boolean isPYICINPV = false;
    boolean isEffectiveICVer = false;
    BasePointInnerLineInfo icLineInfo = null;
    Table<BasePointInnerLineInfo, String, Set<String>> lineInfo2PY2NumScopes = HashBasedTable.create();

    public ICVersionControlAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        if (this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.INTERCOMPANY.getNumber())) {
            this.isPYICINPV = true;
            String sceneNum = this.getFixDimension().get(DimTypesEnum.SCENARIO.getNumber());
            String yearNum = this.getFixDimension().get(DimTypesEnum.YEAR.getNumber());
            String periodNum = this.getFixDimension().get(DimTypesEnum.PERIOD.getNumber());
            String icNum = this.getFixDimension().get(DimTypesEnum.INTERCOMPANY.getNumber());
            long sceneId = MemberReader.findScenaMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)sceneNum).getId();
            long yearId = MemberReader.findFyMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)yearNum).getId();
            long periodId = MemberReader.findPeriodMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)periodNum).getId();
            VersionParam verParam = new VersionParam(this.getModelId(), sceneId, yearId, periodId);
            IDNumberTreeNode icNode = MemberReader.findMemberByNumber((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)"InternalCompany", (String)icNum);
            Set<Long> inValidIC = ICVersionServiceHelper.getInvalidIdByParent(verParam);
            if (icNode == IDNumberTreeNode.NotFoundTreeNode) {
                return;
            }
            this.isEffectiveICVer = !inValidIC.contains(icNode.getId());
            return;
        }
        boolean hasPY = false;
        if (!this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) || !this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber())) {
            hasPY = true;
        }
        if (this._ctx.getPointInfo() != null) {
            for (BasePointInnerLineInfo lineInfo : this._ctx.getPointInfo().getBasePointInnerLineInfo()) {
                if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(lineInfo.getDimension().getNumber()) || !hasPY) continue;
                this.isCheckICVer = true;
                this.icLineInfo = lineInfo;
            }
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.isPYICINPV) {
            return !this.isEffectiveICVer;
        }
        if (!this.isCheckICVer) {
            return false;
        }
        if (this.icLineInfo == null) {
            return false;
        }
        String sceneNum = comb.get(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = comb.get(DimTypesEnum.YEAR.getNumber());
        String periodNum = comb.get(DimTypesEnum.PERIOD.getNumber());
        long sceneId = MemberReader.findScenaMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)sceneNum).getId();
        long yearId = MemberReader.findFyMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)yearNum).getId();
        long periodId = MemberReader.findPeriodMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)periodNum).getId();
        VersionParam verParam = new VersionParam(this.getModelId(), sceneId, yearId, periodId);
        Set icVerNumbers = new HashSet(16);
        for (DynaMembScopeInfo scope : this.icLineInfo.getDynaMembScopes()) {
            if (this.lineInfo2PY2NumScopes.get((Object)this.icLineInfo, (Object)(yearNum + periodNum)) != null) {
                icVerNumbers = (Set)this.lineInfo2PY2NumScopes.get((Object)this.icLineInfo, (Object)(yearNum + periodNum));
                continue;
            }
            MembRangeItem item = new MembRangeItem(scope.getMember().getDimension().getUqCode(), (Long)((DimMember)scope.getMember()).getId(), scope.getMember().getNumber(), RangeEnum.getRangeByVal((int)scope.getRangeId()), scope.isCustom(), (Object)this.getModelId());
            HashSet numbers = new HashSet(16);
            item.matchItem4Ic(verParam, c -> numbers.add(c.getNumber()));
            this.lineInfo2PY2NumScopes.put((Object)this.icLineInfo, (Object)(yearNum + periodNum), numbers);
            icVerNumbers = numbers;
        }
        String icNum = comb.get(DimTypesEnum.INTERCOMPANY.getNumber());
        return !icVerNumbers.contains(icNum);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ICVersionControlAccess.getCode();
    }
}

