/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.dimension.helper.InitPeriodServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.PeriodUtils;

public class InitPeriodStatusAccess
extends AbstractBizStatusAccess {
    private boolean readyTolockAll = false;
    private boolean checkSingle = false;
    private boolean isEcOrCnyCurrency;
    private boolean isInitPeriod;
    private boolean isFirstPeriod;
    private boolean isExistChangeType = MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId()));

    public InitPeriodStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.InitPeriodControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        if (this.getFixDimension().containsKey(DimTypesEnum.CURRENCY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.ENTITY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PROCESS.getNumber())) {
            this.isInitPeriod = this.isInitPeriod();
            this.isFirstPeriod = this.isFirstPeriod();
            String selectCurrency = this.getMemberNumber(DimTypesEnum.CURRENCY.getNumber());
            String localCurrency = OrgCurrencyServiceHelper.getOrgModelAndCurrency(this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber()).getId(), this.getMemberNumber(DimTypesEnum.YEAR.getNumber()), this.getMemberFromFixDim(DimTypesEnum.PERIOD.getNumber()).getId()).getString("currency.number");
            if (CurrencyEnum.DC.number.equals(selectCurrency)) {
                HashSet<Long> orgIdSet = new HashSet<Long>(16);
                orgIdSet.add(this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber()).getId());
                HashSet<String> proNumSet = new HashSet<String>(16);
                proNumSet.add(this.getMemberNumber(DimTypesEnum.PROCESS.getNumber()));
                Table<Long, String, String> currencyTableByOrgIdAndProNum = TransMemberUtil.getCurrencyTableByOrgIdAndProNum(orgIdSet, proNumSet, this._ctx.getQueryCommandInfo().getModelNumber());
                selectCurrency = (String)currencyTableByOrgIdAndProNum.get((Object)this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber()).getId(), (Object)this.getMemberNumber(DimTypesEnum.PROCESS.getNumber()));
            }
            if (selectCurrency != null && localCurrency != null) {
                this.isEcOrCnyCurrency = CurrencyEnum.EC.number.equals(selectCurrency) || selectCurrency.equals(localCurrency);
                this.readyTolockAll = true;
            }
        } else {
            this.checkSingle = true;
        }
    }

    @Override
    public boolean doCheckSingle(Map<String, String> comb) {
        if (this.readyTolockAll) {
            String changetypeNum = comb.get(DimTypesEnum.CHANGETYPE.getNumber());
            if (this.isExistChangeType && "BOP".equals(changetypeNum)) {
                return !this.isEcOrCnyCurrency || !this.isInitPeriod || this.isFirstPeriod;
            }
            return false;
        }
        if (this.checkSingle) {
            String currency = comb.get(DimTypesEnum.CURRENCY.getNumber());
            String entity = comb.get(DimTypesEnum.ENTITY.getNumber());
            String scenario = comb.get(DimTypesEnum.SCENARIO.getNumber());
            String year = comb.get(DimTypesEnum.YEAR.getNumber());
            String period = comb.get(DimTypesEnum.PERIOD.getNumber());
            String changetype = comb.get(DimTypesEnum.CHANGETYPE.getNumber());
            long orgId = this.getMemberId(PresetConstant.ENTITY_DIM, entity);
            long scenarioId = this.getMemberId(PresetConstant.SCENE_DIM, scenario);
            long periodId = this.getMemberId(PresetConstant.PERIOD_DIM, period);
            String localCurrency = this.findNodeById(DimTypesEnum.ENTITY.getNumber(), orgId).getCurrency();
            boolean isEcOrCnyCurrency = CurrencyEnum.EC.number.equals(currency) || currency.equals(localCurrency);
            boolean isInitPeriod = this.isInitPeriod(orgId, scenarioId, year, periodId);
            boolean isFirstPeriod = PeriodUtils.isFirstPeriod((String)period);
            if (this.isExistChangeType && "BOP".equals(changetype)) {
                return !isEcOrCnyCurrency || !isInitPeriod || isFirstPeriod;
            }
        }
        return false;
    }

    private boolean isInitPeriod(long orgId, long scenarioId, String year, long periodId) {
        return (Boolean)BcmThreadCache.get((Object)"InitPeriod", (Object)scenarioId, (Object)year, (Object)orgId, () -> InitPeriodServiceHelper.isInitPeriod(this.getModelId(), orgId, scenarioId, year, periodId));
    }

    private boolean isInitPeriod() {
        long orgId = this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber()).getId();
        long scenarioId = this.getMemberFromFixDim(DimTypesEnum.SCENARIO.getNumber()).getId();
        String selectYearNum = this.getMemberNumber(DimTypesEnum.YEAR.getNumber());
        long selectPeriodId = this.getMemberFromFixDim(DimTypesEnum.PERIOD.getNumber()).getId();
        return InitPeriodServiceHelper.isInitPeriod(this.getModelId(), orgId, scenarioId, selectYearNum, selectPeriodId);
    }

    private boolean isFirstPeriod() {
        String selectPeriodNum = this.getMemberNumber(DimTypesEnum.PERIOD.getNumber());
        return PeriodUtils.isFirstPeriod((String)selectPeriodNum);
    }
}

