/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.access.SceneAndChangetypeModel;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateDimEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class InnerLogicGenerateStatusAccess
extends AbstractBizStatusAccess {
    private boolean lockAll;
    private boolean isneedlock;
    private Map<String, String> sceneMem;
    private Set<String> accountTypeMap;
    private SceneAndChangetypeModel sceneandchangetype;

    public InnerLogicGenerateStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.InnerLogicGenerate.getCode();
    }

    public SceneAndChangetypeModel getSceneandchangetype() {
        if (this.sceneandchangetype == null) {
            this.querySceneAndChangetypeOfPageView();
        }
        return this.sceneandchangetype;
    }

    @Override
    protected void doPrePareData() {
        SceneAndChangetypeModel scmodel = this.getSceneandchangetype();
        this.lockAll = scmodel.isLockAll();
        if (this.lockAll) {
            this.stopPreData();
        }
        this.isneedlock = scmodel.isNeedLock();
        if (!this.lockAll && this.isneedlock) {
            this.sceneMem = scmodel.getSceneMem();
        }
    }

    @Override
    public boolean doCheckSingle(Map<String, String> comb) {
        if (this.lockAll) {
            return true;
        }
        if (this.isneedlock) {
            String dchangetype = this.sceneMem.get(comb.get(DimTypesEnum.SCENARIO.getNumber()));
            String changetypeNum = comb.get(DimTypesEnum.CHANGETYPE.getNumber());
            String accountNum = comb.get(DimTypesEnum.ACCOUNT.getNumber());
            if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId())) && (DChangeTypeEnum.YTD.getIndex().equals(dchangetype) && "CurrentPeriod".equals(changetypeNum) || DChangeTypeEnum.CurrentPeriods.getIndex().equals(dchangetype) && "YTD".equals(changetypeNum))) {
                if (DChangeTypeEnum.YTD.getIndex().equals(dchangetype)) {
                    if (this.getAccountType() != null) {
                        return this.getAccountType().contains(accountNum);
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private void querySceneAndChangetypeOfPageView() {
        QFilter qfroot;
        QFilter qfmodel;
        DynamicObjectCollection dot;
        this.sceneandchangetype = new SceneAndChangetypeModel();
        this._ctx.getQueryCommandInfo().getFixDimension().forEach((dimenNum, memNum) -> {
            if (DimTypesEnum.SCENARIO.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setSceneInWhere(TemplateDimEnum.View);
                this.sceneandchangetype.setSceneMemNum((String)memNum);
                QFilter numberqf = new QFilter("number", "=", memNum);
                QFilter modelqf = new QFilter("model", "=", (Object)this.getModelId());
                DynamicObject dot = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"dchangetype", (QFilter[])new QFilter[]{numberqf, modelqf});
                if (dot != null) {
                    String dchangetype = dot.getString("dchangetype");
                    this.sceneandchangetype.setSceneMemenum(dchangetype.equals("0") ? DChangeTypeEnum.YTD : (dchangetype.equals("1") ? DChangeTypeEnum.CurrentPeriods : DChangeTypeEnum.All));
                }
                if (DChangeTypeEnum.All == this.sceneandchangetype.getSceneMemenum()) {
                    this.sceneandchangetype.setNeedLock(false);
                }
            } else if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setChangetypeInWhere(TemplateDimEnum.View);
                this.sceneandchangetype.setChangeTypeMemNum((String)memNum);
                if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId())) && !this.sceneandchangetype.getChangeTypeMemNum().equals("CurrentPeriod") && !this.sceneandchangetype.getChangeTypeMemNum().equals("YTD") && !this.sceneandchangetype.getChangeTypeMemNum().equals("BFLY")) {
                    this.sceneandchangetype.setNeedLock(false);
                }
            }
        });
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId())) && (DChangeTypeEnum.YTD == this.sceneandchangetype.getSceneMemenum() && "CurrentPeriod" == this.sceneandchangetype.getChangeTypeMemNum() || DChangeTypeEnum.CurrentPeriods == this.sceneandchangetype.getSceneMemenum() && "YTD" == this.sceneandchangetype.getChangeTypeMemNum())) {
            this.sceneandchangetype.setLockAll(true);
        }
        if (this.sceneandchangetype.isNeedLock() && !this.sceneandchangetype.isLockAll() && (dot = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"number,dchangetype", (QFilter[])new QFilter[]{qfmodel = new QFilter("model", "=", (Object)this.getModelId()), qfroot = new QFilter("level", "!=", (Object)1)})) != null) {
            HashMap<String, String> sceneMember = new HashMap<String, String>(16);
            for (DynamicObject scene : dot) {
                sceneMember.put(scene.getString("number"), scene.getString("dchangetype"));
            }
            this.sceneandchangetype.setSceneMem(sceneMember);
        }
    }

    public Set<String> getAccountType() {
        if (this.accountTypeMap == null) {
            this.accountTypeMap = new HashSet<String>(16);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            qfBuilder.add(new QFilter("accounttype", "in", Arrays.asList(AccountTypeEnum.LOSS.index, AccountTypeEnum.CASHFLOW.index)));
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dy : dys) {
                this.accountTypeMap.add(dy.getString("number"));
            }
        }
        return this.accountTypeMap;
    }
}

