/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.report.ReportContextProvider;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class InputMemberAccess
extends AbstractBizStatusAccess {
    private Set<String> adjustAt;
    private Set<String> adjustBp;
    private IDNumberTreeNode fixOrg;
    private Table<String, String, String> assoMembs;
    private boolean isCheckRedirect = true;

    public InputMemberAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.InputMemberControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        DynamicObjectCollection atDoc = ReportContextProvider.getDataSourceAT(this.getModelId());
        DynamicObjectCollection bpDoc = ReportContextProvider.getDataSourceBp(this.getModelId());
        this.adjustAt = atDoc.stream().filter(d -> d.getString("datasource").equals(DataSourceEnum.ENTRYADJUSTMENT.getOIndex())).map(m -> m.getString("number")).collect(Collectors.toSet());
        this.adjustBp = bpDoc.stream().filter(d -> d.getString("datasource").equals("2")).map(m -> m.getString("number")).collect(Collectors.toSet());
        if (this._ctx.isCommonDimsIncludeDim(DimTypesEnum.ENTITY.getNumber())) {
            String par_sonNum = (String)this._ctx.getQueryCommandInfo().getCommonDims().get(DimTypesEnum.ENTITY.getNumber())[1];
            String orgRealNum = (String)ThreadCache.get((Object)("on" + par_sonNum), () -> MemberReader.findMemberByNumber((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
            this.assoMembs = (Table)ThreadCache.get((Object)("assoMembInModel" + this.getModelId()), () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg(this._ctx.getQueryCommandInfo().getModelNumber(), orgRealNum));
        } else {
            this.assoMembs = HashBasedTable.create();
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        IDNumberTreeNode org;
        String at = comb.get(DimTypesEnum.AUDITTRIAL.getNumber());
        String process = comb.get(DimTypesEnum.PROCESS.getNumber());
        String currency = comb.get(DimTypesEnum.CURRENCY.getNumber());
        if (this.assoMembs.contains((Object)DimTypesEnum.PROCESS.getNumber(), (Object)process)) {
            process = (String)this.assoMembs.get((Object)DimTypesEnum.PROCESS.getNumber(), (Object)process);
        }
        if (this.assoMembs.contains((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)at)) {
            at = (String)this.assoMembs.get((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)at);
        }
        IDNumberTreeNode orgNode = this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
        Pair<String, String> pair = TransMemberUtil.getTransOrgAndCurbyOrgId(orgNode, orgNode.getModelId(), process, currency);
        currency = (String)pair.p2;
        if (this._ctx.getEffCombChecker().getAtCWPNums().contains(at)) {
            return !"ERAdj".equals(process) && (!"RAdj".equals(process) || currency.equals(orgNode.getCurrency()));
        }
        if ("RAdj".equals(process)) {
            return !"CWP".equals(at) || currency.equals(orgNode.getCurrency());
        }
        if ("IRpt".equals(process)) {
            return !this._ctx.getEffCombChecker().checkAtCanWrite(at) || currency.equals(orgNode.getCurrency());
        }
        IDNumberTreeNode iDNumberTreeNode = org = this.fixOrg != null ? this.fixOrg : this.getMember(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
        if (!this._ctx.getEffCombChecker().checkBpCanWrite(org.isLeaf(), process)) {
            return true;
        }
        return this.adjustAt.contains(at) || this.adjustBp.contains(process);
    }
}

