/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.bizstatus.access.AbstractPermissionStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.cache.MemPermClassCacheManager;
import kd.fi.bcm.business.permission.cache.MembPermCacheManager;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.lang.StringUtils;

public class NoPermAccess
extends AbstractPermissionStatusAccess {
    private boolean checkMGStatus = false;
    private boolean lockAll = false;
    long currUserId = RequestContext.get().getCurrUserId();

    public NoPermAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.NoPermControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        String cube = this._ctx.getQueryCommandInfo().getModelNumber();
        if (this._ctx.getQueryCommandInfo().getFormulaCal() && StringUtils.isNotEmpty((String)cube)) {
            this.prePareDataForFormulaCal(cube);
            return;
        }
        super.doPrePareData();
        if (this.unControl) {
            return;
        }
        if (Objects.nonNull(this._ctx.getQueryCommandInfo().getCommonDims()) && ((Boolean)ThreadCache.get((Object)("checkMGStatus_" + this.currUserId + this.getModelId()), () -> BcmFunPermissionHelper.needCheckMGStatus(this.currUserId, this.getModelId()))).booleanValue()) {
            this.checkMGStatus = true;
            this.lockAll = !this.checkOrgDcStatus();
        } else if (!this._ctx.getQueryCommandInfo().getFixDimension().isEmpty()) {
            this.lockAll = this.doCheckSingle(this._ctx.getQueryCommandInfo().getFixDimension());
        }
    }

    private void prePareDataForFormulaCal(String cube) {
        Long modelId = MemberReader.findModelIdByNum((String)cube);
        if (MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId))) {
            this.unControl = true;
            return;
        }
        this.permMng = (MembPermCacheManager)ThreadCache.get((Object)("getPermMng" + modelId), () -> new MembPermCacheManager(modelId));
        this.permClass = (MemPermClassCacheManager)ThreadCache.get((Object)("getPermClass" + modelId), () -> new MemPermClassCacheManager(modelId));
        this.cache = (Map)ThreadCache.get((Object)("getCache" + modelId), () -> new HashMap(16));
        this.pack = new AbstractPermissionStatusAccess.PermTypePack();
        this.pack.permType = PermEnum.READWRITE;
    }

    private boolean checkOrgDcStatus() {
        Map<String, Object[]> commonDims = this._ctx.getQueryCommandInfo().getCommonDims();
        if (Objects.nonNull(commonDims) && !commonDims.isEmpty()) {
            long orgId = (Long)commonDims.get(DimTypesEnum.ENTITY.getNumber())[0];
            long scearioId = (Long)commonDims.get(DimTypesEnum.SCENARIO.getNumber())[0];
            long yearId = (Long)commonDims.get(DimTypesEnum.YEAR.getNumber())[0];
            long periodId = (Long)commonDims.get(DimTypesEnum.PERIOD.getNumber())[0];
            return this.getMcStatus(MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber()), orgId, scearioId, yearId, periodId).getFlow().isSubmit();
        }
        return false;
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        boolean isNoPerm;
        if (this.unControl) {
            return false;
        }
        AbstractPermissionStatusAccess.PermTypePack tempPack = this.pack.copyPack();
        this.cycleComparedPermType(comb, tempPack);
        boolean bl = isNoPerm = PermEnum.NOPERM == tempPack.permType;
        if (isNoPerm) {
            return isNoPerm;
        }
        if (this.checkMGStatus || this.lockAll) {
            return this.lockAll;
        }
        return isNoPerm;
    }

    public void encryptedSpreadModel(SpreadManager sm) {
        Set postionInfoSet;
        ViewPointDimDomain viewPointDomain = sm.getFilter().getViewPointDomain();
        PageDimDomain pageDomain = sm.getFilter().getPageDomain();
        if (viewPointDomain != null) {
            for (IDimMember member : viewPointDomain.getAllMembers()) {
                this._ctx.getQueryCommandInfo().addFixDimension(member.getDimension().getNumber(), member.getNumber());
            }
        }
        if (pageDomain != null) {
            for (IDimMember member : pageDomain.getAllMembers()) {
                this._ctx.getQueryCommandInfo().addFixDimension(member.getDimension().getNumber(), member.getNumber());
            }
        }
        this.doPrePareData();
        if (this.unControl || this.checkMGStatus && !this.lockAll) {
            return;
        }
        if (!this.lockAll) {
            HashMap crossFilter = new HashMap(16);
            sm.getBook().getSheet(0).iteratorCells(c -> {
                if (c.isMdDataDomain() && c.getMemberFromUserObject() != null) {
                    for (IDimMember member : c.getMemberFromUserObject()) {
                        crossFilter.put(member.getDimension().getNumber(), member.getNumber());
                    }
                    if (this.doCheckSingle(crossFilter)) {
                        c.setValue((Object)"******");
                    }
                }
                crossFilter.clear();
            });
        }
        if (this.lockAll && !(postionInfoSet = sm.getAreaManager().getPostionInfoSet()).isEmpty()) {
            postionInfoSet.forEach(e -> sm.getBook().getSheet(0).iteratorRangeCells(new RangeModel(e.getAreaRange()), c -> {
                if (c.isMdDataDomain() || Objects.nonNull(e.getExtendInfo())) {
                    c.setValue((Object)"******");
                }
            }));
        }
        ThreadCache.remove((Object)("checkMGStatus_" + this.currUserId + this.getModelId()));
        ThreadCache.remove((Object)("checkMGStatus_noperm_" + this.currUserId + this.getModelId()));
    }

    private McStatus getMcStatus(Object modelId, Object orgId, Object scenarioId, Object yearId, Object periodId) {
        return (McStatus)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)("getMc" + modelId), orgId, new Object[]{scenarioId, yearId, periodId}), () -> McStatus.getMcStatus(modelId, orgId, scenarioId, yearId, periodId));
    }
}

