/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class PeriodManageStatusAccess
extends AbstractBizStatusAccess {
    private boolean lockAll;
    private boolean notControl;
    private Set<String> orgNumbers;
    private Set<Long> sceneIds;
    private Set<Long> yearIds;
    private Set<Long> periodIds;
    private Map<String, Boolean> isOpenMap;

    public PeriodManageStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.PeriodManageControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        if (!ConfigServiceHelper.getBoolParam(this._ctx.getQueryCommandInfo().getModelNumber(), "CM012")) {
            this.notControl = true;
            return;
        }
        long modelId = MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber());
        if (this.getFixDimension().containsKey(DimTypesEnum.ENTITY.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.SCENARIO.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.YEAR.getNumber()) && this.getFixDimension().containsKey(DimTypesEnum.PERIOD.getNumber())) {
            String orgNumber = this.getMemberNumber(DimTypesEnum.ENTITY.getNumber());
            long sceneId = this.getMemberId(DimTypesEnum.SCENARIO.getNumber());
            long yearId = this.getMemberId(DimTypesEnum.YEAR.getNumber());
            long periodId = this.getMemberId(DimTypesEnum.PERIOD.getNumber());
            boolean isOpen = PeriodSettingHelper.checkPeriodStatus(modelId, this.getOrgRealNum(orgNumber), sceneId, yearId, periodId, "datastatus");
            if (!isOpen) {
                this.lockAll = true;
                this.stopPreData();
            }
            this.notControl = true;
        } else {
            this.orgNumbers = new HashSet<String>(16);
            this.sceneIds = new HashSet<Long>(16);
            this.yearIds = new HashSet<Long>(16);
            this.periodIds = new HashSet<Long>(16);
            if (this.getFixDimension().containsKey(DimTypesEnum.ENTITY.getNumber())) {
                this.orgNumbers.add(this.getOrgRealNum(this.getMemberNumber(DimTypesEnum.ENTITY.getNumber())));
            }
            this.sceneIds.add(this.getMemberId(PresetConstant.SCENE_DIM));
            this.yearIds.add(this.getMemberId(PresetConstant.FY_DIM));
            this.periodIds.add(this.getMemberId(PresetConstant.PERIOD_DIM));
        }
    }

    @Override
    public void beforeCheckSingle(Map<String, String> comb) {
        if (this.notControl || this.lockAll) {
            return;
        }
        comb.forEach((dimNum, memNum) -> {
            if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                this.orgNumbers.add(this.getOrgRealNum((String)memNum));
            } else if (PresetConstant.SCENE_DIM.equals(dimNum)) {
                this.sceneIds.add(this.getMemberId(PresetConstant.SCENE_DIM, (String)memNum));
            } else if (PresetConstant.FY_DIM.equals(dimNum)) {
                this.yearIds.add(this.getMemberId(PresetConstant.FY_DIM, (String)memNum));
            } else if (PresetConstant.PERIOD_DIM.equals(dimNum)) {
                this.periodIds.add(this.getMemberId(PresetConstant.PERIOD_DIM, (String)memNum));
            }
        });
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        long periodId;
        long yearId;
        if (this.lockAll) {
            return true;
        }
        if (this.notControl) {
            return false;
        }
        String orgNumber = comb.get(PresetConstant.ENTITY_DIM);
        long sceneId = this.getMemberId(PresetConstant.SCENE_DIM, comb.get(PresetConstant.SCENE_DIM));
        Boolean isOpen = this.getIsOpen(sceneId, yearId = this.getMemberId(PresetConstant.FY_DIM, comb.get(PresetConstant.FY_DIM)), periodId = this.getMemberId(PresetConstant.PERIOD_DIM, comb.get(PresetConstant.PERIOD_DIM)), orgNumber);
        return isOpen == false;
    }

    private Boolean getIsOpen(long sceneId, long yearId, long periodId, String orgNumber) {
        return (Boolean)BcmThreadCache.get((Object)"OpenMap", (Object)sceneId, (Object)yearId, (Object)periodId, (Object)orgNumber, () -> {
            String key = String.format("%s_%s_%s_%s", this.getOrgRealNum(orgNumber), sceneId, yearId, periodId);
            return this.getIsOpenMap().getOrDefault(key, Boolean.FALSE);
        });
    }

    public Map<String, Boolean> getIsOpenMap() {
        if (this.isOpenMap == null) {
            this.isOpenMap = PeriodSettingHelper.batchCheckPeriodStatus(this.getModelId(), this.orgNumbers, this.sceneIds, this.yearIds, this.periodIds, "datastatus");
        }
        return this.isOpenMap;
    }
}

