/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.access.IBizStatusAccess;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class RedirectMemberAccess
extends AbstractBizStatusAccess {
    private Table<String, String, String> assoMembs;
    private boolean isFixdimHasRedictMemb = false;
    private Pair<Object, Set<String>> isOpen2ExtOrgs;
    private List<IBizStatusAccess> list = new ArrayList<IBizStatusAccess>(10);

    public RedirectMemberAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        super.doPrePareData();
        Map<String, String> fixDimension = this.getFixDimension();
        if (this._ctx.isCommonDimsIncludeDim(DimTypesEnum.ENTITY.getNumber())) {
            boolean isCWP;
            String par_sonNum = (String)this._ctx.getQueryCommandInfo().getCommonDims().get(DimTypesEnum.ENTITY.getNumber())[1];
            String orgRealNum = (String)ThreadCache.get((Object)("on" + par_sonNum), () -> MemberReader.findMemberByNumber((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)DimTypesEnum.ENTITY.getNumber(), (String)par_sonNum).getNumber());
            boolean bl = isCWP = "CWP".equals(fixDimension.get(DimTypesEnum.AUDITTRIAL.getNumber())) && "ERAdj".equals(fixDimension.get(DimTypesEnum.PROCESS.getNumber()));
            if (isCWP) {
                ThreadCache.remove((Object)("assoMembInModel" + this.getModelId()));
                this.assoMembs = (Table)ThreadCache.get((Object)("assoMembInModel" + this.getModelId()), () -> AssoStorageMemUtil.getAllAssoMembers(this._ctx.getQueryCommandInfo().getModelNumber()));
            } else {
                this.assoMembs = (Table)ThreadCache.get((Object)("assoMembInModel" + this.getModelId()), () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg(this._ctx.getQueryCommandInfo().getModelNumber(), orgRealNum));
            }
            this.isOpen2ExtOrgs = (Pair)ThreadCache.get((Object)"isOpen2ExtOrgs", () -> ConfigServiceHelper.getCfgWithExpOrg(this.getModelId(), "CM043"));
            for (Map.Entry<String, String> dim2Memb : fixDimension.entrySet()) {
                if (!this.assoMembs.contains((Object)dim2Memb.getKey(), (Object)dim2Memb.getValue())) continue;
                this.isFixdimHasRedictMemb = true;
            }
        } else {
            this.assoMembs = HashBasedTable.create();
        }
    }

    @Override
    public void addOtherAccess(List<IBizStatusAccess> acclist) {
        for (IBizStatusAccess iBizStatusAccess : acclist) {
            for (Integer code : BizStatusServer.hasRedirectMember) {
                if (iBizStatusAccess.getStatusCode() != code.intValue()) continue;
                this.list.add(iBizStatusAccess);
            }
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        HashMap<String, String> newComb = new HashMap<String, String>(comb);
        boolean isHasRedirectMemb = false;
        for (Map.Entry entry : newComb.entrySet()) {
            String newValue = (String)this.assoMembs.get(entry.getKey(), entry.getValue());
            if (newValue == null) {
                newComb.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            isHasRedirectMemb = true;
            newComb.put((String)entry.getKey(), newValue);
        }
        if (!this.assoMembs.isEmpty() && isHasRedirectMemb) {
            for (IBizStatusAccess iBizStatusAccess : this.list) {
                boolean ischeck = iBizStatusAccess.checkSingle(newComb);
                if (!ischeck) continue;
                this.twiceMark(comb);
            }
            for (Map.Entry entry : comb.entrySet()) {
                if (!this.assoMembs.contains(entry.getKey(), entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.RedirectMemberAccess.getCode();
    }
}

