/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.Arrays;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.enums.ReportStatusEnum;

public class ReportStatusControlStatusAccess
extends AbstractBizStatusAccess {
    private static final String REPORTSTATUS = "reportstatus";
    private boolean lockAll = false;

    public ReportStatusControlStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        long reportId = this._ctx.getQueryCommandInfo().getReportId();
        if (reportId != 0L) {
            QFilter filter = new QFilter("id", "=", (Object)reportId);
            this.lockAll = this.checkReportStatus(filter);
            if (this.lockAll) {
                this.stopPreData();
            }
        }
    }

    private boolean checkReportStatus(QFilter filter) {
        return (Boolean)ThreadCache.get((Object)"ReportStatusControlStatusAccess+checkReportStatus", () -> {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_reportentity", (String)REPORTSTATUS, (QFilter[])filter.toArray());
            return dynamicObject != null && Arrays.asList(ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()).contains(dynamicObject.getString(REPORTSTATUS));
        });
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ReportStatusControl.getCode();
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        return this.lockAll;
    }
}

