/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class ValidCalAccountAccess
extends AbstractBizStatusAccess {
    private Set<String> isCalAccount;

    public ValidCalAccountAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ValidCalAccControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        long modelId = MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber());
        this.isCalAccount = new HashSet<String>(16);
        QFilter[] filter = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("iscaltype", "=", (Object)Character.valueOf('1'))};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_accountmembertree", (String)"number,iscaltype", (QFilter[])filter, null);){
            for (Row d : ds) {
                this.isCalAccount.add(d.getString("number"));
            }
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        String accNumber = comb.get(DimTypesEnum.ACCOUNT.getNumber());
        if (accNumber != null) {
            return this.isCalAccount.contains(accNumber);
        }
        return false;
    }
}

