/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class ValidCrossStatusAccess
extends AbstractBizStatusAccess {
    private boolean preData;
    private String modelNum;
    private Set<String> accNumbers;
    private Map<String, String> dimensionMap;
    private Map<String, String> dimModelMap;
    private Map<List<String>, Map<String, List<String>>> accMemMap;
    private boolean unControl;

    public ValidCrossStatusAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ValidCrossControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        this.accNumbers = new HashSet<String>(16);
    }

    @Override
    public void beforeCheckSingle(Map<String, String> comb) {
        String accNumber = comb.get(DimTypesEnum.ACCOUNT.getNumber());
        if (accNumber != null) {
            this.accNumbers.add(accNumber);
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        this.preData();
        if (this.unControl) {
            return false;
        }
        String accNumber = comb.get(DimTypesEnum.ACCOUNT.getNumber());
        if (accNumber != null) {
            IDNumberTreeNode accMemberByNumber = this.getMember(PresetConstant.ACCOUNT_DIM, accNumber);
            String accId = accMemberByNumber.getId().toString();
            for (Map.Entry<List<String>, Map<String, List<String>>> entryAccMemMap : this.accMemMap.entrySet()) {
                Map<String, List<String>> getMemMap;
                if (!entryAccMemMap.getKey().contains(accId) || (getMemMap = entryAccMemMap.getValue()) == null) continue;
                for (Map.Entry<String, List<String>> entry : getMemMap.entrySet()) {
                    String dimNumber = comb.get(this.dimensionMap.get(entry.getKey()));
                    List<String> dimNumbers = entry.getValue();
                    if (dimNumbers.contains(dimNumber)) continue;
                    return true;
                }
            }
        }
        return this.filterCancelMergeDataByUnitOrg(comb);
    }

    private boolean filterCancelMergeDataByUnitOrg(Map<String, String> comb) {
        String processNumber;
        String par_sonNum = comb.get(DimTypesEnum.ENTITY.getNumber());
        IDNumberTreeNode member = this.getMember(DimTypesEnum.ENTITY.getNumber(), par_sonNum);
        Map cancelMergeDataByUnitOrg = (Map)ThreadCache.get((Object)("vcscmd" + comb.get(DimTypesEnum.SCENARIO.getNumber()) + comb.get(DimTypesEnum.YEAR.getNumber()) + comb.get(DimTypesEnum.PERIOD.getNumber()) + member.getParent().getId()), () -> MergeControlHelper.getIfMergeMapByParentOrgId(this.getModelId(), this.getMemberId(DimTypesEnum.SCENARIO.getNumber(), (String)comb.get(DimTypesEnum.SCENARIO.getNumber())), (String)comb.get(DimTypesEnum.YEAR.getNumber()), this.getMemberId(DimTypesEnum.PERIOD.getNumber(), (String)comb.get(DimTypesEnum.PERIOD.getNumber())), member.getParent().getId()));
        if (!cancelMergeDataByUnitOrg.isEmpty() && cancelMergeDataByUnitOrg.containsKey(member.getNumber()) && !((Boolean)cancelMergeDataByUnitOrg.get(member.getNumber())).booleanValue() && (processNumber = comb.get(DimTypesEnum.PROCESS.getNumber())) != null) {
            return "CCTotal".equalsIgnoreCase(processNumber) || "CCADJ".equalsIgnoreCase(processNumber) || "CC".equalsIgnoreCase(processNumber) || "EJE".equalsIgnoreCase(processNumber) || "PRPT".equalsIgnoreCase(processNumber) || "CADJ".equalsIgnoreCase(processNumber) || "ARPT".equalsIgnoreCase(processNumber) || "ADJ".equalsIgnoreCase(processNumber);
        }
        return false;
    }

    private void preData() {
        if (!this.preData) {
            this.preData = true;
            QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
            ArrayList<String> accMenberIds = new ArrayList<String>(16);
            this.modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            ((Map)MemberReader.getAllNodeByNumberFromCache((String)"bcm_accountmembertree", (String)this.modelNum).get(DimTypesEnum.ACCOUNT.getNumber())).forEach((k, v) -> {
                if (this.accNumbers.contains(k)) {
                    accMenberIds.add(Long.toString(v.getId()));
                }
            });
            if (accMenberIds.size() == 0) {
                this.unControl = true;
            }
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,membermodel", (QFilter[])new QFilter[]{modelFilter});
            this.dimensionMap = new HashMap<String, String>(16);
            this.dimModelMap = new HashMap<String, String>(16);
            for (DynamicObject dimension : dimensions) {
                this.dimensionMap.put(dimension.getString("id"), dimension.getString("number"));
                this.dimModelMap.put(dimension.getString("id"), dimension.getString("membermodel"));
            }
            String sql = "SELECT fid, fdim, fval FROM t_bcm_structofaccount_dm WHERE fid in (" + ValidCrossStatusAccess.getPlaceholder(accMenberIds) + ")";
            DataSet dataSet = DB.queryDataSet((String)"t_bcm_structofaccount_dm", (DBRoute)BCMConstant.DBROUTE, (String)sql);
            this.accMemMap = new HashMap<List<String>, Map<String, List<String>>>(16);
            for (Row ds : dataSet) {
                HashMap memMap = new HashMap(16);
                ArrayList<String> accIddim = new ArrayList<String>(16);
                String accId = ds.getString("fid");
                String dim = ds.getString("fdim");
                String val = ds.getString("fval");
                if (StringUtils.isEmpty((String)val)) continue;
                JSONArray array = JSON.parseArray((String)val);
                ArrayList dimNumberList = new ArrayList(16);
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject jsonObjDim = array.getJSONObject(i);
                    String dimNumber = jsonObjDim.getString("number");
                    String scopeStr = jsonObjDim.getString("scope");
                    String pid = jsonObjDim.getString("pid");
                    String id = jsonObjDim.getString("id");
                    IDNumberTreeNode accMemberByNumber = MemberReader.findMemberByNumber((String)this.modelNum, (String)this.dimensionMap.get(dim), (String)dimNumber);
                    String longNumber = accMemberByNumber.getLongNumber();
                    int scope = Integer.parseInt(scopeStr);
                    boolean isCustom = !StringUtils.isEmpty((String)pid);
                    long mId = Long.parseLong(id);
                    MembRangeItem item = new MembRangeItem(this.dimModelMap.get(dim), (Long)mId, longNumber, dimNumber, scope, isCustom, (Object)this.getModelId());
                    item.matchItems(c -> dimNumberList.add(c.number));
                }
                if (dimNumberList.size() > 0) {
                    memMap.put(dim, dimNumberList);
                }
                accIddim.add(accId);
                accIddim.add(dim);
                this.accMemMap.put(accIddim, memMap);
            }
        }
    }

    private static String getPlaceholder(List<String> ids) {
        if (ids.isEmpty()) {
            return "0";
        }
        StringBuilder strId = new StringBuilder();
        for (String str : ids) {
            strId.append('\'');
            strId.append(str);
            strId.append("',");
        }
        return strId.substring(0, strId.length() - 1);
    }
}

