/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;

public class ValidEntityAcess
extends AbstractBizStatusAccess {
    private Map<String, List<String>> validOrgListMap = Maps.newHashMapWithExpectedSize((int)16);
    private boolean unControl;

    public ValidEntityAcess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.ValidEntityControl.getCode();
    }

    @Override
    protected void doPrePareData() {
        super.doPrePareData();
        QueryStatusCommandInfo comm = this._ctx.getQueryCommandInfo();
        Map<String, String> fixDimension = comm.getFixDimension();
        if (fixDimension.containsKey(DimEntityNumEnum.YEAR.getNumber()) && fixDimension.containsKey(DimEntityNumEnum.PERIOD.getNumber()) && !fixDimension.containsKey(DimTypesEnum.ENTITY.getNumber())) {
            this.unControl = true;
            return;
        }
        List<String> yearMembers = comm.getDimMembers(DimEntityNumEnum.YEAR.getNumber());
        List<String> periodMembers = comm.getDimMembers(DimEntityNumEnum.PERIOD.getNumber());
        List<String> sceneMembers = comm.getDimMembers(DimEntityNumEnum.SCENARIO.getNumber());
        List<String> orgMembers = comm.getDimMembers(DimEntityNumEnum.ENTITY.getNumber());
        ArrayList<Long> orgids = new ArrayList<Long>(orgMembers.size());
        for (String org : orgMembers) {
            orgids.add(this.getMember(DimEntityNumEnum.ENTITY.getNumber(), org).getId());
        }
        for (String yearNum : yearMembers) {
            for (String periodNum : periodMembers) {
                for (String sceneNum : sceneMembers) {
                    Long periodId = MemberReader.findPeriodMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)periodNum).getId();
                    Long sceneId = MemberReader.findScenaMemberByNum((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)sceneNum).getId();
                    List<Long> idList = EntityVersioningUtil.getOrgsByVersion(this.getModelId(), sceneId, yearNum, periodId, orgids);
                    ArrayList<String> number = new ArrayList<String>(idList.size());
                    for (long id : idList) {
                        number.add(MemberReader.findEntityMemberById((String)this._ctx.getQueryCommandInfo().getModelNumber(), (Long)id).getParent_SonNumber());
                    }
                    this.validOrgListMap.put(yearNum + "|" + periodNum + "|" + sceneNum, number);
                }
            }
        }
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        if (this.unControl) {
            return false;
        }
        String yearNum = DimEntityNumEnum.YEAR.getNumber();
        String periodNum = DimEntityNumEnum.PERIOD.getNumber();
        String sceneNum = DimEntityNumEnum.SCENARIO.getNumber();
        String key = comb.get(yearNum) + "|" + comb.get(periodNum) + "|" + comb.get(sceneNum);
        String org = comb.get(DimEntityNumEnum.ENTITY.getNumber());
        List<String> entities = this.validOrgListMap.get(key);
        return !CollectionUtils.isEmpty(entities) && entities.contains(org);
    }
}

