/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.access.adjust;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizstatus.access.AbstractBizStatusAccess;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class AdjustNotDetailedLabelBizAccess
extends AbstractBizStatusAccess {
    private Set<String> exchangeRateOrgInfo;
    private boolean isNotDetailedLabelForFix = false;
    private boolean isOrgInFix = false;
    private Set<String> orgNumbers = new HashSet<String>(4);
    private boolean isConInput = ConfigServiceHelper.getBoolParam(this._ctx.getQueryCommandInfo().getModelNumber(), "isConInput");
    private Table<String, String, String> assoMembs;

    public AdjustNotDetailedLabelBizAccess(BizStatusContext ctx) {
        super(ctx);
    }

    @Override
    protected void doPrePareData() {
        QueryStatusCommandInfo queryCommandInfo = this._ctx.getQueryCommandInfo();
        Map<String, String> fixDimension = queryCommandInfo.getFixDimension();
        if (fixDimension.containsKey(DimTypesEnum.ENTITY.getNumber())) {
            if (DimTypesEnum.ENTITY.getNumber().equals(this.getMemberFromFixDim(DimTypesEnum.ENTITY.getNumber()).getNumber())) {
                this.isNotDetailedLabelForFix = true;
                this.stopPreData();
            } else {
                this.isOrgInFix = true;
                this.orgNumbers.add(fixDimension.get(DimTypesEnum.ENTITY.getNumber()));
            }
        }
        if (this._ctx.isCommonDimsIncludeDim(DimTypesEnum.ENTITY.getNumber())) {
            this.assoMembs = (Table)ThreadCache.get((Object)("assoMembInModel" + this.getModelId() + "_adjust"), () -> AssoStorageMemUtil.getAllAssoMembersExcludeOrg(this._ctx.getQueryCommandInfo().getModelNumber(), null));
            for (Map.Entry<String, String> dim2Memb : fixDimension.entrySet()) {
                if (!this.assoMembs.contains((Object)dim2Memb.getKey(), (Object)dim2Memb.getValue())) continue;
                fixDimension.put(dim2Memb.getKey(), (String)this.assoMembs.get((Object)dim2Memb.getKey(), (Object)dim2Memb.getValue()));
            }
        } else {
            this.assoMembs = HashBasedTable.create();
        }
        WatchLoggerUtil.debug(this.log, "assoMembs_" + this.assoMembs);
        this.isNotDetailedLabelForFix = this.isOrgInFix ? fixDimension.entrySet().stream().filter(f -> !DimTypesEnum.ENTITY.getNumber().equals(f.getKey())).anyMatch(f -> this.isLeafOrLabel((String)f.getKey(), (String)f.getValue())) : fixDimension.entrySet().stream().anyMatch(f -> this.isLeafOrLabel((String)f.getKey(), (String)f.getValue()));
    }

    @Override
    public void beforeCheckSingle(Map<String, String> comb) {
        if (!this.isNotDetailedLabelForFix && !this.isOrgInFix) {
            this.orgNumbers.add(comb.get(DimTypesEnum.ENTITY.getNumber()));
        }
    }

    public boolean isLeafOrLabel(String dimNumber, String memNum) {
        if ("Entity".equals(dimNumber)) {
            return false;
        }
        return (Boolean)ThreadCache.get((Object)("lf" + dimNumber + memNum), () -> {
            IDNumberTreeNode member = this.getMember(dimNumber, this.assoMembs.get((Object)dimNumber, (Object)memNum) == null ? memNum : (String)this.assoMembs.get((Object)dimNumber, (Object)memNum));
            return !member.isLeaf() || StorageTypeEnum.LABEL == member.getStorageType();
        });
    }

    @Override
    protected boolean doCheckSingle(Map<String, String> comb) {
        return (Boolean)BcmThreadCache.get((Object)"CM045", (Object)ChildConfigEnum.WRITENOLEAF.getBusinesstypevalue(), (Object)this._ctx.getQueryCommandInfo().getModelNumber(), () -> ConfigServiceHelper.getBoolChildParam(MemberReader.findModelIdByNum((String)this._ctx.getQueryCommandInfo().getModelNumber()), "CM045", ChildConfigEnum.WRITENOLEAF.getBusinesstypevalue())) == false && this.doCheckSingleParent(comb);
    }

    private boolean doCheckSingleParent(Map<String, String> comb) {
        if (this.isNotDetailedLabelForFix || this.isOrgInFixAndExchangeRateOrg()) {
            return true;
        }
        Map<String, String> fixDimension = this.getFixDimension();
        Map<String, String> rowColDimension = comb.entrySet().stream().filter(c -> !fixDimension.containsKey(c.getKey()) && c.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean isNotDetailedLabelForRowCol = this.isOrgInFix ? rowColDimension.entrySet().stream().anyMatch(rc -> {
            if (((String)rc.getKey()).equals("Extends")) {
                return false;
            }
            return this.isLeafOrLabel((String)rc.getKey(), (String)rc.getValue());
        }) : rowColDimension.entrySet().stream().anyMatch(rc -> !DimTypesEnum.ENTITY.getNumber().equals(rc.getKey()) && this.isLeafOrLabel((String)rc.getKey(), (String)rc.getValue()));
        if (isNotDetailedLabelForRowCol) {
            return true;
        }
        this.createOrgIsExchangeRateOrg();
        String orgNumber = comb.get(DimTypesEnum.ENTITY.getNumber());
        boolean isExchangeRateOrg = this.isExchangeRateOrg(orgNumber);
        if (isExchangeRateOrg) {
            return true;
        }
        String processNumber = comb.get(DimTypesEnum.PROCESS.getNumber());
        String at = comb.get(DimTypesEnum.AUDITTRIAL.getNumber());
        if (this.assoMembs.contains((Object)DimTypesEnum.PROCESS.getNumber(), (Object)processNumber)) {
            processNumber = (String)this.assoMembs.get((Object)DimTypesEnum.PROCESS.getNumber(), (Object)processNumber);
        }
        if (this.assoMembs.contains((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)at)) {
            at = (String)this.assoMembs.get((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)at);
        }
        if ("EIRpt".equals(processNumber) && this._ctx.getEffCombChecker().getAtInputNums().contains(at) && this.isConInput) {
            return false;
        }
        return this.isLeafOrLabel(DimTypesEnum.ENTITY.getNumber(), comb.get(DimTypesEnum.ENTITY.getNumber()));
    }

    private boolean isOrgInFixAndExchangeRateOrg() {
        if (this.isOrgInFix) {
            this.createOrgIsExchangeRateOrg();
            Map<String, String> fixDimension = this.getFixDimension();
            return this.isExchangeRateOrg(fixDimension.get(DimTypesEnum.ENTITY.getNumber()));
        }
        return false;
    }

    private void createOrgIsExchangeRateOrg() {
        if (this.exchangeRateOrgInfo == null) {
            this.exchangeRateOrgInfo = new HashSet<String>();
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            HashSet numbers = new HashSet(16);
            this.orgNumbers.stream().forEach(number -> {
                String trueNumber = number;
                if (number.contains("_")) {
                    trueNumber = number.split("_")[1];
                }
                numbers.add(trueNumber);
            });
            qFilter.and("number", "in", numbers);
            qFilter.and("isexchangerate", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"number,isexchangerate", (QFilter[])new QFilter[]{qFilter});
            orgs.forEach(org -> this.exchangeRateOrgInfo.add(org.getString("number")));
        }
    }

    private boolean isExchangeRateOrg(String orgNumber) {
        String trueNumber = orgNumber;
        if (trueNumber.contains("_")) {
            trueNumber = orgNumber.split("_")[1];
        }
        return this.exchangeRateOrgInfo.contains(trueNumber);
    }

    private boolean isAllowEntryForMergeEntity(Map<String, String> comb) {
        return comb.entrySet().stream().anyMatch(e -> {
            String dimNum = (String)e.getKey();
            String memNum = (String)e.getValue();
            if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimNum) && this._ctx.getEffCombChecker().getOwnLogicCTMembers().contains(memNum)) {
                return false;
            }
            if (DimEntityNumEnum.isMergeDim((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum))) {
                return MemberReader.getNoMergeMembers((String)this._ctx.getQueryCommandInfo().getModelNumber(), (String)dimNum).contains(memNum);
            }
            return false;
        });
    }

    @Override
    public int getStatusCode() {
        return BizStatusAccessFactory.StatusCodeEnum.MemberSelfControl.getCode();
    }
}

