/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.bizstatus.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.common.collect.WithFixMemCrossModel;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class QueryStatusCommandInfo
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(QueryStatusCommandInfo.class);
    private Function<Map<String, String>, String> keyPacker;
    private WithFixMemCrossModel crossMembModel = new WithFixMemCrossModel();

    public QueryStatusCommandInfo() {
    }

    public boolean isExitFixMemCross() {
        return this.crossMembModel.size() != 0;
    }

    public QueryStatusCommandInfo(String modelNumber) {
        this.put("modelNumber", modelNumber);
    }

    public Function<Map<String, String>, String> getKeyPacker() {
        if (this.keyPacker == null) {
            this.setKeyPacker(membs -> {
                StringBuilder sb = new StringBuilder();
                this.getCrossDimensions().forEach((? super T dim) -> sb.append((String)membs.get(dim)));
                return sb.toString();
            });
        }
        return this.keyPacker;
    }

    public void setKeyPacker(Function<Map<String, String>, String> keyPacker) {
        this.keyPacker = keyPacker;
    }

    public String getModelNumber() {
        return (String)this.get("modelNumber");
    }

    public void setModelNumber(String modelNumber) {
        this.put("modelNumber", modelNumber);
    }

    public boolean isBizGroupInMerge() {
        return this.get("isBizGroupInMerge", false);
    }

    public void setBizGroupInMerge(boolean isMerge) {
        this.put("isBizGroupInMerge", isMerge);
    }

    public void setFormulaCal(boolean formulaCal) {
        this.put("isFormulaCal", formulaCal);
    }

    public boolean getFormulaCal() {
        return this.get("isFormulaCal", false);
    }

    public void setFromNeedSum(boolean isFromNeedSum) {
        this.put("isFromNeedSum", isFromNeedSum);
    }

    public boolean getFromNeedSum() {
        return this.get("isFromNeedSum", false);
    }

    public void addCommonDims(String dim, Long mid, String membNumber) {
        Map commonDims = (Map)this.computeIfAbsent("commonDims", k -> new HashMap(16));
        commonDims.put(dim, new Object[]{mid, membNumber});
    }

    public Map<String, Object[]> getCommonDims() {
        return (Map)this.get("commonDims");
    }

    public void iterateCrossDims(Consumer<Map<String, String>> consumer) {
        if (!this.hasCrossDims()) {
            HashMap map = new HashMap(this.crossMembModel.getFixDims());
            if (this.getCommonDims() != null) {
                Map<String, Object[]> commonDims = this.getCommonDims();
                commonDims.forEach((k, v) -> {
                    if (!map.containsKey(k)) {
                        map.put(k, v[1].toString());
                    }
                });
            }
            consumer.accept(map);
        } else {
            this.crossMembModel.iterateCrossDims(consumer);
        }
    }

    public Map<String, String> getCompCrossMembs(int index) {
        return this.crossMembModel.get(index);
    }

    public void addFixDimension(String dim, String member) {
        this.crossMembModel.addFixDimension(dim, member);
    }

    public Map<String, String> getFixDimension() {
        return this.crossMembModel.getFixDims();
    }

    public void setCrossDimensions(List<String> dimNums) {
        this.crossMembModel.setCrossDims(dimNums);
    }

    public List<String> getCrossDimensions() {
        return this.crossMembModel.getCrossDims();
    }

    public void addCrossMembers(List<String> cross) {
        this.crossMembModel.addCross(cross);
    }

    public void setBizStatusQueryTypes(List<Integer> types) {
        this.put("bizTypes", types);
    }

    public List<Integer> getBizStatusQueryTypes() {
        return (List)this.get("bizTypes");
    }

    public <T> T get(String key) {
        return (T)super.get(key);
    }

    public <T> T get(String key, T defaultVal) {
        return this.get(key) == null ? defaultVal : this.get(key);
    }

    public void setTemplateId(long id) {
        this.put("templateId", id);
    }

    public long getTemplateId() {
        return (Long)this.get("templateId");
    }

    public void setReportId(long id) {
        this.put("reportId", id);
    }

    public long getReportId() {
        Object reportId = this.get("reportId");
        if (reportId == null) {
            return 0L;
        }
        return (Long)reportId;
    }

    public List<String> getDimMembers(String dim) {
        return this.crossMembModel.getDimMembers(dim);
    }

    public boolean hasCrossDims() {
        return this.crossMembModel.size() != 0;
    }

    public String toJson() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static QueryStatusCommandInfo of(String json) {
        try {
            return (QueryStatusCommandInfo)JSONUtils.cast((String)json, QueryStatusCommandInfo.class);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static void main(String[] args) {
        QueryStatusCommandInfo comm = new QueryStatusCommandInfo("cube00001");
        comm.addFixDimension("dim1", "mem1");
        comm.addFixDimension("dim2", "mem2");
        comm.setCrossDimensions(Arrays.asList("d3", "d4", "d5", "d6"));
        comm.addCrossMembers(Arrays.asList("m3", "m4", "m5", "m6"));
        comm.addCrossMembers(Arrays.asList("m3-1", "m4-1", "m5-1", "m6-1"));
        comm.setBizStatusQueryTypes(Arrays.asList(1, 2, 3));
        comm.addCommonDims("Entity", 9999L, "BIZ0001");
        comm.addCommonDims("Account", 77777L, "R0001");
        comm.setTemplateId(1212L);
        String json = comm.toJson();
        System.out.println(json);
        comm = QueryStatusCommandInfo.of(json);
        System.out.println(comm.toJson());
        comm.iterateCrossDims(System.out::println);
    }
}

