/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.carry;

import java.util.HashSet;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class CarryContext {
    private Pair<Long, String> model;
    private Pair<Long, String> entity;
    private Pair<Long, String> scene;
    private Pair<Long, String> year;
    private Pair<Long, String> period;
    private Pair<Long, String> currency;
    private Set<String> changetypes;
    private Set<String> orgs;
    private Set<String> accounts;

    public CarryContext(Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> scene, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> currency) {
        this(model, entity, scene, year, period, currency, null);
    }

    public CarryContext(Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> scene, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> currency, Set<String> accounts) {
        this.model = model;
        this.entity = entity;
        this.scene = scene;
        this.year = year;
        this.period = period;
        this.currency = currency;
        this.accounts = accounts;
    }

    public CarryContext(Pair<Long, String> model, Pair<Long, String> entity, Pair<Long, String> scene, Pair<Long, String> year, Pair<Long, String> period, Pair<Long, String> currency, Set<String> orgs, Set<String> accounts, Set<String> changetypes) {
        this.model = model;
        this.entity = entity;
        this.scene = scene;
        this.year = year;
        this.period = period;
        this.currency = currency;
        this.orgs = orgs;
        this.accounts = accounts;
        this.changetypes = changetypes;
    }

    public CarryContext(Pair<Long, String> model, String entity, String scene, String year, String period, String currency, Set<String> orgs, Set<String> accounts, Set<String> changetypes) {
        this.model = model;
        this.entity = Pair.onePair(null, (Object)entity);
        this.scene = Pair.onePair(null, (Object)scene);
        this.year = Pair.onePair(null, (Object)year);
        this.period = Pair.onePair(null, (Object)period);
        this.currency = Pair.onePair(null, (Object)currency);
        this.orgs = orgs;
        this.accounts = accounts;
        this.changetypes = changetypes;
    }

    public Set<String> getOrgs() {
        return this.orgs;
    }

    public Pair<Long, String> getModel() {
        return this.model;
    }

    public Pair<Long, String> getEntity() {
        return this.entity;
    }

    public Pair<Long, String> getScene() {
        return this.scene;
    }

    public Pair<Long, String> getYear() {
        return this.year;
    }

    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    public void setModel(Pair<Long, String> model) {
        this.model = model;
    }

    public void setEntity(Pair<Long, String> entity) {
        this.entity = entity;
    }

    public void setScene(Pair<Long, String> scene) {
        this.scene = scene;
    }

    public void setYear(Pair<Long, String> year) {
        this.year = year;
    }

    public void setPeriod(Pair<Long, String> period) {
        this.period = period;
    }

    public void setCurrency(Pair<Long, String> currency) {
        this.currency = currency;
    }

    public Set<String> getAccounts() {
        if (this.accounts == null) {
            this.accounts = new HashSet<String>();
            QFBuilder qb = new QFBuilder();
            qb.add("accounttype", "!=", (Object)AccountTypeEnum.EXCHANGERATE.index);
            qb.add("model", "=", this.model.p1);
            QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getAccounts"), (String)"bcm_accountmembertree", (String)"number", (QFilter[])qb.toArray(), null).forEach(c -> this.accounts.add(c.getString("number")));
        }
        return this.accounts;
    }

    public void setAccounts(Set<String> accounts) {
        this.accounts = accounts;
    }

    public Set<String> getChangetypes() {
        return this.changetypes;
    }

    public void setChangetypes(Set<String> changetypes) {
        this.changetypes = changetypes;
    }

    public boolean isAvailable() {
        if (this.accounts == null || this.accounts.isEmpty()) {
            return false;
        }
        return this.orgs != null && !this.orgs.isEmpty();
    }
}

