/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.carry;

import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.enums.OlapSourceEnum;

public class CarryInfo {
    private String cubecatalog;
    private Map<String, String[]> filter;
    private RunScriptBuilder run;

    public CarryInfo(String cubecatalog) {
        this.cubecatalog = cubecatalog;
    }

    public void prepareRun() {
        this.run = new RunScriptBuilder(this.cubecatalog);
        this.filter.forEach((key, value) -> this.run.addDimensionScope((String)key, (String)value));
    }

    public void setOlapSourceType(OlapSourceEnum olapSourceEnum) {
        this.run.setSourceEnum(olapSourceEnum);
    }

    public void addOneRunExpress(PairList<String, String> targPairVParam, PairList<String, String> srcPairVParam) {
        this.run.appendV(targPairVParam);
        this.run.appendEqualSign();
        this.run.appendV(srcPairVParam);
        this.run.endRunExpress();
    }

    public void runVExpress() {
        this.run.runScript();
    }

    public void addFilter(String dimKey, String ... values) {
        if (this.filter == null) {
            this.filter = new HashMap<String, String[]>();
        }
        this.filter.put(dimKey, values);
    }

    public Map<String, String[]> getFilter() {
        return this.filter;
    }
}

