/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.carry;

import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.carry.CarryContext;
import kd.fi.bcm.business.carry.CarryInfo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.DataFromEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CarryServiceHelper {
    public static final List<String> CT_DATAFROMISNULL = Arrays.asList("BBOY", "BBOY01", "BBOY02", "BBOY03", "BBOY04", "BFLY", "BOP");
    private static final String SCOPE = "scope";
    private static final String KEY_SPLIT = "|";

    public static StringBuilder simpleCarry(long modelId, String cube, String lastScenario, String fyNum, String perNum, String scenario, String tarFyNum, String tarPerNum, Set<String> orgNums, Set<String> accountNums, String currency) {
        String[] mainAccounts;
        StringBuilder sb = new StringBuilder();
        HashSet<String> exchangeRateAccounts = new HashSet<String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(accountNums)) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter accountFilter = new QFilter("number", "in", accountNums);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number,accounttype", (QFilter[])new QFilter[]{modelFilter, accountFilter});
            HashSet<String> normalNums = new HashSet<String>();
            for (DynamicObject dyn : cols) {
                if (dyn.getString("accounttype") == null) continue;
                if (dyn.getString("accounttype").equals(AccountTypeEnum.EXCHANGERATE.index)) {
                    exchangeRateAccounts.add(dyn.getString("number"));
                    continue;
                }
                normalNums.add(dyn.getString("number"));
            }
            mainAccounts = normalNums.toArray(new String[0]);
        } else {
            mainAccounts = CarryServiceHelper.getAccount(modelId);
        }
        if (mainAccounts.length > 0) {
            boolean existChangeTypeDimension = MemberReader.isExistChangeTypeDimension((long)modelId);
            PairList targPairList = PairList.newWithParam((Object)DimTypesEnum.YEAR.getNumber(), (Object)tarFyNum);
            targPairList.addPair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)tarPerNum);
            if (existChangeTypeDimension) {
                targPairList.addPair((Object)DimTypesEnum.CHANGETYPE.getNumber(), (Object)"BFLY");
            }
            if (currency != null) {
                targPairList.addPair((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)currency);
            }
            CarryServiceHelper.doDeleteCWP(modelId, cube, scenario, tarFyNum, tarPerNum, orgNums, mainAccounts, currency);
            CarryServiceHelper.runCommonV(cube, lastScenario, scenario, fyNum, perNum, orgNums, currency, mainAccounts, existChangeTypeDimension, (PairList<String, String>)targPairList);
            Map<String, Map<String, List<String>>> carrySpecialSetting = CarryServiceHelper.getCarrySpecialSetting(cube, scenario, tarFyNum);
            Map<String, List<String>> specials = carrySpecialSetting.get(tarPerNum);
            if (specials != null) {
                HashMap<String, String> specialMap = new HashMap<String, String>(16);
                specials.forEach((key, val) -> {
                    if (!key.equals(perNum)) {
                        for (String v : val) {
                            Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                            HashSet entities = new HashSet(16);
                            HashSet accounts = new HashSet(16);
                            tempMapList.forEach((dim, scopes) -> {
                                HashMap<String, Integer> idScopeMap = new HashMap<String, Integer>(16);
                                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)scopes)) {
                                    scopes.forEach(map -> idScopeMap.put((String)map.get("id"), Integer.valueOf((String)map.get(SCOPE))));
                                }
                                if (dim.equals(SysDimensionEnum.Account.getSign())) {
                                    idScopeMap.forEach((id, scope) -> {
                                        String accountNum = MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)Long.valueOf(id)).getNumber();
                                        new MembRangeItem("bcm_accountmembertree", Long.valueOf(id), accountNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> accounts.add(c.number));
                                        sb.append(accountNum).append("@").append(RangeEnum.getRangeByVal((int)scope).getName()).append(",");
                                    });
                                } else if (dim.equals(SysDimensionEnum.Entity.getSign())) {
                                    idScopeMap.forEach((id, scope) -> {
                                        String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)Long.valueOf(id)).getNumber();
                                        new MembRangeItem("bcm_entitymembertree", Long.valueOf(id), entityNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> entities.add(c.number));
                                        sb.append(entityNum).append("@").append(RangeEnum.getRangeByVal((int)scope).getName()).append(",");
                                    });
                                }
                            });
                            Set specialEntities = entities;
                            HashSet<Object> specialAccounts = accounts;
                            HashSet<String> mainAs = new HashSet<String>(Arrays.asList(mainAccounts));
                            if (specialEntities.isEmpty()) {
                                specialEntities = orgNums;
                            }
                            if (specialAccounts.isEmpty()) {
                                specialAccounts = mainAs;
                            }
                            for (String entity : specialEntities) {
                                for (String string : specialAccounts) {
                                    if (!orgNums.contains(entity) || !mainAs.contains(string)) continue;
                                    specialMap.put(entity + KEY_SPLIT + string, (String)key);
                                }
                            }
                        }
                    }
                });
                if (specialMap.size() > 0) {
                    HashMap<String, Set> entPeriodAccounts = new HashMap<String, Set>(16);
                    specialMap.forEach((key, value) -> {
                        String[] splits = key.split("\\|");
                        String ent = splits[0];
                        String acc = splits[1];
                        entPeriodAccounts.putIfAbsent(ent + KEY_SPLIT + value, new HashSet());
                        ((Set)entPeriodAccounts.get(ent + KEY_SPLIT + value)).add(acc);
                    });
                    entPeriodAccounts.forEach((key, value) -> BatchProcessHelper.handleSync(() -> {
                        String[] splits = key.split("\\|");
                        CarryServiceHelper.runCommonV(cube, lastScenario, scenario, fyNum, splits[1], Collections.singleton(splits[0]), currency, value.toArray(new String[0]), existChangeTypeDimension, (PairList<String, String>)targPairList);
                    }));
                } else if (sb.length() > 0) {
                    sb.setLength(0);
                }
            }
        }
        HashMap<String, String> carrymap = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(accountNums)) {
            carrymap.put("ClosingRate", "BOYRate");
            carrymap.put("UserdefinedRate", "BOYUserdefinedRate");
            carrymap.put("AverageRate", "BOYAverageRate");
            CarryServiceHelper.handleUserDefineN(modelId, carrymap);
        } else if (!exchangeRateAccounts.isEmpty()) {
            if (exchangeRateAccounts.contains("BOYRate")) {
                carrymap.put("ClosingRate", "BOYRate");
            }
            if (exchangeRateAccounts.contains("BOYUserdefinedRate")) {
                carrymap.put("UserdefinedRate", "BOYUserdefinedRate");
            }
            if (exchangeRateAccounts.contains("BOYAverageRate")) {
                carrymap.put("AverageRate", "BOYAverageRate");
            }
        }
        if (!carrymap.isEmpty()) {
            HashMap exchangeScheme = new HashMap(16);
            QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("isexchangerate", "=", (Object)"1").toArray()).forEach(o -> exchangeScheme.put(o.getString("number"), o.getLong("id")));
            Set leftOrg = orgNums.stream().filter(exchangeScheme::containsKey).collect(Collectors.toSet());
            if (!leftOrg.isEmpty()) {
                CarryInfo info = CarryServiceHelper.getComCarryInfo(cube, scenario, exchangeScheme.keySet());
                info.prepareRun();
                info.setOlapSourceType(OlapSourceEnum.S2);
                carrymap.forEach((key, value) -> {
                    PairList targPairList = PairList.newWithParam((Object)DimTypesEnum.ACCOUNT.getNumber(), (Object)value);
                    targPairList.addPair((Object)DimTypesEnum.YEAR.getNumber(), (Object)tarFyNum);
                    targPairList.addPair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)tarPerNum);
                    PairList srcPairList = PairList.newWithParam((Object)DimTypesEnum.ACCOUNT.getNumber(), (Object)key);
                    srcPairList.addPair((Object)DimTypesEnum.SCENARIO.getNumber(), (Object)lastScenario);
                    srcPairList.addPair((Object)DimTypesEnum.YEAR.getNumber(), (Object)fyNum);
                    srcPairList.addPair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)perNum);
                    if (currency != null) {
                        targPairList.addPair((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)currency);
                        srcPairList.addPair((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)currency);
                    }
                    info.addOneRunExpress((PairList<String, String>)targPairList, (PairList<String, String>)srcPairList);
                });
                info.runVExpress();
                Set<Long> leftOrgId = leftOrg.stream().map(exchangeScheme::get).collect(Collectors.toSet());
                CarryServiceHelper.getExchangeData(modelId, cube, scenario, tarFyNum, tarPerNum, lastScenario, fyNum, perNum, leftOrgId);
            }
        }
        return sb;
    }

    private static void handleUserDefineN(Long modelId, Map<String, String> carrymap) {
        Set<String> userdefinedRates = ExchageRateServiceHelper.getUserdefinedrateAccountIgnoreCase(modelId);
        userdefinedRates.stream().filter(s -> !s.startsWith("boy")).forEach(v -> carrymap.put((String)v, "boy" + v));
    }

    private static void handleUserDefineN(Long modelId, DynamicObject source, DynamicObject target) {
        Set<String> userdefinedRates = ExchageRateServiceHelper.getUserdefinedrateAccountIgnoreCase(modelId);
        userdefinedRates.stream().filter(s -> !s.startsWith("boy")).forEach(v -> {
            if (source.get(v) != null && source.getBigDecimal(v).compareTo(BigDecimal.ZERO) != 0) {
                target.set("boy" + v, source.get(v));
            }
        });
    }

    private static void runCommonV(String cube, String lastScenario, String scenario, String fyNum, String perNum, Set<String> orgNums, String currency, String[] mainAccounts, boolean existChangeTypeDimension, PairList<String, String> tarPairList) {
        CarryInfo info = CarryServiceHelper.getComCarryInfo(cube, scenario, orgNums);
        PairList srcPairList = PairList.newWithParam((Object)DimTypesEnum.YEAR.getNumber(), (Object)fyNum).addPair((Object)DimTypesEnum.SCENARIO.getNumber(), (Object)lastScenario);
        info.addFilter(DimTypesEnum.ACCOUNT.getNumber(), mainAccounts);
        info.prepareRun();
        info.setOlapSourceType(OlapSourceEnum.S2);
        srcPairList.addPair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)perNum);
        if (existChangeTypeDimension) {
            srcPairList.addPair((Object)DimTypesEnum.CHANGETYPE.getNumber(), (Object)"EndingBalance");
        }
        if (currency != null) {
            srcPairList.addPair((Object)DimTypesEnum.CURRENCY.getNumber(), (Object)currency);
        }
        info.addOneRunExpress(tarPairList, (PairList<String, String>)srcPairList);
        info.runVExpress();
    }

    public static Map<String, Map<String, List<String>>> getCarrySpecialSetting(String modelNum, String scenario, String yearNum) {
        DynamicObject dyn;
        QFilter qfYear;
        QFilter qfScenario;
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>(16);
        QFilter qfModel = new QFilter("model", "=", (Object)MemberReader.findModelIdByNum((String)modelNum));
        DynamicObject carryObj = QueryServiceHelper.queryOne((String)"bcm_carrymap", (String)"id", (QFilter[])new QFilter[]{qfModel, qfScenario = new QFilter("scenario", "=", (Object)MemberReader.findScenaMemberByNum((String)modelNum, (String)scenario).getId()), qfYear = new QFilter("year", "=", (Object)MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum).getId())});
        if (carryObj != null && (dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)carryObj.getLong("id"), (String)"bcm_carrymap")) != null && !dyn.getDynamicObjectCollection("specialentry").isEmpty()) {
            DynamicObjectCollection carryObjs = dyn.getDynamicObjectCollection("specialentry");
            for (DynamicObject carry : carryObjs) {
                String accountScope = carry.getString("accountscope");
                String scopes = StringUtils.isEmpty((CharSequence)accountScope) ? carry.getString("dimensionscope") : "";
                if (!StringUtils.isNotEmpty((CharSequence)scopes)) continue;
                String sourceNum = carry.getDynamicObject("sourceperiod").getString("number");
                DynamicObjectCollection colls = carry.getDynamicObjectCollection("beforeperiod");
                if (CollectionUtils.isEmpty((Collection)colls)) continue;
                for (DynamicObject coll : colls) {
                    map.putIfAbsent(coll.getString("fbasedataid.number"), new LinkedHashMap(16));
                    Map tem = (Map)map.get(coll.getString("fbasedataid.number"));
                    tem.putIfAbsent(sourceNum, new ArrayList());
                    ((List)tem.get(sourceNum)).add(scopes);
                }
            }
        }
        return map;
    }

    public static void carry(CarryContext ctx) {
        boolean isFalse = false;
        if (!ctx.isAvailable()) {
            return;
        }
        CarryInfo info = CarryServiceHelper.getComCarryInfo((String)ctx.getModel().p2, (String)ctx.getScene().p2, ctx.getOrgs());
        info.addFilter(PresetConstant.ACCOUNT_DIM, ctx.getAccounts().toArray(new String[0]));
        info.addFilter(PresetConstant.PERIOD_DIM, (String)ctx.getPeriod().p2);
        if (ctx.getCurrency() != null) {
            info.addFilter(PresetConstant.CURRENCY_DIM, (String)ctx.getCurrency().p2);
        }
        info.prepareRun();
        info.setOlapSourceType(OlapSourceEnum.S3);
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", ctx.getModel().p1);
        qf.add("ismerge", "=", (Object)isFalse);
        qf.add("datafrom", "!=", (Object)Character.valueOf(DataFromEnum.NULL.getValue()));
        if (ctx.getChangetypes() != null) {
            qf.add("number", "in", ctx.getChangetypes());
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_changetypemembertree", (String)"id, number, datafrom", (QFilter[])qf.toArray());
        String lastYear = CarryServiceHelper.getLastYear((String)ctx.getYear().p2);
        MemberReader.isExistChangeTypeDimension((long)((Long)ctx.getModel().p1));
        col.forEach(e -> {
            String datafrom = e.getString("datafrom");
            String number = e.getString("number");
            String fromNumber = null;
            if (MemberReader.isExistChangeTypeDimension((long)((Long)ctx.getModel().p1))) {
                fromNumber = datafrom.equals(String.valueOf(DataFromEnum.LSP_YTD.getValue())) ? "YTD" : (datafrom.equals(String.valueOf(DataFromEnum.LSP_CURRENTPERIOD.getValue())) ? "CurrentPeriod" : (datafrom.equals(String.valueOf(DataFromEnum.LSP_ENDBALANCE.getValue())) ? "EndingBalance" : datafrom));
            }
            String exchangePeriodForLastYear = ConfigServiceHelper.getExchangePeriodForLastYear((Long)ctx.getModel().p1, (String)ctx.getScene().p2, (String)ctx.getPeriod().p2);
            if (StringUtils.isNotBlank((CharSequence)fromNumber)) {
                PairList srcPair = PairList.newWithParam((Object)PresetConstant.CHANGETYPE_DIM, (Object)fromNumber).addPair((Object)PresetConstant.FY_DIM, (Object)lastYear);
                if (!Objects.equals(exchangePeriodForLastYear, ctx.getPeriod().p2)) {
                    srcPair.addPair((Object)PresetConstant.PERIOD_DIM, (Object)exchangePeriodForLastYear);
                }
                info.addOneRunExpress((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.CHANGETYPE_DIM, (Object)number).addPair((Object)PresetConstant.FY_DIM, ctx.getYear().p2), (PairList<String, String>)srcPair);
                info.runVExpress();
            }
        });
    }

    private static String getLastYear(String year) {
        if (year != null && year.startsWith("FY")) {
            year = year.substring(2);
            return "FY" + (Integer.parseInt(year) - 1);
        }
        return null;
    }

    private static CarryInfo getComCarryInfo(String cube, String scenario, Collection<String> orgnumbers) {
        CarryInfo info = new CarryInfo(cube);
        info.addFilter(PresetConstant.SCENE_DIM, scenario);
        if (orgnumbers != null && !orgnumbers.isEmpty()) {
            info.addFilter(PresetConstant.ENTITY_DIM, orgnumbers.toArray(new String[orgnumbers.size()]));
        }
        return info;
    }

    private static String[] getAccount(long modelid) {
        QFBuilder qb = new QFBuilder();
        qb.add("accounttype", "!=", (Object)AccountTypeEnum.EXCHANGERATE.index);
        qb.add("model", "=", (Object)modelid);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])qb.toArray());
        ArrayList list = new ArrayList();
        if (cols == null) {
            return null;
        }
        cols.forEach(c -> list.add(c.getString("number")));
        return list.toArray(new String[0]);
    }

    private static void doDeleteCWP(long modelid, String cube, String scenario, String tarFyNum, String tarPerNum, Set<String> orgnumbers, String[] accountNums, String currency) {
        DynamicObjectCollection audittirals = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"id, number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelid).add("number", "in", (Object)new String[]{"CWP", "AutoCWP"}).toArray(), (String)"dseq");
        if (audittirals == null || audittirals.isEmpty()) {
            return;
        }
        String[] audittiralsNum = new String[audittirals.size()];
        int num = 0;
        for (DynamicObject audittiral : audittirals) {
            audittiralsNum[num] = audittiral.getString("number");
            ++num;
        }
        SQLBuilder sql = new SQLBuilder(cube);
        sql.addFilter(DimTypesEnum.SCENARIO.getNumber(), scenario);
        sql.addFilter(DimTypesEnum.YEAR.getNumber(), tarFyNum);
        sql.addFilter(DimTypesEnum.PERIOD.getNumber(), tarPerNum);
        if (MemberReader.isExistChangeTypeDimension((long)modelid)) {
            sql.addFilter(DimTypesEnum.CHANGETYPE.getNumber(), "BFLY");
        }
        sql.addFilter(DimTypesEnum.ACCOUNT.getNumber(), accountNums);
        sql.addFilter(DimTypesEnum.ENTITY.getNumber(), orgnumbers.toArray(new String[0]));
        if (MemberReader.isExistAuditTrailDimension((long)modelid)) {
            sql.addFilter(DimTypesEnum.AUDITTRIAL.getNumber(), audittiralsNum);
        }
        if (currency != null) {
            sql.addFilter(DimTypesEnum.CURRENCY.getNumber(), currency);
        }
        String[] dimKeys = CarryServiceHelper.getDimensions(modelid).toArray(new String[0]);
        sql.addSelectField(dimKeys);
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo sinfo = new SaveCommandInfo();
        sinfo.setMeasures(new String[]{measure});
        OlapCommandUtil.addSourceMeasure((String)cube, (CommandInfo)sinfo, (Integer)OlapSourceEnum.S2.getType());
        sinfo.setDimensions(dimKeys);
        CellSet cellSets = new CellSet(dimKeys, new String[]{measure});
        if (rs != null && rs.next()) {
            map.putAll(rs.asMap());
        }
        int currencyIndex = 0;
        for (int i = 0; i < dimKeys.length; ++i) {
            if (!DimTypesEnum.CURRENCY.getNumber().equals(dimKeys[i])) continue;
            currencyIndex = i;
            break;
        }
        for (String key : map.keySet()) {
            String[] temp = key.split("\\|");
            if (SysMembConstant.CurrencyVariable.contains(temp[currencyIndex])) continue;
            cellSets.set(temp, measure, null);
        }
        OlapServiceHelper.saveData(sinfo, cellSets, cube, false);
    }

    private static List<String> getDimensions(long modelId) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray(), (String)"dseq");
        ArrayList<String> list = new ArrayList<String>(dims.size());
        for (DynamicObject dim : dims) {
            list.add(dim.getString("number"));
        }
        return list;
    }

    public static void getExchangeData(Long modelId, String cube, String scenarioNum, String yearNum, String periodNum, String lastScenarioNum, String lastYearNum, String lastPeriodNum, Set<Long> rateIds) {
        ArrayList<DynamicObject> addExchanges = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateExchanges = new ArrayList<DynamicObject>();
        IDNumberTreeNode scenarioNode = MemberReader.findScenaMemberByNum((String)cube, (String)scenarioNum);
        IDNumberTreeNode lastScenarioNode = MemberReader.findScenaMemberByNum((String)cube, (String)lastScenarioNum);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)cube, (String)yearNum);
        IDNumberTreeNode lastYearNode = MemberReader.findFyMemberByNum((String)cube, (String)lastYearNum);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)cube, (String)periodNum);
        IDNumberTreeNode lastPeriodNode = MemberReader.findPeriodMemberByNum((String)cube, (String)lastPeriodNum);
        Long scenarioId = scenarioNode.getId();
        Long lastScenarioId = lastScenarioNode.getId();
        Long yearId = yearNode.getId();
        Long lastYearId = lastYearNode.getId();
        Long periodId = periodNode.getId();
        Long lastPeriodId = lastPeriodNode.getId();
        QFBuilder qfb = new QFBuilder();
        qfb.add("model", "=", (Object)modelId);
        qfb.add("entity", "in", rateIds);
        qfb.add(new QFilter("scene", "=", (Object)lastScenarioId).or(new QFilter("scene", "=", (Object)0L)));
        qfb.add("fy", "=", (Object)lastYearId);
        qfb.add("period", "=", (Object)lastPeriodId);
        DynamicObjectCollection exchange = QueryServiceHelper.query((String)"bcm_exchagerate", (String)(String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet()) + ",id,source.number,target.number"), (QFilter[])qfb.toArray(), (String)"fromid");
        if (exchange.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> originentity2Rates = exchange.stream().collect(Collectors.groupingBy(s -> s.getLong("entity")));
        ArrayListMultimap addentity2Rates = ArrayListMultimap.create();
        Set<Long> openRateIds = ExchangeRateShareSceneHelper.checkRatePeriodSceneOpen(modelId, rateIds, scenarioId, yearId, periodId);
        QFBuilder qfb2 = new QFBuilder();
        qfb2.add("model", "=", (Object)modelId);
        qfb2.add(new QFilter("scene", "=", (Object)scenarioId).or(new QFilter("scene", "=", (Object)0L)));
        qfb2.add("fy", "=", (Object)yearId);
        qfb2.add("period", "=", (Object)periodId);
        Map targetDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)(String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet()) + ",id"), (QFilter[])qfb2.toArray(), (String)"fromid");
        for (DynamicObject dynamicObject : exchange) {
            if (!openRateIds.contains(dynamicObject.getLong("entity"))) continue;
            long curSceneId = dynamicObject.getLong("scene") == 0L ? 0L : scenarioId;
            DynamicObject obj = CarryServiceHelper.getDysBObj(targetDys.values(), dynamicObject);
            if (obj == null) {
                Long formid;
                obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
                obj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                obj.set("model", (Object)modelId);
                obj.set("scene", (Object)curSceneId);
                obj.set("fy", (Object)yearId);
                obj.set("period", (Object)periodId);
                obj.set("entity", dynamicObject.get("entity"));
                obj.set("source", dynamicObject.get("source"));
                obj.set("target", dynamicObject.get("target"));
                obj.set("mutual", (Object)Boolean.FALSE);
                if (LongUtil.isvalidLong((Object)dynamicObject.getLong("fromid")) && (formid = CarryServiceHelper.getMutualDyId(addExchanges, obj)) != 0L) {
                    obj.set("fromid", (Object)formid);
                    obj.set("mutual", (Object)Boolean.TRUE);
                }
                obj.set("precision", dynamicObject.get("precision"));
                addentity2Rates.put((Object)dynamicObject.getLong("entity"), (Object)obj);
                addExchanges.add(obj);
            } else {
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"bcm_exchagerate");
                updateExchanges.add(obj);
            }
            if (dynamicObject.getBigDecimal("periodend").compareTo(BigDecimal.ZERO) != 0) {
                obj.set("beginyear", dynamicObject.get("periodend"));
            }
            if (dynamicObject.getBigDecimal("average").compareTo(BigDecimal.ZERO) != 0) {
                obj.set("boyaveragerate", dynamicObject.get("average"));
            }
            if (dynamicObject.getBigDecimal("userdefine").compareTo(BigDecimal.ZERO) != 0) {
                obj.set("boyuserdefinedrate", dynamicObject.get("userdefine"));
            }
            CarryServiceHelper.handleUserDefineN(modelId, dynamicObject, obj);
        }
        if (addExchanges.size() > 0) {
            addentity2Rates.asMap().forEach((k, v) -> {
                List originData = (List)originentity2Rates.get(k);
                if (originData == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)originData)) {
                    return;
                }
                Long curSceneId = ((DynamicObject)originData.get(0)).getLong("scene");
                List<String> sortedRateKeys = originData.stream().sorted(Comparator.comparing(s -> s.getLong("eseq"))).map(s -> s.getString("source") + KEY_SPLIT + s.getString("target")).collect(Collectors.toList());
                int start = ExchangeRateShareSceneHelper.getNextSeq(modelId, curSceneId, yearId, periodId, k);
                CarryServiceHelper.setListOrder(sortedRateKeys, new ArrayList<DynamicObject>((Collection<DynamicObject>)v), start);
            });
            SaveServiceHelper.save((DynamicObject[])addExchanges.toArray(new DynamicObject[0]));
        }
        if (updateExchanges.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateExchanges.toArray(new DynamicObject[0]));
        }
        ExchangeQueryHelper.clearRateCache(new BaseData(modelId, scenarioNode, yearNode, periodNode));
    }

    public static Long getMutualDyId(List<DynamicObject> addExchanges, DynamicObject addObj) {
        Long modelId = addObj.getLong("model");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode source = MemberReader.findProcessMemberById((String)modelNum, (Long)addObj.getLong("source"));
        IDNumberTreeNode target = MemberReader.findCurrencyMemberById((String)modelNum, (Long)addObj.getLong("target"));
        Optional<DynamicObject> obj = addExchanges.stream().filter(s -> {
            IDNumberTreeNode ssource = MemberReader.findProcessMemberById((String)modelNum, (Long)s.getLong("source"));
            IDNumberTreeNode starget = MemberReader.findCurrencyMemberById((String)modelNum, (Long)s.getLong("target"));
            return Objects.equals(s.getString("model"), addObj.getString("model")) && Objects.equals(s.getString("scene"), addObj.getString("scene")) && Objects.equals(s.getString("fy"), addObj.getString("fy")) && Objects.equals(s.getString("period"), addObj.getString("period")) && Objects.equals(s.getString("entity"), addObj.getString("entity")) && Objects.equals(ssource.getNumber(), target.getNumber()) && Objects.equals(starget.getNumber(), source.getNumber());
        }).findFirst();
        if (obj.isPresent()) {
            obj.get().set("mutual", (Object)Boolean.TRUE);
            return obj.get().getLong("id");
        }
        return 0L;
    }

    public static void setListOrder(List<String> orderRegulation, List<DynamicObject> targetList, int start) {
        Collections.sort(targetList, (o1, o2) -> {
            int io1 = orderRegulation.indexOf(o1.getString("source") + KEY_SPLIT + o1.getString("target"));
            int io2 = orderRegulation.indexOf(o2.getString("source") + KEY_SPLIT + o2.getString("target"));
            if (io1 != -1) {
                io1 = targetList.size() - io1;
            }
            if (io2 != -1) {
                io2 = targetList.size() - io2;
            }
            return io2 - io1;
        });
        for (DynamicObject object : targetList) {
            object.set("eseq", (Object)start);
            ++start;
        }
    }

    public static DynamicObject getDysBObj(Collection<DynamicObject> targetDys, DynamicObject sourceDy) {
        Optional<DynamicObject> obj = targetDys.stream().filter(s -> Objects.equals(s.getString("model.id"), sourceDy.getString("model")) && Objects.equals(String.valueOf(s.getLong("scene.id")), sourceDy.getString("scene")) && Objects.equals(s.getString("entity.id"), sourceDy.getString("entity")) && Objects.equals(s.getString("source.id"), sourceDy.getString("source")) && Objects.equals(s.getString("target.id"), sourceDy.getString("target"))).findFirst();
        if (obj.isPresent()) {
            return obj.get();
        }
        return null;
    }

    public static Pair<Long, String> getCarryLast(long modelId, long scenario, long year, long period) {
        Map<Long, List<Object>> result = CarryServiceHelper.getCarryLastSetting(modelId, scenario, year, period);
        List<Object> objectList = result.getOrDefault(period, Arrays.asList(0L, "", 0L));
        return Pair.of((Object)LongUtil.toLong((Object)objectList.get(0)), (Object)objectList.get(1).toString());
    }

    public static Map<Long, List<Object>> getCarryLastSetting(long modelId, long scenario, long year, long period) {
        return (Map)ThreadCache.get((Object)("getLastYearPeriod:" + modelId + KEY_SPLIT + scenario + KEY_SPLIT + year), () -> {
            HashMap<Long, List<Object>> periodMap;
            block8: {
                DynamicObject defaultLastPeriod;
                LinkedList<String> lastYearEffective;
                HashSet<Long> currYearEffective;
                HashMap<String, DynamicObject> tempMap;
                DynamicObject carryMap;
                Optional lastYearNumber;
                String scenarioNum;
                String yearNum;
                String modelNum;
                block7: {
                    modelNum = MemberReader.findModelNumberById((Object)modelId);
                    yearNum = MemberReader.findFyMemberById((String)modelNum, (Long)year).getNumber();
                    scenarioNum = MemberReader.findScenaMemberById((String)modelNum, (Long)scenario).getNumber();
                    lastYearNumber = PeriodUtils.getLastYear((String)modelNum, (String)yearNum);
                    if (!lastYearNumber.isPresent()) {
                        return Collections.emptyMap();
                    }
                    periodMap = new HashMap<Long, List<Object>>(16);
                    QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
                    qfBuilder.and("scenario", "=", (Object)scenario);
                    qfBuilder.add("year", "=", (Object)year);
                    carryMap = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_carrymap", (QFilter[])qfBuilder.toArray());
                    DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)scenario, (String)"bcm_scenemembertree", (String)"sceneperiod");
                    ArrayList ids = new ArrayList();
                    DynamicObjectCollection scenePeriod = dot.getDynamicObjectCollection("sceneperiod");
                    scenePeriod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number,isadjust,useyear", (QFilter[])new QFBuilder("id", "in", ids).toArray(), (String)"dseq");
                    tempMap = new HashMap<String, DynamicObject>(16);
                    currYearEffective = new HashSet<Long>();
                    lastYearEffective = new LinkedList<String>();
                    for (DynamicObject dyn : periods) {
                        tempMap.put(dyn.getString("number"), dyn);
                        if (!dyn.getBoolean("isadjust") || dyn.getBoolean("isadjust") && dyn.getString("useyear").contains(yearNum)) {
                            currYearEffective.add(dyn.getLong("id"));
                        }
                        if (dyn.getBoolean("isadjust") && (!dyn.getBoolean("isadjust") || !dyn.getString("useyear").contains((CharSequence)lastYearNumber.get()))) continue;
                        lastYearEffective.add(dyn.getString("number"));
                    }
                    if (carryMap != null) break block7;
                    Optional lastPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)yearNum, (String)(scenarioNum.contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)true);
                    defaultLastPeriod = CarryServiceHelper.getDefaultLastPeriod(tempMap, lastYearEffective, modelNum, yearNum, scenarioNum, lastPeriod);
                    for (Long pId : currYearEffective) {
                        periodMap.put(pId, Arrays.asList(defaultLastPeriod.getLong("id"), lastYearNumber.get(), scenario));
                    }
                    break block8;
                }
                DynamicObjectCollection entries = carryMap.getDynamicObjectCollection("entryentity");
                defaultLastPeriod = null;
                for (DynamicObject entry : entries) {
                    if (!currYearEffective.contains(entry.getLong("curperiod.id"))) continue;
                    long lastSetting = entry.getLong("lastperiod.id");
                    long lastScenario = entry.getLong("lastscenario.id");
                    String lastScenarioNum = entry.getString("lastscenario.number");
                    String lastNumSetting = entry.getString("lastperiod.number");
                    periodMap.put(entry.getLong("curperiod.id"), Arrays.asList(lastSetting, entry.getString("lastyear.number"), lastScenario));
                }
                if (currYearEffective.size() <= periodMap.size()) break block8;
                if (defaultLastPeriod == null) {
                    Optional lastPeriod = PeriodUtils.getLastPeriod((String)modelNum, (String)yearNum, (String)(scenarioNum.contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)true);
                    defaultLastPeriod = CarryServiceHelper.getDefaultLastPeriod(tempMap, lastYearEffective, modelNum, yearNum, scenarioNum, lastPeriod);
                }
                for (Long cuP : currYearEffective) {
                    if (periodMap.containsKey(cuP)) continue;
                    periodMap.putIfAbsent(cuP, Arrays.asList(defaultLastPeriod.getLong("id"), lastYearNumber.get(), scenario));
                }
            }
            return periodMap;
        });
    }

    public static String getCarryLastYear(long modelId, long scenario, long year, long period) {
        return (String)CarryServiceHelper.getCarryLast(modelId, scenario, year, period).getRight();
    }

    public static long getCarryLastPeriod(long modelId, long scenario, long year, long period) {
        return (Long)CarryServiceHelper.getCarryLast(modelId, scenario, year, period).getLeft();
    }

    @SDKMark
    public static Pair<Long, String> getEntityCarryLast(long modelId, long scenario, long year, long period, long entityId) {
        return CarryServiceHelper.getSpecialCarryLast(modelId, scenario, year, period, entityId, 0L);
    }

    public static Map<Long, String> getBatchEntityCarryLast(long modelId, long scenario, long year, long period, Set<Long> entityIds) {
        return CarryServiceHelper.getSpecialCarryLast(modelId, scenario, year, period, entityIds);
    }

    public static Pair<Long, String> getAccountCarryLast(long modelId, long scenario, long year, long period, long accountId) {
        return CarryServiceHelper.getSpecialCarryLast(modelId, scenario, year, period, 0L, accountId);
    }

    public static Pair<Long, String> getSpecialCarryLast(long modelId, long scenario, long year, long period, long entityId, long accountId) {
        return (Pair)ThreadCache.get((Object)("getSpecialCarryLast:" + modelId + KEY_SPLIT + scenario + KEY_SPLIT + year + KEY_SPLIT + period + KEY_SPLIT + entityId + KEY_SPLIT + accountId), () -> {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.and("scenario", "=", (Object)scenario);
            qfBuilder.add("year", "=", (Object)year);
            DynamicObject carryMap = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_carrymap", (QFilter[])qfBuilder.toArray());
            Pair res = CarryServiceHelper.getCarryLast(modelId, scenario, year, period);
            if (carryMap != null && !carryMap.getDynamicObjectCollection("specialentry").isEmpty()) {
                LinkedHashMap mapped = new LinkedHashMap(16);
                DynamicObjectCollection carryObjs = carryMap.getDynamicObjectCollection("specialentry");
                for (DynamicObject carry : carryObjs) {
                    String accountScope = carry.getString("accountscope");
                    String scopes = StringUtils.isEmpty((CharSequence)accountScope) ? carry.getString("dimensionscope") : "";
                    if (!StringUtils.isNotEmpty((CharSequence)scopes)) continue;
                    String sourceNum = carry.getDynamicObject("sourceperiod").getString("number");
                    DynamicObjectCollection colls = carry.getDynamicObjectCollection("beforeperiod");
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)colls)) continue;
                    for (DynamicObject coll : colls) {
                        if (coll.getLong("fbasedataid.id") != period) continue;
                        mapped.putIfAbsent(sourceNum, new ArrayList());
                        ((List)mapped.get(sourceNum)).add(scopes);
                    }
                }
                String modelNum = MemberReader.findModelNumberById((Object)modelId);
                String entityNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId).getNumber();
                String accountNumber = MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)accountId).getNumber();
                for (Map.Entry entry : mapped.entrySet()) {
                    String key = (String)entry.getKey();
                    List val = (List)entry.getValue();
                    for (String v : val) {
                        Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                        HashSet entities = new HashSet(16);
                        HashSet accounts = new HashSet(16);
                        for (Map.Entry temEntry : tempMapList.entrySet()) {
                            String dim = (String)temEntry.getKey();
                            List scopes = (List)temEntry.getValue();
                            HashMap<String, Integer> idScopeMap = new HashMap<String, Integer>(16);
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)scopes)) {
                                scopes.forEach(map -> idScopeMap.put((String)map.get("id"), Integer.valueOf((String)map.get(SCOPE))));
                            }
                            if (dim.equals(SysDimensionEnum.Account.getSign())) {
                                idScopeMap.forEach((id, scope) -> {
                                    String accountNum = MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)Long.valueOf(id)).getNumber();
                                    new MembRangeItem("bcm_accountmembertree", Long.valueOf(id), accountNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> accounts.add(c.number));
                                });
                                continue;
                            }
                            if (!dim.equals(SysDimensionEnum.Entity.getSign())) continue;
                            idScopeMap.forEach((id, scope) -> {
                                String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)Long.valueOf(id)).getNumber();
                                new MembRangeItem("bcm_entitymembertree", Long.valueOf(id), entityNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> entities.add(c.number));
                            });
                        }
                        if (!accounts.isEmpty() && !entities.isEmpty()) {
                            if (!entities.contains(entityNumber) || !accounts.contains(accountNumber)) continue;
                            res = Pair.of((Object)MemberReader.findPeriodMemberByNum((String)modelNum, (String)key).getId(), (Object)res.getRight());
                            continue;
                        }
                        if (accounts.isEmpty() && !entities.isEmpty()) {
                            if (!entities.contains(entityNumber)) continue;
                            res = Pair.of((Object)MemberReader.findPeriodMemberByNum((String)modelNum, (String)key).getId(), (Object)res.getRight());
                            continue;
                        }
                        if (accounts.isEmpty() || !accounts.contains(accountNumber)) continue;
                        res = Pair.of((Object)MemberReader.findPeriodMemberByNum((String)modelNum, (String)key).getId(), (Object)res.getRight());
                    }
                }
            }
            return res;
        });
    }

    public static Map<Long, String> getSpecialCarryLast(long modelId, long scenario, long year, long period, Set<Long> entityIds) {
        return CarryServiceHelper.getSpecialCarryLast(modelId, scenario, year, period, entityIds, false);
    }

    public static Map<Long, String> getSpecialCarryLast(long modelId, long scenario, long year, long period, Set<Long> entityIds, boolean rePeriod) {
        HashMap<Long, String> entityPeriodMap = new HashMap<Long, String>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and("scenario", "=", (Object)scenario);
        qfBuilder.add("year", "=", (Object)year);
        DynamicObject carryMap = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_carrymap", (QFilter[])qfBuilder.toArray());
        if (carryMap != null && !carryMap.getDynamicObjectCollection("specialentry").isEmpty()) {
            LinkedHashMap mapped = new LinkedHashMap(16);
            DynamicObjectCollection carryObjs = carryMap.getDynamicObjectCollection("specialentry");
            for (DynamicObject carry : carryObjs) {
                String accountScope = carry.getString("accountscope");
                String scopes = StringUtils.isEmpty((CharSequence)accountScope) ? carry.getString("dimensionscope") : "";
                if (!StringUtils.isNotEmpty((CharSequence)scopes)) continue;
                String sourceNum = carry.getDynamicObject("sourceperiod").getString("number");
                DynamicObjectCollection colls = carry.getDynamicObjectCollection("beforeperiod");
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)colls)) continue;
                for (DynamicObject coll : colls) {
                    if (coll.getLong("fbasedataid.id") != period) continue;
                    mapped.putIfAbsent(sourceNum, new ArrayList());
                    ((List)mapped.get(sourceNum)).add(scopes);
                }
            }
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            for (Map.Entry entry : mapped.entrySet()) {
                String key = (String)entry.getKey();
                List val = (List)entry.getValue();
                for (String v : val) {
                    Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                    HashSet entities = new HashSet(16);
                    HashSet accounts = new HashSet(16);
                    for (Map.Entry temEntry : tempMapList.entrySet()) {
                        String dim = (String)temEntry.getKey();
                        List scopes = (List)temEntry.getValue();
                        HashMap<String, Integer> idScopeMap = new HashMap<String, Integer>(16);
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)scopes)) {
                            scopes.forEach(map -> idScopeMap.put((String)map.get("id"), Integer.valueOf((String)map.get(SCOPE))));
                        }
                        if (dim.equals(SysDimensionEnum.Account.getSign())) {
                            idScopeMap.forEach((id, scope) -> {
                                String accountNum = MemberReader.findMemberById((long)modelId, (String)"bcm_accountmembertree", (Long)Long.valueOf(id)).getNumber();
                                new MembRangeItem("bcm_accountmembertree", Long.valueOf(id), accountNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> accounts.add(c.number));
                            });
                            continue;
                        }
                        if (!dim.equals(SysDimensionEnum.Entity.getSign())) continue;
                        idScopeMap.forEach((id, scope) -> {
                            String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)Long.valueOf(id)).getNumber();
                            new MembRangeItem("bcm_entitymembertree", Long.valueOf(id), entityNum, RangeEnum.getRangeByVal((int)scope), false, (Object)modelId).matchItems(c -> entities.add(c.number));
                        });
                    }
                    if (!accounts.isEmpty() || entities.isEmpty()) continue;
                    for (Long entityId : entityIds) {
                        String entityNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId).getNumber();
                        if (entities.contains(entityNumber)) {
                            entityPeriodMap.put(entityId, MemberReader.findPeriodMemberByNum((String)modelNum, (String)key).getNumber());
                            continue;
                        }
                        if (!rePeriod) continue;
                        entityPeriodMap.put(entityId, MemberReader.findPeriodMemberById((Long)modelId, (Long)CarryServiceHelper.getCarryLastPeriod(modelId, scenario, year, period)).getNumber());
                    }
                }
            }
        }
        return entityPeriodMap;
    }

    private static DynamicObject getDefaultLastPeriod(Map<String, DynamicObject> tempMap, List<String> lastYearEffective, String modelNum, String yearNum, String scenarioNum, Optional<String> lastPeriod) {
        String lastP;
        DynamicObject defaultLastPeriod = null;
        if (!lastPeriod.isPresent()) {
            Optional optional = PeriodUtils.getLastPeriod((String)modelNum, (String)yearNum, (String)(scenarioNum.contains("QRpt") ? "Q_Q1" : "M_M01"), (boolean)false);
            lastP = optional.orElse(null);
        } else {
            lastP = lastPeriod.get();
        }
        for (String lastPeriodNum : lastYearEffective) {
            if (!lastPeriodNum.equals(lastP)) continue;
            defaultLastPeriod = tempMap.get(lastPeriodNum);
            break;
        }
        if (defaultLastPeriod == null && !lastYearEffective.isEmpty()) {
            defaultLastPeriod = tempMap.get(lastYearEffective.get(lastYearEffective.size() - 1));
        }
        return defaultLastPeriod;
    }

    public static void carryYear(long modelId, long scenario, long year, long period, Set<Long> orgIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        HashSet<String> orgNums = new HashSet<String>();
        ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>(10);
        ArrayList children = new ArrayList(10);
        for (Long id : orgIds) {
            IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)modelId, (Long)id);
            if (member == IDNumberTreeNode.NotFoundTreeNode) continue;
            nodes.add(member);
            if (member.isLeaf()) continue;
            children.addAll(member.getChildren());
        }
        nodes.forEach(re -> orgNums.add(re.getNumber()));
        children.forEach(re -> orgNums.add(re.getParent().getNumber() + "_" + re.getNumber()));
        if (orgNums.size() == 0) {
            return;
        }
        List<Object> carryLast = CarryServiceHelper.getCarryLastSetting(modelId, scenario, year, period).get(period);
        if (carryLast == null || org.apache.commons.collections.CollectionUtils.isEmpty(orgNums)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"BeginYearCarryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String cube = MemberReader.findModelNumberById((Object)modelId);
        String scenarioNum = MemberReader.findScenaMemberById((Long)modelId, (Long)scenario).getNumber();
        String lastScenarioNum = MemberReader.findScenaMemberById((Long)modelId, (Long)LongUtil.toLong((Object)carryLast.get(2))).getNumber();
        String lastYear = carryLast.get(1).toString();
        String thisYear = MemberReader.findFyMemberById((Long)modelId, (Long)year).getNumber();
        String lastPeriod = MemberReader.findPeriodMemberById((Long)modelId, (Long)LongUtil.toLong((Object)carryLast.get(0))).getNumber();
        String thisPeriod = MemberReader.findPeriodMemberById((Long)modelId, (Long)period).getNumber();
        StringBuilder bu = CarryServiceHelper.simpleCarry(modelId, cube, lastScenarioNum, lastYear, lastPeriod, scenarioNum, thisYear, thisPeriod, orgNums, null, null);
        DynamicObject[] carryObjs = new DynamicObject[orgIds.size()];
        int index = 0;
        Map<String, Map<String, List<String>>> carrySpecialSetting = CarryServiceHelper.getCarrySpecialSetting(cube, scenarioNum, thisYear);
        Map<String, List<String>> specials = carrySpecialSetting.get(thisPeriod);
        for (Long orgId : orgIds) {
            carryObjs[index] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_carryentity");
            DynamicObject carryObj = carryObjs[index];
            carryObj.set("model", (Object)modelId);
            carryObj.set("scene", (Object)scenario);
            carryObj.set("lastscene", (Object)LongUtil.toLong((Object)carryLast.get(2)));
            carryObj.set("year", (Object)year);
            carryObj.set("period", (Object)period);
            carryObj.set("lastperiod", (Object)LongUtil.toLong((Object)carryLast.get(0)));
            carryObj.set("org", (Object)orgId);
            carryObj.set("carrystatus", (Object)"1");
            carryObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            carryObj.set("modifydate", (Object)TimeServiceHelper.now());
            HashMap<String, List> sourcePeriod = new HashMap<String, List>(16);
            DynamicObjectCollection colls = carryObj.getDynamicObjectCollection("entryentity");
            if (bu.length() > 0 && specials != null) {
                specials.forEach((key, val) -> {
                    if (!key.equals(lastPeriod)) {
                        for (String v : val) {
                            Map tempMapList = (Map)SerializationUtils.fromJsonString((String)v, Map.class);
                            HashSet entities = new HashSet(16);
                            if (tempMapList.get(SysDimensionEnum.Entity.getSign()) != null) {
                                ((List)tempMapList.get(SysDimensionEnum.Entity.getSign())).forEach(map -> {
                                    Long id = Long.valueOf((String)map.get("id"));
                                    String scope = (String)map.get(SCOPE);
                                    String entityNum = MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)id).getNumber();
                                    new MembRangeItem("bcm_entitymembertree", id, entityNum, RangeEnum.getRangeByVal((int)Integer.parseInt(scope)), false, (Object)modelId).matchItems(c -> entities.add(c.id.toString()));
                                });
                            }
                            if (!entities.isEmpty() && !entities.contains(orgId.toString())) continue;
                            sourcePeriod.putIfAbsent((String)key, new ArrayList(10));
                            if (tempMapList.get(SysDimensionEnum.Account.getSign()) == null) continue;
                            ((List)tempMapList.get(SysDimensionEnum.Account.getSign())).forEach(map -> ((List)sourcePeriod.get(key)).add(new kd.fi.bcm.common.Pair((Object)Long.valueOf((String)map.get("id")), map.get(SCOPE))));
                        }
                    }
                });
                if (sourcePeriod.size() > 0) {
                    sourcePeriod.forEach((per, pairs) -> {
                        Long periodId = MemberReader.findPeriodMemberByNum((String)cube, (String)per).getId();
                        if (pairs.isEmpty()) {
                            DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                            temp.set("sourceperiod", (Object)periodId);
                            colls.add((Object)temp);
                        } else {
                            for (kd.fi.bcm.common.Pair pair : pairs) {
                                DynamicObject temp = new DynamicObject(colls.getDynamicObjectType());
                                temp.set("account", pair.p1);
                                temp.set(SCOPE, pair.p2);
                                temp.set("sourceperiod", (Object)periodId);
                                colls.add((Object)temp);
                            }
                        }
                    });
                }
            }
            ++index;
        }
        SaveServiceHelper.save((DynamicObject[])carryObjs);
    }
}

