/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.entrydetail.CheckTmplDetailBatchModel;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.lang.math.NumberUtils;

public class CheckContext
implements ICheckContext {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, CheckContext.class.getClass());
    private Pair<Long, String> model;
    private Map<String, Pair<String, String[]>> scopes;
    private List<String> selectDimKeys;
    private Tuple<Long, String, String> entity;
    protected String currencyNumber;
    private boolean isCompany;
    private boolean isSpptMultRule;
    private boolean isSpptDataSort;
    private boolean isSpptMyCompany;
    private CheckParam param;
    private List<String> userDefineDims;
    private List<String> allDims;
    private Map<String, String> fieldMapped;
    private Map<String, String> userDefineNumberMap;
    private Map<EntityKey, Pair<Long, String>> parentMap;
    private Map<String, List<CheckTmpl>> checkTmplMap;
    private Map<String, Long> allDimNumberIdMapped;
    private Map<Long, String> allDimIdNumberMapped;
    private Map<String, String> entCurrencyMapped;
    private boolean isNeedMonitorDataStatus = true;
    private Set<String> leafEntitySet;
    private Set<String> unLeafEntitySet;
    private Set<Long> unLeafEntityIds;
    private Set<String> srptUnLeafEntitySet;
    private Set<String> csteUnLeafEntitySet;
    private Set<String> entityVersion;
    private boolean isAvailable = true;
    private boolean isIncludeADJ;
    private CheckResult checkResult = new CheckResult();
    private Map<String, Object> properties = new HashMap<String, Object>(16);
    Map<String, Pair<Long, String>> sortedOrgByChangeType = new HashMap<String, Pair<Long, String>>(16);
    private Set<String> adjEntitySet;
    private String checkExecuteType = "0";
    private int batchSize = 1000;
    private int checkJNGroupSize = 1000;

    public CheckContext(CheckParam param) {
        log.startWatch();
        this.scopes = new HashMap<String, Pair<String, String[]>>(16);
        this.param = param;
        this.model = param.getModel();
        this.isIncludeADJ = param.isIncludeAdj();
        try {
            this.initModel();
            this.initEntity();
            this.checkEntityStatus();
            this.initDim();
            this.initCheckTmpls();
            this.initNoMerges();
            this.initEntityVersion();
            this.initEntityScope();
            this.initScope();
            this.checkScope();
        }
        catch (Throwable t) {
            try {
                this.isAvailable = false;
                this.setCheckResult(CheckResult.fail(t.getMessage()));
                log.error("init CheckContext error:", t);
                log.info("init CheckContext error:" + ThrowableHelper.toString((Throwable)t));
            }
            catch (Throwable throwable) {
                log.infoEnd(String.format("\u7ec4\u7ec7%s\u8fdb\u884c\u5bf9\u8d26\uff0c\u521d\u59cb\u5316CheckContext\u8017\u65f6\u3002", this.getCheckParam().getEntity().p2));
                throw throwable;
            }
            log.infoEnd(String.format("\u7ec4\u7ec7%s\u8fdb\u884c\u5bf9\u8d26\uff0c\u521d\u59cb\u5316CheckContext\u8017\u65f6\u3002", this.getCheckParam().getEntity().p2));
        }
        log.infoEnd(String.format("\u7ec4\u7ec7%s\u8fdb\u884c\u5bf9\u8d26\uff0c\u521d\u59cb\u5316CheckContext\u8017\u65f6\u3002", this.getCheckParam().getEntity().p2));
    }

    private void checkEntityStatus() {
        boolean isQuoteLocked;
        if (!this.isAvailable) {
            return;
        }
        if (!this.isCompany && this.getCheckParam().isGenerateElim() && this.getCheckParam().isIncludeAdj() && this.getCheckParam().getCreateTypeEnum() == CheckCreateTypeEnum.CHECKADJUST_CREATE && (isQuoteLocked = MergeControlHelper.isQuoteLocked((Long)this.getModel().p1, (Long)this.getCheckParam().getScene().p1, (Long)this.getCheckParam().getYear().p1, (Long)this.getCheckParam().getPeriod().p1, (Long)this.getCheckParam().getEntity().p1))) {
            this.interruptContinueCheck((String)this.param.getEntity().p2, CheckConstant.CHECKCONTEXT_CONTROL_SCENEVERSION);
            return;
        }
        if (this.param.getCreateTypeEnum() != null && CheckCreateTypeEnum.CHECKADJUST_CREATE.value.equals(this.param.getCreateTypeEnum().value)) {
            Set<String> orgNumbersOpen;
            Map<String, Boolean> orgStatus = AllInOneUtils.isSubmittedBatch((Long)this.model.p1, Sets.newHashSet((Object[])new String[]{(String)this.getEntity().p2}), this.param.getScene().p1, this.param.getYear().p1, this.param.getPeriod().p1);
            if (orgStatus.getOrDefault(this.getEntity().p2, Boolean.FALSE).booleanValue()) {
                this.interruptContinueCheck((String)this.param.getEntity().p2, CheckConstant.CHECKCONTEXT_CONTROL_ALLINONESUBMIT);
                return;
            }
            if (ConfigServiceHelper.getBoolParam((Long)this.getModel().p1, "CM012") && !(orgNumbersOpen = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)this.getModel().p1, Sets.newHashSet((Object[])new String[]{(String)this.getEntity().p2}), (Long)this.param.getScene().p1, (Long)this.param.getYear().p1, (Long)this.param.getPeriod().p1, "entrystatus")).contains(this.getEntity().p2)) {
                this.interruptContinueCheck((String)this.param.getEntity().p2, CheckConstant.CHECKCONTEXT_CONTROL_ENTRYSTATUS);
            }
        }
    }

    private void initNoMerges() {
        if (!this.isAvailable) {
            return;
        }
        this.putProperty("noMerge", MergeControlHelper.getNoMergeByNumber((Long)this.model.p1, (Long)this.getCheckParam().getScene().p1, (Long)this.getCheckParam().getYear().p1, (Long)this.getCheckParam().getPeriod().p1));
    }

    private void initModel() {
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"bcm_model", (String)"isspptmultrule, isspptdatasort", (QFilter[])new QFilter[]{new QFilter("id", "=", this.model.p1)});
        this.isSpptMultRule = dyna.getBoolean("isspptmultrule");
        this.isSpptDataSort = dyna.getBoolean("isspptdatasort");
        this.batchSize = this.getParamConfig("checkQueryOlapBatchSize");
        int adjustGroupSize = this.getParamConfig("CheckJNGroupSize");
        if (adjustGroupSize > 0 && adjustGroupSize <= 10000) {
            this.checkJNGroupSize = adjustGroupSize;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)this.model.p1);
        Set icIds = Stream.of("InternalCompany", "ICTotal", "ICEntity").map(num -> MemberReader.findMemberByNumber((String)modelNumber, (String)DimEntityNumEnum.INTERCOMPANY.getNumber(), (String)num).getId()).collect(Collectors.toSet());
        this.putProperty("InternalCompanyIds", icIds);
    }

    private int getParamConfig(String Key2) {
        try {
            int i;
            String batchSizStr = ConfigServiceHelper.getStringParam((Long)this.model.p1, Key2);
            if (StringUtils.isNotEmpty((String)batchSizStr) && NumberUtils.isNumber((String)batchSizStr) && (i = new BigDecimal(batchSizStr).intValue()) > 0) {
                return i;
            }
        }
        catch (Exception e) {
            log.error("init config check_olap_batchSize  error" + e.getCause());
        }
        return 1000;
    }

    private void initDim() {
        if (!this.isAvailable) {
            return;
        }
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", this.model.p1).toArray(), (String)"dseq");
        this.fieldMapped = new HashMap<String, String>(16);
        this.allDims = new ArrayList<String>(10);
        this.selectDimKeys = new ArrayList<String>(10);
        this.userDefineDims = new ArrayList<String>(10);
        this.userDefineNumberMap = new HashMap<String, String>(16);
        this.allDimNumberIdMapped = new HashMap<String, Long>(16);
        this.allDimIdNumberMapped = new HashMap<Long, String>(16);
        dims.forEach(e -> {
            this.allDims.add(e.getString("number"));
            this.selectDimKeys.add(e.getString("number"));
            if (!e.getBoolean("issysdimension")) {
                this.fieldMapped.put(e.getString("fieldmapped"), e.getString("number"));
                this.fieldMapped.put(e.getString("number"), e.getString("fieldmapped"));
                this.userDefineDims.add(e.getString("number"));
                this.userDefineNumberMap.put(e.getString("number"), e.getString("shortnumber"));
                this.userDefineNumberMap.put(e.getString("shortnumber"), e.getString("number"));
            }
            this.allDimNumberIdMapped.put(e.getString("number"), e.getLong("id"));
            this.allDimIdNumberMapped.put(e.getLong("id"), e.getString("number"));
        });
        this.isSpptMyCompany = this.allDims.contains(PresetConstant.MYCOMPANY_DIM) && !this.userDefineDims.contains(PresetConstant.MYCOMPANY_DIM);
    }

    @Override
    public void addScope(String dimNum, Pair<String, String[]> scope) {
        if (scope == null) {
            this.scopes.remove(dimNum);
        } else {
            this.scopes.put(dimNum, scope);
        }
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    public void setModel(Pair<Long, String> model) {
        this.model = model;
    }

    public void setScopes(Map<String, Pair<String, String[]>> scopes) {
        this.scopes = scopes;
    }

    @Override
    public String[] getSelectField() {
        if (this.selectDimKeys == null) {
            this.initDim();
        }
        return this.selectDimKeys.toArray(new String[0]);
    }

    public void setSelectField(List<String> fields) {
        this.selectDimKeys = fields;
    }

    @Override
    public String[] getMeasures() {
        return new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
    }

    @Override
    public Collection<Pair<String, String[]>> getScopes() {
        return this.scopes.values();
    }

    private String getSelector() {
        ArrayList<String> selector = new ArrayList<String>(29);
        selector.add("id");
        selector.add("issingledc");
        selector.add("islinkage");
        selector.add("balance");
        selector.add("number");
        selector.add("name");
        selector.add("elimtype");
        selector.add("diffmode");
        selector.add("diffmethod");
        selector.add("diffmodeformula");
        selector.add("checkconfig");
        selector.add("journaltype");
        selector.add("adjustcatalog.id as adjustcatalogid");
        selector.add("entryentity.id as tmplentryid");
        selector.add("entryentity.mappingaccount.id as mappingaccountid");
        selector.add("entryentity.changetype.id as changetypeid");
        selector.add("entryentity.changetype.number as " + PresetConstant.CHANGETYPE_DIM);
        selector.add("entryentity.elim_changetype.id as elimchangetypeid");
        selector.add("entryentity.elim_changetype.number as elim" + PresetConstant.CHANGETYPE_DIM);
        selector.add("entryentity.multigaap.id as multigaapid");
        selector.add("entryentity.multigaap.number as " + PresetConstant.RULE_DIM);
        selector.add("entryentity.datasort.id as datasortid");
        selector.add("entryentity.datasort.number as " + PresetConstant.DATASORT_DIM);
        selector.add("entryentity.mycompany.id as mycompanyid");
        selector.add("entryentity.mycompany.number as " + PresetConstant.MYCOMPANY_DIM);
        selector.add("entryentity.dc as dc");
        selector.add("entryentity.elimdc as elimdc");
        selector.add("entryentity.seq as seq");
        selector.add("entryentity.diffitem as diffitem");
        selector.add("entryentity.entrygroup as entrygroup");
        selector.add("entryentity.entrymyop as entrymyop");
        selector.add("templatecatalog.id");
        selector.add("templatecatalog.number");
        selector.add("templatecatalog.process.id as processid");
        selector.add("templatecatalog.process.number as processnumber");
        return String.join((CharSequence)",", selector);
    }

    private void initCheckTmpls() {
        ArrayListMultimap<String, Long> checkTmplPermMap;
        Object noPermIds;
        if (!this.isAvailable) {
            return;
        }
        HashSet<Long> tmplids = new HashSet<Long>();
        HashSet<Long> tmplIdParam = new HashSet<Long>();
        QFBuilder qf = new QFBuilder();
        if (this.isBatchDiff()) {
            tmplIdParam.addAll(this.queryTmplsByCheckRecord(this.getCheckParam().get("checkRecordIds")));
        } else if (this.param.getCheckTmpl() != null) {
            tmplIdParam.addAll(Arrays.asList((Object[])this.param.getCheckTmpl().p1));
        }
        qf.add("id", "in", CheckUtil.queryDispensedTmpls((Long)this.model.p1, (Long)this.param.getScene().p1, tmplIdParam, this.param.getElimType(), Sets.newHashSet((Object[])new String[]{(String)this.entity.p2})));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checktmpl", (String)this.getSelector(), (QFilter[])qf.toArray());
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(this.model.p1));
        if (!adminUserBol && !CollectionUtils.isEmpty((Collection)(noPermIds = (checkTmplPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_checktmpl", String.valueOf(this.model.p1), RequestContext.get().getUserId())).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())))) {
            doc.removeIf(arg_0 -> CheckContext.lambda$initCheckTmpls$2((List)noPermIds, arg_0));
        }
        HashMap<Long, DynamicObject> needUpdateDy = new HashMap<Long, DynamicObject>(5);
        for (DynamicObject d2 : doc) {
            if (StringUtils.isEmpty((String)d2.getString("processnumber"))) {
                this.initTmplCatalogProcess(d2, needUpdateDy);
            }
            tmplids.add(d2.getLong("id"));
        }
        if (needUpdateDy.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateDy.values().toArray(new DynamicObject[0]));
        }
        Set<Long> effectiveTmpls = CheckUtil.queryEffectiveTmpls((Long)this.model.p1, (Long)this.param.getYear().p1, (Long)this.param.getPeriod().p1, tmplids);
        doc.removeIf(d -> !effectiveTmpls.contains(d.getLong("id")));
        if (doc.isEmpty()) {
            this.interruptContinueCheck((String)this.param.getEntity().p2, CheckConstant.CHECKCONTEXT_CONTROL_NOTEMPLATE);
            return;
        }
        Map<String, Map<String, List<DynamicObject>>> groupDos = doc.stream().collect(Collectors.groupingBy(e -> e.getString("processnumber"), Collectors.groupingBy(e -> e.getString("number"))));
        if (this.checkTmplMap == null) {
            this.checkTmplMap = new HashMap<String, List<CheckTmpl>>(16);
        }
        if (!this.checkTmplMap.isEmpty()) {
            this.checkTmplMap.clear();
        }
        CheckTmplDetailBatchModel checkTmplBatchModel = new CheckTmplDetailBatchModel();
        groupDos.forEach((elimType, v) -> v.forEach((tmplNumber, doList) -> checkTmplBatchModel.addEntryInfo((String)elimType, (String)tmplNumber, (Collection<DynamicObject>)doList)));
        checkTmplBatchModel.initCheckTmplDetailModels();
        groupDos.forEach((elimType, v) -> {
            ArrayList tmplList = new ArrayList(10);
            v.forEach((tmplNumber, doList) -> tmplList.add(CheckRecordHelper.newCheckTmpl(this, elimType, tmplNumber, checkTmplBatchModel)));
            this.checkTmplMap.put((String)elimType, tmplList);
        });
        this.putProperty("TmplSingleMemberRangeMap", null);
        this.putProperty("TmplCellMemberRangeMap", null);
    }

    private Set<Long> queryTmplsByCheckRecord(Object checkRecordIds) {
        HashSet<Long> tmplIds = new HashSet<Long>();
        QueryServiceHelper.query((String)"bcm_checkrecord", (String)"checktmpl.id", (QFilter[])new QFilter[]{new QFilter("id", "in", checkRecordIds)}).forEach(e -> tmplIds.add(e.getLong("checktmpl.id")));
        return tmplIds;
    }

    private void interruptContinueCheck(String orgNum, Long v) {
        this.isAvailable = false;
        HashMap<String, HashSet> result = new HashMap<String, HashSet>(16);
        result.put(orgNum, Sets.newHashSet((Object[])new Long[]{v}));
        this.checkResult = CheckResult.success(result);
    }

    private void initTmplCatalogProcess(DynamicObject d, Map<Long, DynamicObject> needUpdateDy) {
        Long id = d.getLong("template.templatecatalog.id");
        String number = d.getString("template.templatecatalog.number");
        DynamicObject dy = needUpdateDy.get(id);
        if (dy != null) {
            d.set("processid", (Object)dy.getLong("process.id"));
            d.set("processnumber", (Object)number);
            return;
        }
        DynamicObject process = DimensionServiceHelper.queryMemberIdByNumber("bcm_processmembertree", this.model.p1, number);
        if (process == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6a21\u677f\u5206\u7c7b\u4e2d\u7684\u8fc7\u7a0b\u5c5e\u6027\uff1a%s", (String)"CheckContext_1", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        Long processId = process.getLong("id");
        DynamicObject cat = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_checktmplcatalog"));
        DynamicObject processObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_processmembertree"));
        processObj.set("id", (Object)processId);
        cat.set("process", (Object)processObj);
        cat.set("process.id", (Object)processId);
        needUpdateDy.put(id, cat);
        d.set("processid", (Object)processId);
        d.set("processnumber", (Object)number);
    }

    private void initScope() {
        if (!this.isAvailable) {
            return;
        }
        if (this.checkTmplMap.isEmpty()) {
            return;
        }
        this.addScope(PresetConstant.SCENE_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.SCENE_DIM, (Object)this.toStringArray((String)this.param.getScene().p2)));
        this.addScope(PresetConstant.FY_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.FY_DIM, (Object)this.toStringArray((String)this.param.getYear().p2)));
        this.addScope(PresetConstant.PERIOD_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.PERIOD_DIM, (Object)this.toStringArray((String)this.param.getPeriod().p2)));
        if (!this.isCompany) {
            if (this.param.getCurrency() != null && this.param.getCurrency().p2 != null) {
                this.addScope(PresetConstant.CURRENCY_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.CURRENCY_DIM, (Object)this.toStringArray((String)this.param.getCurrency().p2)));
            } else {
                this.addScope(PresetConstant.CURRENCY_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.CURRENCY_DIM, (Object)this.toStringArray(this.currencyNumber)));
            }
        }
        HashSet accountNumb = new HashSet(16);
        HashSet ctNumb = new HashSet(16);
        HashSet ruleNumb = new HashSet(16);
        HashSet dataSortNumb = new HashSet(16);
        HashSet auditTrailNumb = new HashSet(16);
        HashMap<String, Set> userDefinedDimMap = new HashMap<String, Set>(16);
        QFBuilder qf = new QFBuilder();
        qf.add("model.id", "=", this.model.p1);
        qf.add("aggoprt", "=", (Object)AggOprtEnum.SKIP.getSign());
        qf.add("isleaf", "=", (Object)Boolean.TRUE);
        Set skipAggoprtATNums = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"number,datasource", (QFilter[])qf.toArray()).stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        this.checkTmplMap.forEach((k, v) -> v.stream().forEach(e -> e.getEntries().forEach(entry -> {
            if (!entry.isDiffitem()) {
                Optional.ofNullable(entry.getAccountNumbers()).ifPresent(p -> accountNumb.addAll(entry.getAccountNumbers()));
                Optional.ofNullable(entry.getChangetypeNumber()).ifPresent(p -> ctNumb.add(entry.getChangetypeNumber()));
                if (this.isSpptMultRule) {
                    Optional.ofNullable(entry.getRuleNumber()).ifPresent(p -> ruleNumb.add(entry.getRuleNumber()));
                }
                if (this.isSpptDataSort) {
                    Optional.ofNullable(entry.getDatasortNumber()).ifPresent(p -> dataSortNumb.add(entry.getDatasortNumber()));
                }
                this.userDefineDims.forEach(dimNum -> this.initUserDefineDimScope(userDefinedDimMap, (CheckTmpl.Entry)entry, (String)dimNum));
                this.initAudittrailDimScope(auditTrailNumb, (CheckTmpl.Entry)entry, "audittrail", skipAggoprtATNums);
            }
        })));
        this.addScope(PresetConstant.ACCOUNT_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.ACCOUNT_DIM, (Object)accountNumb.toArray(new String[0])));
        if (MemberReader.isExistChangeTypeDimension((long)((Long)this.model.p1))) {
            this.addScope(PresetConstant.CHANGETYPE_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.CHANGETYPE_DIM, (Object)ctNumb.toArray(new String[0])));
        }
        if (MemberReader.isExistAuditTrailDimension((long)((Long)this.model.p1))) {
            this.addScope(PresetConstant.AUDITTRIAL_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.AUDITTRIAL_DIM, (Object)auditTrailNumb.toArray(new String[0])));
        }
        userDefinedDimMap.forEach((dimNumber, membSet) -> {
            if (membSet == null || membSet.size() == 0) {
                this.addScope((String)dimNumber, null);
            } else {
                this.addScope((String)dimNumber, (Pair<String, String[]>)Pair.onePair((Object)dimNumber, (Object)membSet.toArray(new String[0])));
            }
        });
        if (this.isSpptMultRule) {
            this.addScope(PresetConstant.RULE_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.RULE_DIM, (Object)ruleNumb.toArray(new String[0])));
        }
        if (this.isSpptDataSort) {
            this.addScope(PresetConstant.DATASORT_DIM, (Pair<String, String[]>)Pair.onePair((Object)PresetConstant.DATASORT_DIM, (Object)dataSortNumb.toArray(new String[0])));
        }
    }

    private void checkScope() {
        if (!this.isAvailable) {
            return;
        }
        HashSet<String> dimNames = new HashSet<String>(16);
        for (Pair<String, String[]> pair : this.getScopes()) {
            if (pair == null || PresetConstant.ENTITY_DIM.equals(pair.p1) || PresetConstant.MYCOMPANY_DIM.equals(pair.p1) || PresetConstant.INTERNALCOMPANY_DIM.equals(pair.p1) || !DimTypesEnum.include((String)((String)pair.p1)) || pair.p2 != null && ((String[])pair.p2).length != 0) continue;
            dimNames.add(DimTypesEnum.getDimTypesEnumByNumber((String)((String)pair.p1)).getName());
        }
        if (dimNames.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62b5\u9500\u6a21\u677f\u4e2d\u201c%s\u7ef4\u5ea6\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u62b5\u9500\u6a21\u677f\u3002", (String)"CheckContext_3", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)", ", dimNames)));
        }
        if (this.leafEntitySet.isEmpty()) {
            this.isAvailable = false;
            log.warn(String.format("\u7ec4\u7ec7%s\u4e0b\u6ca1\u6709\u53ef\u53c2\u4e0e\u5bf9\u8d26\u7684\u660e\u7ec6\u8282\u70b9\uff0c\u4e0d\u9700\u8981\u5bf9\u8d26\u3002", this.getCheckParam().getEntity().p2));
        }
        if (this.checkTmplMap.isEmpty()) {
            this.isAvailable = false;
            log.warn("\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u8d26\u6a21\u677f\uff0c\u4e0d\u9700\u8981\u5bf9\u8d26\u3002");
        }
    }

    protected void initEntity() {
        Long entityid = (Long)this.getCheckParam().getEntity().p1;
        if (entityid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8d26\u53c2\u6570\u3002", (String)"CheckContext_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject dyna = OrgCurrencyServiceHelper.getOrgById(entityid, (Long)this.getCheckParam().getYear().p1, (Long)this.getCheckParam().getPeriod().p1);
        if (dyna != null) {
            boolean isLeaf = dyna.getBoolean("isleaf");
            this.setCompany(isLeaf);
            this.getCheckParam().setEntity((Pair<Long, String>)Pair.onePair((Object)entityid, (Object)dyna.getString("number")));
            this.entity = Tuple.create((Object)dyna.getLong("id"), (Object)dyna.getString("number"), (Object)dyna.getString("longnumber"));
            this.currencyNumber = this.getCheckParam().getCurrency() != null ? (String)this.getCheckParam().getCurrency().p2 : dyna.getString("currency.number");
            if (isLeaf && !dyna.getBoolean("isinnerorg")) {
                this.isAvailable = false;
            }
        }
    }

    private void initEntityVersion() {
        if (!this.isAvailable) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", this.model.p1);
        QFilter qFilter = new QFilter("isinnerorg", "=", (Object)Boolean.TRUE);
        if (!ConfigServiceHelper.isHwApp()) {
            qFilter.or("isleaf", "=", (Object)Boolean.FALSE);
        }
        qfBuilder.add(qFilter);
        qfBuilder.add("isexchangerate", "=", (Object)Boolean.FALSE);
        qfBuilder.add(this.getEntityVersionLongNumberQF());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, isleaf,longnumber, number", (QFilter[])qfBuilder.toArray());
        Set<String> noMerge = this.getNoMerge();
        if (!this.isCompany) {
            if (noMerge != null && noMerge.size() > 0) {
                noMerge.removeIf(num -> ((String)this.entity.p3).contains(num + "!") || ((String)this.entity.p3).endsWith((String)num));
                doc.removeIf(e -> noMerge.stream().anyMatch(num -> e.getString("longnumber").contains(num + "!") || e.getString("longnumber").endsWith((String)num)));
            }
        } else {
            doc.removeIf(e -> e.getBoolean("isleaf") && noMerge.stream().anyMatch(num -> e.getString("longnumber").endsWith((String)num)));
        }
        if (this.param.get("checkRecordIds") == null) {
            CheckUtil.filterInnerInternalCompany((Long)this.model.p1, (Long)this.param.getScene().p1, (Long)this.param.getYear().p1, (Long)this.param.getPeriod().p1, doc);
        }
        FilterOrgStructParam orgParam = new FilterOrgStructParam((long)((Long)this.model.p1), (long)((Long)this.param.getScene().p1), (String)this.param.getYear().p2, (long)((Long)this.param.getPeriod().p1));
        orgParam.setFrom(FilterOrgStructParam.FROM_CHECKELIM);
        orgParam.setOpenSortedDictionary(true);
        Map<Long, String> effectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, doc.stream().map(p -> p.getLong("id")).collect(Collectors.toList()));
        Map<String, Set<Long>> orgByChangeType = EntityVersioningUtil.sortOrgByChangeType((String)this.model.p2, this.isCompany ? null : (String)this.entity.p2, effectiveOrgMap.keySet(), orgParam.getSortedDictionary());
        orgByChangeType.forEach((num, orgIdList) -> {
            if (!orgIdList.isEmpty()) {
                IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)((String)this.model.p2), (String)"Entity", (long)((Long)orgIdList.iterator().next()));
                this.sortedOrgByChangeType.put((String)num, (Pair<Long, String>)Pair.onePair((Object)orgNode.getId(), (Object)orgNode.getLongNumber()));
            }
        });
        this.entityVersion = this.sortedOrgByChangeType.values().stream().map(e -> (String)e.p2).collect(Collectors.toSet());
        this.putProperty("entityVersion", this.entityVersion);
    }

    private void initEntityScope() {
        if (!this.isAvailable) {
            return;
        }
        this.unLeafEntitySet = new HashSet<String>(16);
        this.unLeafEntityIds = new HashSet<Long>(16);
        QFBuilder qf3 = new QFBuilder();
        qf3.add("model", "=", this.model.p1);
        qf3.add("isleaf", "=", (Object)Boolean.FALSE);
        qf3.add("isexchangerate", "=", (Object)Boolean.FALSE);
        qf3.add(this.getLongNumberQF());
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number, longnumber, currency.number", (QFilter[])qf3.toArray()).forEach(e -> {
            if (this.entityVersion.contains(e.getString("longnumber"))) {
                this.unLeafEntitySet.add(e.getString("number"));
                this.unLeafEntityIds.add(e.getLong("id"));
            }
        });
        this.srptUnLeafEntitySet = new HashSet<String>(16);
        this.csteUnLeafEntitySet = new HashSet<String>(16);
        Map<String, MergeDataSourceEnum> mergeDataSourceMap = MergeControlHelper.getMergeSource(this.model.p1, this.getCheckParam().getScene().p1, this.getCheckParam().getYear().p1, this.getCheckParam().getPeriod().p1, this.unLeafEntitySet);
        mergeDataSourceMap.forEach((k, v) -> {
            if (v == MergeDataSourceEnum.CSTE) {
                this.csteUnLeafEntitySet.add((String)k);
            } else {
                this.srptUnLeafEntitySet.add((String)k);
            }
        });
        HashSet<String> myCsteUnLeafEntitySetByCM028 = new HashSet<String>(16);
        HashSet myLeafEntitySet = new HashSet(16);
        HashSet<String> adjentityVersion = new HashSet<String>(this.entityVersion);
        if (!ConfigServiceHelper.getBoolParam((Long)this.model.p1, "CM028") && CheckCreateTypeEnum.CHECKADJUST_CREATE.value.equals(this.param.getCreateTypeEnum().value)) {
            if (this.isSpptMyCompany) {
                adjentityVersion.removeIf(e -> {
                    for (String csteEntity : this.csteUnLeafEntitySet) {
                        if (!e.contains("!" + csteEntity + "!")) continue;
                        return true;
                    }
                    return false;
                });
            } else {
                this.entityVersion.removeIf(e -> {
                    for (String csteEntity : this.csteUnLeafEntitySet) {
                        if (!e.contains("!" + csteEntity + "!")) continue;
                        return true;
                    }
                    return false;
                });
            }
            this.csteUnLeafEntitySet.forEach(e -> {
                if (adjentityVersion.stream().anyMatch(v -> v.endsWith((String)e))) {
                    myCsteUnLeafEntitySetByCM028.add((String)e);
                }
            });
            this.putProperty("entityVersion", this.entityVersion);
        } else {
            myCsteUnLeafEntitySetByCM028.addAll(this.csteUnLeafEntitySet);
        }
        this.leafEntitySet = new HashSet<String>(16);
        if (this.isCompany) {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", this.model.p1);
            qf.add("isinnerorg", "=", (Object)Boolean.TRUE);
            qf.add("isexchangerate", "=", (Object)Boolean.FALSE);
            qf.add("isleaf", "=", (Object)Boolean.TRUE);
            qf.add("isinnerorg", "=", (Object)Boolean.TRUE);
            qf.add("longnumber", "like", (Object)(EntityServiceHelper.getSecondLongNumber((String)this.entity.p3) + "!%"));
            QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number, longnumber, currency.number", (QFilter[])qf.toArray()).forEach(e -> {
                if (this.entityVersion.contains(e.getString("longnumber"))) {
                    this.leafEntitySet.add(e.getString("number"));
                }
                if (adjentityVersion.contains(e.getString("longnumber"))) {
                    myLeafEntitySet.add(e.getString("number"));
                }
            });
        } else {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", this.model.p1);
            qf.add("isinnerorg", "=", (Object)Boolean.TRUE);
            qf.add("isexchangerate", "=", (Object)Boolean.FALSE);
            qf.add("isleaf", "=", (Object)Boolean.TRUE);
            qf.add("longnumber", "like", (Object)((String)this.entity.p3 + "!%"));
            QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number, longnumber, currency.number", (QFilter[])qf.toArray()).forEach(e -> {
                if (this.entityVersion.contains(e.getString("longnumber"))) {
                    this.leafEntitySet.add(e.getString("number"));
                }
                if (adjentityVersion.contains(e.getString("longnumber"))) {
                    myLeafEntitySet.add(e.getString("number"));
                }
            });
        }
        this.adjEntitySet = new HashSet<String>(16);
        if (this.isSpptMyCompany) {
            this.adjEntitySet.addAll(myCsteUnLeafEntitySetByCM028);
            this.adjEntitySet.addAll(myLeafEntitySet);
        } else {
            this.adjEntitySet.addAll(this.leafEntitySet);
        }
    }

    private QFilter getEntityVersionLongNumberQF() {
        String longNumber = this.getLongNumber();
        return new QFilter("longnumber", "like", (Object)(longNumber + "!%")).or("longnumber", "=", (Object)longNumber).or("longnumber", "in", EntityServiceHelper.getParentLongNumber(longNumber));
    }

    private QFilter getLongNumberQF() {
        String longNumber = this.getLongNumber();
        return new QFilter("longnumber", "like", (Object)(longNumber + "!%")).or("longnumber", "=", (Object)longNumber);
    }

    private String getLongNumber() {
        return this.isCompany ? EntityServiceHelper.getSecondLongNumber((String)this.entity.p3) : (String)this.entity.p3;
    }

    private String[] toStringArray(String ... s) {
        return s;
    }

    @Override
    public List<String> getAllDims() {
        return this.allDims;
    }

    private void initUserDefineDimScope(Map<String, Set<String>> userDefineDimMap, CheckTmpl.Entry entry, String dimNum) {
        String field = this.fieldMapped.get(dimNum);
        Optional<CheckTmpl.EntryDetailWithSign> t = entry.getDims().stream().filter(e -> field.equals(e.getSign())).findFirst();
        if (t.isPresent()) {
            CheckTmpl.EntryDetailWithSign detailWithSign = t.get();
            Set dimSet = userDefineDimMap.computeIfAbsent(dimNum, k -> new HashSet(16));
            dimSet.addAll(detailWithSign.getNumberSet());
        }
    }

    private void initAudittrailDimScope(Set<String> dimSet, CheckTmpl.Entry entry, String dimNum, Set<String> skipAggoprtATNums) {
        Optional<CheckTmpl.EntryDetailWithSign> t = entry.getDims().stream().filter(e -> dimNum.equals(e.getSign())).findFirst();
        if (t.isPresent()) {
            CheckTmpl.EntryDetailWithSign detailWithSign = t.get();
            HashSet<String> numberSet = new HashSet<String>(detailWithSign.getNumberSet());
            numberSet.removeIf(e -> "EntityInputTraDif".equals(e) || skipAggoprtATNums.contains(e));
            dimSet.addAll(numberSet);
        }
    }

    @Override
    public List<String> getUserDefineDims() {
        return this.userDefineDims;
    }

    @Override
    public Tuple<Long, String, String> getEntity() {
        return this.entity;
    }

    @Override
    public CheckParam getCheckParam() {
        return this.param;
    }

    @Override
    public Map<String, String> getUserDefineNumberMap() {
        return this.userDefineNumberMap;
    }

    @Override
    public Map<String, String> getFieldMapped() {
        return this.fieldMapped;
    }

    @Override
    public boolean isCompany() {
        return this.isCompany;
    }

    public void setCompany(boolean isCompany) {
        this.isCompany = isCompany;
    }

    @Override
    public Map<EntityKey, Pair<Long, String>> getParentMap() {
        return this.parentMap;
    }

    @Override
    public void setParentMap(Map<EntityKey, Pair<Long, String>> parentMap) {
        this.parentMap = parentMap;
    }

    @Override
    public Map<String, List<CheckTmpl>> getCheckTmplMap() {
        return this.checkTmplMap;
    }

    @Override
    public Map<String, Long> getAllDimNumberIdMapped() {
        return this.allDimNumberIdMapped;
    }

    @Override
    public Map<Long, String> getAllDimIdNumberMapped() {
        return this.allDimIdNumberMapped;
    }

    @Override
    public Map<String, String> getEntCurrencyMapped() {
        return this.entCurrencyMapped;
    }

    @Override
    public void setEntCurrencyMapped(Map<String, String> entCurrencyMapped) {
        this.entCurrencyMapped = entCurrencyMapped;
    }

    @Override
    public boolean isSpptMultRule() {
        return this.isSpptMultRule;
    }

    @Override
    public boolean isSpptDataSort() {
        return this.isSpptDataSort;
    }

    @Override
    public boolean isSpptMyCompany() {
        return this.isSpptMyCompany;
    }

    @Override
    public void setNeedMonitorDataStatus(boolean b) {
        this.isNeedMonitorDataStatus = b;
    }

    @Override
    public boolean isNeedMonitorDataStatus() {
        return this.isNeedMonitorDataStatus;
    }

    @Override
    public Set<String> getLeafEntitySet() {
        return this.leafEntitySet;
    }

    @Override
    public Set<String> getUnLeafEntitySet() {
        return this.unLeafEntitySet;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public CheckResult getCheckResult() {
        return this.checkResult;
    }

    @Override
    public void setCheckResult(CheckResult checkResult) {
        this.checkResult = checkResult;
    }

    @Override
    public <T> void putProperty(String key, T v) {
        this.properties.put(key, v);
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    @Override
    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    @Override
    public boolean isIncludeADJ() {
        return this.isIncludeADJ;
    }

    @Override
    public Set<String> getAdjEntitySet() {
        return this.adjEntitySet;
    }

    @Override
    public Set<String> getNoMerge() {
        return (Set)this.getProperty("noMerge");
    }

    @Override
    public boolean isBatchDiff() {
        return this.getCheckRecordIds() != null;
    }

    @Override
    public Set<Long> getCheckRecordIds() {
        return (Set)this.getCheckParam().get("checkRecordIds");
    }

    @Override
    public Set<String> getSrptUnLeafEntitySet() {
        return this.srptUnLeafEntitySet;
    }

    @Override
    public Set<String> getCsteUnLeafEntitySet() {
        return this.csteUnLeafEntitySet;
    }

    @Override
    public Set<Long> getUnLeafEntityIds() {
        return this.unLeafEntityIds;
    }

    @Override
    public String getCheckExecuteType() {
        return this.checkExecuteType;
    }

    @Override
    public void setCheckExecuteType(String checkExecuteType) {
        this.checkExecuteType = checkExecuteType;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Map<String, Pair<Long, String>> getSortedOrgByChangeType() {
        return this.sortedOrgByChangeType;
    }

    public List<String> getSelectDimKeys() {
        return this.selectDimKeys;
    }

    public CheckParam getParam() {
        return this.param;
    }

    public Set<String> getEntityVersion() {
        return this.entityVersion;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCheckTmplMap(Map<String, List<CheckTmpl>> checkTmplMap) {
        this.checkTmplMap = checkTmplMap;
    }

    @Override
    public int getCheckJNGroupSize() {
        return this.checkJNGroupSize;
    }

    private static /* synthetic */ boolean lambda$initCheckTmpls$2(List noPermIds, DynamicObject e) {
        return noPermIds.contains(e.getLong("id"));
    }
}

