/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.ExecuteContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.allinone.service.BizRuleExecuteService;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.CheckResult;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.ICheckService;
import kd.fi.bcm.business.check.executor.CheckExecutorFactory;
import kd.fi.bcm.business.check.executor.ICheckExecutor;
import kd.fi.bcm.business.check.executor.InterCheckExecutor;
import kd.fi.bcm.business.check.helper.CheckRecordHelper;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.check.model.CheckRecord;
import kd.fi.bcm.business.check.model.ReportData;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.convert.convertor.CheckingDataHandler;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.ProcessUtils;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.enums.CheckStatusEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.ElimTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.fel.common.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckService
implements ICheckService {
    protected ICheckContext ctx;
    private List<ICheckExecutor> chain;
    private IMDResultSet rs;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private static final Set<String> dimSet = Sets.newHashSet((Object[])new String[]{"Entity", "MyCompany", "InternalCompany"});

    public CheckService(ICheckContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void execute() {
        this.log.startWatch();
        this.ctx.getCheckParam().stepCount();
        this.beforeExecute();
        this.ctx.getCheckParam().stepCount();
        this.log.info(String.format("\u7ec4\u7ec7%s\u5bf9\u8d26\uff0c\u591a\u7ef4\u5e93\u67e5\u8be2\u51fa\u6765\u7684\u5bf9\u8d26\u6570\u636e\u6709%s\u6761\uff0c\u51c6\u5907\u6570\u636e\u8017\u65f6\u3002", this.ctx.getCheckParam().getEntity().p2, this.rs != null ? this.rs.getFetchSize() : 0));
        this.doExecute();
        this.ctx.getCheckParam().stepCount();
        this.log.info(String.format("\u7ec4\u7ec7%s\u5bf9\u8d26\uff0c\u5bf9\u8d26\u8017\u65f6\u3002", this.ctx.getCheckParam().getEntity().p2));
        this.afterExecute();
        this.log.info(String.format("\u7ec4\u7ec7%s\u5bf9\u8d26\uff0c\u5bf9\u8d26\u540e\u5904\u7406\u8017\u65f6\u3002", this.ctx.getCheckParam().getEntity().p2));
        this.log.infoEnd(String.format("\u7ec4\u7ec7%s\u5bf9\u8d26\uff0cexecute\u65b9\u6cd5\u5171\u8017\u65f6\u3002", this.ctx.getCheckParam().getEntity().p2));
        this.ctx.getCheckParam().stepCount();
    }

    @Override
    public void beforeExecute() {
        if (!this.ctx.isAvailable()) {
            return;
        }
        this.prepareData();
        if (this.rs.isEmpty()) {
            this.log.warn("\u591a\u7ef4\u5e93\u4e2d\u67e5\u8be2\u51fa\u6765\u7684\u5bf9\u8d26\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5bf9\u8d26\u3002");
            return;
        }
        this.chain = new ArrayList<ICheckExecutor>(5);
        this.ctx.getCheckTmplMap().forEach((k, v) -> this.chain.add(CheckExecutorFactory.getExecutor(this.ctx, ElimTypeEnum.getEnum((String)k))));
        this.initCommonParent(this.ctx, this.rs);
    }

    private void prepareData() {
        this.doExecuteADJRule();
        this.doConvert();
        this.rs = this.queryCheckData(this.ctx, this.ctx.isIncludeADJ() ? "TARPT" : "Rpt");
        if (this.ctx.isIncludeADJ() && ConfigServiceHelper.getBoolParam((Long)this.ctx.getModel().p1, "isSupportCheckADJRule")) {
            this.ctx.putProperty("rptdata", this.queryCheckData(this.ctx, "Rpt"));
        }
    }

    private void doExecuteADJRule() {
        if (this.ctx.isIncludeADJ() && !CollectionUtils.isEmpty(this.ctx.getUnLeafEntityIds()) && ConfigServiceHelper.getBoolParam((Long)this.ctx.getModel().p1, "isSupportCheckADJRule")) {
            Map<String, Boolean> orgStatus = AllInOneUtils.isSubmittedBatch((Long)this.ctx.getModel().p1, this.ctx.getUnLeafEntitySet(), this.ctx.getCheckParam().getScene().p1, this.ctx.getCheckParam().getYear().p1, this.ctx.getCheckParam().getPeriod().p1);
            for (Long id : this.ctx.getUnLeafEntityIds()) {
                IDNumberTreeNode member = MemberReader.findMemberById((long)((Long)this.ctx.getModel().p1), (String)"bcm_entitymembertree", (Long)id);
                if (orgStatus.getOrDefault(member.getNumber(), Boolean.FALSE).booleanValue()) continue;
                OrgBuilder build = OrgBuilder.build((Long)this.ctx.getModel().p1, (Long)this.ctx.getCheckParam().getScene().p1, (Long)this.ctx.getCheckParam().getYear().p1, (Long)this.ctx.getCheckParam().getPeriod().p1);
                OrgNode orgNode = build.genOrgNode(id);
                build.extendDirectChildren(orgNode);
                this.getBizRuleExecuteService().executeMultiOrgRule(Collections.singletonList("ADJ"), orgNode.getEC(), orgNode.getMergeChildrenRelaWithParentPair());
            }
        }
    }

    private void doConvert() {
        HashMultimap adjOrgs = HashMultimap.create();
        HashSet allOrgs = Sets.newHashSetWithExpectedSize((int)16);
        HashMultimap abMap = HashMultimap.create();
        IMDResultSet rs = this.queryRawData(this.ctx);
        while (rs.next()) {
            String a;
            String e2 = rs.getString(PresetConstant.ENTITY_DIM);
            String mc = this.ctx.isSpptMyCompany() ? rs.getString(PresetConstant.MYCOMPANY_DIM) : null;
            String ic = rs.getString(PresetConstant.INTERNALCOMPANY_DIM);
            allOrgs.add(e2);
            allOrgs.add(mc);
            allOrgs.add(ic);
            if (!this.isNotPresetICMember(ic)) continue;
            String string = a = this.ctx.isSpptMyCompany() ? mc : e2;
            if (a != null && a.contains("_")) {
                a = a.split("_")[1];
            }
            abMap.put((Object)a, (Object)ic);
        }
        QFilter modelQf = new QFilter("model", "=", this.ctx.getModel().p1);
        QFilter numberQf = new QFilter("number", "in", this.transVirtrual2RealEntity(allOrgs));
        QFilter storageQf = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        DynamicObjectCollection orgs = OrgCurrencyServiceHelper.getOrgsCurrency(new QFilter[]{modelQf, numberQf, storageQf}, (Long)this.ctx.getCheckParam().getYear().p1, (Long)this.ctx.getCheckParam().getPeriod().p1);
        HashMap currencyMap = new HashMap(orgs.size());
        orgs.forEach(dy -> currencyMap.put(dy.getString("number"), Pair.onePair((Object)dy.getLong("id"), (Object)dy.getString("currency.number"))));
        HashMultimap theSameParentOrgMap = HashMultimap.create();
        HashMultimap org2CurrencyMap = HashMultimap.create();
        HashSet<String> abOrgs = new HashSet<String>(16);
        abOrgs.addAll(abMap.keySet());
        abOrgs.addAll(abMap.values());
        HashMultimap<String, String> orgNumMapLongNum = CheckingDataHandler.queryEntiyLongNumber(abOrgs, this.ctx);
        abMap.asMap().entrySet().forEach(e -> orgNumMapLongNum.get(e.getKey()).forEach(myCompLongNum -> ((Collection)e.getValue()).forEach(interCompNum -> orgNumMapLongNum.get(interCompNum).forEach(interCompLongNum -> {
            String theSameParentLongNum = CheckingDataHandler.getTheSameParentLongNum(myCompLongNum, interCompLongNum);
            theSameParentOrgMap.put(e.getKey(), (Object)theSameParentLongNum);
        }))));
        if (!theSameParentOrgMap.isEmpty()) {
            Map<String, String> orgLongNum2CurrencyMap = CheckingDataHandler.queryEntityCurrencyByLongNum(theSameParentOrgMap.values(), (Long)this.ctx.getModel().p1, (Long)this.ctx.getCheckParam().getYear().p1, (Long)this.ctx.getCheckParam().getPeriod().p1);
            theSameParentOrgMap.forEach((k, v) -> {
                if (this.ctx.getCheckParam().getCurrency() != null) {
                    org2CurrencyMap.put(k, this.ctx.getCheckParam().getCurrency().p2);
                } else {
                    org2CurrencyMap.put(k, orgLongNum2CurrencyMap.get(v));
                }
            });
        }
        HashSet msgs = new HashSet();
        HashSet<String> cvtSet = new HashSet<String>();
        rs.beforeFirst();
        ArrayList<Callable<Set>> tasks = new ArrayList<Callable<Set>>();
        while (rs.next()) {
            Set transCurrencies;
            String inputCurrency;
            String entity = rs.getString(PresetConstant.ENTITY_DIM);
            String mc = this.ctx.isSpptMyCompany() ? rs.getString(PresetConstant.MYCOMPANY_DIM) : null;
            String process = rs.getString(PresetConstant.PROCESS_DIM);
            if ("TADJ".equals(process)) {
                process = "ADJ";
            }
            if ("ADJ".equals(process)) {
                String[] e3 = entity.split("_");
                if (!currencyMap.containsKey(e3[0])) {
                    if ("Entity".equals(e3[0])) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u6210\u5458 %s \u7684\u5e01\u79cd\u751f\u6548\u65e5\u671f\u3002", (String)"CheckService_3", (String)"fi-bcm-business", (Object[])new Object[0]), e3[0]));
                }
                inputCurrency = (String)((Pair)currencyMap.get((Object)e3[0])).p2;
                transCurrencies = org2CurrencyMap.get((Object)(mc != null ? mc : e3[1]));
                entity = e3[1];
            } else {
                if (!currencyMap.containsKey(entity)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u6210\u5458 %s \u7684\u5e01\u79cd\u751f\u6548\u65e5\u671f\u3002", (String)"CheckService_3", (String)"fi-bcm-business", (Object[])new Object[0]), entity));
                }
                inputCurrency = (String)((Pair)currencyMap.get((Object)entity)).p2;
                transCurrencies = org2CurrencyMap.get((Object)(mc != null ? mc : entity));
            }
            for (String cvtCurrency : transCurrencies) {
                String originalEntity = rs.getString(PresetConstant.ENTITY_DIM);
                if ("ADJ".equals(process)) {
                    adjOrgs.put((Object)cvtCurrency, (Object)originalEntity);
                }
                if (inputCurrency.equals(cvtCurrency)) continue;
                String org2 = rs.getString(PresetConstant.ENTITY_DIM);
                String key = String.format("%s&%s&%s&%s", org2, inputCurrency, cvtCurrency, process);
                if (!cvtSet.add(key)) continue;
                String cvtProcess = process;
                tasks.add(() -> ConvertServiceHelper.convert4ProcessSpilt((Long)this.ctx.getModel().p1, (String)this.ctx.getCheckParam().getScene().p2, (String)this.ctx.getCheckParam().getYear().p2, (String)this.ctx.getCheckParam().getPeriod().p2, org2, cvtProcess, cvtCurrency, false));
            }
        }
        if (tasks.size() > 0) {
            List results = ThreadPoolService.runInWaiting4Thread(tasks.toArray(new Callable[0]));
            results.forEach(r -> msgs.addAll(r));
        }
        if (msgs.size() > 0) {
            throw new KDBizException(new ErrorCode("inner_chk_101", String.join((CharSequence)";", msgs)), new Object[0]);
        }
        if (!adjOrgs.isEmpty()) {
            adjOrgs.keySet().forEach(arg_0 -> this.lambda$doConvert$9((Multimap)adjOrgs, arg_0));
        }
    }

    private Set<String> transVirtrual2RealEntity(Set<String> orgs) {
        HashSet<String> newOrgs = new HashSet<String>(orgs.size());
        for (String o : orgs) {
            if (o != null && o.contains("_")) {
                String[] org = o.split("_");
                newOrgs.add(org[0]);
                newOrgs.add(org[1]);
                continue;
            }
            newOrgs.add(o);
        }
        return newOrgs;
    }

    private boolean isNotPresetICMember(String ic) {
        return !"ICEntity".equals(ic) && !"ICOEntity".equals(ic) && !"ICTotal".equals(ic) && !"ICNone".equals(ic) && !"InternalCompany".equals(ic);
    }

    @Override
    public void afterExecute() {
        if (!this.ctx.isAvailable()) {
            return;
        }
        this.dealPhaSubmitCheckMsg(this.ctx);
    }

    private void dealPhaSubmitCheckMsg(ICheckContext ctx) {
        Map subMap = (Map)ctx.getProperty("AllInOneSubmitted");
        if (subMap != null) {
            CheckResult checkResult = ctx.getCheckResult();
            if (checkResult != null && checkResult.getData() != null && checkResult.getData() instanceof Map) {
                Map data = (Map)checkResult.getData();
                data.putAll(subMap);
            } else if (ctx.getCheckResult() != null && !"fail".equals(ctx.getCheckResult().getErrorCode()) || ctx.getCheckResult() == null) {
                ctx.setCheckResult(CheckResult.success(subMap));
            }
        }
    }

    private void generateRetainRecs(DynamicObject dy, Map<String, Long> retainRecs) {
        BigDecimal value1 = dy.getBigDecimal("entryentity.entrydebit");
        BigDecimal value2 = dy.getBigDecimal("entryentity.entrycredit");
        if (BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0) {
            return;
        }
        String key = this.getRepeatKey(dy.getString("currency.number"), dy.getString("entryentity.entryorg.number"), dy.getString("entryentity.entrymycompany.number"), dy.getString("entryentity.entrycompany.number"), dy.getString("checktmpl.number"), dy.getString("entryentity.entrydebitaccout.number"), dy.getString("entryentity.entrycreditaccout.number"));
        retainRecs.put(key, dy.getLong("id"));
    }

    private String getRepeatKey(CheckRecord.Entry entry, String checkTmplNum, Long currencyId) {
        return this.getRepeatKey(this.getCacheNumberById(this.ctx, PresetConstant.CURRENCY_DIM, currencyId), this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, entry.getEntryorg()), entry.getEntrymycompany() == null || entry.getEntrymycompany() == 0L ? "" : this.getCacheNumberById(this.ctx, PresetConstant.MYCOMPANY_DIM, entry.getEntrymycompany()), this.getCacheNumberById(this.ctx, PresetConstant.INTERNALCOMPANY_DIM, entry.getEntrycompany()), checkTmplNum, this.getCacheNumberById(this.ctx, PresetConstant.ACCOUNT_DIM, entry.getEntrydebitaccout()), this.getCacheNumberById(this.ctx, PresetConstant.ACCOUNT_DIM, entry.getEntrycreditaccout()));
    }

    private String getRepeatKey(String currency, String org, String myCompany, String icCompany, String checkTmpl, String debit, String credit) {
        return currency + '#' + org + '#' + (StringUtils.isEmpty((CharSequence)myCompany) ? "" : myCompany) + '#' + icCompany + '#' + checkTmpl + '#' + debit + '#' + credit + '#';
    }

    private void doExecute() {
        if (!this.ctx.isAvailable()) {
            return;
        }
        ArrayList<CheckRecord> recs = new ArrayList<CheckRecord>(10);
        if (this.chain != null) {
            this.chain.forEach(e -> {
                List<CheckRecord> results = e.check(this.rs);
                if (results != null) {
                    recs.addAll(results);
                }
            });
        }
        this.ctx.getCheckParam().stepCount();
        String lockKey = this.getLockKey(this.ctx);
        try (DLock lock = DLock.create((String)lockKey);){
            if (!this.ctx.isCompany() && !lock.tryLock(10000L)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CheckService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.ctx.getCheckParam().getEntity().p2));
            }
            try (TXHandle tx = TX.required((String)"saveCheckRecord");){
                try {
                    this.doDelete(this.ctx);
                    this.ctx.getCheckParam().stepCount();
                    this.doSaveBatch(this.ctx, recs);
                }
                catch (Throwable t) {
                    tx.markRollback();
                    this.log.error("--doExecute--:\n" + ThrowableHelper.toString((Throwable)t));
                    String errMsg = t instanceof KDBizException ? t.getMessage() : ThrowableHelper.toString((Throwable)t);
                    throw new KDBizException(t, new ErrorCode("", errMsg), new Object[0]);
                }
            }
        }
    }

    private void doSaveBatch(ICheckContext ctx, List<CheckRecord> recs) {
        if (recs == null || recs.isEmpty()) {
            return;
        }
        if (!ctx.isSpptMyCompany() && ctx.getCsteUnLeafEntitySet().contains(ctx.getEntity().p2) && CheckCreateTypeEnum.CHECKADJUST_CREATE.value.equals(ctx.getCheckParam().getCreateTypeEnum().value)) {
            return;
        }
        Map<String, List<CheckRecord>> groupMap = recs.stream().collect(Collectors.groupingBy(r -> r.getEntityid() + "&" + ElimTypeEnum.getEnum((Integer)r.getElimType()).getNumber() + "&" + r.getTmpl().getId()));
        HashSet<Long> elimPks = new HashSet<Long>(16);
        groupMap.values().forEach(list -> BatchProcessHelper.batchConsume((List)list, (int)ctx.getCheckJNGroupSize(), subList -> this.doSave(ctx, new ArrayList<CheckRecord>((Collection<CheckRecord>)subList), elimPks)));
        this.doSycToMDD(elimPks);
    }

    private String getLockKey(ICheckContext ctx) {
        return "fi/bcm/" + (String)ctx.getModel().p2 + "." + (String)ctx.getCheckParam().getScene().p2 + "." + (String)ctx.getCheckParam().getYear().p2 + "." + (String)ctx.getCheckParam().getPeriod().p2 + "." + (String)ctx.getCheckParam().getEntity().p2;
    }

    private void initCommonParent(ICheckContext ctx, IMDResultSet rs) {
        if (rs instanceof MDResultSet) {
            HashSet<EntityKey> entityKey = new HashSet<EntityKey>(rs.getFetchSize());
            HashSet<String> mycompanies = new HashSet<String>(rs.getFetchSize());
            HashSet<String> entities = new HashSet<String>(rs.getFetchSize());
            HashSet<String> parentEntityNum = new HashSet<String>(16);
            rs.beforeFirst();
            while (rs.next()) {
                String mycompany = rs.getRow().getString(ctx.isSpptMyCompany() ? PresetConstant.MYCOMPANY_DIM : PresetConstant.ENTITY_DIM);
                if (mycompany.contains("_")) {
                    String[] split = mycompany.split("_");
                    mycompany = split[1];
                    parentEntityNum.add(split[0]);
                }
                String company = rs.getRow().getString(PresetConstant.INTERNALCOMPANY_DIM);
                entityKey.add(EntityKey.genKey(mycompany, company));
                mycompanies.add(mycompany);
                String entity = rs.getRow().getString(PresetConstant.ENTITY_DIM);
                if (entity.contains("_")) {
                    String[] split = entity.split("_");
                    entity = split[1];
                    parentEntityNum.add(split[0]);
                }
                entities.add(entity);
            }
            ctx.setParentMap(EntityServiceHelper.batchQueryCommonParent(ctx, entityKey));
            HashSet<String> ents = new HashSet<String>(mycompanies);
            ents.addAll(entities);
            if (ctx.getParentMap() != null && ctx.getParentMap().size() > 0) {
                for (Pair<Long, String> p : ctx.getParentMap().values()) {
                    ents.add((String)p.p2);
                }
            }
            if (ctx.isIncludeADJ()) {
                ents.addAll(parentEntityNum);
            }
            ctx.setEntCurrencyMapped(this.getEntityCurrencyMap((Long)ctx.getModel().p1, ents));
        }
    }

    public Map<String, String> getEntityCurrencyMap(Long modelId, Collection<String> orgMembNumbers) {
        String entity = "bcm_entitymembertree";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("number", "in", orgMembNumbers);
        qfBuilder.add("isexchangerate", "=", (Object)Boolean.FALSE);
        String selector = "id, number, currency.number";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entity, (String)selector, (QFilter[])qfBuilder.toArray());
        HashMap<String, String> entCurrencyMap = new HashMap<String, String>(16);
        doc.forEach(e -> entCurrencyMap.put(e.getString("number"), e.getString("currency.number")));
        return entCurrencyMap;
    }

    private void doDelete(ICheckContext ctx) {
        DynamicObjectCollection doc;
        HashMap<String, Long> retainRecs = new HashMap<String, Long>();
        ctx.putProperty("retainRecs", retainRecs);
        HashMap<String, String> checkRecordMark = new HashMap<String, String>(16);
        ctx.putProperty("checkRecordMark", checkRecordMark);
        String selectFields = "id,isautoelim,diffmode,currency.number,checktmpl,checktmpl.number,entryentity.entryorg.number,entryentity.entrycompany.number,entryentity.entrymycompany.number,entryentity.entrydebitaccout.number,entryentity.entrycreditaccout.number,entryentity.entrydebit,entryentity.entrycredit,entryentity.checktmplentry,model,scene,year,period,process,currency,entity,entryentity.entryorg,entryentity.entrymycompany,entryentity.entrycompany,entity.number,myentity.number,oppositeentity.number,checktmpl.balance,entryentity.dc,mark";
        Set checkTmplIds = ctx.getCheckTmplMap().values().stream().flatMap(a -> a.stream().map(CheckTmpl::getId)).collect(Collectors.toSet());
        HashSet<Long> adjustCheckIds = new HashSet<Long>(16);
        QFBuilder builder = new QFBuilder();
        if (ctx.getCheckParam().get("checkRecordIds") != null) {
            Set checkRecordIds = (Set)ctx.getCheckParam().get("checkRecordIds");
            doc = QueryServiceHelper.query((String)"bcm_checkrecord", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)checkRecordIds), new QFilter("checktmpl.id", "in", checkTmplIds)});
        } else {
            CheckParam param = ctx.getCheckParam();
            builder.add("model", "=", param.getModel().p1);
            builder.add("scene", "=", param.getScene().p1);
            builder.add("year", "=", param.getYear().p1);
            builder.add("period", "=", param.getPeriod().p1);
            if (ctx.isCompany()) {
                if (ctx.isSpptMyCompany()) {
                    builder.add(new QFilter("entryentity.entrymycompany.number", "=", param.getEntity().p2).or("entryentity.entrycompany.number", "=", param.getEntity().p2));
                } else {
                    builder.add(new QFilter("entryentity.entryorg.number", "=", param.getEntity().p2).or("entryentity.entrycompany.number", "=", param.getEntity().p2));
                }
                String secondLn = EntityServiceHelper.getSecondLongNumber((String)ctx.getEntity().p3);
                builder.add(new QFilter("entity.longnumber", "like", (Object)(secondLn + "!%")).or("entity.longnumber", "=", (Object)secondLn));
            } else {
                builder.add("entity.number", "=", param.getEntity().p2);
            }
            if (ctx.getCheckParam().getIcNumbers() != null && ctx.getCheckParam().getIcNumbers().length > 0) {
                ArrayList<String> icNumbers = new ArrayList<String>(Arrays.asList(ctx.getCheckParam().getIcNumbers()));
                if (ctx.isCompany()) {
                    icNumbers.removeIf(e -> e.equals(ctx.getEntity().p2));
                }
                if (icNumbers.isEmpty()) {
                    return;
                }
                if (ctx.isSpptMyCompany()) {
                    builder.add(new QFilter("entryentity.entrymycompany.number", "in", (Object)icNumbers).or("entryentity.entrycompany.number", "in", (Object)icNumbers));
                } else {
                    builder.add(new QFilter("entryentity.entryorg.number", "in", (Object)icNumbers).or("entryentity.entrycompany.number", "in", (Object)icNumbers));
                }
            }
            if (ctx.isIncludeADJ()) {
                if (param.getCreateTypeEnum() != null && CheckCreateTypeEnum.CHECK_CREATE == param.getCreateTypeEnum()) {
                    builder.add("createtype", "=", (Object)CheckCreateTypeEnum.CHECK_CREATE.value);
                } else {
                    builder.add("createtype", "!=", (Object)CheckCreateTypeEnum.CHECK_CREATE.value);
                }
            } else {
                builder.add("createtype", "!=", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
            }
            builder.add("checktmpl", "in", checkTmplIds);
            doc = QueryServiceHelper.query((String)"bcm_checkrecord", (String)selectFields, (QFilter[])builder.toArray());
        }
        HashMap<Long, Boolean> markPut = new HashMap<Long, Boolean>(16);
        for (DynamicObject dyn2 : doc) {
            String isAutoElim = dyn2.getString("isautoelim");
            Long id = dyn2.getLong("id");
            if ("1".equals(isAutoElim)) {
                this.cacheCheckMark(checkRecordMark, markPut, dyn2);
                adjustCheckIds.add(id);
                continue;
            }
            this.generateRetainRecs(dyn2, retainRecs);
        }
        if (adjustCheckIds.size() == 0) {
            return;
        }
        if (ctx.getCheckParam().isGenerateElim() && ctx.isIncludeADJ()) {
            this.addDeleteIds(builder, adjustCheckIds);
            DynamicObjectCollection checkIdMappings = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustCheckIds)});
            Set checkEntryIds = checkIdMappings.stream().map(e -> e.getLong("entryentity.id")).collect(Collectors.toSet());
            DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"elim.id,linkid,elim.status", (QFilter[])new QFilter[]{new QFilter("model", "=", ctx.getModel().p1), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.CHECK_RECORD.getBizType()), new QFilter("linkid", "in", checkEntryIds), new QFilter("elim.sourcetype", "=", (Object)(ElimRptAdjSourceTypeEnum.AUTO.getValue() + ""))});
            if (mappings.size() > 0) {
                Set needDeleteAdjustIds = mappings.stream().map(d -> d.getLong("elim.id")).collect(Collectors.toSet());
                Set<Long> needCheckStageLockAdjustIds = mappings.stream().filter(d -> RptAdjustStatusEnum.AUDIT.status().equals(d.getString("elim.status"))).map(d -> d.getLong("elim.id")).collect(Collectors.toSet());
                ArrayList lockStageInfo = new ArrayList(16);
                Map<Long, HashBasedTable<Long, Long, List<String>>> adjustDataLock = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(this.getOperationName(true), new AdjustOperationContext((Long)ctx.getCheckParam().getModel().p1, (Long)ctx.getCheckParam().getScene().p1, (Long)ctx.getCheckParam().getYear().p1, (Long)ctx.getCheckParam().getPeriod().p1), needCheckStageLockAdjustIds, pair -> {
                    lockStageInfo.addAll((Collection)pair.p2);
                    return "";
                });
                if (!adjustDataLock.isEmpty()) {
                    Set<Long> lockAdjustIds = adjustDataLock.keySet();
                    needDeleteAdjustIds.removeAll(lockAdjustIds);
                    Set lockCheckEntryIds = mappings.stream().filter(e -> lockAdjustIds.contains(e.getLong("elim.id"))).map(e -> e.getLong("linkid")).collect(Collectors.toSet());
                    Set lockCheckIds = checkIdMappings.stream().filter(e -> lockCheckEntryIds.contains(e.getLong("entryentity.id"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
                    adjustCheckIds.removeAll(lockCheckIds);
                    doc.stream().filter(e -> lockCheckIds.contains(e.getLong("id"))).forEach(dyn -> this.generateRetainRecs((DynamicObject)dyn, (Map<String, Long>)retainRecs));
                    lockStageInfo.forEach(p -> CheckUtil.saveLockInfo(ctx, "lockAdjustInfo", CheckConstant.CHECKCONTEXT_CONTROL_ADJUSTLOCK, String.format("%s(%s)", p.p1, p.p2)));
                }
                CheckParam param = ctx.getCheckParam();
                OperationResult operationResult = AdjustClearServiceHelper.batchDeleteAutoAdjust(this.getOperationName(true), (Long)param.getModel().p1, (Long)param.getScene().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1, new ArrayList<Long>(needDeleteAdjustIds));
                if (!operationResult.isSuccess()) {
                    this.log.error(String.format("CheckService.doDelete error, Message:%1$s   AllErrorInfo :%2$s ", operationResult.getMessage(), operationResult.getAllErrorInfo().toString()));
                    throw new KDBizException(String.format("AdjustClearServiceHelper.batchDeleteAutoAdjust :Message:%1$s   AllErrorInfo :%2$s ", operationResult.getMessage(), operationResult.getAllErrorInfo().toString()));
                }
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_checkrecord"), (Object[])adjustCheckIds.toArray());
    }

    private void cacheCheckMark(Map<String, String> checkRecordMark, Map<Long, Boolean> markPut, DynamicObject dyn) {
        BigDecimal value1 = dyn.getBigDecimal("entryentity.entrydebit");
        BigDecimal value2 = dyn.getBigDecimal("entryentity.entrycredit");
        if (BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0) {
            return;
        }
        if (dyn.getString("myentity.number") == null || dyn.getString("oppositeentity.number") == null) {
            return;
        }
        String markKey = this.getMarkKey(dyn);
        if (markKey == null) {
            return;
        }
        String mark = checkRecordMark.getOrDefault(markKey, "");
        Long chkRecId = dyn.getLong("id");
        if (dyn.getBoolean("checktmpl.balance")) {
            if (!markPut.containsKey(chkRecId)) {
                mark = StringUtils.isNotBlank((CharSequence)mark) && StringUtils.isNotBlank((CharSequence)dyn.getString("mark")) ? mark + "\r\n" + dyn.getString("mark") : (StringUtils.isNotBlank((CharSequence)mark) ? mark : dyn.getString("mark"));
            }
        } else {
            mark = dyn.getString("mark");
        }
        if (StringUtils.isEmpty((CharSequence)mark)) {
            mark = dyn.getString("mark");
        }
        markPut.put(chkRecId, true);
        checkRecordMark.put(markKey, mark);
    }

    private String getMarkKey(DynamicObject dyn) {
        HashMap entryMap = new HashMap(16);
        this.ctx.getCheckTmplMap().values().forEach(l -> l.forEach(t -> t.getEntries().forEach(e -> entryMap.put(e.getEntryId(), e))));
        CheckTmpl.Entry entry = (CheckTmpl.Entry)entryMap.get(dyn.getLong("entryentity.checktmplentry"));
        if (entry != null) {
            return this.getMarkKey(dyn.getString("entity.number"), dyn.getString("myentity.number"), dyn.getString("oppositeentity.number"), dyn.getString("currency.number"), dyn.getString("checktmpl.number"), dyn.getBoolean("checktmpl.balance"), dyn.getBoolean("entryentity.dc"), dyn.getString("entryentity.entrycompany.number"), entry);
        }
        return null;
    }

    private String getMarkKey(CheckRecord rec) {
        Optional<CheckRecord.Entry> first = rec.getEntries().stream().filter(e -> !e.isDi()).findFirst();
        return first.map(entry -> this.getMarkKey(this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, rec.getEntityid()), this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, rec.getMyentityid()), this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, rec.getOpentityid()), this.getCacheNumberById(this.ctx, PresetConstant.CURRENCY_DIM, rec.getCurrencyid()), rec.getTmpl().getNumber(), rec.getTmpl().isGroupDC(), entry.isDc(), this.getCacheNumberById(this.ctx, PresetConstant.INTERNALCOMPANY_DIM, entry.getEntrycompany()), entry.getTmplEntry())).orElse(null);
    }

    private String getMarkKey(String entity, String myentity, String oppositeentity, String currency, String tmplNum, boolean balance, boolean isDebit, String icNum, CheckTmpl.Entry tmplEntry) {
        boolean ab;
        Boolean myDebit = null;
        String myopType = "0";
        if (!balance) {
            myDebit = isDebit && oppositeentity.equals(icNum) || !isDebit && !oppositeentity.equals(icNum) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            if (this.ctx.isCompany() && !myentity.equals(this.ctx.getCheckParam().getEntity().p2)) {
                myDebit = myDebit == false;
            }
        }
        if ((ab = oppositeentity.equals(icNum)) && tmplEntry.getEntrymyop().equals("1") || !ab && tmplEntry.getEntrymyop().equals("2")) {
            myopType = "1";
        } else if (ab && tmplEntry.getEntrymyop().equals("2") || !ab && tmplEntry.getEntrymyop().equals("1")) {
            myopType = "2";
        }
        if (this.ctx.isCompany() && !myentity.equals(this.ctx.getCheckParam().getEntity().p2) && !myopType.equals("0")) {
            myopType = myopType.equals("1") ? "2" : "1";
        }
        String myoppoEntitySorted = Lists.newArrayList((Object[])new String[]{myentity, oppositeentity}).stream().sorted().collect(Collectors.joining(String.valueOf('#')));
        return entity + '#' + myoppoEntitySorted + '#' + currency + '#' + tmplNum + '#' + (myDebit == null ? "" : myDebit.toString()) + '#' + myopType;
    }

    private void addDeleteIds(QFBuilder builder, Set<Long> ids) {
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(10);
        for (QFilter qf : builder.toArray()) {
            String property = qf.getProperty();
            if ("isautoelim".equals(property) || "process.number".equals(property) || "createtype".equals(property) || "checktmpl".equals(property)) continue;
            if ("entryentity.entrymycompany.number".equals(property)) {
                qfs.add(new QFilter("mycompany.number", "=", qf.getValue()).or("company.number", "=", qf.getValue()));
                continue;
            }
            if ("entryentity.entryorg.number".equals(property)) {
                qfs.add(new QFilter("org.number", "=", qf.getValue()).or("company.number", "=", qf.getValue()));
                continue;
            }
            qfs.add(qf);
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checkrecordid", (String)"deletedcheckid", (QFilter[])qfs.toArray(new QFilter[0]));
        doc.forEach(e -> ids.add(e.getLong("deletedcheckid")));
        List deletedcheckid = doc.stream().map(e -> e.getLong("deletedcheckid")).collect(Collectors.toList());
        DynamicObject[] checkids = BusinessDataServiceHelper.load((String)"bcm_checkrecord", (String)"id,checktmpl", (QFilter[])new QFilter("id", "in", deletedcheckid).toArray());
        Arrays.stream(checkids).forEach(e -> {
            if (!this.ctx.getCheckTmplMap().entrySet().stream().flatMap(a -> ((List)a.getValue()).stream()).map(p -> p.getId()).collect(Collectors.toList()).contains(e.getLong("checktmpl.id"))) {
                ids.remove(e.getLong("id"));
            }
        });
        BusinessDataWriter.delete((String)"bcm_checkrecordid", (QFilter[])new QFilter[]{new QFilter("deletedcheckid", "in", ids)});
    }

    private void doSave(ICheckContext ctx, List<CheckRecord> recs, Set<Long> sycToMDDAdjustIds) {
        if (recs == null || recs.isEmpty()) {
            return;
        }
        if (!ctx.isSpptMyCompany() && ctx.getCsteUnLeafEntitySet().contains(ctx.getEntity().p2) && CheckCreateTypeEnum.CHECKADJUST_CREATE.value.equals(ctx.getCheckParam().getCreateTypeEnum().value)) {
            return;
        }
        int size = recs.size();
        HashMap<String, Object> sameHeadAdjusts = new HashMap<String, Object>(size);
        HashMultimap adjustRecordLink = HashMultimap.create();
        ArrayList<DynamicObject> recDynaObj = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> elimDynaObj = new ArrayList<DynamicObject>(size);
        ArrayList<DynamicObject> elimDataDynaObj = new ArrayList<DynamicObject>(10);
        HashSet<Long> linkSourceAdjustId = new HashSet<Long>(16);
        ArrayList<Long> elimDynaPks = new ArrayList<Long>(10);
        ArrayList needAuditIds = new ArrayList(16);
        Map retainRecs = (Map)ctx.getProperty("retainRecs");
        recs.removeIf(rec -> rec.getEntries().stream().filter(entry -> !BigDecimal.ZERO.equals(entry.getValue())).anyMatch(e -> retainRecs.containsKey(this.getRepeatKey((CheckRecord.Entry)e, rec.getTmpl().getNumber(), rec.getCurrencyid()))));
        if (recs.isEmpty()) {
            return;
        }
        Map<Long, String> checkNumbers = CheckRecordHelper.batchQueryCheckNumber(ctx, recs);
        Map checkRecordMark = (Map)ctx.getProperty("checkRecordMark");
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < recs.size(); ++i) {
            Object elimInfo;
            CheckRecord rec2 = recs.get(i);
            DynamicObject checkInfo = CheckRecordHelper.buildCheckDynamicObject(ctx, rec2, checkNumbers);
            if (this.isGenerateElim(rec2)) {
                checkInfo.set("status", (Object)(ctx.getCheckParam().isGenerateElim() ? CheckStatusEnum.CONFIRMED.getValue() : CheckStatusEnum.UNCONFIRM.value));
                this.handleDiffItems(checkInfo);
            } else if (rec2.getDiffMode() == 3 && rec2.getDifference().compareTo(BigDecimal.ZERO) != 0) {
                this.handleDiffItems(checkInfo);
            } else if (rec2.getDiffMode() == 5) {
                checkInfo.set("status", (Object)CheckStatusEnum.CONFIRMED.getValue());
            }
            String mark = (String)checkRecordMark.get(this.getMarkKey(rec2));
            if (StringUtils.isNotBlank((CharSequence)mark)) {
                checkInfo.set("mark", (Object)mark);
            }
            recDynaObj.add(checkInfo);
            if (!this.isGenerateElim(rec2) || !ctx.getCheckParam().isGenerateElim()) continue;
            if (ctx.isBatchDiff()) {
                elimInfo = CheckRecordHelper.buildElimDynamicObject(ctx, rec2, checkInfo.getLong("id"), "");
                elimDynaObj.add((DynamicObject)elimInfo);
            } else {
                String sameHeadKey = rec2.getEntityid() + "&" + ElimTypeEnum.getEnum((Integer)rec2.getElimType()).getNumber() + "&" + rec2.getTmpl().getId();
                if (sameHeadAdjusts.containsKey(sameHeadKey)) {
                    elimInfo = (DynamicObject)sameHeadAdjusts.get(sameHeadKey);
                } else {
                    elimInfo = CheckRecordHelper.buildElimDynamicObject(ctx, rec2, checkInfo.getLong("id"), "");
                    elimDynaObj.add((DynamicObject)elimInfo);
                    sameHeadAdjusts.put(sameHeadKey, elimInfo);
                }
            }
            DynamicObjectCollection elimDataColl = CheckRecordHelper.buildElimDataDynamicObject(ctx, rec2, (DynamicObject)elimInfo, checkInfo.getString("number"), EntrySourceEnum.CHECKAUTOCREATE, countMap);
            elimDataDynaObj.addAll((Collection<DynamicObject>)elimDataColl);
            if (rec2.getTmpl().isLinkage() == 1) {
                linkSourceAdjustId.add(elimInfo.getLong("id"));
            }
            elimDynaPks.add(elimInfo.getLong("id"));
            if (elimDataColl.isEmpty()) continue;
            adjustRecordLink.put((Object)elimInfo.getLong("id"), (Object)checkInfo);
        }
        this.checkAdjustData(elimDynaObj, elimDataDynaObj, linkSourceAdjustId);
        this.dealAdjustNumber(elimDynaObj, (Multimap<Long, DynamicObject>)adjustRecordLink);
        CheckRecordHelper.resetAdjustBalance((Long)ctx.getModel().p1, elimDynaObj, elimDataDynaObj);
        ctx.getCheckParam().stepCount();
        if (ctx.getCheckParam().isGenerateElim()) {
            if (elimDynaObj.size() > 0) {
                DynamicObject elim = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
                SaveServiceHelper.save((IDataEntityType)elim.getDynamicObjectType(), (Object[])elimDynaObj.toArray(new Object[0]));
            }
            if (elimDataDynaObj.size() > 0) {
                String modelNumber = MemberReader.findModelNumberById((Object)ctx.getModel().p1);
                elimDataDynaObj.forEach(d -> AdjustOperationHelper.fillAdjustDataOfOlapOrg(modelNumber, d, true));
                this.dealElimDataSeq(elimDataDynaObj);
                DynamicObject elimdata = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
                SaveServiceHelper.save((IDataEntityType)elimdata.getDynamicObjectType(), (Object[])elimDataDynaObj.toArray(new Object[0]));
                CheckRecordHelper.saveAdjustMapping(elimDataDynaObj);
                if (linkSourceAdjustId.size() > 0) {
                    LinkageMappingService.newObject(linkSourceAdjustId, EntrySourceEnum.CHECKLINKAGECREATE).buildAutoElimLinkage();
                }
                DynamicObjectCollection linkDyns = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id,linkagelinksource", (QFilter[])new QFilter("linkagelinksource", "in", elimDynaPks).toArray());
                HashMap<Long, Long> linkIdMap = new HashMap<Long, Long>(16);
                if (linkDyns != null) {
                    for (DynamicObject linkDyn : linkDyns) {
                        elimDynaPks.add(linkDyn.getLong("id"));
                        linkIdMap.put(linkDyn.getLong("id"), linkDyn.getLong("linkagelinksource"));
                    }
                }
                HashMultimap lockGroupMap = HashMultimap.create();
                ArrayList lockStageInfo = new ArrayList(16);
                HashBasedTable<Long, Long, List<String>> adjustDataLock = AdjustOperationHelper.batchCheckOlapDataLockByIds(this.getOperationName(false), new AdjustOperationContext((Long)ctx.getCheckParam().getModel().p1, (Long)ctx.getCheckParam().getScene().p1, (Long)ctx.getCheckParam().getYear().p1, (Long)ctx.getCheckParam().getPeriod().p1), elimDynaPks, pair -> {
                    lockGroupMap.put((Object)((IDynamicObjectModel)pair.p1).getLong("adjust"), (Object)((IDynamicObjectModel)pair.p1).getString("groupnum"));
                    lockStageInfo.addAll((Collection)pair.p2);
                    return "";
                });
                if (!adjustDataLock.isEmpty()) {
                    HashMultimap idGroupMap = HashMultimap.create();
                    lockGroupMap.forEach((id, groupNum) -> idGroupMap.put((Object)linkIdMap.getOrDefault(id, (Long)id), groupNum));
                    AdjustClearServiceHelper.batchDeleteAutoAdjustGroup("CheckService.doSave", (Long)ctx.getModel().p1, (Long)ctx.getCheckParam().getScene().p1, (Long)ctx.getCheckParam().getYear().p1, (Long)ctx.getCheckParam().getPeriod().p1, (HashMultimap<Long, String>)idGroupMap);
                    idGroupMap.forEach((arg_0, arg_1) -> CheckService.lambda$doSave$47((Multimap)adjustRecordLink, arg_0, arg_1));
                    lockStageInfo.forEach(p -> CheckUtil.saveLockInfo(ctx, "lockAdjustInfo", CheckConstant.CHECKCONTEXT_CONTROL_ADJUSTLOCK, String.format("%s(%s)", p.p1, p.p2)));
                    QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter[]{new QFilter("id", "in", elimDynaPks)}, null, (int)-1).forEach(id -> needAuditIds.add(LongUtil.toLong((Object)id)));
                    sycToMDDAdjustIds.addAll(needAuditIds);
                } else {
                    sycToMDDAdjustIds.addAll(elimDynaPks);
                }
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)"id,adjust.id,adjust.number,groupnum,checkrecordentry", (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", needAuditIds)});
                if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                    Map<String, Set<String>> adjGroupNums = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString("adjust.number"), Collectors.mapping(e -> e.getString("groupnum"), Collectors.toSet())));
                    Map<String, Set<String>> adjustDatas = (Map<String, Set<String>>)ctx.getProperty("addeded_AdjustDatas");
                    if (adjustDatas != null) {
                        CheckService.mergeMaps(adjustDatas, adjGroupNums);
                    } else {
                        adjustDatas = adjGroupNums;
                    }
                    ctx.putProperty("addeded_AdjustDatas", adjustDatas);
                }
            }
        }
        if (!recDynaObj.isEmpty()) {
            DynamicObject rec3 = BusinessDataServiceHelper.newDynamicObject((String)"bcm_checkrecord");
            SaveServiceHelper.save((IDataEntityType)rec3.getDynamicObjectType(), (Object[])recDynaObj.toArray(new Object[0]));
        }
    }

    private void dealAdjustNumber(List<DynamicObject> elimDynaObj, Multimap<Long, DynamicObject> adjustRecordLink) {
        if (elimDynaObj.isEmpty()) {
            return;
        }
        List numbers = CodeRuleServiceHelper.getNumbers((String)"bcm_rptadjust", elimDynaObj);
        if (numbers == null || numbers.size() != elimDynaObj.size() || numbers.contains(null)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"CheckRecordHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < numbers.size(); ++i) {
            String adjustNumber = (String)numbers.get(i);
            DynamicObject adjustHead = elimDynaObj.get(i);
            adjustHead.set("number", (Object)adjustNumber);
            adjustRecordLink.get((Object)adjustHead.getLong("id")).forEach(record -> record.set("adjustnumber", (Object)adjustNumber));
        }
    }

    private static void mergeMaps(Map<String, Set<String>> map1, Map<String, Set<String>> map2) {
        if (map2 == null) {
            return;
        }
        map2.forEach((key, value) -> map1.merge((String)key, (Set<String>)value, (existingSet, newSet) -> {
            existingSet.addAll(newSet);
            return existingSet;
        }));
    }

    private void doSycToMDD(Set<Long> elimPks) {
        if (!elimPks.isEmpty()) {
            Map addedDatas = (Map)this.ctx.getProperty("addeded_AdjustDatas");
            AdjustCheckServiceHelper.doSysToMddWithTraceLog(this.getOperationName(false), addedDatas, (Long)this.ctx.getModel().p1, (Long)this.ctx.getCheckParam().getScene().p1, (Long)this.ctx.getCheckParam().getYear().p1, (Long)this.ctx.getCheckParam().getPeriod().p1, elimPks, true);
        }
    }

    private void checkAdjustData(List<DynamicObject> heads, List<DynamicObject> entry, Set<Long> linkSourceAdjustId) {
        Set adjust = entry.stream().map(e -> e.getLong("adjust")).collect(Collectors.toSet());
        HashSet<Long> removeAdjustIds = new HashSet<Long>(16);
        Iterator<DynamicObject> iterator = heads.iterator();
        while (iterator.hasNext()) {
            DynamicObject e2 = iterator.next();
            if (adjust.contains(e2.getLong("id"))) continue;
            removeAdjustIds.add(e2.getLong("id"));
            iterator.remove();
        }
        linkSourceAdjustId.removeAll(removeAdjustIds);
    }

    private void dealElimDataSeq(List<DynamicObject> elimDataDynaObj) {
        Map<Long, List<DynamicObject>> adjustGroup = elimDataDynaObj.parallelStream().collect(Collectors.groupingBy(e -> e.getLong("adjust")));
        elimDataDynaObj.forEach(e -> {
            int size = String.valueOf(((List)adjustGroup.get(e.getLong("adjust"))).size()).length();
            e.set("dseq", (Object)String.format("%0" + size + "d", e.getInt("dseq")));
        });
        AdjustConvertUtil.setAdjustDataShowSeqByMoreAdjust(elimDataDynaObj, AdjustDataSortRuleEnum.SEQ_SORT);
    }

    private void handleDiffItems(DynamicObject info) {
        DynamicObjectCollection doc = info.getDynamicObjectCollection("entryentity");
        doc.forEach(item -> {
            if (!item.getBoolean("merge")) {
                item.set("entrydebelimval", item.get("entrydebit"));
                item.set("entrycreelimval", item.get("entrycredit"));
            }
            if (item.getBoolean("isdiffitem")) {
                item.set("entrydebit", (Object)BigDecimal.ZERO);
                item.set("entrycredit", (Object)BigDecimal.ZERO);
            }
        });
    }

    private boolean isGenerateElim(CheckRecord e) {
        boolean isAuto = e.getDiffMode() == 8 || e.getDiffMode() == 11 || e.getDiffMode() == 1 || e.getDiffMode() == 2 || e.getDiffMode() == 6 || e.getDiffMode() == 7 || e.getDiffMode() == 9 || e.getDiffMode() == 10 || e.getDiffMode() == 4 || e.getDiffMode() == 3 && e.getDifference().compareTo(BigDecimal.ZERO) == 0;
        boolean isSameCurrency = Boolean.TRUE;
        if (this.ctx.getCheckParam().getCurrency() != null && this.ctx.getEntCurrencyMapped() != null) {
            String mergeOrgCurrency = this.ctx.getEntCurrencyMapped().get(this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, e.getEntityid()));
            isSameCurrency = ObjectUtils.equals((Object)this.ctx.getCheckParam().getCurrency().p2, (Object)mergeOrgCurrency);
        }
        return isAuto && isSameCurrency;
    }

    private IMDResultSet queryCheckData(ICheckContext ctx, String process) {
        MDResultSet result;
        Object[] icNumbers;
        String[] adjEntities;
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addSelectField(ctx.getSelectField());
        sql.addMeasures(ctx.getMeasures());
        sql.setIncludeNull(false);
        ctx.getScopes().forEach(e -> {
            if (!(PresetConstant.PROCESS_DIM.equals(e.p1) || PresetConstant.ENTITY_DIM.equals(e.p1) || PresetConstant.CURRENCY_DIM.equals(e.p1))) {
                sql.addFilter((String)e.p1, (String[])e.p2);
            }
        });
        sql.addFilter(PresetConstant.PROCESS_DIM, process);
        String[] leafEntities = ctx.getLeafEntitySet().toArray(new String[0]);
        if (CollectionUtils.isEmpty(ctx.getAdjEntitySet())) {
            return new MDResultSet();
        }
        if ("TARPT".equals(process)) {
            adjEntities = EntityServiceHelper.trans2WithParentEntity(ctx, ctx.getAdjEntitySet()).toArray(new String[0]);
            if (adjEntities.length == 0) {
                return new MDResultSet();
            }
        } else {
            adjEntities = ctx.getAdjEntitySet().toArray(new String[0]);
        }
        if ((icNumbers = ctx.getCheckParam().getIcNumbers()) == null || icNumbers.length == 0) {
            icNumbers = leafEntities;
        }
        if (ctx.isCompany()) {
            String[] stringArray;
            if ("TARPT".equals(process)) {
                stringArray = EntityServiceHelper.trans2WithParentEntity(ctx, Sets.newHashSet((Object[])new String[]{(String)ctx.getEntity().p2})).toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)ctx.getEntity().p2;
            }
            String[] entities = stringArray;
            if (entities.length == 0) {
                return new MDResultSet();
            }
            sql.addFilter(PresetConstant.ENTITY_DIM, entities);
            if (ctx.isSpptMyCompany()) {
                sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, adjEntities);
                sql.addFilter(PresetConstant.MYCOMPANY_DIM, (String)ctx.getEntity().p2);
            }
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, (String[])icNumbers);
            result = this.batchQueryData(sql);
            if (ctx.isSpptMyCompany()) {
                sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, adjEntities);
                sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, (String[])icNumbers);
            } else {
                Object[] entityNums = "TARPT".equals(process) ? EntityServiceHelper.trans2WithParentEntity(ctx, Sets.newHashSet((Object[])icNumbers)).toArray(new String[0]) : icNumbers;
                sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, (String[])entityNums);
            }
            sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, (String)ctx.getEntity().p2);
            MDResultSet result2 = this.batchQueryData(sql);
            result.merger(result2);
        } else {
            sql.addFilter(PresetConstant.ENTITY_DIM, adjEntities);
            if (ctx.isSpptMyCompany()) {
                sql.addFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
            }
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, (String[])icNumbers);
            result = this.batchQueryData(sql);
            if (ctx.getCheckParam().getIcNumbers() != null && ctx.getCheckParam().getIcNumbers().length > 0) {
                Object[] entityArr;
                Object[] objectArray = entityArr = "TARPT".equals(process) ? EntityServiceHelper.trans2WithParentEntity(ctx, Sets.newHashSet((Object[])icNumbers)).toArray(new String[0]) : icNumbers;
                if (ctx.isSpptMyCompany()) {
                    sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, adjEntities);
                    sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, (String[])icNumbers);
                } else {
                    sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, (String[])entityArr);
                }
                HashSet<String> icEntity = new HashSet<String>(ctx.getLeafEntitySet());
                icEntity.removeAll(Sets.newHashSet((Object[])icNumbers));
                if (icEntity.size() > 0 && entityArr.length > 0) {
                    sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, icEntity.toArray(new String[0]));
                    MDResultSet result2 = this.batchQueryData(sql);
                    result.merger(result2);
                }
            }
        }
        if ("TARPT".equals(process) && ctx.isSpptMyCompany() && !CollectionUtils.isEmpty(ctx.getSrptUnLeafEntitySet())) {
            MDResultSet adjResult = this.queryCheckDataForSRPTADJ(ctx);
            result.merger(adjResult);
        }
        return result;
    }

    private MDResultSet queryCheckDataForSRPTADJ(ICheckContext ctx) {
        MDResultSet result;
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addSelectField(ctx.getSelectField());
        sql.addMeasures(ctx.getMeasures());
        sql.setIncludeNull(false);
        ctx.getScopes().forEach(e -> {
            if (!(PresetConstant.PROCESS_DIM.equals(e.p1) || PresetConstant.ENTITY_DIM.equals(e.p1) || PresetConstant.CURRENCY_DIM.equals(e.p1))) {
                sql.addFilter((String)e.p1, (String[])e.p2);
            }
        });
        sql.addFilter(PresetConstant.PROCESS_DIM, "TADJ");
        String[] leafEntities = ctx.getLeafEntitySet().toArray(new String[0]);
        String[] srptUnLeafEntities = EntityServiceHelper.trans2WithParentEntity(ctx, ctx.getSrptUnLeafEntitySet()).toArray(new String[0]);
        if (srptUnLeafEntities.length == 0) {
            return new MDResultSet();
        }
        Object[] icNumbers = ctx.getCheckParam().getIcNumbers();
        if (icNumbers == null || icNumbers.length == 0) {
            icNumbers = leafEntities;
        }
        if (ctx.isCompany()) {
            sql.addFilter(PresetConstant.ENTITY_DIM, srptUnLeafEntities);
            sql.addFilter(PresetConstant.MYCOMPANY_DIM, (String)ctx.getEntity().p2);
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, (String[])icNumbers);
            result = this.batchQueryData(sql);
            sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, (String[])icNumbers);
            sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, (String)ctx.getEntity().p2);
            MDResultSet result2 = this.batchQueryData(sql);
            result.merger(result2);
        } else {
            sql.addFilter(PresetConstant.ENTITY_DIM, srptUnLeafEntities);
            sql.addFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, (String[])icNumbers);
            result = this.batchQueryData(sql);
            if (ctx.getCheckParam().getIcNumbers() != null && ctx.getCheckParam().getIcNumbers().length > 0) {
                sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, (String[])icNumbers);
                HashSet<String> icEntity = new HashSet<String>(ctx.getLeafEntitySet());
                icEntity.removeAll(Sets.newHashSet((Object[])icNumbers));
                if (icEntity.size() > 0) {
                    sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, icEntity.toArray(new String[0]));
                    MDResultSet result2 = this.batchQueryData(sql);
                    result.merger(result2);
                }
            }
        }
        return result;
    }

    private IMDResultSet queryRawData(ICheckContext ctx) {
        IMDResultSet rs1 = this.queryRawData(ctx, "Rpt");
        if (ctx.isIncludeADJ()) {
            IMDResultSet rs3 = this.queryRawData(ctx, "ADJ");
            rs1.merger(rs3);
            IMDResultSet rs4 = this.queryRawData(ctx, "TADJ");
            rs1.merger(rs4);
        }
        return rs1;
    }

    private IMDResultSet queryRawData(ICheckContext ctx, String process) {
        String[] adjEntities;
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addSelectField(ctx.getSelectField());
        sql.addMeasures(ctx.getMeasures());
        sql.setIncludeNull(true);
        ctx.getScopes().forEach(e -> {
            if (!(PresetConstant.PROCESS_DIM.equals(e.p1) || PresetConstant.ENTITY_DIM.equals(e.p1) || PresetConstant.CURRENCY_DIM.equals(e.p1))) {
                sql.addFilter((String)e.p1, (String[])e.p2);
            }
        });
        sql.addFilter(PresetConstant.PROCESS_DIM, process);
        String[] leafEntities = ctx.getLeafEntitySet().toArray(new String[0]);
        if (CollectionUtils.isEmpty(ctx.getAdjEntitySet())) {
            return new MDResultSet();
        }
        HashSet<String> totalEntity = new HashSet<String>(16);
        totalEntity.addAll(ctx.getAdjEntitySet());
        if (ProcessUtils.getLevel(process) == 2) {
            totalEntity.addAll(ctx.getSrptUnLeafEntitySet());
            adjEntities = EntityServiceHelper.trans2WithParentEntity(ctx, totalEntity).toArray(new String[0]);
            if (adjEntities.length == 0) {
                return new MDResultSet();
            }
        } else {
            adjEntities = totalEntity.toArray(new String[0]);
        }
        if ("Rpt".equals(process)) {
            if (ctx.isCompany()) {
                sql.addFilter(PresetConstant.ENTITY_DIM, (String)ctx.getEntity().p2);
                if (ctx.isSpptMyCompany()) {
                    sql.addFilter(PresetConstant.MYCOMPANY_DIM, (String)ctx.getEntity().p2);
                }
                sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, leafEntities);
                MDResultSet result = this.batchQueryData(sql);
                sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, adjEntities);
                if (ctx.isSpptMyCompany()) {
                    sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
                }
                sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, (String)ctx.getEntity().p2);
                MDResultSet result2 = this.batchQueryData(sql);
                result.merger(result2);
                return result;
            }
            sql.addFilter(PresetConstant.ENTITY_DIM, adjEntities);
            if (ctx.isSpptMyCompany()) {
                sql.addFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
            }
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, leafEntities);
            MDResultSet result = this.batchQueryData(sql);
            return result;
        }
        if (ctx.isCompany()) {
            sql.addFilter(PresetConstant.ENTITY_DIM, adjEntities);
            if (ctx.isSpptMyCompany()) {
                sql.addFilter(PresetConstant.MYCOMPANY_DIM, (String)ctx.getEntity().p2);
            }
            sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, leafEntities);
            MDResultSet result = this.batchQueryData(sql);
            sql.replaceOrAddFilter(PresetConstant.ENTITY_DIM, adjEntities);
            if (ctx.isSpptMyCompany()) {
                sql.replaceOrAddFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
            }
            sql.replaceOrAddFilter(PresetConstant.INTERNALCOMPANY_DIM, (String)ctx.getEntity().p2);
            MDResultSet result2 = this.batchQueryData(sql);
            result.merger(result2);
            return result;
        }
        sql.addFilter(PresetConstant.ENTITY_DIM, adjEntities);
        if (ctx.isSpptMyCompany()) {
            sql.addFilter(PresetConstant.MYCOMPANY_DIM, leafEntities);
        }
        sql.addFilter(PresetConstant.INTERNALCOMPANY_DIM, leafEntities);
        MDResultSet result = this.batchQueryData(sql);
        return result;
    }

    private MDResultSet batchQueryData(SQLBuilder sql) {
        Optional<Pair> maxPairOptional = sql.getFilters().stream().filter(e -> dimSet.contains(e.p1)).max(Comparator.comparingInt(e -> ((String[])e.p2).length));
        if (maxPairOptional.isPresent()) {
            MDResultSet result = new MDResultSet();
            Pair maxPair = maxPairOptional.get();
            BatchProcessHelper.batchConsume(Arrays.asList((Object[])maxPair.p2), (int)this.ctx.getBatchSize(), t -> {
                sql.replaceOrAddFilter((String)maxPair.p1, t.toArray(new String[0]));
                result.merger(OlapServiceHelper.queryData(sql));
            });
            return result;
        }
        return OlapServiceHelper.queryData(sql);
    }

    private void copyTAdj(Collection<String> entity, String currency) {
        RunScriptBuilder run = new RunScriptBuilder((String)this.ctx.getModel().p2);
        run.addDimensionScope(PresetConstant.ENTITY_DIM, entity.toArray(entity.toArray(new String[0])));
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, currency);
        run.addDimensionScope(PresetConstant.FY_DIM, (String)this.ctx.getCheckParam().getYear().p2);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)this.ctx.getCheckParam().getPeriod().p2);
        run.addDimensionScope(PresetConstant.SCENE_DIM, (String)this.ctx.getCheckParam().getScene().p2);
        run.appendV((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"TADJ"));
        run.appendEqualSign();
        run.appendV((PairList<String, String>)PairList.newWithParam((Object)PresetConstant.PROCESS_DIM, (Object)"ADJ"));
        run.endRunExpress();
        run.runScript(false);
    }

    private void clearTAdj(Collection<String> entity, String currency) {
        RunScriptBuilder run = new RunScriptBuilder((String)this.ctx.getModel().p2);
        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.SCENE_DIM, this.ctx.getCheckParam().getScene().p2));
        run.appendEqualSign();
        run.appendStr("null");
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.ENTITY_DIM, entity.toArray(entity.toArray(new String[0])));
        run.addDimensionScope(PresetConstant.CURRENCY_DIM, currency);
        run.addDimensionScope(PresetConstant.FY_DIM, (String)this.ctx.getCheckParam().getYear().p2);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)this.ctx.getCheckParam().getPeriod().p2);
        run.addDimensionScope(PresetConstant.PROCESS_DIM, "TADJ");
        run.runScript(false);
    }

    @Override
    public void check(Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        if (!this.ctx.isAvailable()) {
            return;
        }
        InterCheckExecutor executor = new InterCheckExecutor(this.ctx);
        Set checkRecordIds = (Set)this.ctx.getCheckParam().get("checkRecordIds");
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"bcm_checkrecord", (String)"number,checktmpl.number,process.number, currency.number,entryentity.entryorg.number,entryentity.entrycompany.number,entryentity.isdiffitem,entryentity.entryorg,entryentity.entrydebitaccout,entryentity.entrycreditaccout,entryentity.entryyear,entryentity.entryperiod,entryentity.entryscene,entryentity.entryprocess,entryentity.entrycurrency,entryentity.entryaudittrail,entryentity.entrychangetype,entryentity.entrymycompany,entryentity.entrycompany,entryentity.entrymultigaap,entryentity.entrydatasort,entryentity.entrydim1,entryentity.entrydim2,entryentity.entrydim3,entryentity.entrydim4,entryentity.entrydim5,entryentity.entrydim6,entryentity.entrymyecmoney,entryentity.entryopecmoney,entryentity.entryocmoney,entryentity.entrydebit,entryentity.entrycredit", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)checkRecordIds)});
        ArrayList<CheckRecord> recs = new ArrayList<CheckRecord>(checkRecordIds.size());
        HashSet<EntityKey> entityKeys = new HashSet<EntityKey>(docs.length);
        HashSet<String> allOrgNums = new HashSet<String>(16);
        this.ctx.getCheckParam().stepCount();
        for (DynamicObject doc : docs) {
            String bnumber;
            String anumber = ((DynamicObject)doc.getDynamicObjectCollection("entryentity").get(0)).getString(this.ctx.isSpptMyCompany() ? "entrymycompany.number" : "entryorg.number");
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{anumber, bnumber = ((DynamicObject)doc.getDynamicObjectCollection("entryentity").get(0)).getString("entrycompany.number")})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8d26\u6570\u636e\u672c\u65b9\u5355\u4f4d\u6216\u5bf9\u65b9\u5355\u4f4d\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"CheckService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            EntityKey entityKey = EntityKey.genKey(anumber, bnumber);
            entityKeys.add(entityKey);
            allOrgNums.add(anumber);
            allOrgNums.add(bnumber);
        }
        this.ctx.setParentMap(EntityServiceHelper.batchQueryCommonParent(this.ctx, entityKeys));
        HashSet<String> ents = new HashSet<String>(16);
        ents.addAll(allOrgNums);
        if (this.ctx.getParentMap() != null && this.ctx.getParentMap().size() > 0) {
            for (Pair<Long, String> p2 : this.ctx.getParentMap().values()) {
                ents.add((String)p2.p2);
            }
        }
        this.ctx.setEntCurrencyMapped(this.getEntityCurrencyMap((Long)this.ctx.getModel().p1, ents));
        this.ctx.getCheckParam().stepCount();
        for (DynamicObject doc : docs) {
            CheckRecord rec2Op;
            CheckRecord rec2Myop;
            CheckRecord rec1Myop;
            String bnumber;
            String currency = doc.getString("currency.number");
            String anumber = ((DynamicObject)doc.getDynamicObjectCollection("entryentity").get(0)).getString(this.ctx.isSpptMyCompany() ? "entrymycompany.number" : "entryorg.number");
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{anumber, bnumber = ((DynamicObject)doc.getDynamicObjectCollection("entryentity").get(0)).getString("entrycompany.number")})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5bf9\u8d26\u6570\u636e\u672c\u65b9\u5355\u4f4d\u6216\u5bf9\u65b9\u5355\u4f4d\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"CheckService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            EntityKey entityKey = EntityKey.genKey(anumber, bnumber);
            Optional<CheckTmpl> opt = this.ctx.getCheckTmplMap().entrySet().stream().flatMap(p -> ((List)p.getValue()).stream()).filter(e -> doc.getString("checktmpl.number").equals(e.getNumber())).findFirst();
            if (!opt.isPresent()) continue;
            CheckTmpl tmpl = opt.get();
            tmpl.setDiffMode(((DiffModeEnum)diffPair.p1).getValue());
            tmpl.setDiffMethod(((DiffMethodEnum)diffPair.p2).getValue());
            List<ReportData> datas = this.getReportDta(doc.getDynamicObjectCollection("entryentity"));
            ArrayList<Pair<ReportData, CheckTmpl.Entry>> dataPairs = new ArrayList<Pair<ReportData, CheckTmpl.Entry>>(16);
            datas.forEach(data -> {
                Optional<CheckTmpl.Entry> optEntry = tmpl.getEntries().stream().filter(te -> CheckRecordHelper.matchReportDataAndCheckTmplEntry(data, te)).findFirst();
                if (optEntry.isPresent() && data.getValue() != null) {
                    dataPairs.add(Pair.onePair((Object)data, (Object)optEntry.get()));
                }
            });
            if (dataPairs.size() <= 0) continue;
            boolean isContainsMyop = dataPairs.stream().anyMatch(p -> "0".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()));
            boolean isContainsMyOrOp = dataPairs.stream().anyMatch(p -> "1".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()) || "2".equals(((CheckTmpl.Entry)p.p2).getEntrymyop()));
            if (isContainsMyop && (rec1Myop = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, true, "0")) != null) {
                recs.add(rec1Myop);
            }
            if (isContainsMyOrOp) {
                CheckRecord rec1Op;
                CheckRecord rec1My = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, true, "1");
                if (rec1My != null) {
                    recs.add(rec1My);
                }
                if ((rec1Op = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, true, "2")) != null) {
                    recs.add(rec1Op);
                }
            }
            if (tmpl.isGroupDC()) continue;
            if (isContainsMyop && (rec2Myop = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, false, "0")) != null) {
                recs.add(rec2Myop);
            }
            if (!isContainsMyOrOp) continue;
            CheckRecord rec2My = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, false, "1");
            if (rec2My != null) {
                recs.add(rec2My);
            }
            if ((rec2Op = CheckRecordHelper.newCheckRecord(this.ctx, doc.getString("number"), currency, entityKey, tmpl, dataPairs, false, "2")) == null) continue;
            recs.add(rec2Op);
        }
        this.ctx.getCheckParam().stepCount();
        executor.check(recs, diffPair);
        try (TXHandle tx = TX.required();){
            try {
                this.doDelete(this.ctx);
                HashSet<Long> elimPks = new HashSet<Long>(16);
                this.ctx.getCheckParam().stepCount();
                this.doSave(this.ctx, recs, elimPks);
                this.doSycToMDD(elimPks);
                this.ctx.getCheckParam().stepCount();
            }
            catch (Throwable t) {
                tx.markRollback();
                this.log.error("--CheckService.check--:\n" + ThrowableHelper.toString((Throwable)t));
                String errMsg = t instanceof KDBizException ? t.getMessage() : ThrowableHelper.toString((Throwable)t);
                throw new KDBizException(t, new ErrorCode("", errMsg), new Object[0]);
            }
        }
        this.dealPhaSubmitCheckMsg(this.ctx);
        this.ctx.getCheckParam().stepCount();
    }

    private List<ReportData> getReportDta(DynamicObjectCollection entryentity) {
        ArrayList<ReportData> datas = new ArrayList<ReportData>(entryentity.size());
        HashMap<MDResultSet.MemberMeta, MDResultSet.MemberMeta> memberMetaDic = new HashMap<MDResultSet.MemberMeta, MDResultSet.MemberMeta>();
        MDResultSetMetaData metaData = new MDResultSetMetaData();
        for (String dim : this.ctx.getAllDims()) {
            metaData.addColumnMeta(dim);
        }
        for (DynamicObject dynamicObject : entryentity) {
            BigDecimal value1 = dynamicObject.getBigDecimal("entrydebit");
            BigDecimal value2 = dynamicObject.getBigDecimal("entrycredit");
            BigDecimal ecValue1 = dynamicObject.getBigDecimal("entrymyecmoney");
            BigDecimal ecValue2 = dynamicObject.getBigDecimal("entryopecmoney");
            if (BigDecimal.ZERO.compareTo(value1) == 0 && BigDecimal.ZERO.compareTo(value2) == 0) continue;
            Row row = new Row(metaData, memberMetaDic);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PresetConstant.ENTITY_DIM, this.getCacheNumberById(this.ctx, PresetConstant.ENTITY_DIM, dynamicObject.getLong("entryorg.id")));
            long debit = dynamicObject.getLong("entrydebitaccout.id");
            long credit = dynamicObject.getLong("entrycreditaccout.id");
            map.put(PresetConstant.ACCOUNT_DIM, this.getCacheNumberById(this.ctx, PresetConstant.ACCOUNT_DIM, debit != 0L ? debit : credit));
            map.put(PresetConstant.FY_DIM, this.getCacheNumberById(this.ctx, PresetConstant.FY_DIM, dynamicObject.getLong("entryyear.id")));
            map.put(PresetConstant.PERIOD_DIM, this.getCacheNumberById(this.ctx, PresetConstant.PERIOD_DIM, dynamicObject.getLong("entryperiod.id")));
            map.put(PresetConstant.SCENE_DIM, this.getCacheNumberById(this.ctx, PresetConstant.SCENE_DIM, dynamicObject.getLong("entryscene.id")));
            map.put(PresetConstant.PROCESS_DIM, this.getCacheNumberById(this.ctx, PresetConstant.PROCESS_DIM, dynamicObject.getLong("entryprocess.id")));
            map.put(PresetConstant.CURRENCY_DIM, this.getCacheNumberById(this.ctx, PresetConstant.CURRENCY_DIM, dynamicObject.getLong("entrycurrency.id")));
            map.put(PresetConstant.AUDITTRIAL_DIM, this.getCacheNumberById(this.ctx, PresetConstant.AUDITTRIAL_DIM, dynamicObject.getLong("entryaudittrail.id")));
            map.put(PresetConstant.CHANGETYPE_DIM, this.getCacheNumberById(this.ctx, PresetConstant.CHANGETYPE_DIM, dynamicObject.getLong("entrychangetype.id")));
            map.put(PresetConstant.MYCOMPANY_DIM, this.ctx.isSpptMyCompany() ? this.getCacheNumberById(this.ctx, PresetConstant.MYCOMPANY_DIM, dynamicObject.getLong("entrymycompany.id")) : null);
            map.put(PresetConstant.INTERNALCOMPANY_DIM, this.getCacheNumberById(this.ctx, PresetConstant.INTERNALCOMPANY_DIM, dynamicObject.getLong("entrycompany.id")));
            map.put(PresetConstant.RULE_DIM, this.ctx.isSpptMultRule() ? this.getCacheNumberById(this.ctx, PresetConstant.RULE_DIM, dynamicObject.getLong("entrymultigaap.id")) : null);
            map.put(PresetConstant.DATASORT_DIM, this.ctx.isSpptDataSort() ? this.getCacheNumberById(this.ctx, PresetConstant.DATASORT_DIM, dynamicObject.getLong("entrydatasort.id")) : null);
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(0)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim1.id")));
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(1)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim2.id")));
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(2)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim3.id")));
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(3)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim4.id")));
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(4)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim5.id")));
            map.put(this.ctx.getFieldMapped().get(CheckConstant.PRESET_DIMFIELDS.get(5)), this.getCacheNumberById(this.ctx, "bcm_userdefinedmembertree", dynamicObject.getLong("entrydim6.id")));
            this.ctx.getAllDims().forEach(d -> row.addColumnValue(map.get(d)));
            ReportData data = new ReportData(row, this.ctx.getFieldMapped());
            data.setValue(value1.compareTo(BigDecimal.ZERO) != 0 ? value1 : value2);
            data.setEcValue(ecValue1.compareTo(BigDecimal.ZERO) != 0 ? ecValue1 : ecValue2);
            data.setOcValue(dynamicObject.getBigDecimal("entryocmoney") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("entryocmoney"));
            data.setTc(CheckUtil.getTc(this.ctx, data.getRow()));
            data.setEc(CheckUtil.getEc(this.ctx, data.getRow()));
            datas.add(data);
        }
        return datas;
    }

    private String getCacheNumberById(ICheckContext ctx, String dimnumber, Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        return MemberReader.findMemberById((long)((Long)ctx.getModel().p1), (String)DimensionServiceHelper.getDimMembEntityNumByDimNum(dimnumber), (Long)id).getNumber();
    }

    protected BizRuleExecuteService getBizRuleExecuteService() {
        ExecuteContext exeCtx = new ExecuteContext(SimpleItem.newOne(this.ctx.getModel().p1, (String)this.ctx.getModel().p2), SimpleItem.newOne(this.ctx.getEntity().p1, (String)this.ctx.getEntity().p2), SimpleItem.newOne(this.ctx.getCheckParam().getYear().p1, (String)this.ctx.getCheckParam().getYear().p2), SimpleItem.newOne(this.ctx.getCheckParam().getPeriod().p1, (String)this.ctx.getCheckParam().getPeriod().p2), SimpleItem.newOne(this.ctx.getCheckParam().getScene().p1, (String)this.ctx.getCheckParam().getScene().p2), false);
        return new BizRuleExecuteService(exeCtx);
    }

    private String getOperationName(boolean isDelete) {
        String opName = ResManager.loadKDString((String)"\u5bf9\u8d26\u5e76\u62b5\u9500", (String)"CheckService_4", (String)"fi-bcm-business", (Object[])new Object[0]);
        if (this.ctx.isBatchDiff()) {
            opName = ResManager.loadKDString((String)"\u5bf9\u8d26\u6279\u91cf\u5dee\u5f02\u5904\u7406", (String)"CheckService_9", (String)"fi-bcm-business", (Object[])new Object[0]);
        } else if ("1".equals(this.ctx.getCheckExecuteType())) {
            opName = ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u5bf9\u8d26", (String)"CheckService_5", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return String.format("%s-%s", opName, isDelete ? AdjustOperTypeEnum.DELETEOPERATION.getName() : AdjustOperTypeEnum.CREATEAUTOOPERATION.getName());
    }

    private static /* synthetic */ void lambda$doSave$47(Multimap adjustRecordLink, Long id, String groupNums) {
        Collection checkDyns = adjustRecordLink.asMap().getOrDefault(id, new HashSet());
        checkDyns.stream().filter(checkInfo -> groupNums.contains(checkInfo.getString("number"))).forEach(checkInfo -> {
            checkInfo.set("status", (Object)CheckStatusEnum.UNCONFIRM.value);
            checkInfo.set("isautoelim", (Object)"1");
            checkInfo.set("adjustnumber", (Object)" ");
        });
    }

    private /* synthetic */ void lambda$doConvert$9(Multimap adjOrgs, String currency) {
        this.clearTAdj(adjOrgs.get((Object)currency), currency);
        this.copyTAdj(adjOrgs.get((Object)currency), currency);
    }
}

