/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.check.CheckParam;
import kd.fi.bcm.business.check.ICheckContext;
import kd.fi.bcm.business.check.entrydetail.CheckTmplEntryDetail;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.check.model.CheckRecord;
import kd.fi.bcm.business.check.model.key.CheckTmpl;
import kd.fi.bcm.business.check.model.key.EntityKey;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembBaseItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckStatusEnum;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class CheckUtil {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(CheckUtil.class);
    public static final String DEFEULTDIFFSETTING = String.join((CharSequence)"#", "1.1", "1.1", "2.1", "2.2", "9.2", "10.2", "1.4", "8", "5");
    public static List<String> diffSettingOrderList = Arrays.asList("1.1", "2.1", "9.1", "10.1", "1.2", "2.2", "9.2", "10.2", "1.3", "2.3", "9.3", "10.3", "1.4", "2.4", "9.4", "10.4", "8", "5");

    public static String genElimDimKey(ICheckContext ctx, CheckRecord.Entry entry) {
        if (entry.isDi()) {
            return entry.getId().toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getEntrydebitaccout());
        sb.append('&');
        sb.append(entry.getEntrycreditaccout());
        sb.append('&');
        sb.append(entry.getEntryorg());
        sb.append('&');
        sb.append(entry.getEntrycompany());
        sb.append('&');
        sb.append(entry.getEntrychangetype());
        sb.append('&');
        List<CheckTmpl.EntryDetailWithSign> elims = entry.getTmplEntry().getElimDims();
        int index = 0;
        for (String dim : CheckConstant.PRESET_DIMFIELDS) {
            CheckTmpl.EntryDetailWithSign sign;
            List<CheckTmplEntryDetail> details;
            Optional<CheckTmpl.EntryDetailWithSign> opt;
            Long singleMemberId = null;
            if (elims != null && (opt = elims.stream().filter(e -> dim.equals(e.getSign())).findFirst()).isPresent() && (details = (sign = opt.get()).getDetails()) != null && details.size() == 1 && RangeEnum.VALUE_10.getValue() == details.get(0).getScope().intValue()) {
                singleMemberId = details.get(0).getMemberTreeId();
            }
            Long dimid = singleMemberId == null ? (index == 0 ? entry.getEntrydim1() : (index == 1 ? entry.getEntrydim2() : (index == 2 ? entry.getEntrydim3() : (index == 3 ? entry.getEntrydim4() : (index == 4 ? entry.getEntrydim5() : entry.getEntrydim6()))))) : singleMemberId;
            sb.append(dimid);
            sb.append('&');
            ++index;
        }
        return sb.toString();
    }

    public static Long getMembIdFromCache(ICheckContext ctx, String dimNumber, String membNumber) {
        if (membNumber == null || membNumber.length() == 0 || membNumber.equals(IDNumberTreeNode.NotFoundTreeNode.getNumber())) {
            return null;
        }
        String num = membNumber;
        if (PresetConstant.ENTITY_DIM.equals(dimNumber)) {
            Pair<Long, String> orgPair;
            if (membNumber.contains("_")) {
                String[] split = membNumber.split("_");
                membNumber = split[1];
            }
            String mergeLongNum = (String)ctx.getEntity().p3;
            if (ctx.isCompany()) {
                mergeLongNum = EntityServiceHelper.getSecondLongNumber((String)ctx.getEntity().p3);
            }
            if ((orgPair = ctx.getSortedOrgByChangeType().get(membNumber)) != null) {
                return (Long)orgPair.p1;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u672a\u627e\u5230\u53c2\u4e0e\u5bf9\u8d26\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"CheckUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), mergeLongNum, num));
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)((String)ctx.getModel().p2), (String)dimNumber, (String)membNumber);
        return node.getId();
    }

    public static String getEntityBySign(String sign) {
        String entity;
        if ("company".equals(sign) || "elimcompany".equals(sign)) {
            entity = "bcm_icmembertree";
        } else if (sign.startsWith("dim") || sign.startsWith("elimdim")) {
            entity = "bcm_userdefinedmembertree";
        } else if ("audittrail".equals(sign) || "elimaudittrail".equals(sign)) {
            entity = "bcm_audittrialmembertree";
        } else if ("accounttree".equalsIgnoreCase(sign)) {
            entity = "bcm_accountmembertree";
        } else {
            throw new KDBizException("unsupported detail sign!");
        }
        return entity;
    }

    public static String convertToRealEntity(String entity) {
        if (entity != null && entity.contains("_")) {
            entity = entity.split("_")[1];
        }
        return entity;
    }

    public static String getEc(ICheckContext ctx, Row row) {
        String mc = CheckUtil.convertToRealEntity(row.getString(ctx.isSpptMyCompany() ? PresetConstant.MYCOMPANY_DIM : PresetConstant.ENTITY_DIM));
        return ctx.getEntCurrencyMapped().get(mc);
    }

    public static String getTc(ICheckContext ctx, Row row) {
        String ic = row.getString(PresetConstant.INTERNALCOMPANY_DIM);
        String mc = CheckUtil.convertToRealEntity(ctx.isSpptMyCompany() ? row.getString(PresetConstant.MYCOMPANY_DIM) : row.getString(PresetConstant.ENTITY_DIM));
        Pair<Long, String> parent = ctx.getParentMap().get(EntityKey.genKey(mc, ic));
        if (parent == null) {
            return null;
        }
        return ctx.isCompany() ? (ctx.getCheckParam().getCurrency() != null ? (String)ctx.getCheckParam().getCurrency().p2 : ctx.getEntCurrencyMapped().get(parent.p2)) : ctx.getCurrencyNumber();
    }

    public static Set<Long> queryDispensedTmpls(Long modelId, Long sceneId, Set<Long> checkTmplIds, String elimType, Set<String> orgNums) {
        HashSet<Long> checkTmpls = new HashSet<Long>(16);
        QFBuilder qb = new QFBuilder("model.id", "=", (Object)modelId);
        qb.add("isenable", "=", (Object)"1");
        if (checkTmplIds != null && checkTmplIds.size() > 0) {
            qb.add("id", "in", checkTmplIds);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id,scenarios.isexcept,scenarios.scenariomeb.id,scenarios.scenariomeb.number,scenarios.scenarioscope", (QFilter[])qb.toArray());
        dynamicObjects.removeIf(d -> d.getString("scenarios.scenarioscope") == null);
        Set<Long> filterScenarioTmplsIds = CheckUtil.filterByScene(modelId, sceneId, (Collection<DynamicObject>)dynamicObjects, new HashMap<String, Set<Pair<Long, String>>>(16));
        if (filterScenarioTmplsIds.isEmpty()) {
            return checkTmpls;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("template.model.id", "=", (Object)modelId);
        qf.add("template.id", "in", filterScenarioTmplsIds);
        if (elimType != null) {
            String[] split = elimType.split(",");
            boolean ignoreCheckTmpl = false;
            ArrayList<String> checkTypes = new ArrayList<String>(10);
            for (String s : split) {
                if ("all".equals(s)) {
                    ignoreCheckTmpl = true;
                    break;
                }
                if ("".equals(s)) continue;
                checkTypes.add(s);
            }
            if (!ignoreCheckTmpl) {
                qf.add("template.templatecatalog.number", "in", checkTypes);
            }
        }
        String selectFields = "entity.id, entity.number, template.id, template.number, property.id, property.number, propertyvalue.id, propertyvalue.number, range";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_checktmplassignentry", (String)selectFields, (QFilter[])qf.toArray());
        for (DynamicObject d2 : doc) {
            String mnumber;
            long mId;
            boolean isCustom;
            if (d2.getLong("propertyvalue.id") != 0L) {
                isCustom = true;
                mId = d2.getLong("propertyvalue.id");
                mnumber = d2.getString("propertyvalue.number");
            } else {
                isCustom = false;
                mId = d2.getLong("entity.id");
                mnumber = d2.getString("entity.number");
            }
            new MembRangeItem("bcm_entitymembertree", (Long)mId, mnumber, RangeEnum.getRangeByVal((int)d2.getInt("range")), isCustom, (Object)modelId).matchItems(e -> {
                if (orgNums.contains(e.number)) {
                    checkTmpls.add(d2.getLong("template.id"));
                }
            });
        }
        return checkTmpls;
    }

    public static Set<Long> getApplySceneTmpls(Long modelId, Long sceneId) {
        return CheckUtil.getApplySceneTmpls(modelId, sceneId, "bcm_checktmpl");
    }

    public static Set<Long> getApplySceneTmpls(Long modelId, Long sceneId, String entityName) {
        QFBuilder qb = new QFBuilder("model.id", "=", (Object)modelId);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entityName, (String)"id,scenarios.isexcept,scenarios.scenariomeb.id,scenarios.scenariomeb.number,scenarios.scenarioscope", (QFilter[])qb.toArray());
        dyns.removeIf(d -> d.getString("scenarios.scenarioscope") == null);
        if (dyns != null && !dyns.isEmpty()) {
            return CheckUtil.filterByScene(modelId, sceneId, (Collection<DynamicObject>)dyns, new HashMap<String, Set<Pair<Long, String>>>(16));
        }
        return new HashSet<Long>(16);
    }

    public static Set<Long> filterByScene(Long modelId, Long sceneId, Collection<DynamicObject> col, Map<String, Set<Pair<Long, String>>> membRangeItemCache) {
        Map<Long, List<DynamicObject>> tmplMap = col.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        HashSet<Long> result = new HashSet<Long>(16);
        if (Objects.isNull(sceneId) || sceneId == -1L || sceneId == 0L) {
            PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
            Set<Long> allSceneIds = MemberReader.getAllNodeFromCache((String)"bcm_scenemembertree", (Object)modelId).keySet();
            Set<Long> noPermSceneIds = permissionService.matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Scenario"), "bcm_scenemembertree", allSceneIds);
            if (noPermSceneIds.isEmpty()) {
                result.addAll(tmplMap.keySet());
            } else {
                tmplMap.forEach((id, list) -> {
                    Set<Pair<Long, String>> scenariosPairs = CheckUtil.analyzingScenariosPair(modelId, list, membRangeItemCache, "scenarios.");
                    if (!noPermSceneIds.containsAll(scenariosPairs.stream().map(p -> (Long)p.p1).collect(Collectors.toSet()))) {
                        result.add((Long)id);
                    }
                });
            }
        } else {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
            if (sceneNode != IDNumberTreeNode.NotFoundTreeNode) {
                tmplMap.forEach((id, list) -> {
                    Set scenarioSet = CheckUtil.analyzingScenariosPair(modelId, list, membRangeItemCache, "scenarios.").stream().map(p -> (String)p.p2).collect(Collectors.toSet());
                    if (scenarioSet.contains(sceneNode.getNumber())) {
                        result.add((Long)id);
                    }
                });
            }
        }
        return result;
    }

    public static Set<Pair<Long, String>> analyzingScenariosPair(long modelId, Collection<DynamicObject> dyns, Map<String, Set<Pair<Long, String>>> membRangeItemCache, String prefix) {
        HashSet<Pair<Long, String>> applyScenarios = new HashSet<Pair<Long, String>>(16);
        HashSet noScenarios = new HashSet(16);
        dyns.forEach(d -> {
            MembRangeItem item = new MembRangeItem("bcm_scenemembertree", (Long)d.getLong(prefix + "scenariomeb.id"), d.getString(prefix + "scenariomeb.number"), Integer.parseInt(d.getString(prefix + "scenarioscope")), false, (Object)modelId);
            String key = item.genKey("");
            Set nums = membRangeItemCache.computeIfAbsent(key, v -> {
                HashSet numberSet = new HashSet(16);
                item.matchItems(c -> numberSet.add(Pair.onePair(c.getId(), (Object)c.getNumber())));
                return numberSet;
            });
            if (PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode().equals(d.getString(prefix + "isexcept"))) {
                applyScenarios.addAll(nums);
            } else {
                noScenarios.addAll(nums);
            }
        });
        applyScenarios.removeAll(noScenarios);
        return applyScenarios;
    }

    public static Set<Long> queryEffectiveTmpls(Long modelId, Long yearId, Long periodId, Set<Long> checkTmplIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(checkTmplIds)) {
            DynamicObject[] doc;
            List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
            for (DynamicObject tmpl : doc = BusinessDataServiceHelper.load((String)"bcm_checktmpl", (String)"id,effective.effectiveyear, effective.effectiveperiod, effective.applytype, effective.yearscope", (QFilter[])new QFilter[]{new QFilter("id", "in", checkTmplIds)})) {
                if (!ConvertDifferenceHandle.isApply(yearId, periodId, tmpl.getDynamicObjectCollection("effective"), yearIdsList)) continue;
                result.add(tmpl.getLong("id"));
            }
        }
        return result;
    }

    public static Map<String, Pair<Set<Long>, String>> unAuditBatch(List<Long> checkRecordIds, String entityNumber, CheckParam param) {
        Set<Long> shareLockCheckRecordIds;
        String opName = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"CheckService_12", (String)"fi-bcm-business", (Object[])new Object[0]);
        HashMap<String, Pair<Set<Long>, String>> result = new HashMap<String, Pair<Set<Long>, String>>();
        DynamicObjectCollection checkIdMappings = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", checkRecordIds)});
        Set checkEntryIds = checkIdMappings.stream().map(e -> e.getLong("entryentity.id")).collect(Collectors.toSet());
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"elim.id,elim.number,elimentry.id,elimentry.groupnum,linkid", (QFilter[])new QFilter[]{new QFilter("model", "=", param.getModel().p1), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.CHECK_RECORD.getBizType()), new QFilter("linkid", "in", checkEntryIds)});
        if (mappings.isEmpty()) {
            CheckUtil.updateCheckRecordStatus(checkRecordIds);
            return result;
        }
        HashMultimap idGroupMap = HashMultimap.create();
        HashMap linkToSourceAdjustMap = new HashMap(16);
        mappings.forEach(d -> idGroupMap.put((Object)d.getLong("elim.id"), (Object)d.getString("elimentry.groupnum")));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjust", (String)"id,linkagelinksource", (QFilter[])new QFBuilder("linkagelinksource", "in", (Object)idGroupMap.keySet()).toArray(), null);){
            ds.forEachRemaining(row -> {
                idGroupMap.putAll((Object)row.getLong("id"), (Iterable)idGroupMap.get((Object)row.getLong("linkagelinksource")));
                linkToSourceAdjustMap.put(row.getLong("id"), row.getLong("linkagelinksource"));
            });
        }
        HashSet<Long> unAutoStatusLockAdjustIds = new HashSet<Long>(16);
        HashSet unAutoStatusLockAdjustNums = new HashSet(16);
        HashSet<Long> shareLockAdjustIds = new HashSet<Long>(16);
        HashSet shareLockAdjustNums = new HashSet(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjust", (String)"id,number,sourcetype,shareentry.shareadjust", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idGroupMap.keySet())}, null);){
            ds.forEachRemaining(row -> {
                Long srcId;
                if (!(ElimRptAdjSourceTypeEnum.AUTO.getValue() + "").equals(row.getString("sourcetype")) && !(ElimRptAdjSourceTypeEnum.LINK.getValue() + "").equals(row.getString("sourcetype"))) {
                    srcId = linkToSourceAdjustMap.getOrDefault(row.getLong("id"), row.getLong("id"));
                    unAutoStatusLockAdjustIds.add(srcId);
                    unAutoStatusLockAdjustNums.add(row.getString("number"));
                    idGroupMap.removeAll((Object)srcId);
                    linkToSourceAdjustMap.entrySet().stream().filter(e -> ((Long)e.getKey()).equals(row.getLong("id")) || ((Long)e.getValue()).equals(row.getLong("id"))).forEach(e -> {
                        idGroupMap.removeAll(e.getKey());
                        idGroupMap.removeAll(e.getValue());
                    });
                }
                if (LongUtil.toLong((Object)row.getLong("shareentry.shareadjust")) != 0L) {
                    srcId = linkToSourceAdjustMap.getOrDefault(row.getLong("id"), row.getLong("id"));
                    shareLockAdjustIds.add(srcId);
                    shareLockAdjustNums.add(row.getString("number"));
                    idGroupMap.removeAll((Object)srcId);
                    linkToSourceAdjustMap.entrySet().stream().filter(e -> ((Long)e.getKey()).equals(row.getLong("id")) || ((Long)e.getValue()).equals(row.getLong("id"))).forEach(e -> {
                        idGroupMap.removeAll(e.getKey());
                        idGroupMap.removeAll(e.getValue());
                    });
                }
            });
        }
        Set<Long> unAutoStatusLockCheckRecordIds = CheckUtil.getCheckRecordIdByLockAdjustIds(unAutoStatusLockAdjustIds, mappings, checkIdMappings);
        if (checkRecordIds.removeAll(unAutoStatusLockCheckRecordIds)) {
            String numStr = unAutoStatusLockAdjustNums.size() <= 10 ? Joiner.on((String)",").join(unAutoStatusLockAdjustNums) : Joiner.on((String)",").join(new ArrayList(unAutoStatusLockAdjustNums).subList(0, 10)) + "......";
            result.put("adjustunautolock", (Pair<Set<Long>, String>)Pair.onePair(unAutoStatusLockCheckRecordIds, (Object)numStr));
        }
        if (checkRecordIds.removeAll(shareLockCheckRecordIds = CheckUtil.getCheckRecordIdByLockAdjustIds(shareLockAdjustIds, mappings, checkIdMappings))) {
            String numStr = shareLockAdjustNums.size() <= 10 ? Joiner.on((String)",").join(shareLockAdjustNums) : Joiner.on((String)",").join(new ArrayList(shareLockAdjustNums).subList(0, 10)) + "......";
            result.put("adjustsharelock", (Pair<Set<Long>, String>)Pair.onePair(shareLockCheckRecordIds, (Object)numStr));
        }
        if (checkRecordIds.isEmpty() || idGroupMap.isEmpty()) {
            return result;
        }
        HashMultimap stageLockGroupMap = HashMultimap.create();
        HashSet pairLockList = new HashSet(16);
        DynamicObjectCollection adjustDatas = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)CheckUtil.getAdjustEntryField(), (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", (Object)idGroupMap.keySet())});
        AdjustOperationHelper.batchCheckOlapDataLock(opName, new AdjustOperationContext((Long)param.getModel().p1, (Long)param.getScene().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1), adjustDatas.stream().filter(d -> idGroupMap.containsEntry((Object)d.getLong("adjust.id"), (Object)d.getString("groupnum"))).collect(Collectors.toSet()), pair -> {
            pairLockList.addAll((Collection)pair.p2);
            DynamicObject entry = (DynamicObject)pair.p1;
            stageLockGroupMap.put((Object)entry.getLong("adjust.id"), (Object)entry.getString("groupnum"));
            return "";
        });
        if (!stageLockGroupMap.isEmpty()) {
            HashMultimap stageLockSrcMap = HashMultimap.create();
            stageLockGroupMap.forEach((adjustId, groupNum) -> {
                stageLockSrcMap.put((Object)linkToSourceAdjustMap.getOrDefault(adjustId, adjustId), groupNum);
                idGroupMap.remove(adjustId, groupNum);
                linkToSourceAdjustMap.entrySet().stream().filter(e -> ((Long)e.getKey()).equals(adjustId) || ((Long)e.getValue()).equals(adjustId)).forEach(e -> {
                    idGroupMap.remove(e.getKey(), groupNum);
                    idGroupMap.remove(e.getValue(), groupNum);
                });
            });
            Set stageLockCheckEntryIds = mappings.stream().filter(m -> stageLockSrcMap.containsEntry((Object)m.getLong("elim.id"), (Object)m.getString("elimentry.groupnum"))).map(e -> e.getLong("linkid")).collect(Collectors.toSet());
            Set stageLockCheckRecordId = checkIdMappings.stream().filter(e -> stageLockCheckEntryIds.contains(e.getLong("entryentity.id"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
            if (checkRecordIds.removeAll(stageLockCheckRecordId)) {
                String numStr = String.join((CharSequence)",", pairLockList.stream().map(p -> String.format("%s(%s)", p.p1, p.p2)).collect(Collectors.toSet()));
                result.put("adjuststagelock", (Pair<Set<Long>, String>)Pair.onePair(stageLockCheckRecordId, (Object)numStr));
            }
            if (checkRecordIds.isEmpty()) {
                return result;
            }
        }
        try (TXHandle tx = TX.required((String)"actionUnAudit");){
            try {
                if (!idGroupMap.isEmpty()) {
                    AdjustClearServiceHelper.batchDeleteAutoAdjustGroup(opName, (Long)param.getModel().p1, (Long)param.getScene().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1, (HashMultimap<Long, String>)idGroupMap);
                }
                CheckUtil.updateCheckRecordStatus(checkRecordIds);
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error("--actionUnAudit--:\n" + ThrowableHelper.toString((Throwable)t));
                throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
            }
        }
        return result;
    }

    private static Set<Long> getCheckRecordIdByLockAdjustIds(Set<Long> lockAdjustIds, DynamicObjectCollection linkMappings, DynamicObjectCollection checkIdMappings) {
        Set lockCheckEntryIds = linkMappings.stream().filter(m -> lockAdjustIds.contains(m.getLong("elim.id"))).map(e -> e.getLong("linkid")).collect(Collectors.toSet());
        return checkIdMappings.stream().filter(e -> lockCheckEntryIds.contains(e.getLong("entryentity.id"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private static void updateCheckRecordStatus(List<Long> checkRecordIds) {
        if (!checkRecordIds.isEmpty()) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern("yyyy-MM-dd HH:mm:ss");
            ArrayList<String> updateParams = new ArrayList<String>(5);
            updateParams.add("fstatus = " + CheckStatusEnum.UNCONFIRM.value);
            updateParams.add("fisautoelim = '1' ");
            updateParams.add("fadjustnumber = ' '");
            updateParams.add("fdiffmode = 3");
            updateParams.add("fdiffmethod = " + DiffMethodEnum.EMPTY.getValue());
            updateParams.add("fmodifierid = " + RequestContext.get().getUserId());
            updateParams.add(String.format("fmodifytime = {ts'%s'}", df.format(TimeServiceHelper.now())));
            CharSequence[] succids = checkRecordIds.stream().map(p -> p.toString()).collect(Collectors.toSet()).toArray(new String[0]);
            String sql = "update t_bcm_checkrecord set " + String.join((CharSequence)",", updateParams) + " where fid in (%s)";
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(sql, String.join((CharSequence)",", succids)));
            SaveServiceHelper.clearDataEntityCache((String)"bcm_checkrecord");
        }
    }

    public static void requestContextWrapper(RequestContext requestContext, Map<String, Object> params) {
        if (params.get("requestContext") != null) {
            RequestContext orginalRequestContext = (RequestContext)ObjectSerialUtil.deSerializedBytes((String)((String)params.get("requestContext")));
            if (!StringUtils.isEmpty((Object)orginalRequestContext.getClient())) {
                requestContext.setClient(orginalRequestContext.getClient());
            }
            if (orginalRequestContext.getOrgId() != 0L) {
                requestContext.setOrgId(orginalRequestContext.getOrgId());
            }
            if (!StringUtils.isEmpty((Object)orginalRequestContext.getLoginIP())) {
                requestContext.setLoginIP(orginalRequestContext.getLoginIP());
            }
            RequestContext.set((RequestContext)requestContext);
        }
    }

    public static void saveLockInfo(ICheckContext ctx, String orgNum, Long type, String info) {
        HashMap<String, HashSet> subMap = (HashMap<String, HashSet>)ctx.getProperty("AllInOneSubmitted");
        if (subMap == null) {
            subMap = new HashMap<String, HashSet>();
        }
        if (type == -5L) {
            if (subMap.get("lockAdjustInfo") != null && ((Set)subMap.get("lockAdjustInfo")).size() < 10) {
                ((Set)subMap.get("lockAdjustInfo")).add(info);
            } else {
                subMap.put("lockAdjustInfo", Sets.newHashSet((Object[])new Object[]{info}));
            }
        } else if (subMap.get(orgNum) != null) {
            ((Set)subMap.get(orgNum)).add(type);
        } else {
            subMap.put(orgNum, Sets.newHashSet((Object[])new Object[]{type}));
        }
        ctx.putProperty("AllInOneSubmitted", subMap);
    }

    public static void filterInnerInternalCompany(Long modelId, Long sceneId, Long yearId, Long periodId, DynamicObjectCollection doc) {
        Set orgNums = doc.stream().filter(e -> e.getBoolean("isleaf")).map(e -> e.getString("number")).collect(Collectors.toSet());
        Set allICNums = (Set)ThreadCache.get((Object)String.join((CharSequence)"-", "CheckUtil.filterInnerInternalCompany", modelId.toString(), sceneId.toString(), yearId.toString(), periodId.toString()), () -> {
            HashSet icNums = new HashSet(16);
            IDNumberTreeNode icEntityNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"InternalCompany", (String)"ICEntity");
            if (icEntityNode == IDNumberTreeNode.NotFoundTreeNode) {
                return icNums;
            }
            MembBaseItem membBaseItem = new MembBaseItem("bcm_icmembertree", icEntityNode.getId(), icEntityNode.getLongNumber(), icEntityNode.getNumber(), RangeEnum.VALUE_90, false, (Object)modelId);
            membBaseItem.matchItem4Ic(new VersionParam(modelId, sceneId, yearId, periodId), item -> icNums.add(item.getNumber()));
            return icNums;
        });
        orgNums.removeAll(allICNums);
        doc.removeIf(e -> e.getBoolean("isleaf") && orgNums.contains(e.getString("number")));
    }

    public static Map<String, String> getDiffItems(Long modelId) {
        Map diffItems = (Map)ThreadCache.get((Object)(modelId.toString() + "getDiffItems"), () -> {
            boolean maxMappingParam = ConfigServiceHelper.getBoolParam(modelId, "isCheckMaxLineReplace");
            LinkedHashMap result = new LinkedHashMap(16);
            Arrays.stream(DiffModeEnum.values()).filter(e -> e != DiffModeEnum.CUSTOM && e != DiffModeEnum.MANUAL && e.isVisible()).forEach(e -> {
                if (e == DiffModeEnum.ZERO || e == DiffModeEnum.DIRECT) {
                    result.put(e.getValue() + "", e.getName());
                } else {
                    Arrays.stream(DiffMethodEnum.values()).filter(f -> f != DiffMethodEnum.EMPTY && (maxMappingParam || f != DiffMethodEnum.MAXMAPPING)).forEach(f -> result.put(String.format("%1$s.%2$s", e.getValue(), f.getValue()), String.format("%1$s.%2$s", e.getName(), f.getName())));
                }
            });
            return result;
        });
        return new LinkedHashMap<String, String>(diffItems);
    }

    public static String getDiffPairName(Pair<DiffModeEnum, DiffMethodEnum> diffPair) {
        if (diffPair.p2 == DiffMethodEnum.EMPTY) {
            return ((DiffModeEnum)diffPair.p1).getName();
        }
        return String.format("%1$s.%2$s", ((DiffModeEnum)diffPair.p1).getName(), ((DiffMethodEnum)diffPair.p2).getName());
    }

    public static String getAdjustEntryField() {
        Set fieldSet = DynUtils.getDynamicTypeProperties((String)"bcm_rptadjustdata");
        fieldSet.add("adjust.id");
        fieldSet.add("adjust.number");
        return String.join((CharSequence)",", fieldSet);
    }
}

