/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.check.diff;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.diff.ColletorsExt;
import kd.fi.bcm.business.check.diff.IDiff;
import kd.fi.bcm.business.check.diff.IDiffEntry;
import kd.fi.bcm.business.check.helper.DiffModeFormulaHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;

public class DiffHandler {
    public static void balance(IDiff data, int diffMode, int diffMethod) {
        DiffHandler.beforeBalance(data);
        Map<String, Map<Boolean, BigDecimal>> groupByAb = DiffHandler.groupByAb(data);
        if (ConfigServiceHelper.getBoolParam(data.getModelid(), "isCheckTotalDiffFirst")) {
            BigDecimal totalDiff = BigDecimal.ZERO;
            for (Map<Boolean, BigDecimal> sumMap2 : groupByAb.values()) {
                BigDecimal abSum = sumMap2.get(Boolean.TRUE);
                BigDecimal baSum = data.isSingleDC() ? sumMap2.get(Boolean.FALSE) : sumMap2.get(Boolean.FALSE).negate();
                BigDecimal d = data.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
                totalDiff = totalDiff.add(d);
            }
            if (totalDiff.compareTo(BigDecimal.ZERO) == 0) {
                data.setDifference2(BigDecimal.ZERO);
                data.getEntries().forEach(e -> {
                    e.setEntryDiffMode(diffMode);
                    e.setEntryDiffMethod(diffMethod);
                    e.setDiffType(2);
                });
                data.setDifference(BigDecimal.ZERO);
                return;
            }
        }
        if (diffMode == 4) {
            HashMap<String, Integer> groupDiffMap = new HashMap<String, Integer>(16);
            HashMap<String, Map<String, String>> paramMap = new HashMap<String, Map<String, String>>(16);
            for (Map.Entry<String, Map<Boolean, BigDecimal>> entry : groupByAb.entrySet()) {
                Map<String, String> param;
                BigDecimal d;
                String groupKey2 = entry.getKey();
                groupDiffMap.put(groupKey2, diffMode);
                BigDecimal abSum = entry.getValue().get(Boolean.TRUE);
                BigDecimal baSum = data.isSingleDC() ? entry.getValue().get(Boolean.FALSE) : entry.getValue().get(Boolean.FALSE).negate();
                BigDecimal bigDecimal = d = data.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
                String diffModeFormula = data.getTmpl().getDiffModeFormula();
                if (!StringUtils.isNotEmpty((String)diffModeFormula)) continue;
                Map<Boolean, BigDecimal> ocValueMap = DiffHandler.calculateOcValue(data.getEntries().stream().filter(e -> groupKey2.equals(e.getGroup())).collect(Collectors.toList()));
                BigDecimal myocMoney = ocValueMap.get(Boolean.TRUE);
                BigDecimal opocMoney = ocValueMap.get(Boolean.FALSE);
                int groupDiffMode = Integer.parseInt(param.get((param = DiffModeFormulaHelper.calculateDiffModeByFormal(d, data.getTmpl().getResolvedFormula(), myocMoney, opocMoney.negate(), abSum, baSum)).containsKey("diffmode") ? "diffmode" : "default_diffmode"));
                groupDiffMap.put(groupKey2, groupDiffMode);
                paramMap.put(groupKey2, param);
                if (groupDiffMode != 3) continue;
                break;
            }
            if (groupDiffMap.containsValue(3)) {
                groupDiffMap.clear();
                data.setDiffMode(3);
            }
            data.setGroupDiffMap(groupDiffMap);
            data.setParamMap(paramMap);
        }
        groupByAb.forEach((groupKey, sumMap) -> {
            BigDecimal abSum = (BigDecimal)sumMap.get(Boolean.TRUE);
            BigDecimal baSum = data.isSingleDC() ? (BigDecimal)sumMap.get(Boolean.FALSE) : ((BigDecimal)sumMap.get(Boolean.FALSE)).negate();
            BigDecimal d = data.isSingleDC() ? abSum.add(baSum) : abSum.subtract(baSum);
            BigDecimal diff = data.getDifference() != null ? data.getDifference().add(d) : d;
            data.setDifference(diff);
            data.diffProcess((String)groupKey, abSum, baSum, diffMode, diffMethod);
            if (diffMode == 1 || diffMode == 2) {
                data.setDifference2(BigDecimal.ZERO);
            } else if (diffMode == 3 || diffMode == 5) {
                data.setDifference2(diff);
            }
        });
        data.dealRecordTypeEnum();
    }

    private static void beforeBalance(IDiff data) {
        long dientryCount;
        if (data == null || data.getEntries().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5dee\u5f02\u5904\u7406\u6570\u636e\u5f02\u5e38\uff1a\u4e3a\u7a7a", (String)"DiffHandler_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        long groupCount = data.getEntries().stream().map(IDiffEntry::getGroup).distinct().count();
        if (groupCount != (dientryCount = data.getEntries().stream().filter(IDiffEntry::isDi).count())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5dee\u5f02\u5904\u7406\u6570\u636e\u5f02\u5e38\uff1a\u5dee\u989d\u9879\u4e0e\u5206\u7ec4\u4e0d\u5339\u914d", (String)"DiffHandler_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, Map<Boolean, BigDecimal>> groupByAb(IDiff data) {
        return data.getEntries().stream().collect(Collectors.groupingBy(IDiffEntry::getGroup, Collectors.partitioningBy(IDiffEntry::isAb, ColletorsExt.summingBigDecimal(IDiffEntry::getValue))));
    }

    public static Map<Boolean, BigDecimal> calculateOcValue(List<IDiffEntry> entries) {
        return entries.stream().collect(Collectors.partitioningBy(IDiffEntry::isAb, ColletorsExt.summingBigDecimal(IDiffEntry::getOCValue)));
    }
}

